/*
 * Decompiled with CFR 0.152.
 */
package com.android.settings.wifi;

import android.content.BroadcastReceiver;
import android.content.ContentResolver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.net.ConnectivityManager;
import android.net.wifi.WifiConfiguration;
import android.net.wifi.WifiManager;
import android.preference.CheckBoxPreference;
import android.preference.Preference;
import android.provider.Settings;
import java.util.ArrayList;

public class WifiApEnabler
implements Preference.OnPreferenceChangeListener {
    private final Context mContext;
    private final CheckBoxPreference mCheckBox;
    private final CharSequence mOriginalSummary;
    private WifiManager mWifiManager;
    private final IntentFilter mIntentFilter;
    ConnectivityManager mCm;
    private String[] mWifiRegexs;
    private final BroadcastReceiver mReceiver = new BroadcastReceiver(){

        public void onReceive(Context context, Intent intent) {
            String action = intent.getAction();
            if ("android.net.wifi.WIFI_AP_STATE_CHANGED".equals(action)) {
                WifiApEnabler.this.handleWifiApStateChanged(intent.getIntExtra("wifi_state", 4));
            } else if ("android.net.conn.TETHER_STATE_CHANGED".equals(action)) {
                ArrayList available = intent.getStringArrayListExtra("availableArray");
                ArrayList active = intent.getStringArrayListExtra("activeArray");
                ArrayList errored = intent.getStringArrayListExtra("erroredArray");
                WifiApEnabler.this.updateTetherState(available.toArray(), active.toArray(), errored.toArray());
            }
        }
    };

    public WifiApEnabler(Context context, CheckBoxPreference checkBox) {
        this.mContext = context;
        this.mCheckBox = checkBox;
        this.mOriginalSummary = checkBox.getSummary();
        checkBox.setPersistent(false);
        this.mWifiManager = (WifiManager)context.getSystemService("wifi");
        this.mCm = (ConnectivityManager)this.mContext.getSystemService("connectivity");
        this.mWifiRegexs = this.mCm.getTetherableWifiRegexs();
        this.mIntentFilter = new IntentFilter("android.net.wifi.WIFI_AP_STATE_CHANGED");
        this.mIntentFilter.addAction("android.net.conn.TETHER_STATE_CHANGED");
    }

    public void resume() {
        this.mContext.registerReceiver(this.mReceiver, this.mIntentFilter);
        this.enableWifiCheckBox();
        this.mCheckBox.setOnPreferenceChangeListener((Preference.OnPreferenceChangeListener)this);
    }

    public void pause() {
        this.mContext.unregisterReceiver(this.mReceiver);
        this.mCheckBox.setOnPreferenceChangeListener(null);
    }

    private void enableWifiCheckBox() {
        boolean isAirplaneMode;
        boolean bl = isAirplaneMode = Settings.System.getInt((ContentResolver)this.mContext.getContentResolver(), (String)"airplane_mode_on", (int)0) != 0;
        if (!isAirplaneMode) {
            this.mCheckBox.setEnabled(true);
        } else {
            this.mCheckBox.setEnabled(false);
        }
    }

    public boolean onPreferenceChange(Preference preference, Object value) {
        ContentResolver cr = this.mContext.getContentResolver();
        boolean enable = (Boolean)value;
        int wifiState = this.mWifiManager.getWifiState();
        if (enable && (wifiState == 2 || wifiState == 3)) {
            this.mWifiManager.setWifiEnabled(false);
            Settings.Secure.putInt((ContentResolver)cr, (String)"wifi_saved_state", (int)1);
        }
        if (this.mWifiManager.setWifiApEnabled(null, enable)) {
            this.mCheckBox.setEnabled(false);
        } else {
            this.mCheckBox.setSummary(2131231058);
        }
        if (!enable) {
            int wifiSavedState = 0;
            try {
                wifiSavedState = Settings.Secure.getInt((ContentResolver)cr, (String)"wifi_saved_state");
            }
            catch (Settings.SettingNotFoundException e) {
                // empty catch block
            }
            if (wifiSavedState == 1) {
                this.mWifiManager.setWifiEnabled(true);
                Settings.Secure.putInt((ContentResolver)cr, (String)"wifi_saved_state", (int)0);
            }
        }
        return false;
    }

    void updateConfigSummary(WifiConfiguration wifiConfig) {
        String s = this.mContext.getString(17040161);
        this.mCheckBox.setSummary((CharSequence)String.format(this.mContext.getString(2131231115), wifiConfig == null ? s : wifiConfig.SSID));
    }

    private void updateTetherState(Object[] available, Object[] tethered, Object[] errored) {
        String s;
        boolean wifiTethered = false;
        boolean wifiErrored = false;
        for (Object o : tethered) {
            s = (String)o;
            for (String regex : this.mWifiRegexs) {
                if (!s.matches(regex)) continue;
                wifiTethered = true;
            }
        }
        for (Object o : errored) {
            s = (String)o;
            for (String regex : this.mWifiRegexs) {
                if (!s.matches(regex)) continue;
                wifiErrored = true;
            }
        }
        if (wifiTethered) {
            WifiConfiguration wifiConfig = this.mWifiManager.getWifiApConfiguration();
            this.updateConfigSummary(wifiConfig);
        } else if (wifiErrored) {
            this.mCheckBox.setSummary(2131231058);
        }
    }

    private void handleWifiApStateChanged(int state) {
        switch (state) {
            case 2: {
                this.mCheckBox.setSummary(2131231056);
                this.mCheckBox.setEnabled(false);
                break;
            }
            case 3: {
                this.mCheckBox.setChecked(true);
                this.mCheckBox.setEnabled(true);
                break;
            }
            case 0: {
                this.mCheckBox.setSummary(2131231057);
                this.mCheckBox.setEnabled(false);
                break;
            }
            case 1: {
                this.mCheckBox.setChecked(false);
                this.mCheckBox.setSummary(this.mOriginalSummary);
                this.enableWifiCheckBox();
                break;
            }
            default: {
                this.mCheckBox.setChecked(false);
                this.mCheckBox.setSummary(2131231058);
                this.enableWifiCheckBox();
            }
        }
    }
}

