/*
 * Decompiled with CFR 0.152.
 */
package com.android.settings.wifi;

import android.app.AlertDialog;
import android.content.Context;
import android.content.DialogInterface;
import android.net.wifi.WifiConfiguration;
import android.os.Bundle;
import android.text.Editable;
import android.text.TextWatcher;
import android.view.View;
import android.widget.AdapterView;
import android.widget.CheckBox;
import android.widget.EditText;
import android.widget.Spinner;
import android.widget.TextView;
import com.android.settings.wifi.AccessPoint;

class WifiApDialog
extends AlertDialog
implements View.OnClickListener,
TextWatcher,
AdapterView.OnItemSelectedListener {
    static final int BUTTON_SUBMIT = -1;
    private final DialogInterface.OnClickListener mListener;
    private static final int OPEN_INDEX = 0;
    private static final int WPA_INDEX = 1;
    private View mView;
    private TextView mSsid;
    private int mSecurityType = 0;
    private EditText mPassword;
    WifiConfiguration mWifiConfig;

    public WifiApDialog(Context context, DialogInterface.OnClickListener listener, WifiConfiguration wifiConfig) {
        super(context);
        this.mListener = listener;
        this.mWifiConfig = wifiConfig;
        if (wifiConfig != null) {
            this.mSecurityType = AccessPoint.getSecurity(wifiConfig);
        }
    }

    public WifiConfiguration getConfig() {
        WifiConfiguration config = new WifiConfiguration();
        config.SSID = ((Object)this.mSsid.getText()).toString();
        switch (this.mSecurityType) {
            case 0: {
                config.allowedKeyManagement.set(0);
                return config;
            }
            case 2: {
                config.allowedKeyManagement.set(1);
                config.allowedAuthAlgorithms.set(0);
                if (this.mPassword.length() != 0) {
                    String password;
                    config.preSharedKey = password = this.mPassword.getText().toString();
                }
                return config;
            }
        }
        return null;
    }

    protected void onCreate(Bundle savedInstanceState) {
        this.mView = this.getLayoutInflater().inflate(2130903104, null);
        Spinner mSecurity = (Spinner)this.mView.findViewById(2131427548);
        this.setView(this.mView);
        this.setInverseBackgroundForced(true);
        Context context = this.getContext();
        this.setTitle(2131231120);
        this.mView.findViewById(2131427546).setVisibility(0);
        this.mSsid = (TextView)this.mView.findViewById(2131427547);
        this.mPassword = (EditText)this.mView.findViewById(2131427550);
        this.setButton(-1, context.getString(2131231093), this.mListener);
        this.setButton(-2, context.getString(2131231094), this.mListener);
        if (this.mWifiConfig != null) {
            this.mSsid.setText((CharSequence)this.mWifiConfig.SSID);
            switch (this.mSecurityType) {
                case 0: {
                    mSecurity.setSelection(0);
                    break;
                }
                case 2: {
                    String str = this.mWifiConfig.preSharedKey;
                    this.mPassword.setText((CharSequence)str);
                    mSecurity.setSelection(1);
                }
            }
        }
        this.mSsid.addTextChangedListener((TextWatcher)this);
        this.mPassword.addTextChangedListener((TextWatcher)this);
        ((CheckBox)this.mView.findViewById(2131427551)).setOnClickListener((View.OnClickListener)this);
        mSecurity.setOnItemSelectedListener((AdapterView.OnItemSelectedListener)this);
        super.onCreate(savedInstanceState);
        this.showSecurityFields();
        this.validate();
    }

    private void validate() {
        if (this.mSsid != null && this.mSsid.length() == 0 || this.mSecurityType == 2 && this.mPassword.length() < 8) {
            this.getButton(-1).setEnabled(false);
        } else {
            this.getButton(-1).setEnabled(true);
        }
    }

    public void onClick(View view) {
        this.mPassword.setInputType(1 | (((CheckBox)view).isChecked() ? 144 : 128));
    }

    public void onTextChanged(CharSequence s, int start, int before, int count) {
    }

    public void beforeTextChanged(CharSequence s, int start, int count, int after) {
    }

    public void afterTextChanged(Editable editable) {
        this.validate();
    }

    public void onItemSelected(AdapterView parent, View view, int position, long id2) {
        this.mSecurityType = position == 0 ? 0 : 2;
        this.showSecurityFields();
        this.validate();
    }

    public void onNothingSelected(AdapterView parent) {
    }

    private void showSecurityFields() {
        if (this.mSecurityType == 0) {
            this.mView.findViewById(2131427549).setVisibility(8);
            return;
        }
        this.mView.findViewById(2131427549).setVisibility(0);
    }
}

