/*
 * Decompiled with CFR 0.152.
 */
package com.android.settings.wifi;

import android.app.AlertDialog;
import android.content.Context;
import android.content.DialogInterface;
import android.net.wifi.WifiManager;
import android.os.Bundle;
import android.preference.Preference;
import android.preference.PreferenceActivity;
import android.preference.PreferenceScreen;
import android.text.Editable;
import android.view.View;
import android.widget.EditText;

public class WifiAPITest
extends PreferenceActivity
implements Preference.OnPreferenceClickListener {
    private static final String TAG = "WifiAPITest";
    private int netid;
    private static final String KEY_DISCONNECT = "disconnect";
    private static final String KEY_DISABLE_NETWORK = "disable_network";
    private static final String KEY_ENABLE_NETWORK = "enable_network";
    private Preference mWifiDisconnect;
    private Preference mWifiDisableNetwork;
    private Preference mWifiEnableNetwork;
    private WifiManager mWifiManager;

    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.onCreatePreferences();
        this.mWifiManager = (WifiManager)this.getSystemService("wifi");
    }

    private void onCreatePreferences() {
        this.addPreferencesFromResource(2130903105);
        PreferenceScreen preferenceScreen = this.getPreferenceScreen();
        this.mWifiDisconnect = preferenceScreen.findPreference((CharSequence)KEY_DISCONNECT);
        this.mWifiDisconnect.setOnPreferenceClickListener((Preference.OnPreferenceClickListener)this);
        this.mWifiDisableNetwork = preferenceScreen.findPreference((CharSequence)KEY_DISABLE_NETWORK);
        this.mWifiDisableNetwork.setOnPreferenceClickListener((Preference.OnPreferenceClickListener)this);
        this.mWifiEnableNetwork = preferenceScreen.findPreference((CharSequence)KEY_ENABLE_NETWORK);
        this.mWifiEnableNetwork.setOnPreferenceClickListener((Preference.OnPreferenceClickListener)this);
    }

    public boolean onPreferenceTreeClick(PreferenceScreen preferenceScreen, Preference preference) {
        super.onPreferenceTreeClick(preferenceScreen, preference);
        return false;
    }

    public boolean onPreferenceClick(Preference pref) {
        if (pref == this.mWifiDisconnect) {
            this.mWifiManager.disconnect();
        } else if (pref == this.mWifiDisableNetwork) {
            AlertDialog.Builder alert = new AlertDialog.Builder((Context)this);
            alert.setTitle((CharSequence)"Input");
            alert.setMessage((CharSequence)"Enter Network ID");
            final EditText input = new EditText((Context)this);
            alert.setView((View)input);
            alert.setPositiveButton((CharSequence)"Ok", new DialogInterface.OnClickListener(){

                public void onClick(DialogInterface dialog, int whichButton) {
                    Editable value = input.getText();
                    WifiAPITest.this.netid = Integer.parseInt(value.toString());
                    WifiAPITest.this.mWifiManager.disableNetwork(WifiAPITest.this.netid);
                }
            });
            alert.setNegativeButton((CharSequence)"Cancel", new DialogInterface.OnClickListener(){

                public void onClick(DialogInterface dialog, int whichButton) {
                }
            });
            alert.show();
        } else if (pref == this.mWifiEnableNetwork) {
            AlertDialog.Builder alert = new AlertDialog.Builder((Context)this);
            alert.setTitle((CharSequence)"Input");
            alert.setMessage((CharSequence)"Enter Network ID");
            final EditText input = new EditText((Context)this);
            alert.setView((View)input);
            alert.setPositiveButton((CharSequence)"Ok", new DialogInterface.OnClickListener(){

                public void onClick(DialogInterface dialog, int whichButton) {
                    Editable value = input.getText();
                    WifiAPITest.this.netid = Integer.parseInt(value.toString());
                    WifiAPITest.this.mWifiManager.enableNetwork(WifiAPITest.this.netid, false);
                }
            });
            alert.setNegativeButton((CharSequence)"Cancel", new DialogInterface.OnClickListener(){

                public void onClick(DialogInterface dialog, int whichButton) {
                }
            });
            alert.show();
        }
        return true;
    }
}

