/*
 * Decompiled with CFR 0.152.
 */
package com.android.settings.wifi;

import android.content.ContentResolver;
import android.content.Context;
import android.net.wifi.WifiInfo;
import android.net.wifi.WifiManager;
import android.os.Bundle;
import android.os.SystemProperties;
import android.preference.CheckBoxPreference;
import android.preference.EditTextPreference;
import android.preference.ListPreference;
import android.preference.Preference;
import android.preference.PreferenceActivity;
import android.provider.Settings;
import android.text.TextUtils;
import android.view.KeyEvent;
import android.view.Menu;
import android.view.MenuItem;
import android.widget.Toast;

public class AdvancedSettings
extends PreferenceActivity
implements Preference.OnPreferenceChangeListener {
    private static final String KEY_MAC_ADDRESS = "mac_address";
    private static final String KEY_CURRENT_IP_ADDRESS = "current_ip_address";
    private static final String KEY_USE_STATIC_IP = "use_static_ip";
    private static final String KEY_NUM_CHANNELS = "num_channels";
    private static final String KEY_SLEEP_POLICY = "sleep_policy";
    private String[] mSettingNames = new String[]{"wifi_static_ip", "wifi_static_gateway", "wifi_static_netmask", "wifi_static_dns1", "wifi_static_dns2"};
    private String[] mPreferenceKeys = new String[]{"ip_address", "gateway", "netmask", "dns1", "dns2"};
    private CheckBoxPreference mUseStaticIpCheckBox;
    private static final int MENU_ITEM_SAVE = 1;
    private static final int MENU_ITEM_CANCEL = 2;
    private static int DEBUGGABLE;

    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.addPreferencesFromResource(2130968616);
        this.mUseStaticIpCheckBox = (CheckBoxPreference)this.findPreference(KEY_USE_STATIC_IP);
        this.mUseStaticIpCheckBox.setOnPreferenceChangeListener((Preference.OnPreferenceChangeListener)this);
        for (int i = 0; i < this.mPreferenceKeys.length; ++i) {
            Preference preference = this.findPreference(this.mPreferenceKeys[i]);
            preference.setOnPreferenceChangeListener((Preference.OnPreferenceChangeListener)this);
        }
        DEBUGGABLE = SystemProperties.getInt((String)"ro.debuggable", (int)0);
        if (DEBUGGABLE == 1) {
            this.initNumChannelsPreference();
        } else {
            Preference chanPref = this.findPreference(KEY_NUM_CHANNELS);
            if (chanPref != null) {
                this.getPreferenceScreen().removePreference(chanPref);
            }
        }
    }

    protected void onResume() {
        super.onResume();
        this.updateUi();
        if (DEBUGGABLE == 1) {
            this.initNumChannelsPreference();
        }
        this.initSleepPolicyPreference();
        this.refreshWifiInfo();
    }

    private void initNumChannelsPreference() {
        ListPreference pref = (ListPreference)this.findPreference(KEY_NUM_CHANNELS);
        pref.setOnPreferenceChangeListener((Preference.OnPreferenceChangeListener)this);
        WifiManager wifiManager = (WifiManager)this.getSystemService("wifi");
        int[] validChannelCounts = wifiManager.getValidChannelCounts();
        if (validChannelCounts == null) {
            Toast.makeText((Context)this, (int)2131231098, (int)0).show();
            pref.setEnabled(false);
            return;
        }
        CharSequence[] entries = new String[validChannelCounts.length];
        CharSequence[] entryValues = new String[validChannelCounts.length];
        for (int i = 0; i < validChannelCounts.length; ++i) {
            entryValues[i] = String.valueOf(validChannelCounts[i]);
            entries[i] = this.getString(2131231099, new Object[]{validChannelCounts[i]});
        }
        pref.setEntries(entries);
        pref.setEntryValues(entryValues);
        pref.setEnabled(true);
        int numChannels = wifiManager.getNumAllowedChannels();
        if (numChannels >= 0) {
            pref.setValue(String.valueOf(numChannels));
        }
    }

    private void initSleepPolicyPreference() {
        ListPreference pref = (ListPreference)this.findPreference(KEY_SLEEP_POLICY);
        pref.setOnPreferenceChangeListener((Preference.OnPreferenceChangeListener)this);
        int value = Settings.System.getInt((ContentResolver)this.getContentResolver(), (String)"wifi_sleep_policy", (int)0);
        pref.setValue(String.valueOf(value));
    }

    public boolean onKeyDown(int keyCode, KeyEvent event) {
        if (keyCode == 4) {
            this.updateSettingsProvider();
        }
        return super.onKeyDown(keyCode, event);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean onPreferenceChange(Preference preference, Object newValue) {
        String key = preference.getKey();
        if (key == null) {
            return true;
        }
        if (key.equals(KEY_NUM_CHANNELS)) {
            try {
                int numChannels = Integer.parseInt((String)newValue);
                WifiManager wifiManager = (WifiManager)this.getSystemService("wifi");
                if (wifiManager.setNumAllowedChannels(numChannels, true)) return true;
                Toast.makeText((Context)this, (int)2131231098, (int)0).show();
                return true;
            }
            catch (NumberFormatException e) {
                Toast.makeText((Context)this, (int)2131231098, (int)0).show();
                return false;
            }
        } else if (key.equals(KEY_SLEEP_POLICY)) {
            try {
                Settings.System.putInt((ContentResolver)this.getContentResolver(), (String)"wifi_sleep_policy", (int)Integer.parseInt((String)newValue));
                return true;
            }
            catch (NumberFormatException e) {
                Toast.makeText((Context)this, (int)2131231102, (int)0).show();
                return false;
            }
        } else if (key.equals(KEY_USE_STATIC_IP)) {
            boolean value = (Boolean)newValue;
            try {
                Settings.System.putInt((ContentResolver)this.getContentResolver(), (String)"wifi_use_static_ip", (int)(value ? 1 : 0));
                return true;
            }
            catch (NumberFormatException e) {
                return false;
            }
        } else {
            String value = (String)newValue;
            if (!this.isIpAddress(value)) {
                Toast.makeText((Context)this, (int)2131231108, (int)1).show();
                return false;
            }
            preference.setSummary((CharSequence)value);
            for (int i = 0; i < this.mSettingNames.length; ++i) {
                if (!key.equals(this.mPreferenceKeys[i])) continue;
                Settings.System.putString((ContentResolver)this.getContentResolver(), (String)this.mSettingNames[i], (String)value);
                return true;
            }
        }
        return true;
    }

    private boolean isIpAddress(String value) {
        int start = 0;
        int end = value.indexOf(46);
        int numBlocks = 0;
        while (start < value.length()) {
            if (end == -1) {
                end = value.length();
            }
            try {
                int block = Integer.parseInt(value.substring(start, end));
                if (block > 255 || block < 0) {
                    return false;
                }
            }
            catch (NumberFormatException e) {
                return false;
            }
            ++numBlocks;
            start = end + 1;
            end = value.indexOf(46, start);
        }
        return numBlocks == 4;
    }

    public boolean onCreateOptionsMenu(Menu menu) {
        menu.add(0, 1, 0, 2131231106).setIcon(17301582);
        menu.add(0, 2, 0, 2131231107).setIcon(17301560);
        return super.onCreateOptionsMenu(menu);
    }

    public boolean onOptionsItemSelected(MenuItem item) {
        switch (item.getItemId()) {
            case 1: {
                this.updateSettingsProvider();
                this.finish();
                return true;
            }
            case 2: {
                this.finish();
                return true;
            }
        }
        return super.onOptionsItemSelected(item);
    }

    private void updateUi() {
        ContentResolver contentResolver = this.getContentResolver();
        this.mUseStaticIpCheckBox.setChecked(Settings.System.getInt((ContentResolver)contentResolver, (String)"wifi_use_static_ip", (int)0) != 0);
        for (int i = 0; i < this.mSettingNames.length; ++i) {
            EditTextPreference preference = (EditTextPreference)this.findPreference(this.mPreferenceKeys[i]);
            String settingValue = Settings.System.getString((ContentResolver)contentResolver, (String)this.mSettingNames[i]);
            preference.setText(settingValue);
            preference.setSummary((CharSequence)settingValue);
        }
    }

    private void updateSettingsProvider() {
        ContentResolver contentResolver = this.getContentResolver();
        Settings.System.putInt((ContentResolver)contentResolver, (String)"wifi_use_static_ip", (int)(this.mUseStaticIpCheckBox.isChecked() ? 1 : 0));
        for (int i = 0; i < this.mSettingNames.length; ++i) {
            EditTextPreference preference = (EditTextPreference)this.findPreference(this.mPreferenceKeys[i]);
            Settings.System.putString((ContentResolver)contentResolver, (String)this.mSettingNames[i], (String)preference.getText());
        }
    }

    private void refreshWifiInfo() {
        long addr;
        WifiManager wifiManager = (WifiManager)this.getSystemService("wifi");
        WifiInfo wifiInfo = wifiManager.getConnectionInfo();
        Preference wifiMacAddressPref = this.findPreference(KEY_MAC_ADDRESS);
        String macAddress = wifiInfo == null ? null : wifiInfo.getMacAddress();
        wifiMacAddressPref.setSummary((CharSequence)(!TextUtils.isEmpty((CharSequence)macAddress) ? macAddress : this.getString(2131231271)));
        Preference wifiIpAddressPref = this.findPreference(KEY_CURRENT_IP_ADDRESS);
        String ipAddress = null;
        if (wifiInfo != null && (addr = (long)wifiInfo.getIpAddress()) != 0L) {
            if (addr < 0L) {
                addr += 0x100000000L;
            }
            ipAddress = String.format("%d.%d.%d.%d", addr & 0xFFL, addr >> 8 & 0xFFL, addr >> 16 & 0xFFL, addr >> 24 & 0xFFL);
        }
        wifiIpAddressPref.setSummary(ipAddress == null ? this.getString(2131231271) : ipAddress);
    }
}

