/*
 * Decompiled with CFR 0.152.
 */
package com.android.settings.wifi;

import android.content.Context;
import android.net.NetworkInfo;
import android.net.wifi.ScanResult;
import android.net.wifi.WifiConfiguration;
import android.net.wifi.WifiInfo;
import android.net.wifi.WifiManager;
import android.preference.Preference;
import android.view.View;
import android.widget.ImageView;
import com.android.settings.wifi.Summary;

class AccessPoint
extends Preference {
    private static final int[] STATE_SECURED = new int[]{2130771968};
    private static final int[] STATE_NONE = new int[0];
    static final int SECURITY_NONE = 0;
    static final int SECURITY_WEP = 1;
    static final int SECURITY_PSK = 2;
    static final int SECURITY_EAP = 3;
    final String ssid;
    final int security;
    final int networkId;
    private WifiConfiguration mConfig;
    private int mRssi;
    private WifiInfo mInfo;
    private NetworkInfo.DetailedState mState;
    private ImageView mSignal;

    static int getSecurity(WifiConfiguration config) {
        if (config.allowedKeyManagement.get(1)) {
            return 2;
        }
        if (config.allowedKeyManagement.get(2) || config.allowedKeyManagement.get(3)) {
            return 3;
        }
        return config.wepKeys[0] != null ? 1 : 0;
    }

    private static int getSecurity(ScanResult result) {
        if (result.capabilities.contains("WEP")) {
            return 1;
        }
        if (result.capabilities.contains("PSK")) {
            return 2;
        }
        if (result.capabilities.contains("EAP")) {
            return 3;
        }
        return 0;
    }

    AccessPoint(Context context, WifiConfiguration config) {
        super(context);
        this.setWidgetLayoutResource(2130903088);
        this.ssid = config.SSID == null ? "" : AccessPoint.removeDoubleQuotes(config.SSID);
        this.security = AccessPoint.getSecurity(config);
        this.networkId = config.networkId;
        this.mConfig = config;
        this.mRssi = Integer.MAX_VALUE;
    }

    AccessPoint(Context context, ScanResult result) {
        super(context);
        this.setWidgetLayoutResource(2130903088);
        this.ssid = result.SSID;
        this.security = AccessPoint.getSecurity(result);
        this.networkId = -1;
        this.mRssi = result.level;
    }

    protected void onBindView(View view) {
        this.setTitle(this.ssid);
        this.mSignal = (ImageView)view.findViewById(2131427458);
        if (this.mRssi == Integer.MAX_VALUE) {
            this.mSignal.setImageDrawable(null);
        } else {
            this.mSignal.setImageResource(2130837620);
            this.mSignal.setImageState(this.security != 0 ? STATE_SECURED : STATE_NONE, true);
        }
        this.refresh();
        super.onBindView(view);
    }

    public int compareTo(Preference preference) {
        if (!(preference instanceof AccessPoint)) {
            return 1;
        }
        AccessPoint other = (AccessPoint)preference;
        if (this.mInfo != other.mInfo) {
            return this.mInfo != null ? -1 : 1;
        }
        if ((this.mRssi ^ other.mRssi) < 0) {
            return this.mRssi != Integer.MAX_VALUE ? -1 : 1;
        }
        if ((this.networkId ^ other.networkId) < 0) {
            return this.networkId != -1 ? -1 : 1;
        }
        int difference = WifiManager.compareSignalLevel((int)other.mRssi, (int)this.mRssi);
        if (difference != 0) {
            return difference;
        }
        return this.ssid.compareToIgnoreCase(other.ssid);
    }

    boolean update(ScanResult result) {
        if (this.ssid.equals(result.SSID) && this.security == AccessPoint.getSecurity(result)) {
            if (WifiManager.compareSignalLevel((int)result.level, (int)this.mRssi) > 0) {
                this.mRssi = result.level;
            }
            return true;
        }
        return false;
    }

    void update(WifiInfo info, NetworkInfo.DetailedState state) {
        boolean reorder = false;
        if (info != null && this.networkId != -1 && this.networkId == info.getNetworkId()) {
            reorder = this.mInfo == null;
            this.mRssi = info.getRssi();
            this.mInfo = info;
            this.mState = state;
            this.refresh();
        } else if (this.mInfo != null) {
            reorder = true;
            this.mInfo = null;
            this.mState = null;
            this.refresh();
        }
        if (reorder) {
            this.notifyHierarchyChanged();
        }
    }

    int getLevel() {
        if (this.mRssi == Integer.MAX_VALUE) {
            return -1;
        }
        return WifiManager.calculateSignalLevel((int)this.mRssi, (int)4);
    }

    WifiConfiguration getConfig() {
        return this.mConfig;
    }

    WifiInfo getInfo() {
        return this.mInfo;
    }

    NetworkInfo.DetailedState getState() {
        return this.mState;
    }

    static String removeDoubleQuotes(String string2) {
        int length = string2.length();
        if (length > 1 && string2.charAt(0) == '\"' && string2.charAt(length - 1) == '\"') {
            return string2.substring(1, length - 1);
        }
        return string2;
    }

    static String convertToQuotedString(String string2) {
        return "\"" + string2 + "\"";
    }

    private void refresh() {
        if (this.mSignal == null) {
            return;
        }
        Context context = this.getContext();
        this.mSignal.setImageLevel(this.getLevel());
        if (this.mState != null) {
            this.setSummary(Summary.get(context, this.mState));
        } else {
            String status = null;
            if (this.mRssi == Integer.MAX_VALUE) {
                status = context.getString(2131231088);
            } else if (this.mConfig != null) {
                status = context.getString(this.mConfig.status == 1 ? 2131231087 : 2131231086);
            }
            if (this.security == 0) {
                this.setSummary(status);
            } else {
                String format = context.getString(status == null ? 2131231089 : 2131231090);
                String[] type = context.getResources().getStringArray(2131034130);
                this.setSummary(String.format(format, type[this.security], status));
            }
        }
    }
}

