/*
 * Decompiled with CFR 0.152.
 */
package com.android.settings.widget;

import android.app.PendingIntent;
import android.appwidget.AppWidgetManager;
import android.appwidget.AppWidgetProvider;
import android.content.ComponentName;
import android.content.ContentResolver;
import android.content.Context;
import android.content.Intent;
import android.content.SyncStorageEngine;
import android.content.pm.PackageManager;
import android.net.ConnectivityManager;
import android.net.Uri;
import android.net.wifi.WifiManager;
import android.os.AsyncTask;
import android.os.IBinder;
import android.os.IPowerManager;
import android.os.RemoteException;
import android.os.ServiceManager;
import android.provider.Settings;
import android.util.Log;
import android.widget.RemoteViews;
import com.android.settings.bluetooth.LocalBluetoothManager;

public class SettingsAppWidgetProvider
extends AppWidgetProvider {
    static final String TAG = "SettingsAppWidgetProvider";
    static final ComponentName THIS_APPWIDGET = new ComponentName("com.android.settings", "com.android.settings.widget.SettingsAppWidgetProvider");
    private static LocalBluetoothManager sLocalBluetoothManager = null;
    private static final int BUTTON_WIFI = 0;
    private static final int BUTTON_BRIGHTNESS = 1;
    private static final int BUTTON_SYNC = 2;
    private static final int BUTTON_GPS = 3;
    private static final int BUTTON_BLUETOOTH = 4;
    private static final int STATE_DISABLED = 0;
    private static final int STATE_ENABLED = 1;
    private static final int STATE_TURNING_ON = 2;
    private static final int STATE_TURNING_OFF = 3;
    private static final int STATE_UNKNOWN = 4;
    private static final int STATE_INTERMEDIATE = 5;
    private static final int POS_LEFT = 0;
    private static final int POS_CENTER = 1;
    private static final int POS_RIGHT = 2;
    private static final int[] IND_DRAWABLE_OFF = new int[]{2130837521, 2130837520, 2130837522};
    private static final int[] IND_DRAWABLE_MID = new int[]{2130837518, 2130837517, 2130837519};
    private static final int[] IND_DRAWABLE_ON = new int[]{2130837524, 2130837523, 2130837525};
    private static final int MINIMUM_BACKLIGHT = 30;
    private static final int MAXIMUM_BACKLIGHT = 255;
    private static final int DEFAULT_BACKLIGHT = 102;
    private static final StateTracker sWifiState = new WifiStateTracker();
    private static final StateTracker sBluetoothState = new BluetoothStateTracker();
    private static final StateTracker sGpsState = new GpsStateTracker();
    private static final StateTracker sSyncState = new SyncStateTracker();

    public void onUpdate(Context context, AppWidgetManager appWidgetManager, int[] appWidgetIds) {
        RemoteViews view = SettingsAppWidgetProvider.buildUpdate(context, -1);
        for (int i = 0; i < appWidgetIds.length; ++i) {
            appWidgetManager.updateAppWidget(appWidgetIds[i], view);
        }
    }

    public void onEnabled(Context context) {
        PackageManager pm = context.getPackageManager();
        pm.setComponentEnabledSetting(new ComponentName("com.android.settings", ".widget.SettingsAppWidgetProvider"), 1, 1);
    }

    public void onDisabled(Context context) {
        Class<SettingsAppWidgetProvider> clazz = SettingsAppWidgetProvider.class;
        PackageManager pm = context.getPackageManager();
        pm.setComponentEnabledSetting(new ComponentName("com.android.settings", ".widget.SettingsAppWidgetProvider"), 2, 1);
    }

    static RemoteViews buildUpdate(Context context, int appWidgetId) {
        RemoteViews views = new RemoteViews(context.getPackageName(), 2130903103);
        views.setOnClickPendingIntent(2131427530, SettingsAppWidgetProvider.getLaunchPendingIntent(context, appWidgetId, 0));
        views.setOnClickPendingIntent(2131427542, SettingsAppWidgetProvider.getLaunchPendingIntent(context, appWidgetId, 1));
        views.setOnClickPendingIntent(2131427539, SettingsAppWidgetProvider.getLaunchPendingIntent(context, appWidgetId, 2));
        views.setOnClickPendingIntent(2131427536, SettingsAppWidgetProvider.getLaunchPendingIntent(context, appWidgetId, 3));
        views.setOnClickPendingIntent(2131427533, SettingsAppWidgetProvider.getLaunchPendingIntent(context, appWidgetId, 4));
        SettingsAppWidgetProvider.updateButtons(views, context);
        return views;
    }

    public static void updateWidget(Context context) {
        RemoteViews views = SettingsAppWidgetProvider.buildUpdate(context, -1);
        AppWidgetManager gm = AppWidgetManager.getInstance((Context)context);
        gm.updateAppWidget(THIS_APPWIDGET, views);
    }

    private static void updateButtons(RemoteViews views, Context context) {
        sWifiState.setImageViewResources(context, views);
        sBluetoothState.setImageViewResources(context, views);
        sGpsState.setImageViewResources(context, views);
        sSyncState.setImageViewResources(context, views);
        if (SettingsAppWidgetProvider.getBrightnessMode(context)) {
            views.setImageViewResource(2131427543, 2130837529);
            views.setImageViewResource(2131427544, 2130837525);
        } else if (SettingsAppWidgetProvider.getBrightness(context)) {
            views.setImageViewResource(2131427543, 2130837532);
            views.setImageViewResource(2131427544, 2130837525);
        } else {
            views.setImageViewResource(2131427543, 2130837531);
            views.setImageViewResource(2131427544, 2130837522);
        }
    }

    private static PendingIntent getLaunchPendingIntent(Context context, int appWidgetId, int buttonId) {
        Intent launchIntent = new Intent();
        launchIntent.setClass(context, SettingsAppWidgetProvider.class);
        launchIntent.addCategory("android.intent.category.ALTERNATIVE");
        launchIntent.setData(Uri.parse((String)("custom:" + buttonId)));
        PendingIntent pi = PendingIntent.getBroadcast((Context)context, (int)0, (Intent)launchIntent, (int)0);
        return pi;
    }

    public void onReceive(Context context, Intent intent) {
        super.onReceive(context, intent);
        String action = intent.getAction();
        if ("android.net.wifi.WIFI_STATE_CHANGED".equals(action)) {
            sWifiState.onActualStateChange(context, intent);
        } else if ("android.bluetooth.adapter.action.STATE_CHANGED".equals(action)) {
            sBluetoothState.onActualStateChange(context, intent);
        } else if ("android.location.PROVIDERS_CHANGED".equals(action)) {
            sGpsState.onActualStateChange(context, intent);
        } else if (SyncStorageEngine.SYNC_CONNECTION_SETTING_CHANGED_INTENT.getAction().equals(action)) {
            sSyncState.onActualStateChange(context, intent);
        } else if (intent.hasCategory("android.intent.category.ALTERNATIVE")) {
            Uri data = intent.getData();
            int buttonId = Integer.parseInt(data.getSchemeSpecificPart());
            if (buttonId == 0) {
                sWifiState.toggleState(context);
            } else if (buttonId == 1) {
                this.toggleBrightness(context);
            } else if (buttonId == 2) {
                sSyncState.toggleState(context);
            } else if (buttonId == 3) {
                sGpsState.toggleState(context);
            } else if (buttonId == 4) {
                sBluetoothState.toggleState(context);
            }
        } else {
            return;
        }
        SettingsAppWidgetProvider.updateWidget(context);
    }

    private static boolean getBackgroundDataState(Context context) {
        ConnectivityManager connManager = (ConnectivityManager)context.getSystemService("connectivity");
        return connManager.getBackgroundDataSetting();
    }

    private static boolean getBrightness(Context context) {
        try {
            IPowerManager power = IPowerManager.Stub.asInterface((IBinder)ServiceManager.getService((String)"power"));
            if (power != null) {
                int brightness = Settings.System.getInt((ContentResolver)context.getContentResolver(), (String)"screen_brightness");
                return brightness > 100;
            }
        }
        catch (Exception e) {
            Log.d((String)TAG, (String)("getBrightness: " + e));
        }
        return false;
    }

    private static boolean getBrightnessMode(Context context) {
        try {
            IPowerManager power = IPowerManager.Stub.asInterface((IBinder)ServiceManager.getService((String)"power"));
            if (power != null) {
                int brightnessMode = Settings.System.getInt((ContentResolver)context.getContentResolver(), (String)"screen_brightness_mode");
                return brightnessMode == 1;
            }
        }
        catch (Exception e) {
            Log.d((String)TAG, (String)("getBrightnessMode: " + e));
        }
        return false;
    }

    private void toggleBrightness(Context context) {
        try {
            IPowerManager power = IPowerManager.Stub.asInterface((IBinder)ServiceManager.getService((String)"power"));
            if (power != null) {
                ContentResolver cr = context.getContentResolver();
                int brightness = Settings.System.getInt((ContentResolver)cr, (String)"screen_brightness");
                int brightnessMode = 0;
                if (context.getResources().getBoolean(17629189)) {
                    brightnessMode = Settings.System.getInt((ContentResolver)cr, (String)"screen_brightness_mode");
                }
                if (brightnessMode == 1) {
                    brightness = 30;
                    brightnessMode = 0;
                } else if (brightness < 102) {
                    brightness = 102;
                } else if (brightness < 255) {
                    brightness = 255;
                } else {
                    brightnessMode = 1;
                    brightness = 30;
                }
                if (context.getResources().getBoolean(17629189)) {
                    Settings.System.putInt((ContentResolver)context.getContentResolver(), (String)"screen_brightness_mode", (int)brightnessMode);
                } else {
                    brightnessMode = 0;
                }
                if (brightnessMode == 0) {
                    power.setBacklightBrightness(brightness);
                    Settings.System.putInt((ContentResolver)cr, (String)"screen_brightness", (int)brightness);
                }
            }
        }
        catch (RemoteException e) {
            Log.d((String)TAG, (String)("toggleBrightness: " + (Object)((Object)e)));
        }
        catch (Settings.SettingNotFoundException e) {
            Log.d((String)TAG, (String)("toggleBrightness: " + (Object)((Object)e)));
        }
    }

    private static final class SyncStateTracker
    extends StateTracker {
        private SyncStateTracker() {
        }

        public int getButtonId() {
            return 2131427540;
        }

        public int getIndicatorId() {
            return 2131427541;
        }

        public int getButtonImageId(boolean on) {
            return on ? 2130837536 : 2130837535;
        }

        public int getActualState(Context context) {
            boolean on = SettingsAppWidgetProvider.getBackgroundDataState(context) && ContentResolver.getMasterSyncAutomatically();
            return on ? 1 : 0;
        }

        public void onActualStateChange(Context context, Intent unused) {
            this.setCurrentState(context, this.getActualState(context));
        }

        public void requestStateChange(final Context context, final boolean desiredState) {
            final ConnectivityManager connManager = (ConnectivityManager)context.getSystemService("connectivity");
            final boolean backgroundData = SettingsAppWidgetProvider.getBackgroundDataState(context);
            final boolean sync = ContentResolver.getMasterSyncAutomatically();
            new AsyncTask<Void, Void, Boolean>(){

                protected Boolean doInBackground(Void ... args) {
                    if (desiredState) {
                        if (!backgroundData) {
                            connManager.setBackgroundDataSetting(true);
                        }
                        if (!sync) {
                            ContentResolver.setMasterSyncAutomatically((boolean)true);
                        }
                        return true;
                    }
                    if (sync) {
                        ContentResolver.setMasterSyncAutomatically((boolean)false);
                    }
                    return false;
                }

                protected void onPostExecute(Boolean result) {
                    SyncStateTracker.this.setCurrentState(context, result != false ? 1 : 0);
                    SettingsAppWidgetProvider.updateWidget(context);
                }
            }.execute((Object[])new Void[0]);
        }
    }

    private static final class GpsStateTracker
    extends StateTracker {
        private GpsStateTracker() {
        }

        public int getButtonId() {
            return 2131427537;
        }

        public int getIndicatorId() {
            return 2131427538;
        }

        public int getButtonImageId(boolean on) {
            return on ? 2130837534 : 2130837533;
        }

        public int getActualState(Context context) {
            ContentResolver resolver = context.getContentResolver();
            boolean on = Settings.Secure.isLocationProviderEnabled((ContentResolver)resolver, (String)"gps");
            return on ? 1 : 0;
        }

        public void onActualStateChange(Context context, Intent unused) {
            this.setCurrentState(context, this.getActualState(context));
        }

        public void requestStateChange(final Context context, final boolean desiredState) {
            final ContentResolver resolver = context.getContentResolver();
            new AsyncTask<Void, Void, Boolean>(){

                protected Boolean doInBackground(Void ... args) {
                    Settings.Secure.setLocationProviderEnabled((ContentResolver)resolver, (String)"gps", (boolean)desiredState);
                    return desiredState;
                }

                protected void onPostExecute(Boolean result) {
                    GpsStateTracker.this.setCurrentState(context, result != false ? 1 : 0);
                    SettingsAppWidgetProvider.updateWidget(context);
                }
            }.execute((Object[])new Void[0]);
        }
    }

    private static final class BluetoothStateTracker
    extends StateTracker {
        private BluetoothStateTracker() {
        }

        public int getButtonId() {
            return 2131427534;
        }

        public int getIndicatorId() {
            return 2131427535;
        }

        public int getButtonImageId(boolean on) {
            return on ? 2130837528 : 2130837527;
        }

        public int getActualState(Context context) {
            if (sLocalBluetoothManager == null) {
                sLocalBluetoothManager = LocalBluetoothManager.getInstance(context);
                if (sLocalBluetoothManager == null) {
                    return 4;
                }
            }
            return BluetoothStateTracker.bluetoothStateToFiveState(sLocalBluetoothManager.getBluetoothState());
        }

        protected void requestStateChange(Context context, final boolean desiredState) {
            if (sLocalBluetoothManager == null) {
                Log.d((String)SettingsAppWidgetProvider.TAG, (String)"No LocalBluetoothManager");
                return;
            }
            new AsyncTask<Void, Void, Void>(){

                protected Void doInBackground(Void ... args) {
                    sLocalBluetoothManager.setBluetoothEnabled(desiredState);
                    return null;
                }
            }.execute((Object[])new Void[0]);
        }

        public void onActualStateChange(Context context, Intent intent) {
            if (!"android.bluetooth.adapter.action.STATE_CHANGED".equals(intent.getAction())) {
                return;
            }
            int bluetoothState = intent.getIntExtra("android.bluetooth.adapter.extra.STATE", -1);
            this.setCurrentState(context, BluetoothStateTracker.bluetoothStateToFiveState(bluetoothState));
        }

        private static int bluetoothStateToFiveState(int bluetoothState) {
            switch (bluetoothState) {
                case 10: {
                    return 0;
                }
                case 12: {
                    return 1;
                }
                case 11: {
                    return 2;
                }
                case 13: {
                    return 3;
                }
            }
            return 4;
        }
    }

    private static final class WifiStateTracker
    extends StateTracker {
        private WifiStateTracker() {
        }

        public int getButtonId() {
            return 2131427531;
        }

        public int getIndicatorId() {
            return 2131427532;
        }

        public int getButtonImageId(boolean on) {
            return on ? 2130837538 : 2130837537;
        }

        public int getPosition() {
            return 0;
        }

        public int getActualState(Context context) {
            WifiManager wifiManager = (WifiManager)context.getSystemService("wifi");
            if (wifiManager != null) {
                return WifiStateTracker.wifiStateToFiveState(wifiManager.getWifiState());
            }
            return 4;
        }

        protected void requestStateChange(Context context, final boolean desiredState) {
            final WifiManager wifiManager = (WifiManager)context.getSystemService("wifi");
            if (wifiManager == null) {
                Log.d((String)SettingsAppWidgetProvider.TAG, (String)"No wifiManager.");
                return;
            }
            new AsyncTask<Void, Void, Void>(){

                protected Void doInBackground(Void ... args) {
                    int wifiApState = wifiManager.getWifiApState();
                    if (desiredState && (wifiApState == 2 || wifiApState == 3)) {
                        wifiManager.setWifiApEnabled(null, false);
                    }
                    wifiManager.setWifiEnabled(desiredState);
                    return null;
                }
            }.execute((Object[])new Void[0]);
        }

        public void onActualStateChange(Context context, Intent intent) {
            if (!"android.net.wifi.WIFI_STATE_CHANGED".equals(intent.getAction())) {
                return;
            }
            int wifiState = intent.getIntExtra("wifi_state", -1);
            this.setCurrentState(context, WifiStateTracker.wifiStateToFiveState(wifiState));
        }

        private static int wifiStateToFiveState(int wifiState) {
            switch (wifiState) {
                case 1: {
                    return 0;
                }
                case 3: {
                    return 1;
                }
                case 0: {
                    return 3;
                }
                case 2: {
                    return 2;
                }
            }
            return 4;
        }
    }

    private static abstract class StateTracker {
        private boolean mInTransition = false;
        private Boolean mActualState = null;
        private Boolean mIntendedState = null;
        private boolean mDeferredStateChangeRequestNeeded = false;

        private StateTracker() {
        }

        public final void toggleState(Context context) {
            int currentState = this.getTriState(context);
            boolean newState = false;
            switch (currentState) {
                case 1: {
                    newState = false;
                    break;
                }
                case 0: {
                    newState = true;
                    break;
                }
                case 5: {
                    if (this.mIntendedState == null) break;
                    newState = this.mIntendedState == false;
                }
            }
            this.mIntendedState = newState;
            if (this.mInTransition) {
                this.mDeferredStateChangeRequestNeeded = true;
            } else {
                this.mInTransition = true;
                this.requestStateChange(context, newState);
            }
        }

        public abstract int getButtonId();

        public abstract int getIndicatorId();

        public abstract int getButtonImageId(boolean var1);

        public int getPosition() {
            return 1;
        }

        public final void setImageViewResources(Context context, RemoteViews views) {
            int buttonId = this.getButtonId();
            int indicatorId = this.getIndicatorId();
            int pos = this.getPosition();
            switch (this.getTriState(context)) {
                case 0: {
                    views.setImageViewResource(buttonId, this.getButtonImageId(false));
                    views.setImageViewResource(indicatorId, IND_DRAWABLE_OFF[pos]);
                    break;
                }
                case 1: {
                    views.setImageViewResource(buttonId, this.getButtonImageId(true));
                    views.setImageViewResource(indicatorId, IND_DRAWABLE_ON[pos]);
                    break;
                }
                case 5: {
                    if (this.isTurningOn()) {
                        views.setImageViewResource(buttonId, this.getButtonImageId(true));
                        views.setImageViewResource(indicatorId, IND_DRAWABLE_MID[pos]);
                        break;
                    }
                    views.setImageViewResource(buttonId, this.getButtonImageId(false));
                    views.setImageViewResource(indicatorId, IND_DRAWABLE_OFF[pos]);
                }
            }
        }

        public abstract void onActualStateChange(Context var1, Intent var2);

        protected final void setCurrentState(Context context, int newState) {
            boolean wasInTransition = this.mInTransition;
            switch (newState) {
                case 0: {
                    this.mInTransition = false;
                    this.mActualState = false;
                    break;
                }
                case 1: {
                    this.mInTransition = false;
                    this.mActualState = true;
                    break;
                }
                case 2: {
                    this.mInTransition = true;
                    this.mActualState = false;
                    break;
                }
                case 3: {
                    this.mInTransition = true;
                    this.mActualState = true;
                }
            }
            if (wasInTransition && !this.mInTransition && this.mDeferredStateChangeRequestNeeded) {
                Log.v((String)SettingsAppWidgetProvider.TAG, (String)"processing deferred state change");
                if (this.mActualState != null && this.mIntendedState != null && this.mIntendedState.equals(this.mActualState)) {
                    Log.v((String)SettingsAppWidgetProvider.TAG, (String)"... but intended state matches, so no changes.");
                } else if (this.mIntendedState != null) {
                    this.mInTransition = true;
                    this.requestStateChange(context, this.mIntendedState);
                }
                this.mDeferredStateChangeRequestNeeded = false;
            }
        }

        public final boolean isTurningOn() {
            return this.mIntendedState != null && this.mIntendedState != false;
        }

        public final int getTriState(Context context) {
            if (this.mInTransition) {
                return 5;
            }
            switch (this.getActualState(context)) {
                case 0: {
                    return 0;
                }
                case 1: {
                    return 1;
                }
            }
            return 5;
        }

        public abstract int getActualState(Context var1);

        protected abstract void requestStateChange(Context var1, boolean var2);
    }
}

