/*
 * Decompiled with CFR 0.152.
 */
package com.android.settings.vpn;

import android.content.Context;
import android.content.Intent;
import android.net.vpn.VpnManager;
import android.net.vpn.VpnType;
import android.os.Bundle;
import android.preference.Preference;
import android.preference.PreferenceActivity;
import android.preference.PreferenceScreen;
import com.android.settings.vpn.VpnSettings;
import java.util.HashMap;
import java.util.Map;

public class VpnTypeSelection
extends PreferenceActivity {
    private Map<String, VpnType> mTypeMap = new HashMap<String, VpnType>();

    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.addPreferencesFromResource(2130968614);
        this.initTypeList();
    }

    public boolean onPreferenceTreeClick(PreferenceScreen ps, Preference pref) {
        this.setResult(this.mTypeMap.get(((Object)pref.getTitle()).toString()));
        this.finish();
        return true;
    }

    private void initTypeList() {
        PreferenceScreen root = this.getPreferenceScreen();
        for (VpnType t : VpnManager.getSupportedVpnTypes()) {
            String displayName = t.getDisplayName();
            String message = String.format(this.getString(2131231774), displayName);
            this.mTypeMap.put(message, t);
            Preference pref = new Preference((Context)this);
            pref.setTitle((CharSequence)message);
            pref.setSummary(t.getDescriptionId());
            root.addPreference(pref);
        }
    }

    private void setResult(VpnType type) {
        Intent intent = new Intent((Context)this, VpnSettings.class);
        intent.putExtra("vpn_type", type.toString());
        this.setResult(-1, intent);
    }
}

