/*
 * Decompiled with CFR 0.152.
 */
package com.android.settings.vpn;

import android.app.AlertDialog;
import android.app.Dialog;
import android.content.BroadcastReceiver;
import android.content.ComponentName;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.content.ServiceConnection;
import android.net.vpn.IVpnService;
import android.net.vpn.L2tpIpsecProfile;
import android.net.vpn.L2tpIpsecPskProfile;
import android.net.vpn.L2tpProfile;
import android.net.vpn.VpnManager;
import android.net.vpn.VpnProfile;
import android.net.vpn.VpnState;
import android.net.vpn.VpnType;
import android.os.Bundle;
import android.os.ConditionVariable;
import android.os.IBinder;
import android.os.Parcelable;
import android.preference.Preference;
import android.preference.PreferenceActivity;
import android.preference.PreferenceCategory;
import android.preference.PreferenceScreen;
import android.security.Credentials;
import android.security.KeyStore;
import android.text.TextUtils;
import android.util.Log;
import android.view.ContextMenu;
import android.view.MenuItem;
import android.view.View;
import android.widget.AdapterView;
import com.android.settings.vpn.AuthenticationActor;
import com.android.settings.vpn.Util;
import com.android.settings.vpn.VpnEditor;
import com.android.settings.vpn.VpnProfileActor;
import com.android.settings.vpn.VpnTypeSelection;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class VpnSettings
extends PreferenceActivity
implements DialogInterface.OnClickListener {
    static final String KEY_VPN_PROFILE = "vpn_profile";
    static final String KEY_VPN_TYPE = "vpn_type";
    private static final String TAG = VpnSettings.class.getSimpleName();
    private static final String PREF_ADD_VPN = "add_new_vpn";
    private static final String PREF_VPN_LIST = "vpn_list";
    private static final String PROFILES_ROOT = VpnManager.getProfilePath() + "/";
    private static final String PROFILE_OBJ_FILE = ".pobj";
    private static final int REQUEST_ADD_OR_EDIT_PROFILE = 1;
    private static final int REQUEST_SELECT_VPN_TYPE = 2;
    private static final int CONTEXT_MENU_CONNECT_ID = 1;
    private static final int CONTEXT_MENU_DISCONNECT_ID = 2;
    private static final int CONTEXT_MENU_EDIT_ID = 3;
    private static final int CONTEXT_MENU_DELETE_ID = 4;
    private static final int CONNECT_BUTTON = -1;
    private static final int OK_BUTTON = -1;
    private static final int DIALOG_CONNECT = 201;
    private static final int DIALOG_SECRET_NOT_SET = 202;
    private static final int NO_ERROR = 0;
    private static final String KEY_PREFIX_IPSEC_PSK = "VPN_i";
    private static final String KEY_PREFIX_L2TP_SECRET = "VPN_l";
    private PreferenceScreen mAddVpn;
    private PreferenceCategory mVpnListContainer;
    private Map<String, VpnPreference> mVpnPreferenceMap;
    private List<VpnProfile> mVpnProfileList;
    private VpnProfile mActiveProfile;
    private VpnProfileActor mConnectingActor;
    private Runnable mUnlockAction;
    private KeyStore mKeyStore = KeyStore.getInstance();
    private VpnManager mVpnManager = new VpnManager((Context)this);
    private ConnectivityReceiver mConnectivityReceiver = new ConnectivityReceiver();
    private int mConnectingErrorCode = 0;
    private Dialog mShowingDialog;
    private StatusChecker mStatusChecker = new StatusChecker();

    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.addPreferencesFromResource(2130968613);
        this.mVpnListContainer = (PreferenceCategory)this.findPreference(PREF_VPN_LIST);
        this.mAddVpn = (PreferenceScreen)this.findPreference(PREF_ADD_VPN);
        this.mAddVpn.setOnPreferenceClickListener(new Preference.OnPreferenceClickListener(){

            public boolean onPreferenceClick(Preference preference) {
                VpnSettings.this.startVpnTypeSelection();
                return true;
            }
        });
        this.registerForContextMenu((View)this.getListView());
        this.mVpnManager.registerConnectivityReceiver((BroadcastReceiver)this.mConnectivityReceiver);
        this.retrieveVpnListFromStorage();
        this.checkVpnConnectionStatusInBackground();
    }

    public void onResume() {
        super.onResume();
        if (this.mUnlockAction != null && this.isKeyStoreUnlocked()) {
            Runnable action = this.mUnlockAction;
            this.mUnlockAction = null;
            this.runOnUiThread(action);
        }
    }

    protected void onDestroy() {
        super.onDestroy();
        this.unregisterForContextMenu((View)this.getListView());
        this.mVpnManager.unregisterConnectivityReceiver((BroadcastReceiver)this.mConnectivityReceiver);
        if (this.mShowingDialog != null && this.mShowingDialog.isShowing()) {
            this.mShowingDialog.dismiss();
        }
    }

    protected Dialog onCreateDialog(int id2) {
        switch (id2) {
            case 201: {
                return this.createConnectDialog();
            }
            case 202: {
                return this.createSecretNotSetDialog();
            }
            case 5: 
            case 42: 
            case 102: {
                return this.createEditDialog(id2);
            }
        }
        Log.d((String)TAG, (String)("create reconnect dialog for event " + id2));
        return this.createReconnectDialog(id2);
    }

    private Dialog createConnectDialog() {
        return new AlertDialog.Builder((Context)this).setView(this.mConnectingActor.createConnectView()).setTitle((CharSequence)String.format(this.getString(2131231739), this.mActiveProfile.getName())).setPositiveButton((CharSequence)this.getString(2131231745), (DialogInterface.OnClickListener)this).setNegativeButton((CharSequence)this.getString(0x1040000), (DialogInterface.OnClickListener)this).setOnCancelListener(new DialogInterface.OnCancelListener(){

            public void onCancel(DialogInterface dialog) {
                VpnSettings.this.removeDialog(201);
                VpnSettings.this.changeState(VpnSettings.this.mActiveProfile, VpnState.IDLE);
            }
        }).create();
    }

    private Dialog createReconnectDialog(int id2) {
        int msgId;
        switch (id2) {
            case 51: {
                msgId = 2131231768;
                break;
            }
            case 7: {
                msgId = 2131231769;
                break;
            }
            case 103: {
                msgId = 2131231764;
                break;
            }
            case 48: {
                msgId = 2131231770;
                break;
            }
            default: {
                msgId = 2131231763;
            }
        }
        return this.createCommonDialogBuilder().setMessage(msgId).create();
    }

    private Dialog createEditDialog(int id2) {
        int msgId;
        switch (id2) {
            case 5: {
                msgId = 2131231766;
                break;
            }
            case 102: {
                msgId = 2131231765;
                break;
            }
            case 42: {
                msgId = 2131231771;
                break;
            }
            default: {
                return null;
            }
        }
        return this.createCommonEditDialogBuilder().setMessage(msgId).create();
    }

    private Dialog createSecretNotSetDialog() {
        return this.createCommonDialogBuilder().setMessage(2131231767).setPositiveButton(2131231746, new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialog, int w) {
                VpnSettings.this.startVpnEditor(VpnSettings.this.mActiveProfile);
            }
        }).create();
    }

    private AlertDialog.Builder createCommonEditDialogBuilder() {
        return this.createCommonDialogBuilder().setPositiveButton(2131231746, new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialog, int w) {
                VpnProfile p = VpnSettings.this.mActiveProfile;
                VpnSettings.this.onIdle();
                VpnSettings.this.startVpnEditor(p);
            }
        });
    }

    private AlertDialog.Builder createCommonDialogBuilder() {
        return new AlertDialog.Builder((Context)this).setTitle(0x1040014).setIcon(17301543).setPositiveButton(2131231746, new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialog, int w) {
                VpnSettings.this.connectOrDisconnect(VpnSettings.this.mActiveProfile);
            }
        }).setNegativeButton(2131231747, new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialog, int w) {
                VpnSettings.this.onIdle();
            }
        }).setOnCancelListener(new DialogInterface.OnCancelListener(){

            public void onCancel(DialogInterface dialog) {
                VpnSettings.this.onIdle();
            }
        });
    }

    public void onCreateContextMenu(ContextMenu menu, View v, ContextMenu.ContextMenuInfo menuInfo) {
        super.onCreateContextMenu(menu, v, menuInfo);
        VpnProfile p = this.getProfile(this.getProfilePositionFrom((AdapterView.AdapterContextMenuInfo)menuInfo));
        if (p != null) {
            VpnState state = p.getState();
            menu.setHeaderTitle((CharSequence)p.getName());
            boolean isIdle = state == VpnState.IDLE;
            boolean isNotConnect = isIdle || state == VpnState.DISCONNECTING || state == VpnState.CANCELLED;
            menu.add(0, 1, 0, 2131231753).setEnabled(isIdle && this.mActiveProfile == null);
            menu.add(0, 2, 0, 2131231754).setEnabled(state == VpnState.CONNECTED);
            menu.add(0, 3, 0, 2131231755).setEnabled(isNotConnect);
            menu.add(0, 4, 0, 2131231756).setEnabled(isNotConnect);
        }
    }

    public boolean onContextItemSelected(MenuItem item) {
        int position = this.getProfilePositionFrom((AdapterView.AdapterContextMenuInfo)item.getMenuInfo());
        VpnProfile p = this.getProfile(position);
        switch (item.getItemId()) {
            case 1: 
            case 2: {
                this.connectOrDisconnect(p);
                return true;
            }
            case 3: {
                this.startVpnEditor(p);
                return true;
            }
            case 4: {
                this.deleteProfile(position);
                return true;
            }
        }
        return super.onContextItemSelected(item);
    }

    protected void onActivityResult(final int requestCode, final int resultCode, final Intent data) {
        block11: {
            if (resultCode == 0 || data == null) {
                Log.d((String)TAG, (String)"no result returned by editor");
                return;
            }
            if (requestCode == 2) {
                String typeName = data.getStringExtra(KEY_VPN_TYPE);
                this.startVpnEditor(this.createVpnProfile(typeName));
            } else if (requestCode == 1) {
                Runnable action;
                VpnProfile p = (VpnProfile)data.getParcelableExtra(KEY_VPN_PROFILE);
                if (p == null) {
                    Log.e((String)TAG, (String)"null object returned by editor");
                    return;
                }
                int index = this.getProfileIndexFromId(p.getId());
                if (this.checkDuplicateName(p, index)) {
                    final VpnProfile profile = p;
                    Util.showErrorMessage((Context)this, String.format(this.getString(2131231759), p.getName()), new DialogInterface.OnClickListener(){

                        public void onClick(DialogInterface dialog, int w) {
                            VpnSettings.this.startVpnEditor(profile);
                        }
                    });
                    return;
                }
                if (this.needKeyStoreToSave(p) && !this.unlockKeyStore(p, action = new Runnable(){

                    public void run() {
                        VpnSettings.this.onActivityResult(requestCode, resultCode, data);
                    }
                })) {
                    return;
                }
                try {
                    if (index < 0) {
                        this.addProfile(p);
                        Util.showShortToastMessage((Context)this, String.format(this.getString(2131231783), p.getName()));
                        break block11;
                    }
                    this.replaceProfile(index, p);
                    Util.showShortToastMessage((Context)this, String.format(this.getString(2131231784), p.getName()));
                }
                catch (IOException e) {
                    final VpnProfile profile = p;
                    Util.showErrorMessage((Context)this, e + ": " + e.getMessage(), new DialogInterface.OnClickListener(){

                        public void onClick(DialogInterface dialog, int w) {
                            VpnSettings.this.startVpnEditor(profile);
                        }
                    });
                }
            } else {
                throw new RuntimeException("unknown request code: " + requestCode);
            }
        }
    }

    public synchronized void onClick(DialogInterface dialog, int which) {
        if (which == -1) {
            Dialog d = (Dialog)dialog;
            String error = this.mConnectingActor.validateInputs(d);
            if (error == null) {
                this.mConnectingActor.connect(d);
                this.removeDialog(201);
                return;
            }
            this.dismissDialog(201);
            this.mShowingDialog = new AlertDialog.Builder((Context)this).setTitle(0x1040014).setIcon(17301543).setMessage((CharSequence)String.format(this.getString(2131231757), error)).setPositiveButton(2131231748, new DialogInterface.OnClickListener(){

                public void onClick(DialogInterface dialog, int which) {
                    VpnSettings.this.showDialog(201);
                }
            }).create();
            this.mShowingDialog.show();
        } else {
            this.removeDialog(201);
            this.changeState(this.mActiveProfile, VpnState.IDLE);
        }
    }

    private int getProfileIndexFromId(String id2) {
        int index = 0;
        for (VpnProfile p : this.mVpnProfileList) {
            if (p.getId().equals(id2)) {
                return index;
            }
            ++index;
        }
        return -1;
    }

    private boolean checkDuplicateName(VpnProfile p, int index) {
        List<VpnProfile> list = this.mVpnProfileList;
        VpnPreference pref = this.mVpnPreferenceMap.get(p.getName());
        if (pref != null && index >= 0 && index < list.size() && pref.mProfile == list.get(index)) {
            pref = null;
        }
        return pref != null;
    }

    private int getProfilePositionFrom(AdapterView.AdapterContextMenuInfo menuInfo) {
        return menuInfo.position - this.mVpnListContainer.getOrder() - 1;
    }

    private VpnProfile getProfile(int position) {
        return position >= 0 ? this.mVpnProfileList.get(position) : null;
    }

    private void deleteProfile(final int position) {
        if (position < 0 || position >= this.mVpnProfileList.size()) {
            return;
        }
        DialogInterface.OnClickListener onClickListener = new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialog, int which) {
                dialog.dismiss();
                if (which == -1) {
                    VpnProfile p = (VpnProfile)VpnSettings.this.mVpnProfileList.remove(position);
                    VpnPreference pref = (VpnPreference)((Object)VpnSettings.this.mVpnPreferenceMap.remove(p.getName()));
                    VpnSettings.this.mVpnListContainer.removePreference((Preference)pref);
                    VpnSettings.this.removeProfileFromStorage(p);
                }
            }
        };
        this.mShowingDialog = new AlertDialog.Builder((Context)this).setTitle(0x1040014).setIcon(17301543).setMessage(2131231760).setPositiveButton(17039370, onClickListener).setNegativeButton(2131231747, onClickListener).create();
        this.mShowingDialog.show();
    }

    private void setProfileId(VpnProfile profile) {
        String id2;
        while ((id2 = String.valueOf(Math.abs(Double.doubleToLongBits(Math.random())))).length() < 8) {
        }
        for (VpnProfile p : this.mVpnProfileList) {
            if (!p.getId().equals(id2)) continue;
            this.setProfileId(profile);
            return;
        }
        profile.setId(id2);
    }

    private void addProfile(VpnProfile p) throws IOException {
        this.setProfileId(p);
        this.processSecrets(p);
        VpnSettings.saveProfileToStorage(p);
        this.mVpnProfileList.add(p);
        this.addPreferenceFor(p);
        this.disableProfilePreferencesIfOneActive();
    }

    private VpnPreference addPreferenceFor(VpnProfile p) {
        return this.addPreferenceFor(p, true);
    }

    private VpnPreference addPreferenceFor(VpnProfile p, boolean addToContainer) {
        VpnPreference pref = new VpnPreference((Context)this, p);
        this.mVpnPreferenceMap.put(p.getName(), pref);
        if (addToContainer) {
            this.mVpnListContainer.addPreference((Preference)pref);
        }
        pref.setOnPreferenceClickListener(new Preference.OnPreferenceClickListener(){

            public boolean onPreferenceClick(Preference pref) {
                VpnSettings.this.connectOrDisconnect(((VpnPreference)pref).mProfile);
                return true;
            }
        });
        return pref;
    }

    private void replaceProfile(int index, VpnProfile p) throws IOException {
        Map<String, VpnPreference> map = this.mVpnPreferenceMap;
        VpnProfile oldProfile = this.mVpnProfileList.set(index, p);
        VpnPreference pref = map.remove(oldProfile.getName());
        if (pref.mProfile != oldProfile) {
            throw new RuntimeException("inconsistent state!");
        }
        p.setId(oldProfile.getId());
        this.processSecrets(p);
        if (Util.copyFiles(VpnSettings.getProfileDir(oldProfile), VpnSettings.getProfileDir(p))) {
            this.removeProfileFromStorage(oldProfile);
        }
        VpnSettings.saveProfileToStorage(p);
        pref.setProfile(p);
        map.put(p.getName(), pref);
    }

    private void startVpnTypeSelection() {
        Intent intent = new Intent((Context)this, VpnTypeSelection.class);
        this.startActivityForResult(intent, 2);
    }

    private boolean isKeyStoreUnlocked() {
        return this.mKeyStore.test() == 1;
    }

    private boolean needKeyStoreToSave(VpnProfile p) {
        switch (p.getType()) {
            case L2TP_IPSEC_PSK: {
                L2tpIpsecPskProfile pskProfile = (L2tpIpsecPskProfile)p;
                String presharedKey = pskProfile.getPresharedKey();
                if (!TextUtils.isEmpty((CharSequence)presharedKey)) {
                    return true;
                }
            }
            case L2TP: {
                L2tpProfile l2tpProfile = (L2tpProfile)p;
                if (!l2tpProfile.isSecretEnabled() || TextUtils.isEmpty((CharSequence)l2tpProfile.getSecretString())) break;
                return true;
            }
        }
        return false;
    }

    private boolean needKeyStoreToConnect(VpnProfile p) {
        switch (p.getType()) {
            case L2TP_IPSEC_PSK: 
            case L2TP_IPSEC: {
                return true;
            }
            case L2TP: {
                return ((L2tpProfile)p).isSecretEnabled();
            }
        }
        return false;
    }

    private boolean unlockKeyStore(VpnProfile p, Runnable action) {
        if (this.isKeyStoreUnlocked()) {
            return true;
        }
        this.mUnlockAction = action;
        Credentials.getInstance().unlock((Context)this);
        return false;
    }

    private void startVpnEditor(VpnProfile profile) {
        Intent intent = new Intent((Context)this, VpnEditor.class);
        intent.putExtra(KEY_VPN_PROFILE, (Parcelable)profile);
        this.startActivityForResult(intent, 1);
    }

    private synchronized void connect(final VpnProfile p) {
        Runnable action;
        if (this.needKeyStoreToConnect(p) && !this.unlockKeyStore(p, action = new Runnable(){

            public void run() {
                VpnSettings.this.connect(p);
            }
        })) {
            return;
        }
        if (!this.checkSecrets(p)) {
            return;
        }
        this.changeState(p, VpnState.CONNECTING);
        if (this.mConnectingActor.isConnectDialogNeeded()) {
            this.showDialog(201);
        } else {
            this.mConnectingActor.connect(null);
        }
    }

    private synchronized void connectOrDisconnect(VpnProfile p) {
        VpnPreference pref = this.mVpnPreferenceMap.get(p.getName());
        switch (p.getState()) {
            case IDLE: {
                this.connect(p);
                break;
            }
            case CONNECTING: {
                break;
            }
            case CONNECTED: 
            case DISCONNECTING: {
                this.changeState(p, VpnState.DISCONNECTING);
                this.getActor(p).disconnect();
            }
        }
    }

    private void changeState(VpnProfile p, VpnState state) {
        VpnState oldState = p.getState();
        if (oldState == state) {
            return;
        }
        p.setState(state);
        this.mVpnPreferenceMap.get(p.getName()).setSummary(this.getProfileSummaryString(p));
        switch (state) {
            case CONNECTED: {
                this.mConnectingActor = null;
                this.mActiveProfile = p;
                this.disableProfilePreferencesIfOneActive();
                break;
            }
            case CONNECTING: {
                this.mConnectingActor = this.getActor(p);
            }
            case DISCONNECTING: {
                this.mActiveProfile = p;
                this.disableProfilePreferencesIfOneActive();
                break;
            }
            case CANCELLED: {
                this.changeState(p, VpnState.IDLE);
                break;
            }
            case IDLE: {
                assert (this.mActiveProfile == p);
                if (this.mConnectingErrorCode == 0) {
                    this.onIdle();
                    break;
                }
                this.showDialog(this.mConnectingErrorCode);
                this.mConnectingErrorCode = 0;
            }
        }
    }

    private void onIdle() {
        Log.d((String)TAG, (String)"   onIdle()");
        this.mActiveProfile = null;
        this.mConnectingActor = null;
        this.enableProfilePreferences();
    }

    private void disableProfilePreferencesIfOneActive() {
        if (this.mActiveProfile == null) {
            return;
        }
        block3: for (VpnProfile p : this.mVpnProfileList) {
            switch (p.getState()) {
                case IDLE: 
                case CONNECTING: 
                case DISCONNECTING: {
                    this.mVpnPreferenceMap.get(p.getName()).setEnabled(false);
                    continue block3;
                }
            }
            this.mVpnPreferenceMap.get(p.getName()).setEnabled(true);
        }
    }

    private void enableProfilePreferences() {
        for (VpnProfile p : this.mVpnProfileList) {
            this.mVpnPreferenceMap.get(p.getName()).setEnabled(true);
        }
    }

    static String getProfileDir(VpnProfile p) {
        return PROFILES_ROOT + p.getId();
    }

    static void saveProfileToStorage(VpnProfile p) throws IOException {
        File f = new File(VpnSettings.getProfileDir(p));
        if (!f.exists()) {
            f.mkdirs();
        }
        ObjectOutputStream oos = new ObjectOutputStream(new FileOutputStream(new File(f, PROFILE_OBJ_FILE)));
        oos.writeObject(p);
        oos.close();
    }

    private void removeProfileFromStorage(VpnProfile p) {
        Util.deleteFile(VpnSettings.getProfileDir(p));
    }

    private void retrieveVpnListFromStorage() {
        this.mVpnPreferenceMap = new LinkedHashMap<String, VpnPreference>();
        this.mVpnProfileList = Collections.synchronizedList(new ArrayList());
        this.mVpnListContainer.removeAll();
        File root = new File(PROFILES_ROOT);
        String[] dirs = root.list();
        if (dirs == null) {
            return;
        }
        for (String dir : dirs) {
            File f = new File(new File(root, dir), PROFILE_OBJ_FILE);
            if (!f.exists()) continue;
            try {
                VpnProfile p = this.deserialize(f);
                if (p == null || !this.checkIdConsistency(dir, p)) continue;
                this.mVpnProfileList.add(p);
            }
            catch (IOException e) {
                Log.e((String)TAG, (String)"retrieveVpnListFromStorage()", (Throwable)e);
            }
        }
        Collections.sort(this.mVpnProfileList, new Comparator<VpnProfile>(){

            @Override
            public int compare(VpnProfile p1, VpnProfile p2) {
                return p1.getName().compareTo(p2.getName());
            }

            public boolean equals(VpnProfile p) {
                return false;
            }
        });
        for (VpnProfile p : this.mVpnProfileList) {
            VpnPreference pref = this.addPreferenceFor(p, false);
        }
        this.disableProfilePreferencesIfOneActive();
    }

    private void checkVpnConnectionStatusInBackground() {
        new Thread(new Runnable(){

            public void run() {
                VpnSettings.this.mStatusChecker.check(VpnSettings.this.mVpnProfileList);
            }
        }).start();
    }

    private boolean checkIdConsistency(String dirName, VpnProfile p) {
        if (!dirName.equals(p.getId())) {
            Log.d((String)TAG, (String)("ID inconsistent: " + dirName + " vs " + p.getId()));
            return false;
        }
        return true;
    }

    private VpnProfile deserialize(File profileObjectFile) throws IOException {
        try {
            ObjectInputStream ois = new ObjectInputStream(new FileInputStream(profileObjectFile));
            VpnProfile p = (VpnProfile)ois.readObject();
            ois.close();
            return p;
        }
        catch (ClassNotFoundException e) {
            Log.d((String)TAG, (String)"deserialize a profile", (Throwable)e);
            return null;
        }
    }

    private String getProfileSummaryString(VpnProfile p) {
        switch (p.getState()) {
            case CONNECTING: {
                return this.getString(2131231777);
            }
            case DISCONNECTING: {
                return this.getString(2131231778);
            }
            case CONNECTED: {
                return this.getString(2131231779);
            }
        }
        return this.getString(2131231780);
    }

    private VpnProfileActor getActor(VpnProfile p) {
        return new AuthenticationActor((Context)this, p);
    }

    private VpnProfile createVpnProfile(String type) {
        return this.mVpnManager.createVpnProfile(Enum.valueOf(VpnType.class, type));
    }

    private boolean checkSecrets(VpnProfile p) {
        L2tpProfile l2tpProfile;
        String key;
        boolean secretMissing = false;
        if (p instanceof L2tpIpsecProfile) {
            L2tpIpsecProfile certProfile = (L2tpIpsecProfile)p;
            String cert = certProfile.getCaCertificate();
            if (TextUtils.isEmpty((CharSequence)cert) || !this.mKeyStore.contains("CACERT_" + cert)) {
                certProfile.setCaCertificate(null);
                secretMissing = true;
            }
            if (TextUtils.isEmpty((CharSequence)(cert = certProfile.getUserCertificate())) || !this.mKeyStore.contains("USRCERT_" + cert)) {
                certProfile.setUserCertificate(null);
                secretMissing = true;
            }
        }
        if (p instanceof L2tpIpsecPskProfile) {
            L2tpIpsecPskProfile pskProfile = (L2tpIpsecPskProfile)p;
            String presharedKey = pskProfile.getPresharedKey();
            key = KEY_PREFIX_IPSEC_PSK + p.getId();
            if (TextUtils.isEmpty((CharSequence)presharedKey) || !this.mKeyStore.contains(key)) {
                pskProfile.setPresharedKey(null);
                secretMissing = true;
            }
        }
        if (p instanceof L2tpProfile && (l2tpProfile = (L2tpProfile)p).isSecretEnabled()) {
            String secret = l2tpProfile.getSecretString();
            key = KEY_PREFIX_L2TP_SECRET + p.getId();
            if (TextUtils.isEmpty((CharSequence)secret) || !this.mKeyStore.contains(key)) {
                l2tpProfile.setSecretString(null);
                secretMissing = true;
            }
        }
        if (secretMissing) {
            this.mActiveProfile = p;
            this.showDialog(202);
            return false;
        }
        return true;
    }

    private void processSecrets(VpnProfile p) {
        switch (p.getType()) {
            case L2TP_IPSEC_PSK: {
                L2tpIpsecPskProfile pskProfile = (L2tpIpsecPskProfile)p;
                String presharedKey = pskProfile.getPresharedKey();
                String key = KEY_PREFIX_IPSEC_PSK + p.getId();
                if (!TextUtils.isEmpty((CharSequence)presharedKey) && !this.mKeyStore.put(key, presharedKey)) {
                    Log.e((String)TAG, (String)("keystore write failed: key=" + key));
                }
                pskProfile.setPresharedKey(key);
            }
            case L2TP: 
            case L2TP_IPSEC: {
                L2tpProfile l2tpProfile = (L2tpProfile)p;
                String key = KEY_PREFIX_L2TP_SECRET + p.getId();
                if (l2tpProfile.isSecretEnabled()) {
                    String secret = l2tpProfile.getSecretString();
                    if (!TextUtils.isEmpty((CharSequence)secret) && !this.mKeyStore.put(key, secret)) {
                        Log.e((String)TAG, (String)("keystore write failed: key=" + key));
                    }
                    l2tpProfile.setSecretString(key);
                    break;
                }
                this.mKeyStore.delete(key);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class StatusChecker {
        private List<VpnProfile> mList;

        private StatusChecker() {
        }

        synchronized void check(final List<VpnProfile> list) {
            final ConditionVariable cv = new ConditionVariable();
            cv.close();
            VpnSettings.this.mVpnManager.startVpnService();
            ServiceConnection c = new ServiceConnection(){

                public synchronized void onServiceConnected(ComponentName className, IBinder binder) {
                    cv.open();
                    IVpnService service = IVpnService.Stub.asInterface((IBinder)binder);
                    for (VpnProfile p : list) {
                        try {
                            service.checkStatus(p);
                        }
                        catch (Throwable e) {
                            Log.e((String)TAG, (String)(" --- checkStatus(): " + p.getName()), (Throwable)e);
                            VpnSettings.this.changeState(p, VpnState.IDLE);
                        }
                    }
                    VpnSettings.this.unbindService(this);
                    StatusChecker.this.showPreferences();
                }

                public void onServiceDisconnected(ComponentName className) {
                    cv.open();
                    StatusChecker.this.setDefaultState(list);
                    VpnSettings.this.unbindService(this);
                    StatusChecker.this.showPreferences();
                }
            };
            if (VpnSettings.this.mVpnManager.bindVpnService(c)) {
                if (!cv.block(1000L)) {
                    Log.d((String)TAG, (String)"checkStatus() bindService failed");
                    this.setDefaultState(list);
                }
            } else {
                this.setDefaultState(list);
            }
        }

        private void showPreferences() {
            for (VpnProfile p : VpnSettings.this.mVpnProfileList) {
                VpnPreference pref = (VpnPreference)((Object)VpnSettings.this.mVpnPreferenceMap.get(p.getName()));
                VpnSettings.this.mVpnListContainer.addPreference((Preference)pref);
            }
        }

        private void setDefaultState(List<VpnProfile> list) {
            for (VpnProfile p : list) {
                VpnSettings.this.changeState(p, VpnState.IDLE);
            }
            this.showPreferences();
        }
    }

    private class ConnectivityReceiver
    extends BroadcastReceiver {
        private ConnectivityReceiver() {
        }

        public void onReceive(Context context, Intent intent) {
            String profileName = intent.getStringExtra("profile_name");
            if (profileName == null) {
                return;
            }
            VpnState s = (VpnState)intent.getSerializableExtra("connection_state");
            if (s == null) {
                Log.e((String)TAG, (String)"received null connectivity state");
                return;
            }
            VpnSettings.this.mConnectingErrorCode = intent.getIntExtra("err", 0);
            VpnPreference pref = (VpnPreference)((Object)VpnSettings.this.mVpnPreferenceMap.get(profileName));
            if (pref != null) {
                Log.d((String)TAG, (String)("received connectivity: " + profileName + ": connected? " + s + "   err=" + VpnSettings.this.mConnectingErrorCode));
                VpnSettings.this.changeState(pref.mProfile, s);
            } else {
                Log.e((String)TAG, (String)("received connectivity: " + profileName + ": connected? " + s + ", but profile does not exist;" + " just ignore it"));
            }
        }
    }

    private class VpnPreference
    extends Preference {
        VpnProfile mProfile;

        VpnPreference(Context c, VpnProfile p) {
            super(c);
            this.setProfile(p);
        }

        void setProfile(VpnProfile p) {
            this.mProfile = p;
            this.setTitle(p.getName());
            this.setSummary(VpnSettings.this.getProfileSummaryString(p));
        }
    }
}

