/*
 * Decompiled with CFR 0.152.
 */
package com.android.settings.vpn;

import android.content.Context;
import android.net.vpn.VpnProfile;
import android.preference.CheckBoxPreference;
import android.preference.EditTextPreference;
import android.preference.ListPreference;
import android.preference.Preference;
import android.preference.PreferenceGroup;
import android.text.TextUtils;
import android.text.method.PasswordTransformationMethod;
import android.text.method.TransformationMethod;

class VpnProfileEditor {
    private static final String KEY_VPN_NAME = "vpn_name";
    private EditTextPreference mName;
    private EditTextPreference mServerName;
    private EditTextPreference mDomainSuffices;
    private VpnProfile mProfile;

    public VpnProfileEditor(VpnProfile p) {
        this.mProfile = p;
    }

    public VpnProfile getProfile() {
        return this.mProfile;
    }

    public void loadPreferencesTo(PreferenceGroup subpanel) {
        Context c = subpanel.getContext();
        this.mName = (EditTextPreference)subpanel.findPreference((CharSequence)KEY_VPN_NAME);
        this.mName.setOnPreferenceChangeListener(new Preference.OnPreferenceChangeListener(){

            public boolean onPreferenceChange(Preference pref, Object newValue) {
                VpnProfileEditor.this.setName((String)newValue);
                return true;
            }
        });
        this.setName(this.getProfile().getName());
        this.mName.getEditText().setInputType(16385);
        subpanel.addPreference(this.createServerNamePreference(c));
        this.loadExtraPreferencesTo(subpanel);
        subpanel.addPreference((Preference)this.createDomainSufficesPreference(c));
    }

    protected void loadExtraPreferencesTo(PreferenceGroup subpanel) {
    }

    public String validate() {
        String result = this.validate((Preference)this.mName, 2131231782);
        return result != null ? result : this.validate((Preference)this.mServerName, 2131231801);
    }

    protected EditTextPreference createDomainSufficesPreference(Context c) {
        EditTextPreference pref = this.mDomainSuffices = this.createEditTextPreference(c, 2131231803, 2131231804, this.mProfile.getDomainSuffices(), new Preference.OnPreferenceChangeListener(){

            public boolean onPreferenceChange(Preference pref, Object newValue) {
                String v = ((String)newValue).trim();
                VpnProfileEditor.this.mProfile.setDomainSuffices(v);
                VpnProfileEditor.this.setSummary(pref, 2131231804, v, false);
                return true;
            }
        });
        pref.getEditText().setInputType(16);
        return pref;
    }

    private Preference createServerNamePreference(Context c) {
        EditTextPreference pref = this.mServerName = this.createEditTextPreference(c, 2131231799, 2131231800, this.mProfile.getServerName(), new Preference.OnPreferenceChangeListener(){

            public boolean onPreferenceChange(Preference pref, Object newValue) {
                String v = ((String)newValue).trim();
                VpnProfileEditor.this.mProfile.setServerName(v);
                VpnProfileEditor.this.setSummary(pref, 2131231800, v);
                return true;
            }
        });
        pref.getEditText().setInputType(16);
        return pref;
    }

    protected EditTextPreference createEditTextPreference(Context c, int titleId, int prefNameId, String value, Preference.OnPreferenceChangeListener listener) {
        EditTextPreference pref = new EditTextPreference(c);
        pref.setTitle(titleId);
        pref.setDialogTitle(titleId);
        this.setSummary((Preference)pref, prefNameId, value);
        pref.setText(value);
        pref.setPersistent(true);
        pref.setOnPreferenceChangeListener(listener);
        return pref;
    }

    protected String validate(Preference pref, int fieldNameId) {
        Context c = pref.getContext();
        String value = pref instanceof EditTextPreference ? ((EditTextPreference)pref).getText() : ((ListPreference)pref).getValue();
        String formatString = pref instanceof EditTextPreference ? c.getString(2131231757) : c.getString(2131231758);
        return TextUtils.isEmpty((CharSequence)value) ? String.format(formatString, c.getString(fieldNameId)) : null;
    }

    protected void setSummary(Preference pref, int fieldNameId, String v) {
        this.setSummary(pref, fieldNameId, v, true);
    }

    protected void setSummary(Preference pref, int fieldNameId, String v, boolean required) {
        Context c = pref.getContext();
        String formatString = required ? c.getString(2131231806) : c.getString(2131231807);
        pref.setSummary((CharSequence)(TextUtils.isEmpty((CharSequence)v) ? String.format(formatString, c.getString(fieldNameId)) : v));
    }

    protected void setCheckBoxTitle(CheckBoxPreference pref, int fieldNameId) {
        Context c = pref.getContext();
        String formatString = c.getString(2131231808);
        pref.setTitle((CharSequence)String.format(formatString, c.getString(fieldNameId)));
    }

    private void setName(String newName) {
        newName = newName == null ? "" : newName.trim();
        this.mName.setText(newName);
        this.getProfile().setName(newName);
        this.setSummary((Preference)this.mName, 2131231781, newName);
    }

    protected static abstract class SecretHandler {
        private EditTextPreference mPref;
        private int mFieldNameId;
        private boolean mHadSecret;

        protected SecretHandler(Context c, int titleId, int fieldNameId) {
            String value = this.getSecretFromProfile();
            this.mHadSecret = !TextUtils.isEmpty((CharSequence)value);
            this.mFieldNameId = fieldNameId;
            EditTextPreference pref = this.mPref = new EditTextPreference(c);
            pref.setTitle(titleId);
            pref.setDialogTitle(titleId);
            pref.getEditText().setInputType(128);
            pref.getEditText().setTransformationMethod((TransformationMethod)new PasswordTransformationMethod());
            pref.setText("");
            pref.getEditText().setHint(this.mHadSecret ? 2131231814 : 2131231815);
            this.setSecretSummary(value);
            pref.setPersistent(true);
            this.saveSecretToProfile("");
            pref.setOnPreferenceChangeListener(new Preference.OnPreferenceChangeListener(){

                public boolean onPreferenceChange(Preference pref, Object newValue) {
                    SecretHandler.this.saveSecretToProfile((String)newValue);
                    SecretHandler.this.setSecretSummary((String)newValue);
                    return true;
                }
            });
        }

        protected EditTextPreference getPreference() {
            return this.mPref;
        }

        protected String validate() {
            Context c = this.mPref.getContext();
            String value = this.mPref.getText();
            return TextUtils.isEmpty((CharSequence)value) && !this.mHadSecret ? String.format(c.getString(2131231757), c.getString(this.mFieldNameId)) : null;
        }

        private void setSecretSummary(String value) {
            EditTextPreference pref = this.mPref;
            Context c = pref.getContext();
            String formatString = TextUtils.isEmpty((CharSequence)value) && !this.mHadSecret ? c.getString(2131231806) : c.getString(2131231805);
            pref.setSummary((CharSequence)String.format(formatString, c.getString(this.mFieldNameId)));
        }

        protected abstract String getSecretFromProfile();

        protected abstract void saveSecretToProfile(String var1);
    }
}

