/*
 * Decompiled with CFR 0.152.
 */
package com.android.settings.vpn;

import android.app.AlertDialog;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.net.vpn.L2tpIpsecProfile;
import android.net.vpn.L2tpIpsecPskProfile;
import android.net.vpn.L2tpProfile;
import android.net.vpn.PptpProfile;
import android.net.vpn.VpnProfile;
import android.os.Bundle;
import android.os.Parcel;
import android.os.Parcelable;
import android.preference.PreferenceActivity;
import android.preference.PreferenceGroup;
import android.text.TextUtils;
import android.view.KeyEvent;
import android.view.Menu;
import android.view.MenuItem;
import com.android.settings.vpn.L2tpEditor;
import com.android.settings.vpn.L2tpIpsecEditor;
import com.android.settings.vpn.L2tpIpsecPskEditor;
import com.android.settings.vpn.PptpEditor;
import com.android.settings.vpn.Util;
import com.android.settings.vpn.VpnProfileEditor;
import com.android.settings.vpn.VpnSettings;

public class VpnEditor
extends PreferenceActivity {
    private static final int MENU_SAVE = 1;
    private static final int MENU_CANCEL = 2;
    private static final String KEY_PROFILE = "profile";
    private static final String KEY_ORIGINAL_PROFILE_NAME = "orig_profile_name";
    private VpnProfileEditor mProfileEditor;
    private boolean mAddingProfile;
    private byte[] mOriginalProfileData;

    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        VpnProfile p = (VpnProfile)(savedInstanceState == null ? this.getIntent().getParcelableExtra("vpn_profile") : savedInstanceState.getParcelable(KEY_PROFILE));
        this.mProfileEditor = this.getEditor(p);
        this.mAddingProfile = TextUtils.isEmpty((CharSequence)p.getName());
        this.addPreferencesFromResource(2130968612);
        this.initViewFor(p);
        Parcel parcel = Parcel.obtain();
        p.writeToParcel(parcel, 0);
        this.mOriginalProfileData = parcel.marshall();
    }

    protected synchronized void onSaveInstanceState(Bundle outState) {
        if (this.mProfileEditor == null) {
            return;
        }
        outState.putParcelable(KEY_PROFILE, (Parcelable)this.getProfile());
    }

    public boolean onCreateOptionsMenu(Menu menu) {
        super.onCreateOptionsMenu(menu);
        menu.add(0, 1, 0, 2131231750).setIcon(17301582);
        menu.add(0, 2, 0, this.mAddingProfile ? 2131231751 : 2131231752).setIcon(17301560);
        return true;
    }

    public boolean onOptionsItemSelected(MenuItem item) {
        switch (item.getItemId()) {
            case 1: {
                if (this.validateAndSetResult()) {
                    this.finish();
                }
                return true;
            }
            case 2: {
                if (this.profileChanged()) {
                    this.showCancellationConfirmDialog();
                } else {
                    this.finish();
                }
                return true;
            }
        }
        return super.onOptionsItemSelected(item);
    }

    public boolean onKeyDown(int keyCode, KeyEvent event) {
        switch (keyCode) {
            case 4: {
                if (this.validateAndSetResult()) {
                    this.finish();
                }
                return true;
            }
        }
        return super.onKeyDown(keyCode, event);
    }

    private void initViewFor(VpnProfile profile) {
        this.setTitle(profile);
        this.mProfileEditor.loadPreferencesTo((PreferenceGroup)this.getPreferenceScreen());
    }

    private void setTitle(VpnProfile profile) {
        String formatString = this.mAddingProfile ? this.getString(2131231774) : this.getString(2131231775);
        this.setTitle(String.format(formatString, profile.getType().getDisplayName()));
    }

    private boolean validateAndSetResult() {
        String errorMsg = this.mProfileEditor.validate();
        if (errorMsg != null) {
            Util.showErrorMessage((Context)this, errorMsg);
            return false;
        }
        if (this.profileChanged()) {
            this.setResult(this.getProfile());
        }
        return true;
    }

    private void setResult(VpnProfile p) {
        Intent intent = new Intent((Context)this, VpnSettings.class);
        intent.putExtra("vpn_profile", (Parcelable)p);
        this.setResult(-1, intent);
    }

    private VpnProfileEditor getEditor(VpnProfile p) {
        switch (p.getType()) {
            case L2TP_IPSEC: {
                return new L2tpIpsecEditor((L2tpIpsecProfile)p);
            }
            case L2TP_IPSEC_PSK: {
                return new L2tpIpsecPskEditor((L2tpIpsecPskProfile)p);
            }
            case L2TP: {
                return new L2tpEditor((L2tpProfile)p);
            }
            case PPTP: {
                return new PptpEditor((PptpProfile)p);
            }
        }
        return new VpnProfileEditor(p);
    }

    private void showCancellationConfirmDialog() {
        new AlertDialog.Builder((Context)this).setTitle(0x1040014).setIcon(17301543).setMessage(this.mAddingProfile ? 2131231761 : 2131231762).setPositiveButton(2131231746, new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialog, int w) {
                VpnEditor.this.finish();
            }
        }).setNegativeButton(2131231749, null).show();
    }

    private VpnProfile getProfile() {
        return this.mProfileEditor.getProfile();
    }

    private boolean profileChanged() {
        Parcel newParcel = Parcel.obtain();
        this.getProfile().writeToParcel(newParcel, 0);
        byte[] newData = newParcel.marshall();
        if (this.mOriginalProfileData.length == newData.length) {
            int n = this.mOriginalProfileData.length;
            for (int i = 0; i < n; ++i) {
                if (this.mOriginalProfileData[i] == newData[i]) continue;
                return true;
            }
            return false;
        }
        return true;
    }
}

