/*
 * Decompiled with CFR 0.152.
 */
package com.android.settings.vpn;

import android.app.AlertDialog;
import android.content.Context;
import android.content.DialogInterface;
import android.widget.Toast;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

class Util {
    static void showShortToastMessage(Context context, String message) {
        Toast.makeText((Context)context, (CharSequence)message, (int)0).show();
    }

    static void showShortToastMessage(Context context, int messageId) {
        Toast.makeText((Context)context, (int)messageId, (int)0).show();
    }

    static void showLongToastMessage(Context context, String message) {
        Toast.makeText((Context)context, (CharSequence)message, (int)1).show();
    }

    static void showLongToastMessage(Context context, int messageId) {
        Toast.makeText((Context)context, (int)messageId, (int)1).show();
    }

    static void showErrorMessage(Context c, String message) {
        Util.createErrorDialog(c, message, null).show();
    }

    static void showErrorMessage(Context c, String message, DialogInterface.OnClickListener listener) {
        Util.createErrorDialog(c, message, listener).show();
    }

    static void deleteFile(String path) {
        Util.deleteFile(new File(path));
    }

    static void deleteFile(String path, boolean toDeleteSelf) {
        Util.deleteFile(new File(path), toDeleteSelf);
    }

    static void deleteFile(File f) {
        Util.deleteFile(f, true);
    }

    static void deleteFile(File f, boolean toDeleteSelf) {
        if (f.isDirectory()) {
            for (File child : f.listFiles()) {
                Util.deleteFile(child, true);
            }
        }
        if (toDeleteSelf) {
            f.delete();
        }
    }

    static boolean isFileOrEmptyDirectory(String path) {
        File f = new File(path);
        if (!f.isDirectory()) {
            return true;
        }
        String[] list = f.list();
        return list == null || list.length == 0;
    }

    static boolean copyFiles(String sourcePath, String targetPath) throws IOException {
        return Util.copyFiles(new File(sourcePath), new File(targetPath));
    }

    static boolean copyFiles(File sourceLocation, File targetLocation) throws IOException {
        if (sourceLocation.equals(targetLocation)) {
            return false;
        }
        if (sourceLocation.isDirectory()) {
            if (!targetLocation.exists()) {
                targetLocation.mkdir();
            }
            String[] children = sourceLocation.list();
            for (int i = 0; i < children.length; ++i) {
                Util.copyFiles(new File(sourceLocation, children[i]), new File(targetLocation, children[i]));
            }
        } else if (sourceLocation.exists()) {
            int len;
            FileInputStream in = new FileInputStream(sourceLocation);
            FileOutputStream out = new FileOutputStream(targetLocation);
            byte[] buf = new byte[1024];
            while ((len = ((InputStream)in).read(buf)) > 0) {
                ((OutputStream)out).write(buf, 0, len);
            }
            ((InputStream)in).close();
            ((OutputStream)out).close();
        }
        return true;
    }

    private static AlertDialog createErrorDialog(Context c, String message, DialogInterface.OnClickListener okListener) {
        AlertDialog.Builder b = new AlertDialog.Builder(c).setTitle(0x1040014).setIcon(17301543).setMessage((CharSequence)message);
        if (okListener != null) {
            b.setPositiveButton(2131231748, okListener);
        } else {
            b.setPositiveButton(17039370, null);
        }
        return b.create();
    }

    private Util() {
    }
}

