/*
 * Decompiled with CFR 0.152.
 */
package com.android.settings.vpn;

import android.content.Context;
import android.net.vpn.PptpProfile;
import android.net.vpn.VpnProfile;
import android.preference.CheckBoxPreference;
import android.preference.Preference;
import android.preference.PreferenceGroup;
import com.android.settings.vpn.VpnProfileEditor;

class PptpEditor
extends VpnProfileEditor {
    private CheckBoxPreference mEncryption;

    public PptpEditor(PptpProfile p) {
        super((VpnProfile)p);
    }

    protected void loadExtraPreferencesTo(PreferenceGroup subpanel) {
        Context c = subpanel.getContext();
        subpanel.addPreference(this.createEncryptionPreference(c));
        PptpProfile profile = (PptpProfile)this.getProfile();
    }

    private Preference createEncryptionPreference(Context c) {
        final PptpProfile profile = (PptpProfile)this.getProfile();
        CheckBoxPreference encryption = this.mEncryption = new CheckBoxPreference(c);
        boolean enabled = profile.isEncryptionEnabled();
        this.setCheckBoxTitle(encryption, 2131231794);
        encryption.setChecked(enabled);
        this.setEncryptionSummary(encryption, enabled);
        encryption.setOnPreferenceChangeListener(new Preference.OnPreferenceChangeListener(){

            public boolean onPreferenceChange(Preference pref, Object newValue) {
                boolean enabled = (Boolean)newValue;
                profile.setEncryptionEnabled(enabled);
                PptpEditor.this.setEncryptionSummary(PptpEditor.this.mEncryption, enabled);
                return true;
            }
        });
        return encryption;
    }

    private void setEncryptionSummary(CheckBoxPreference encryption, boolean enabled) {
        Context c = encryption.getContext();
        String formatString = c.getString(enabled ? 2131231810 : 2131231811);
        encryption.setSummary((CharSequence)String.format(formatString, c.getString(2131231795)));
    }
}

