/*
 * Decompiled with CFR 0.152.
 */
package com.android.settings.vpn;

import android.content.Context;
import android.net.vpn.L2tpIpsecProfile;
import android.net.vpn.L2tpProfile;
import android.preference.ListPreference;
import android.preference.Preference;
import android.preference.PreferenceGroup;
import android.security.KeyStore;
import com.android.settings.vpn.L2tpEditor;

class L2tpIpsecEditor
extends L2tpEditor {
    private static final String TAG = L2tpIpsecEditor.class.getSimpleName();
    private KeyStore mKeyStore = KeyStore.getInstance();
    private ListPreference mUserCertificate;
    private ListPreference mCaCertificate;
    private L2tpIpsecProfile mProfile;

    public L2tpIpsecEditor(L2tpIpsecProfile p) {
        super((L2tpProfile)p);
        this.mProfile = p;
    }

    protected void loadExtraPreferencesTo(PreferenceGroup subpanel) {
        super.loadExtraPreferencesTo(subpanel);
        Context c = subpanel.getContext();
        subpanel.addPreference(this.createUserCertificatePreference(c));
        subpanel.addPreference(this.createCaCertificatePreference(c));
    }

    public String validate() {
        String result = super.validate();
        if (result == null) {
            result = this.validate((Preference)this.mUserCertificate, 2131231787);
        }
        if (result == null) {
            result = this.validate((Preference)this.mCaCertificate, 2131231790);
        }
        return result;
    }

    private Preference createUserCertificatePreference(Context c) {
        this.mUserCertificate = this.createListPreference(c, 2131231785, this.mProfile.getUserCertificate(), this.mKeyStore.saw("USRCERT_"), new Preference.OnPreferenceChangeListener(){

            public boolean onPreferenceChange(Preference pref, Object newValue) {
                L2tpIpsecEditor.this.mProfile.setUserCertificate((String)newValue);
                L2tpIpsecEditor.this.setSummary(pref, 2131231786, (String)newValue);
                return true;
            }
        });
        this.setSummary((Preference)this.mUserCertificate, 2131231786, this.mProfile.getUserCertificate());
        return this.mUserCertificate;
    }

    private Preference createCaCertificatePreference(Context c) {
        this.mCaCertificate = this.createListPreference(c, 2131231788, this.mProfile.getCaCertificate(), this.mKeyStore.saw("CACERT_"), new Preference.OnPreferenceChangeListener(){

            public boolean onPreferenceChange(Preference pref, Object newValue) {
                L2tpIpsecEditor.this.mProfile.setCaCertificate((String)newValue);
                L2tpIpsecEditor.this.setSummary(pref, 2131231789, (String)newValue);
                return true;
            }
        });
        this.setSummary((Preference)this.mCaCertificate, 2131231789, this.mProfile.getCaCertificate());
        return this.mCaCertificate;
    }

    private ListPreference createListPreference(Context c, int titleResId, String text, String[] keys, Preference.OnPreferenceChangeListener listener) {
        ListPreference pref = new ListPreference(c);
        pref.setTitle(titleResId);
        pref.setDialogTitle(titleResId);
        pref.setPersistent(true);
        pref.setEntries((CharSequence[])keys);
        pref.setEntryValues((CharSequence[])keys);
        pref.setValue(text);
        pref.setOnPreferenceChangeListener(listener);
        return pref;
    }
}

