/*
 * Decompiled with CFR 0.152.
 */
package com.android.settings.vpn;

import android.content.Context;
import android.net.vpn.L2tpProfile;
import android.net.vpn.VpnProfile;
import android.preference.CheckBoxPreference;
import android.preference.EditTextPreference;
import android.preference.Preference;
import android.preference.PreferenceGroup;
import com.android.settings.vpn.VpnProfileEditor;

class L2tpEditor
extends VpnProfileEditor {
    private CheckBoxPreference mSecret;
    private VpnProfileEditor.SecretHandler mSecretHandler;

    public L2tpEditor(L2tpProfile p) {
        super((VpnProfile)p);
    }

    protected void loadExtraPreferencesTo(PreferenceGroup subpanel) {
        Context c = subpanel.getContext();
        subpanel.addPreference(this.createSecretPreference(c));
        subpanel.addPreference(this.createSecretStringPreference(c));
        L2tpProfile profile = (L2tpProfile)this.getProfile();
    }

    public String validate() {
        String result = super.validate();
        if (!this.mSecret.isChecked()) {
            return result;
        }
        return result != null ? result : this.mSecretHandler.validate();
    }

    private Preference createSecretPreference(Context c) {
        final L2tpProfile profile = (L2tpProfile)this.getProfile();
        CheckBoxPreference secret = this.mSecret = new CheckBoxPreference(c);
        boolean enabled = profile.isSecretEnabled();
        this.setCheckBoxTitle(secret, 2131231792);
        secret.setChecked(enabled);
        this.setSecretSummary(secret, enabled);
        secret.setOnPreferenceChangeListener(new Preference.OnPreferenceChangeListener(){

            public boolean onPreferenceChange(Preference pref, Object newValue) {
                boolean enabled = (Boolean)newValue;
                profile.setSecretEnabled(enabled);
                L2tpEditor.this.mSecretHandler.getPreference().setEnabled(enabled);
                L2tpEditor.this.setSecretSummary(L2tpEditor.this.mSecret, enabled);
                return true;
            }
        });
        return secret;
    }

    private Preference createSecretStringPreference(Context c) {
        VpnProfileEditor.SecretHandler sHandler = this.mSecretHandler = new VpnProfileEditor.SecretHandler(c, 2131231791, 2131231792){

            protected String getSecretFromProfile() {
                return ((L2tpProfile)L2tpEditor.this.getProfile()).getSecretString();
            }

            protected void saveSecretToProfile(String secret) {
                ((L2tpProfile)L2tpEditor.this.getProfile()).setSecretString(secret);
            }
        };
        EditTextPreference pref = sHandler.getPreference();
        pref.setEnabled(this.mSecret.isChecked());
        return pref;
    }

    private void setSecretSummary(CheckBoxPreference secret, boolean enabled) {
        Context c = secret.getContext();
        String formatString = c.getString(enabled ? 2131231810 : 2131231811);
        secret.setSummary((CharSequence)String.format(formatString, c.getString(2131231792)));
    }
}

