/*
 * Decompiled with CFR 0.152.
 */
package com.android.settings.vpn;

import android.app.Dialog;
import android.content.ComponentName;
import android.content.Context;
import android.content.ServiceConnection;
import android.net.vpn.IVpnService;
import android.net.vpn.VpnManager;
import android.net.vpn.VpnProfile;
import android.net.vpn.VpnState;
import android.os.ConditionVariable;
import android.os.IBinder;
import android.os.RemoteException;
import android.text.TextUtils;
import android.util.Log;
import android.view.View;
import android.widget.CheckBox;
import android.widget.TextView;
import com.android.settings.vpn.VpnProfileActor;
import com.android.settings.vpn.VpnSettings;
import java.io.IOException;

public class AuthenticationActor
implements VpnProfileActor {
    private static final String TAG = AuthenticationActor.class.getName();
    private Context mContext;
    private VpnProfile mProfile;
    private VpnManager mVpnManager;

    public AuthenticationActor(Context context, VpnProfile p) {
        this.mContext = context;
        this.mProfile = p;
        this.mVpnManager = new VpnManager(context);
    }

    public VpnProfile getProfile() {
        return this.mProfile;
    }

    public boolean isConnectDialogNeeded() {
        return true;
    }

    public String validateInputs(Dialog d) {
        TextView usernameView = (TextView)d.findViewById(2131427525);
        TextView passwordView = (TextView)d.findViewById(2131427527);
        Context c = this.mContext;
        if (TextUtils.isEmpty((CharSequence)((Object)usernameView.getText()).toString())) {
            return c.getString(2131231742);
        }
        if (TextUtils.isEmpty((CharSequence)((Object)passwordView.getText()).toString())) {
            return c.getString(2131231743);
        }
        return null;
    }

    public void connect(Dialog d) {
        TextView usernameView = (TextView)d.findViewById(2131427525);
        TextView passwordView = (TextView)d.findViewById(2131427527);
        CheckBox saveUsername = (CheckBox)d.findViewById(2131427528);
        try {
            this.setSavedUsername(saveUsername.isChecked() ? ((Object)usernameView.getText()).toString() : "");
        }
        catch (IOException e) {
            Log.e((String)TAG, (String)"setSavedUsername()", (Throwable)e);
        }
        this.connect(((Object)usernameView.getText()).toString(), ((Object)passwordView.getText()).toString());
        passwordView.setText((CharSequence)"");
    }

    public View createConnectView() {
        View v = View.inflate((Context)this.mContext, (int)2130903102, null);
        TextView usernameView = (TextView)v.findViewById(2131427525);
        TextView passwordView = (TextView)v.findViewById(2131427527);
        CheckBox saveUsername = (CheckBox)v.findViewById(2131427528);
        String username = this.mProfile.getSavedUsername();
        if (!TextUtils.isEmpty((CharSequence)username)) {
            usernameView.setText((CharSequence)username);
            saveUsername.setChecked(true);
            passwordView.requestFocus();
        }
        return v;
    }

    protected Context getContext() {
        return this.mContext;
    }

    private void connect(final String username, final String password) {
        this.mVpnManager.startVpnService();
        ServiceConnection c = new ServiceConnection(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void onServiceConnected(ComponentName className, IBinder service) {
                try {
                    boolean success = IVpnService.Stub.asInterface((IBinder)service).connect(AuthenticationActor.this.mProfile, username, password);
                    if (!success) {
                        Log.d((String)TAG, (String)"~~~~~~ connect() failed!");
                    } else {
                        Log.d((String)TAG, (String)"~~~~~~ connect() succeeded!");
                    }
                }
                catch (Throwable e) {
                    Log.e((String)TAG, (String)"connect()", (Throwable)e);
                    AuthenticationActor.this.broadcastConnectivity(VpnState.IDLE, 101);
                }
                finally {
                    AuthenticationActor.this.mContext.unbindService((ServiceConnection)this);
                }
            }

            public void onServiceDisconnected(ComponentName className) {
                AuthenticationActor.this.checkStatus();
            }
        };
        if (!this.bindService(c)) {
            this.broadcastConnectivity(VpnState.IDLE, 101);
        }
    }

    public void disconnect() {
        ServiceConnection c = new ServiceConnection(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void onServiceConnected(ComponentName className, IBinder service) {
                try {
                    IVpnService.Stub.asInterface((IBinder)service).disconnect();
                }
                catch (RemoteException e) {
                    Log.e((String)TAG, (String)"disconnect()", (Throwable)e);
                    AuthenticationActor.this.checkStatus();
                }
                finally {
                    AuthenticationActor.this.mContext.unbindService((ServiceConnection)this);
                }
            }

            public void onServiceDisconnected(ComponentName className) {
                AuthenticationActor.this.checkStatus();
            }
        };
        if (!this.bindService(c)) {
            this.checkStatus();
        }
    }

    public void checkStatus() {
        final ConditionVariable cv = new ConditionVariable();
        cv.close();
        ServiceConnection c = new ServiceConnection(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public synchronized void onServiceConnected(ComponentName className, IBinder service) {
                cv.open();
                try {
                    IVpnService.Stub.asInterface((IBinder)service).checkStatus(AuthenticationActor.this.mProfile);
                }
                catch (RemoteException e) {
                    Log.e((String)TAG, (String)"checkStatus()", (Throwable)e);
                    AuthenticationActor.this.broadcastConnectivity(VpnState.IDLE);
                }
                finally {
                    AuthenticationActor.this.mContext.unbindService((ServiceConnection)this);
                }
            }

            public void onServiceDisconnected(ComponentName className) {
                cv.open();
                AuthenticationActor.this.broadcastConnectivity(VpnState.IDLE);
                AuthenticationActor.this.mContext.unbindService((ServiceConnection)this);
            }
        };
        if (this.bindService(c) && !cv.block(1000L)) {
            this.broadcastConnectivity(VpnState.IDLE);
        }
    }

    private boolean bindService(ServiceConnection c) {
        return this.mVpnManager.bindVpnService(c);
    }

    private void broadcastConnectivity(VpnState s) {
        this.mVpnManager.broadcastConnectivity(this.mProfile.getName(), s);
    }

    private void broadcastConnectivity(VpnState s, int errorCode) {
        this.mVpnManager.broadcastConnectivity(this.mProfile.getName(), s, errorCode);
    }

    private void setSavedUsername(String name) throws IOException {
        if (!name.equals(this.mProfile.getSavedUsername())) {
            this.mProfile.setSavedUsername(name);
            VpnSettings.saveProfileToStorage(this.mProfile);
        }
    }
}

