/*
 * Decompiled with CFR 0.152.
 */
package com.android.settings.quicklaunch;

import android.content.Context;
import android.content.res.ColorStateList;
import android.preference.Preference;
import android.util.TypedValue;
import android.view.View;
import android.widget.TextView;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ShortcutPreference
extends Preference
implements Comparable<Preference> {
    private static Object sStaticVarsLock = new Object();
    private static String STRING_ASSIGN_APPLICATION;
    private static String STRING_NO_SHORTCUT;
    private static int sDimAlpha;
    private static ColorStateList sRegularTitleColor;
    private static ColorStateList sDimTitleColor;
    private static ColorStateList sRegularSummaryColor;
    private static ColorStateList sDimSummaryColor;
    private char mShortcut;
    private boolean mHasBookmark;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ShortcutPreference(Context context, char shortcut) {
        super(context);
        Object object = sStaticVarsLock;
        synchronized (object) {
            if (STRING_ASSIGN_APPLICATION == null) {
                STRING_ASSIGN_APPLICATION = context.getString(2131231575);
                STRING_NO_SHORTCUT = context.getString(2131231576);
                TypedValue outValue = new TypedValue();
                context.getTheme().resolveAttribute(0x1010033, outValue, true);
                sDimAlpha = (int)(outValue.getFloat() * 255.0f);
            }
        }
        this.mShortcut = shortcut;
        this.setWidgetLayoutResource(2130903087);
    }

    public char getShortcut() {
        return this.mShortcut;
    }

    public void setShortcut(char shortcut) {
        if (shortcut != this.mShortcut) {
            this.mShortcut = shortcut;
            this.notifyChanged();
        }
    }

    public boolean hasBookmark() {
        return this.mHasBookmark;
    }

    public void setHasBookmark(boolean hasBookmark) {
        if (hasBookmark != this.mHasBookmark) {
            this.mHasBookmark = hasBookmark;
            this.notifyChanged();
        }
    }

    public CharSequence getTitle() {
        return this.mHasBookmark ? super.getTitle() : STRING_ASSIGN_APPLICATION;
    }

    public CharSequence getSummary() {
        return this.mHasBookmark ? super.getSummary() : STRING_NO_SHORTCUT;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void onBindView(View view) {
        ColorStateList color2;
        super.onBindView(view);
        TextView shortcutView = (TextView)view.findViewById(2131427457);
        if (shortcutView != null) {
            shortcutView.setText((CharSequence)String.valueOf(this.mShortcut));
        }
        TextView titleView = (TextView)view.findViewById(16908310);
        Object object = sStaticVarsLock;
        synchronized (object) {
            if (sRegularTitleColor == null) {
                sRegularTitleColor = titleView.getTextColors();
                sDimTitleColor = sRegularTitleColor.withAlpha(sDimAlpha);
            }
        }
        ColorStateList colorStateList = color2 = this.mHasBookmark ? sRegularTitleColor : sDimTitleColor;
        if (color2 != null) {
            titleView.setTextColor(color2);
        }
        TextView summaryView = (TextView)view.findViewById(0x1020010);
        Object object2 = sStaticVarsLock;
        synchronized (object2) {
            if (sRegularSummaryColor == null) {
                sRegularSummaryColor = summaryView.getTextColors();
                sDimSummaryColor = sRegularSummaryColor.withAlpha(sDimAlpha);
            }
        }
        ColorStateList colorStateList2 = color2 = this.mHasBookmark ? sRegularSummaryColor : sDimSummaryColor;
        if (color2 != null) {
            summaryView.setTextColor(color2);
        }
    }

    @Override
    public int compareTo(Preference another) {
        if (!(another instanceof ShortcutPreference)) {
            return super.compareTo(another);
        }
        char other = ((ShortcutPreference)another).mShortcut;
        if (Character.isDigit(this.mShortcut) && Character.isLetter(other)) {
            return 1;
        }
        if (Character.isDigit(other) && Character.isLetter(this.mShortcut)) {
            return -1;
        }
        return this.mShortcut - other;
    }
}

