/*
 * Decompiled with CFR 0.152.
 */
package com.android.settings.quicklaunch;

import android.app.AlertDialog;
import android.app.Dialog;
import android.content.ContentResolver;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.content.pm.PackageManager;
import android.content.pm.ResolveInfo;
import android.database.ContentObserver;
import android.database.Cursor;
import android.os.Bundle;
import android.os.Handler;
import android.preference.Preference;
import android.preference.PreferenceActivity;
import android.preference.PreferenceGroup;
import android.preference.PreferenceScreen;
import android.provider.Settings;
import android.util.Log;
import android.util.SparseArray;
import android.util.SparseBooleanArray;
import android.view.KeyCharacterMap;
import android.view.KeyEvent;
import android.view.View;
import android.widget.AdapterView;
import com.android.settings.quicklaunch.BookmarkPicker;
import com.android.settings.quicklaunch.ShortcutPreference;
import java.net.URISyntaxException;

public class QuickLaunchSettings
extends PreferenceActivity
implements AdapterView.OnItemLongClickListener,
DialogInterface.OnClickListener {
    private static final String TAG = "QuickLaunchSettings";
    private static final String KEY_SHORTCUT_CATEGORY = "shortcut_category";
    private static final int DIALOG_CLEAR_SHORTCUT = 0;
    private static final int REQUEST_PICK_BOOKMARK = 1;
    private static final int COLUMN_SHORTCUT = 0;
    private static final int COLUMN_TITLE = 1;
    private static final int COLUMN_INTENT = 2;
    private static final String[] sProjection = new String[]{"shortcut", "title", "intent"};
    private static final String sShortcutSelection = "shortcut=?";
    private Handler mUiHandler = new Handler();
    private static final String DEFAULT_BOOKMARK_FOLDER = "@quicklaunch";
    private Cursor mBookmarksCursor;
    private BookmarksObserver mBookmarksObserver;
    private SparseBooleanArray mBookmarkedShortcuts;
    private PreferenceGroup mShortcutGroup;
    private SparseArray<ShortcutPreference> mShortcutToPreference;
    private CharSequence mClearDialogBookmarkTitle;
    private static final String CLEAR_DIALOG_BOOKMARK_TITLE = "CLEAR_DIALOG_BOOKMARK_TITLE";
    private char mClearDialogShortcut;
    private static final String CLEAR_DIALOG_SHORTCUT = "CLEAR_DIALOG_SHORTCUT";

    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.addPreferencesFromResource(2130968596);
        this.mShortcutGroup = (PreferenceGroup)this.findPreference(KEY_SHORTCUT_CATEGORY);
        this.mShortcutToPreference = new SparseArray();
        this.mBookmarksObserver = new BookmarksObserver(this.mUiHandler);
        this.initShortcutPreferences();
        this.mBookmarksCursor = this.managedQuery(Settings.Bookmarks.CONTENT_URI, sProjection, null, null);
        this.getListView().setOnItemLongClickListener((AdapterView.OnItemLongClickListener)this);
    }

    protected void onResume() {
        super.onResume();
        this.getContentResolver().registerContentObserver(Settings.Bookmarks.CONTENT_URI, true, (ContentObserver)this.mBookmarksObserver);
        this.refreshShortcuts();
    }

    protected void onPause() {
        super.onPause();
        this.getContentResolver().unregisterContentObserver((ContentObserver)this.mBookmarksObserver);
    }

    protected void onRestoreInstanceState(Bundle state) {
        super.onRestoreInstanceState(state);
        this.mClearDialogBookmarkTitle = state.getString(CLEAR_DIALOG_BOOKMARK_TITLE);
        this.mClearDialogShortcut = (char)state.getInt(CLEAR_DIALOG_SHORTCUT, 0);
    }

    protected void onSaveInstanceState(Bundle outState) {
        super.onSaveInstanceState(outState);
        outState.putCharSequence(CLEAR_DIALOG_BOOKMARK_TITLE, this.mClearDialogBookmarkTitle);
        outState.putInt(CLEAR_DIALOG_SHORTCUT, (int)this.mClearDialogShortcut);
    }

    protected Dialog onCreateDialog(int id2) {
        switch (id2) {
            case 0: {
                return new AlertDialog.Builder((Context)this).setTitle((CharSequence)this.getString(2131231578)).setIcon(17301543).setMessage((CharSequence)this.getString(2131231579, new Object[]{Character.valueOf(this.mClearDialogShortcut), this.mClearDialogBookmarkTitle})).setPositiveButton(2131231580, (DialogInterface.OnClickListener)this).setNegativeButton(2131231581, (DialogInterface.OnClickListener)this).create();
            }
        }
        return super.onCreateDialog(id2);
    }

    protected void onPrepareDialog(int id2, Dialog dialog) {
        switch (id2) {
            case 0: {
                AlertDialog alertDialog = (AlertDialog)dialog;
                alertDialog.setMessage((CharSequence)this.getString(2131231579, new Object[]{Character.valueOf(this.mClearDialogShortcut), this.mClearDialogBookmarkTitle}));
            }
        }
    }

    private void showClearDialog(ShortcutPreference pref) {
        if (!pref.hasBookmark()) {
            return;
        }
        this.mClearDialogBookmarkTitle = pref.getTitle();
        this.mClearDialogShortcut = pref.getShortcut();
        this.showDialog(0);
    }

    public void onClick(DialogInterface dialog, int which) {
        if (this.mClearDialogShortcut > '\u0000' && which == -1) {
            this.clearShortcut(this.mClearDialogShortcut);
        }
        this.mClearDialogBookmarkTitle = null;
        this.mClearDialogShortcut = '\u0000';
    }

    private void clearShortcut(char shortcut) {
        this.getContentResolver().delete(Settings.Bookmarks.CONTENT_URI, sShortcutSelection, new String[]{String.valueOf((int)shortcut)});
    }

    public boolean onPreferenceTreeClick(PreferenceScreen preferenceScreen, Preference preference) {
        if (!(preference instanceof ShortcutPreference)) {
            return false;
        }
        ShortcutPreference pref = (ShortcutPreference)preference;
        Intent intent = new Intent((Context)this, BookmarkPicker.class);
        intent.putExtra("com.android.settings.quicklaunch.SHORTCUT", pref.getShortcut());
        this.startActivityForResult(intent, 1);
        return true;
    }

    public boolean onItemLongClick(AdapterView parent, View view, int position, long id2) {
        Preference pref = (Preference)this.getPreferenceScreen().getRootAdapter().getItem(position);
        if (!(pref instanceof ShortcutPreference)) {
            return false;
        }
        this.showClearDialog((ShortcutPreference)pref);
        return true;
    }

    protected void onActivityResult(int requestCode, int resultCode, Intent data) {
        if (resultCode != -1) {
            return;
        }
        if (requestCode == 1) {
            if (data == null) {
                Log.w((String)TAG, (String)"Result from bookmark picker does not have an intent.");
                return;
            }
            char shortcut = data.getCharExtra("com.android.settings.quicklaunch.SHORTCUT", '\u0000');
            this.updateShortcut(shortcut, data);
        } else {
            super.onActivityResult(requestCode, resultCode, data);
        }
    }

    private void updateShortcut(char shortcut, Intent intent) {
        Settings.Bookmarks.add((ContentResolver)this.getContentResolver(), (Intent)intent, (String)"", (String)DEFAULT_BOOKMARK_FOLDER, (char)shortcut, (int)0);
    }

    private ShortcutPreference getOrCreatePreference(char shortcut) {
        ShortcutPreference pref = (ShortcutPreference)this.mShortcutToPreference.get((int)shortcut);
        if (pref != null) {
            return pref;
        }
        Log.w((String)TAG, (String)("Unknown shortcut '" + shortcut + "', creating preference anyway"));
        return this.createPreference(shortcut);
    }

    private ShortcutPreference createPreference(char shortcut) {
        ShortcutPreference pref = new ShortcutPreference((Context)this, shortcut);
        this.mShortcutGroup.addPreference((Preference)pref);
        this.mShortcutToPreference.put((int)shortcut, (Object)pref);
        return pref;
    }

    private void initShortcutPreferences() {
        SparseBooleanArray shortcutSeen = new SparseBooleanArray();
        KeyCharacterMap keyMap = KeyCharacterMap.load((int)0);
        for (int keyCode = KeyEvent.getMaxKeyCode() - 1; keyCode >= 0; --keyCode) {
            char shortcut = Character.toLowerCase(keyMap.getDisplayLabel(keyCode));
            if (shortcut == '\u0000' || shortcutSeen.get((int)shortcut, false) || !Character.isLetterOrDigit(shortcut)) continue;
            shortcutSeen.put((int)shortcut, true);
            this.createPreference(shortcut);
        }
    }

    private synchronized void refreshShortcuts() {
        Cursor c = this.mBookmarksCursor;
        if (c == null) {
            return;
        }
        if (!c.requery()) {
            Log.e((String)TAG, (String)"Could not requery cursor when refreshing shortcuts.");
            return;
        }
        SparseBooleanArray noLongerBookmarkedShortcuts = this.mBookmarkedShortcuts;
        SparseBooleanArray newBookmarkedShortcuts = new SparseBooleanArray();
        while (c.moveToNext()) {
            char shortcut = Character.toLowerCase((char)c.getInt(0));
            if (shortcut == '\u0000') continue;
            ShortcutPreference pref = this.getOrCreatePreference(shortcut);
            CharSequence title = Settings.Bookmarks.getTitle((Context)this, (Cursor)c);
            int intentColumn = c.getColumnIndex("intent");
            String intentUri = c.getString(intentColumn);
            PackageManager packageManager = this.getPackageManager();
            try {
                Intent intent = Intent.getIntent((String)intentUri);
                ResolveInfo info = packageManager.resolveActivity(intent, 0);
                if (info != null) {
                    title = info.loadLabel(packageManager);
                }
            }
            catch (URISyntaxException e) {
                // empty catch block
            }
            pref.setTitle(title);
            pref.setSummary(this.getString(2131231577, new Object[]{String.valueOf(shortcut)}));
            pref.setHasBookmark(true);
            newBookmarkedShortcuts.put((int)shortcut, true);
            if (noLongerBookmarkedShortcuts == null) continue;
            noLongerBookmarkedShortcuts.put((int)shortcut, false);
        }
        if (noLongerBookmarkedShortcuts != null) {
            for (int i = noLongerBookmarkedShortcuts.size() - 1; i >= 0; --i) {
                char shortcut;
                ShortcutPreference pref;
                if (!noLongerBookmarkedShortcuts.valueAt(i) || (pref = (ShortcutPreference)this.mShortcutToPreference.get((int)(shortcut = (char)noLongerBookmarkedShortcuts.keyAt(i)))) == null) continue;
                pref.setHasBookmark(false);
            }
        }
        this.mBookmarkedShortcuts = newBookmarkedShortcuts;
        c.deactivate();
    }

    private class BookmarksObserver
    extends ContentObserver {
        public BookmarksObserver(Handler handler) {
            super(handler);
        }

        public void onChange(boolean selfChange) {
            super.onChange(selfChange);
            QuickLaunchSettings.this.refreshShortcuts();
        }
    }
}

