/*
 * Decompiled with CFR 0.152.
 */
package com.android.settings.quicklaunch;

import android.app.ListActivity;
import android.content.Context;
import android.content.Intent;
import android.content.pm.ActivityInfo;
import android.content.pm.PackageManager;
import android.content.pm.ResolveInfo;
import android.graphics.drawable.Drawable;
import android.os.Bundle;
import android.os.Handler;
import android.view.Menu;
import android.view.MenuItem;
import android.view.View;
import android.widget.ImageView;
import android.widget.ListAdapter;
import android.widget.ListView;
import android.widget.SimpleAdapter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BookmarkPicker
extends ListActivity
implements SimpleAdapter.ViewBinder {
    private static final String TAG = "BookmarkPicker";
    public static final String EXTRA_TITLE = "com.android.settings.quicklaunch.TITLE";
    public static final String EXTRA_SHORTCUT = "com.android.settings.quicklaunch.SHORTCUT";
    private static final int REQUEST_CREATE_SHORTCUT = 1;
    private static Intent sLaunchIntent;
    private static Intent sShortcutIntent;
    private List<ResolveInfo> mResolveList;
    private static final String KEY_TITLE = "TITLE";
    private static final String KEY_RESOLVE_INFO = "RESOLVE_INFO";
    private static final String[] sKeys;
    private static final int[] sResourceIds;
    private SimpleAdapter mMyAdapter;
    private static final int DISPLAY_MODE_LAUNCH = 0;
    private static final int DISPLAY_MODE_SHORTCUT = 1;
    private int mDisplayMode = 0;
    private Handler mUiHandler = new Handler();

    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.updateListAndAdapter();
    }

    public boolean onCreateOptionsMenu(Menu menu) {
        menu.add(0, 0, 0, 2131231582).setIcon(17301932);
        menu.add(0, 1, 0, 2131231583).setIcon(17301945);
        return true;
    }

    public boolean onPrepareOptionsMenu(Menu menu) {
        menu.findItem(0).setVisible(this.mDisplayMode != 0);
        menu.findItem(1).setVisible(this.mDisplayMode != 1);
        return true;
    }

    public boolean onOptionsItemSelected(MenuItem item) {
        switch (item.getItemId()) {
            case 0: {
                this.mDisplayMode = 0;
                break;
            }
            case 1: {
                this.mDisplayMode = 1;
                break;
            }
            default: {
                return false;
            }
        }
        this.updateListAndAdapter();
        return true;
    }

    private void ensureIntents() {
        if (sLaunchIntent == null) {
            sLaunchIntent = new Intent("android.intent.action.MAIN").addCategory("android.intent.category.LAUNCHER");
            sShortcutIntent = new Intent("android.intent.action.CREATE_SHORTCUT");
        }
    }

    private void updateListAndAdapter() {
        new Thread("data updater"){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                BookmarkPicker bookmarkPicker = BookmarkPicker.this;
                synchronized (bookmarkPicker) {
                    ArrayList newResolveList = new ArrayList();
                    ArrayList newAdapterList = new ArrayList();
                    BookmarkPicker.this.fillResolveList(newResolveList);
                    Collections.sort(newResolveList, new ResolveInfo.DisplayNameComparator(BookmarkPicker.this.getPackageManager()));
                    BookmarkPicker.this.fillAdapterList(newAdapterList, newResolveList);
                    BookmarkPicker.this.updateAdapterToUseNewLists(newAdapterList, newResolveList);
                }
            }
        }.start();
    }

    private void updateAdapterToUseNewLists(final ArrayList<Map<String, ?>> newAdapterList, final ArrayList<ResolveInfo> newResolveList) {
        this.mUiHandler.post(new Runnable(){

            public void run() {
                BookmarkPicker.this.mMyAdapter = BookmarkPicker.this.createResolveAdapter(newAdapterList);
                BookmarkPicker.this.mResolveList = newResolveList;
                BookmarkPicker.this.setListAdapter((ListAdapter)BookmarkPicker.this.mMyAdapter);
            }
        });
    }

    private void fillResolveList(List<ResolveInfo> list) {
        this.ensureIntents();
        PackageManager pm = this.getPackageManager();
        list.clear();
        if (this.mDisplayMode == 0) {
            list.addAll(pm.queryIntentActivities(sLaunchIntent, 0));
        } else if (this.mDisplayMode == 1) {
            list.addAll(pm.queryIntentActivities(sShortcutIntent, 0));
        }
    }

    private SimpleAdapter createResolveAdapter(List<Map<String, ?>> list) {
        SimpleAdapter adapter = new SimpleAdapter((Context)this, list, 2130903048, sKeys, sResourceIds);
        adapter.setViewBinder((SimpleAdapter.ViewBinder)this);
        return adapter;
    }

    private void fillAdapterList(List<Map<String, ?>> list, List<ResolveInfo> resolveList) {
        list.clear();
        int resolveListSize = resolveList.size();
        for (int i = 0; i < resolveListSize; ++i) {
            ResolveInfo info = resolveList.get(i);
            TreeMap<String, String> map = new TreeMap<String, String>();
            map.put(KEY_TITLE, this.getResolveInfoTitle(info));
            map.put(KEY_RESOLVE_INFO, (String)info);
            list.add(map);
        }
    }

    private String getResolveInfoTitle(ResolveInfo info) {
        CharSequence label = info.loadLabel(this.getPackageManager());
        if (label == null) {
            label = info.activityInfo.name;
        }
        return label != null ? ((Object)label).toString() : null;
    }

    protected void onListItemClick(ListView l, View v, int position, long id2) {
        if (position >= this.mResolveList.size()) {
            return;
        }
        ResolveInfo info = this.mResolveList.get(position);
        switch (this.mDisplayMode) {
            case 0: {
                Intent intent = BookmarkPicker.getIntentForResolveInfo(info, "android.intent.action.MAIN");
                intent.addCategory("android.intent.category.LAUNCHER");
                this.finish(intent, this.getResolveInfoTitle(info));
                break;
            }
            case 1: {
                this.startShortcutActivity(info);
            }
        }
    }

    private static Intent getIntentForResolveInfo(ResolveInfo info, String action) {
        Intent intent = new Intent(action);
        ActivityInfo ai = info.activityInfo;
        intent.setClassName(ai.packageName, ai.name);
        return intent;
    }

    private void startShortcutActivity(ResolveInfo info) {
        Intent intent = BookmarkPicker.getIntentForResolveInfo(info, "android.intent.action.CREATE_SHORTCUT");
        this.startActivityForResult(intent, 1);
    }

    protected void onActivityResult(int requestCode, int resultCode, Intent data) {
        if (resultCode != -1) {
            return;
        }
        switch (requestCode) {
            case 1: {
                if (data == null) break;
                this.finish((Intent)data.getParcelableExtra("android.intent.extra.shortcut.INTENT"), data.getStringExtra("android.intent.extra.shortcut.NAME"));
                break;
            }
            default: {
                super.onActivityResult(requestCode, resultCode, data);
            }
        }
    }

    private void finish(Intent intent, String title) {
        intent.putExtras(this.getIntent());
        intent.putExtra(EXTRA_TITLE, title);
        this.setResult(-1, intent);
        this.finish();
    }

    public boolean setViewValue(View view, Object data, String textRepresentation) {
        if (view.getId() == 2131427349) {
            Drawable icon = ((ResolveInfo)data).loadIcon(this.getPackageManager());
            if (icon != null) {
                ((ImageView)view).setImageDrawable(icon);
            }
            return true;
        }
        return false;
    }

    static {
        sKeys = new String[]{KEY_TITLE, KEY_RESOLVE_INFO};
        sResourceIds = new int[]{2131427350, 2131427349};
    }
}

