/*
 * Decompiled with CFR 0.152.
 */
package com.android.settings.nfc;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.nfc.NfcAdapter;
import android.os.Handler;
import android.preference.CheckBoxPreference;
import android.preference.Preference;
import android.util.Log;

public class NfcEnabler
implements Preference.OnPreferenceChangeListener {
    private static final String TAG = "NfcEnabler";
    private final Context mContext;
    private final CheckBoxPreference mCheckbox;
    private final NfcAdapter mNfcAdapter;
    private final IntentFilter mIntentFilter;
    private final Handler mHandler = new Handler();
    private final BroadcastReceiver mReceiver = new BroadcastReceiver(){

        public void onReceive(Context context, Intent intent) {
            String action = intent.getAction();
            if ("android.nfc.action.ADAPTER_STATE_CHANGE".equals(action)) {
                NfcEnabler.this.handleNfcStateChanged(intent.getBooleanExtra("android.nfc.isEnabled", false));
            }
        }
    };
    private boolean mNfcState;

    public NfcEnabler(Context context, CheckBoxPreference checkBoxPreference) {
        this.mContext = context;
        this.mCheckbox = checkBoxPreference;
        this.mNfcAdapter = NfcAdapter.getDefaultAdapter((Context)context);
        if (this.mNfcAdapter == null) {
            this.mCheckbox.setEnabled(false);
        }
        this.mIntentFilter = new IntentFilter("android.nfc.action.ADAPTER_STATE_CHANGE");
    }

    public void resume() {
        if (this.mNfcAdapter == null) {
            return;
        }
        this.mContext.registerReceiver(this.mReceiver, this.mIntentFilter);
        this.mCheckbox.setOnPreferenceChangeListener((Preference.OnPreferenceChangeListener)this);
        this.mNfcState = this.mNfcAdapter.isEnabled();
        this.mCheckbox.setChecked(this.mNfcState);
    }

    public void pause() {
        if (this.mNfcAdapter == null) {
            return;
        }
        this.mContext.unregisterReceiver(this.mReceiver);
        this.mCheckbox.setOnPreferenceChangeListener(null);
    }

    public boolean onPreferenceChange(Preference preference, Object value) {
        final boolean desiredState = (Boolean)value;
        this.mCheckbox.setEnabled(false);
        new Thread("toggleNFC"){

            public void run() {
                Log.d((String)NfcEnabler.TAG, (String)("Setting NFC enabled state to: " + desiredState));
                boolean success = false;
                success = desiredState ? NfcEnabler.this.mNfcAdapter.enable() : NfcEnabler.this.mNfcAdapter.disable();
                if (success) {
                    Log.d((String)NfcEnabler.TAG, (String)("Successfully changed NFC enabled state to " + desiredState));
                    NfcEnabler.this.mHandler.post(new Runnable(){

                        public void run() {
                            NfcEnabler.this.handleNfcStateChanged(desiredState);
                        }
                    });
                } else {
                    Log.w((String)NfcEnabler.TAG, (String)("Error setting NFC enabled state to " + desiredState));
                    NfcEnabler.this.mHandler.post(new Runnable(){

                        public void run() {
                            NfcEnabler.this.mCheckbox.setEnabled(true);
                            NfcEnabler.this.mCheckbox.setSummary(2131231050);
                        }
                    });
                }
            }
        }.start();
        return false;
    }

    private void handleNfcStateChanged(boolean newState) {
        this.mCheckbox.setChecked(newState);
        this.mCheckbox.setEnabled(true);
        this.mCheckbox.setSummary(2131231049);
    }
}

