/*
 * Decompiled with CFR 0.152.
 */
package com.android.settings.fuelgauge;

import android.content.Context;

public class Utils {
    private static final int SECONDS_PER_MINUTE = 60;
    private static final int SECONDS_PER_HOUR = 3600;
    private static final int SECONDS_PER_DAY = 86400;

    public static String formatElapsedTime(Context context, double millis) {
        StringBuilder sb = new StringBuilder();
        int seconds = (int)Math.floor(millis / 1000.0);
        int days = 0;
        int hours = 0;
        int minutes = 0;
        if (seconds > 86400) {
            days = seconds / 86400;
            seconds -= days * 86400;
        }
        if (seconds > 3600) {
            hours = seconds / 3600;
            seconds -= hours * 3600;
        }
        if (seconds > 60) {
            minutes = seconds / 60;
            seconds -= minutes * 60;
        }
        if (days > 0) {
            sb.append(context.getString(2131231602, new Object[]{days, hours, minutes, seconds}));
        } else if (hours > 0) {
            sb.append(context.getString(2131231603, new Object[]{hours, minutes, seconds}));
        } else if (minutes > 0) {
            sb.append(context.getString(2131231604, new Object[]{minutes, seconds}));
        } else {
            sb.append(context.getString(2131231605, new Object[]{seconds}));
        }
        return sb.toString();
    }

    public static String formatBytes(Context context, double bytes) {
        if (bytes > 1000000.0) {
            return String.format("%.2f MB", Float.valueOf((float)((int)(bytes / 1000.0)) / 1000.0f));
        }
        if (bytes > 1024.0) {
            return String.format("%.2f KB", Float.valueOf((float)((int)(bytes / 10.0)) / 100.0f));
        }
        return String.format("%d bytes", (int)bytes);
    }
}

