/*
 * Decompiled with CFR 0.152.
 */
package com.android.settings.fuelgauge;

import android.content.Context;
import android.content.Intent;
import android.hardware.Sensor;
import android.hardware.SensorManager;
import android.os.BatteryStats;
import android.os.Bundle;
import android.os.Handler;
import android.os.IBinder;
import android.os.Message;
import android.os.Parcel;
import android.os.RemoteException;
import android.os.ServiceManager;
import android.os.SystemClock;
import android.preference.Preference;
import android.preference.PreferenceActivity;
import android.preference.PreferenceGroup;
import android.preference.PreferenceScreen;
import android.util.Log;
import android.util.SparseArray;
import android.view.Menu;
import android.view.MenuItem;
import com.android.internal.app.IBatteryStats;
import com.android.internal.os.BatteryStatsImpl;
import com.android.internal.os.PowerProfile;
import com.android.settings.fuelgauge.BatteryHistoryDetail;
import com.android.settings.fuelgauge.BatteryHistoryPreference;
import com.android.settings.fuelgauge.BatterySipper;
import com.android.settings.fuelgauge.PowerGaugePreference;
import com.android.settings.fuelgauge.PowerUsageDetail;
import com.android.settings.fuelgauge.Utils;
import java.io.PrintWriter;
import java.io.Serializable;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PowerUsageSummary
extends PreferenceActivity
implements Runnable {
    private static final boolean DEBUG = false;
    private static final String TAG = "PowerUsageSummary";
    private static final int MENU_STATS_TYPE = 1;
    private static final int MENU_STATS_REFRESH = 2;
    IBatteryStats mBatteryInfo;
    BatteryStatsImpl mStats;
    private final List<BatterySipper> mUsageList = new ArrayList<BatterySipper>();
    private final List<BatterySipper> mWifiSippers = new ArrayList<BatterySipper>();
    private final List<BatterySipper> mBluetoothSippers = new ArrayList<BatterySipper>();
    private PreferenceGroup mAppListGroup;
    private int mStatsType = 0;
    private static final int MIN_POWER_THRESHOLD = 5;
    private static final int MAX_ITEMS_TO_LIST = 10;
    private long mStatsPeriod = 0L;
    private double mMaxPower = 1.0;
    private double mTotalPower;
    private double mWifiPower;
    private double mBluetoothPower;
    private PowerProfile mPowerProfile;
    private long mAppWifiRunning;
    private ArrayList<BatterySipper> mRequestQueue = new ArrayList();
    private Thread mRequestThread;
    private boolean mAbort;
    static final int MSG_UPDATE_NAME_ICON = 1;
    Handler mHandler = new Handler(){

        public void handleMessage(Message msg) {
            switch (msg.what) {
                case 1: {
                    BatterySipper bs = (BatterySipper)msg.obj;
                    PowerGaugePreference pgp = (PowerGaugePreference)PowerUsageSummary.this.findPreference(Integer.toString(bs.uidObj.getUid()));
                    if (pgp == null) break;
                    pgp.setIcon(bs.icon);
                    pgp.setPercent(bs.percent);
                    pgp.setTitle(bs.name);
                }
            }
            super.handleMessage(msg);
        }
    };

    protected void onCreate(Bundle icicle) {
        super.onCreate(icicle);
        this.mStats = (BatteryStatsImpl)this.getLastNonConfigurationInstance();
        this.addPreferencesFromResource(2130968594);
        this.mBatteryInfo = IBatteryStats.Stub.asInterface((IBinder)ServiceManager.getService((String)"batteryinfo"));
        this.mAppListGroup = (PreferenceGroup)this.findPreference("app_list");
        this.mPowerProfile = new PowerProfile((Context)this);
    }

    public Object onRetainNonConfigurationInstance() {
        return this.mStats;
    }

    protected void onResume() {
        super.onResume();
        this.mAbort = false;
        this.refreshStats();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void onPause() {
        ArrayList<BatterySipper> arrayList = this.mRequestQueue;
        synchronized (arrayList) {
            this.mAbort = true;
        }
        this.mHandler.removeMessages(1);
        super.onPause();
    }

    public boolean onPreferenceTreeClick(PreferenceScreen preferenceScreen, Preference preference) {
        double[] values;
        int[] types;
        if (preference instanceof BatteryHistoryPreference) {
            Parcel hist = Parcel.obtain();
            this.mStats.writeToParcelWithoutUids(hist, 0);
            byte[] histData = hist.marshall();
            Intent intent = new Intent((Context)this, BatteryHistoryDetail.class);
            intent.putExtra("stats", histData);
            this.startActivity(intent);
            return super.onPreferenceTreeClick(preferenceScreen, preference);
        }
        if (!(preference instanceof PowerGaugePreference)) {
            return false;
        }
        PowerGaugePreference pgp = (PowerGaugePreference)preference;
        BatterySipper sipper = pgp.getInfo();
        Intent intent = new Intent((Context)this, PowerUsageDetail.class);
        intent.putExtra("title", sipper.name);
        intent.putExtra("percent", (int)Math.ceil(sipper.getSortValue() * 100.0 / this.mTotalPower));
        intent.putExtra("gauge", (int)Math.ceil(sipper.getSortValue() * 100.0 / this.mMaxPower));
        intent.putExtra("duration", this.mStatsPeriod);
        intent.putExtra("iconPackage", sipper.defaultPackageName);
        intent.putExtra("iconId", sipper.iconId);
        intent.putExtra("noCoverage", sipper.noCoveragePercent);
        if (sipper.uidObj != null) {
            intent.putExtra("uid", sipper.uidObj.getUid());
        }
        intent.putExtra("drainType", (Serializable)((Object)sipper.drainType));
        switch (sipper.drainType) {
            case APP: {
                BatteryStats.Uid uid = sipper.uidObj;
                types = new int[]{2131231652, 2131231653, 2131231654, 2131231655, 2131231656, 2131231658, 2131231659, 2131231660, 2131231661};
                values = new double[]{sipper.cpuTime, sipper.cpuFgTime, sipper.wakeLockTime, sipper.gpsTime, sipper.wifiRunningTime, sipper.tcpBytesSent, sipper.tcpBytesReceived, 0.0, 0.0};
                StringWriter result = new StringWriter();
                PrintWriter printWriter = new PrintWriter(result);
                this.mStats.dumpLocked(printWriter, "", this.mStatsType, uid.getUid());
                intent.putExtra("report_details", ((Object)result).toString());
                result = new StringWriter();
                printWriter = new PrintWriter(result);
                this.mStats.dumpCheckinLocked(printWriter, this.mStatsType, uid.getUid());
                intent.putExtra("report_checkin_details", ((Object)result).toString());
                break;
            }
            case CELL: {
                types = new int[]{2131231662, 2131231663};
                values = new double[]{sipper.usageTime, sipper.noCoveragePercent};
                break;
            }
            case WIFI: {
                types = new int[]{2131231656, 2131231652, 2131231653, 2131231654, 2131231658, 2131231659};
                values = new double[]{sipper.usageTime, sipper.cpuTime, sipper.cpuFgTime, sipper.wakeLockTime, sipper.tcpBytesSent, sipper.tcpBytesReceived};
                break;
            }
            case BLUETOOTH: {
                types = new int[]{2131231662, 2131231652, 2131231653, 2131231654, 2131231658, 2131231659};
                values = new double[]{sipper.usageTime, sipper.cpuTime, sipper.cpuFgTime, sipper.wakeLockTime, sipper.tcpBytesSent, sipper.tcpBytesReceived};
                break;
            }
            default: {
                types = new int[]{2131231662};
                values = new double[]{sipper.usageTime};
            }
        }
        intent.putExtra("types", types);
        intent.putExtra("values", values);
        this.startActivity(intent);
        return super.onPreferenceTreeClick(preferenceScreen, preference);
    }

    public boolean onCreateOptionsMenu(Menu menu) {
        menu.add(0, 2, 0, 2131231688).setIcon(17301952).setAlphabeticShortcut('r');
        return true;
    }

    public boolean onPrepareOptionsMenu(Menu menu) {
        return true;
    }

    public boolean onOptionsItemSelected(MenuItem item) {
        switch (item.getItemId()) {
            case 1: {
                this.mStatsType = this.mStatsType == 0 ? 3 : 0;
                this.refreshStats();
                return true;
            }
            case 2: {
                this.mStats = null;
                this.refreshStats();
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void refreshStats() {
        if (this.mStats == null) {
            this.load();
        }
        this.mMaxPower = 0.0;
        this.mTotalPower = 0.0;
        this.mWifiPower = 0.0;
        this.mBluetoothPower = 0.0;
        this.mAppWifiRunning = 0L;
        this.mAppListGroup.removeAll();
        this.mUsageList.clear();
        this.mWifiSippers.clear();
        this.mBluetoothSippers.clear();
        this.processAppUsage();
        this.processMiscUsage();
        this.mAppListGroup.setOrderingAsAdded(false);
        BatteryHistoryPreference hist = new BatteryHistoryPreference((Context)this, (BatteryStats)this.mStats);
        hist.setOrder(-1);
        this.mAppListGroup.addPreference((Preference)hist);
        Collections.sort(this.mUsageList);
        for (BatterySipper sipper : this.mUsageList) {
            double percentOfTotal;
            if (sipper.getSortValue() < 5.0 || (percentOfTotal = sipper.getSortValue() / this.mTotalPower * 100.0) < 1.0) continue;
            PowerGaugePreference pref = new PowerGaugePreference((Context)this, sipper.getIcon(), sipper);
            double percentOfMax = sipper.getSortValue() * 100.0 / this.mMaxPower;
            sipper.percent = percentOfTotal;
            pref.setTitle(sipper.name);
            pref.setPercent(percentOfTotal);
            pref.setOrder(Integer.MAX_VALUE - (int)sipper.getSortValue());
            pref.setGaugeValue(percentOfMax);
            if (sipper.uidObj != null) {
                pref.setKey(Integer.toString(sipper.uidObj.getUid()));
            }
            this.mAppListGroup.addPreference((Preference)pref);
            if (this.mAppListGroup.getPreferenceCount() <= 11) continue;
            break;
        }
        ArrayList<BatterySipper> arrayList = this.mRequestQueue;
        synchronized (arrayList) {
            if (!this.mRequestQueue.isEmpty()) {
                if (this.mRequestThread == null) {
                    this.mRequestThread = new Thread((Runnable)this, "BatteryUsage Icon Loader");
                    this.mRequestThread.setPriority(1);
                    this.mRequestThread.start();
                }
                this.mRequestQueue.notify();
            }
        }
    }

    private void updateStatsPeriod(long duration) {
        String durationString = Utils.formatElapsedTime((Context)this, duration / 1000L);
        String label = this.getString(this.mStats.isOnBattery() ? 2131231630 : 2131231637, new Object[]{durationString});
        this.setTitle(label);
    }

    private void processAppUsage() {
        long uSecTime;
        SensorManager sensorManager = (SensorManager)this.getSystemService("sensor");
        int which = this.mStatsType;
        int speedSteps = this.mPowerProfile.getNumSpeedSteps();
        double[] powerCpuNormal = new double[speedSteps];
        long[] cpuSpeedStepTimes = new long[speedSteps];
        for (int p = 0; p < speedSteps; ++p) {
            powerCpuNormal[p] = this.mPowerProfile.getAveragePower("cpu.active", p);
        }
        double averageCostPerByte = this.getAverageDataCost();
        this.mStatsPeriod = uSecTime = this.mStats.computeBatteryRealtime(SystemClock.elapsedRealtime() * 1000L, which);
        this.updateStatsPeriod(uSecTime);
        SparseArray uidStats = this.mStats.getUidStats();
        int NU = uidStats.size();
        for (int iu = 0; iu < NU; ++iu) {
            BatteryStats.Uid u = (BatteryStats.Uid)uidStats.valueAt(iu);
            double power = 0.0;
            double highestDrain = 0.0;
            String packageWithHighestDrain = null;
            Map processStats = u.getProcessStats();
            long cpuTime = 0L;
            long cpuFgTime = 0L;
            long wakelockTime = 0L;
            long gpsTime = 0L;
            if (processStats.size() > 0) {
                for (Map.Entry ent : processStats.entrySet()) {
                    BatteryStats.Uid.Proc ps = (BatteryStats.Uid.Proc)ent.getValue();
                    long userTime = ps.getUserTime(which);
                    long systemTime = ps.getSystemTime(which);
                    long foregroundTime = ps.getForegroundTime(which);
                    cpuFgTime += foregroundTime * 10L;
                    long tmpCpuTime = (userTime + systemTime) * 10L;
                    int totalTimeAtSpeeds = 0;
                    for (int step = 0; step < speedSteps; ++step) {
                        cpuSpeedStepTimes[step] = ps.getTimeAtCpuSpeedStep(step, which);
                        totalTimeAtSpeeds = (int)((long)totalTimeAtSpeeds + cpuSpeedStepTimes[step]);
                    }
                    if (totalTimeAtSpeeds == 0) {
                        totalTimeAtSpeeds = 1;
                    }
                    double processPower = 0.0;
                    for (int step = 0; step < speedSteps; ++step) {
                        double ratio = (double)cpuSpeedStepTimes[step] / (double)totalTimeAtSpeeds;
                        processPower += ratio * (double)tmpCpuTime * powerCpuNormal[step];
                    }
                    cpuTime += tmpCpuTime;
                    power += processPower;
                    if (packageWithHighestDrain == null || packageWithHighestDrain.startsWith("*")) {
                        highestDrain = processPower;
                        packageWithHighestDrain = (String)ent.getKey();
                        continue;
                    }
                    if (!(highestDrain < processPower) || ((String)ent.getKey()).startsWith("*")) continue;
                    highestDrain = processPower;
                    packageWithHighestDrain = (String)ent.getKey();
                }
            }
            if (cpuFgTime > cpuTime) {
                cpuTime = cpuFgTime;
            }
            power /= 1000.0;
            Map wakelockStats = u.getWakelockStats();
            for (Map.Entry wakelockEntry : wakelockStats.entrySet()) {
                BatteryStats.Uid.Wakelock wakelock = (BatteryStats.Uid.Wakelock)wakelockEntry.getValue();
                BatteryStats.Timer timer = wakelock.getWakeTime(0);
                if (timer == null) continue;
                wakelockTime += timer.getTotalTimeLocked(uSecTime, which);
            }
            power += (double)(wakelockTime /= 1000L) * this.mPowerProfile.getAveragePower("cpu.awake") / 1000.0;
            long tcpBytesReceived = u.getTcpBytesReceived(this.mStatsType);
            long tcpBytesSent = u.getTcpBytesSent(this.mStatsType);
            power += (double)(tcpBytesReceived + tcpBytesSent) * averageCostPerByte;
            long wifiRunningTimeMs = u.getWifiRunningTime(uSecTime, which) / 1000L;
            this.mAppWifiRunning += wifiRunningTimeMs;
            power += (double)wifiRunningTimeMs * this.mPowerProfile.getAveragePower("wifi.on") / 1000.0;
            Map sensorStats = u.getSensorStats();
            for (Map.Entry sensorEntry : sensorStats.entrySet()) {
                BatteryStats.Uid.Sensor sensor = (BatteryStats.Uid.Sensor)sensorEntry.getValue();
                int sensorType = sensor.getHandle();
                BatteryStats.Timer timer = sensor.getSensorTime();
                long sensorTime = timer.getTotalTimeLocked(uSecTime, which) / 1000L;
                double multiplier = 0.0;
                switch (sensorType) {
                    case -10000: {
                        multiplier = this.mPowerProfile.getAveragePower("gps.on");
                        gpsTime = sensorTime;
                        break;
                    }
                    default: {
                        Sensor sensorData = sensorManager.getDefaultSensor(sensorType);
                        if (sensorData == null) break;
                        multiplier = sensorData.getPower();
                    }
                }
                power += multiplier * (double)sensorTime / 1000.0;
            }
            if (power != 0.0) {
                BatterySipper app = new BatterySipper((Context)this, this.mRequestQueue, this.mHandler, packageWithHighestDrain, PowerUsageDetail.DrainType.APP, 0, u, new double[]{power});
                app.cpuTime = cpuTime;
                app.gpsTime = gpsTime;
                app.wifiRunningTime = wifiRunningTimeMs;
                app.cpuFgTime = cpuFgTime;
                app.wakeLockTime = wakelockTime;
                app.tcpBytesReceived = tcpBytesReceived;
                app.tcpBytesSent = tcpBytesSent;
                if (u.getUid() == 1010) {
                    this.mWifiSippers.add(app);
                } else if (u.getUid() == 2000) {
                    this.mBluetoothSippers.add(app);
                } else {
                    this.mUsageList.add(app);
                }
            }
            if (u.getUid() == 1010) {
                this.mWifiPower += power;
                continue;
            }
            if (u.getUid() == 2000) {
                this.mBluetoothPower += power;
                continue;
            }
            if (power > this.mMaxPower) {
                this.mMaxPower = power;
            }
            this.mTotalPower += power;
        }
    }

    private void addPhoneUsage(long uSecNow) {
        long phoneOnTimeMs = this.mStats.getPhoneOnTime(uSecNow, this.mStatsType) / 1000L;
        double phoneOnPower = this.mPowerProfile.getAveragePower("radio.active") * (double)phoneOnTimeMs / 1000.0;
        this.addEntry(this.getString(2131231650), PowerUsageDetail.DrainType.PHONE, phoneOnTimeMs, 2130837573, phoneOnPower);
    }

    private void addScreenUsage(long uSecNow) {
        double power = 0.0;
        long screenOnTimeMs = this.mStats.getScreenOnTime(uSecNow, this.mStatsType) / 1000L;
        power += (double)screenOnTimeMs * this.mPowerProfile.getAveragePower("screen.on");
        double screenFullPower = this.mPowerProfile.getAveragePower("screen.full");
        for (int i = 0; i < 5; ++i) {
            double screenBinPower = screenFullPower * (double)((float)i + 0.5f) / 5.0;
            long brightnessTime = this.mStats.getScreenBrightnessTime(i, uSecNow, this.mStatsType) / 1000L;
            power += screenBinPower * (double)brightnessTime;
        }
        this.addEntry(this.getString(2131231646), PowerUsageDetail.DrainType.SCREEN, screenOnTimeMs, 2130837563, power /= 1000.0);
    }

    private void addRadioUsage(long uSecNow) {
        double power = 0.0;
        int BINS = 5;
        long signalTimeMs = 0L;
        for (int i = 0; i < 5; ++i) {
            long strengthTimeMs = this.mStats.getPhoneSignalStrengthTime(i, uSecNow, this.mStatsType) / 1000L;
            power += (double)(strengthTimeMs / 1000L) * this.mPowerProfile.getAveragePower("radio.on", i);
            signalTimeMs += strengthTimeMs;
        }
        long scanningTimeMs = this.mStats.getPhoneSignalScanningTime(uSecNow, this.mStatsType) / 1000L;
        BatterySipper bs = this.addEntry(this.getString(2131231649), PowerUsageDetail.DrainType.CELL, signalTimeMs, 2130837561, power += (double)(scanningTimeMs / 1000L) * this.mPowerProfile.getAveragePower("radio.scanning"));
        if (signalTimeMs != 0L) {
            bs.noCoveragePercent = (double)(this.mStats.getPhoneSignalStrengthTime(0, uSecNow, this.mStatsType) / 1000L) * 100.0 / (double)signalTimeMs;
        }
    }

    private void aggregateSippers(BatterySipper bs, List<BatterySipper> from, String tag) {
        for (int i = 0; i < from.size(); ++i) {
            BatterySipper wbs = from.get(i);
            bs.cpuTime += wbs.cpuTime;
            bs.gpsTime += wbs.gpsTime;
            bs.wifiRunningTime += wbs.wifiRunningTime;
            bs.cpuFgTime += wbs.cpuFgTime;
            bs.wakeLockTime += wbs.wakeLockTime;
            bs.tcpBytesReceived += wbs.tcpBytesReceived;
            bs.tcpBytesSent += wbs.tcpBytesSent;
        }
    }

    private void addWiFiUsage(long uSecNow) {
        long onTimeMs = this.mStats.getWifiOnTime(uSecNow, this.mStatsType) / 1000L;
        long runningTimeMs = this.mStats.getGlobalWifiRunningTime(uSecNow, this.mStatsType) / 1000L;
        if ((runningTimeMs -= this.mAppWifiRunning) < 0L) {
            runningTimeMs = 0L;
        }
        double wifiPower = ((double)(onTimeMs * 0L) * this.mPowerProfile.getAveragePower("wifi.on") + (double)runningTimeMs * this.mPowerProfile.getAveragePower("wifi.on")) / 1000.0;
        BatterySipper bs = this.addEntry(this.getString(2131231647), PowerUsageDetail.DrainType.WIFI, runningTimeMs, 2130837574, wifiPower + this.mWifiPower);
        this.aggregateSippers(bs, this.mWifiSippers, "WIFI");
    }

    private void addIdleUsage(long uSecNow) {
        long idleTimeMs = (uSecNow - this.mStats.getScreenOnTime(uSecNow, this.mStatsType)) / 1000L;
        double idlePower = (double)idleTimeMs * this.mPowerProfile.getAveragePower("cpu.idle") / 1000.0;
        this.addEntry(this.getString(2131231651), PowerUsageDetail.DrainType.IDLE, idleTimeMs, 2130837566, idlePower);
    }

    private void addBluetoothUsage(long uSecNow) {
        long btOnTimeMs = this.mStats.getBluetoothOnTime(uSecNow, this.mStatsType) / 1000L;
        double btPower = (double)btOnTimeMs * this.mPowerProfile.getAveragePower("bluetooth.on") / 1000.0;
        int btPingCount = this.mStats.getBluetoothPingCount();
        BatterySipper bs = this.addEntry(this.getString(2131231648), PowerUsageDetail.DrainType.BLUETOOTH, btOnTimeMs, 2130837559, (btPower += (double)btPingCount * this.mPowerProfile.getAveragePower("bluetooth.at") / 1000.0) + this.mBluetoothPower);
        this.aggregateSippers(bs, this.mBluetoothSippers, "Bluetooth");
    }

    private double getAverageDataCost() {
        long WIFI_BPS = 1000000L;
        long MOBILE_BPS = 200000L;
        double WIFI_POWER = this.mPowerProfile.getAveragePower("wifi.active") / 3600.0;
        double MOBILE_POWER = this.mPowerProfile.getAveragePower("radio.active") / 3600.0;
        long mobileData = this.mStats.getMobileTcpBytesReceived(this.mStatsType) + this.mStats.getMobileTcpBytesSent(this.mStatsType);
        long wifiData = this.mStats.getTotalTcpBytesReceived(this.mStatsType) + this.mStats.getTotalTcpBytesSent(this.mStatsType) - mobileData;
        long radioDataUptimeMs = this.mStats.getRadioDataUptime() / 1000L;
        long mobileBps = radioDataUptimeMs != 0L ? mobileData * 8L * 1000L / radioDataUptimeMs : 200000L;
        double mobileCostPerByte = MOBILE_POWER / (double)(mobileBps / 8L);
        double wifiCostPerByte = WIFI_POWER / 125000.0;
        if (wifiData + mobileData != 0L) {
            return (mobileCostPerByte * (double)mobileData + wifiCostPerByte * (double)wifiData) / (double)(mobileData + wifiData);
        }
        return 0.0;
    }

    private void processMiscUsage() {
        long uSecNow;
        int which = this.mStatsType;
        long uSecTime = SystemClock.elapsedRealtime() * 1000L;
        long timeSinceUnplugged = uSecNow = this.mStats.computeBatteryRealtime(uSecTime, which);
        this.addPhoneUsage(uSecNow);
        this.addScreenUsage(uSecNow);
        this.addWiFiUsage(uSecNow);
        this.addBluetoothUsage(uSecNow);
        this.addIdleUsage(uSecNow);
        this.addRadioUsage(uSecNow);
    }

    private BatterySipper addEntry(String label, PowerUsageDetail.DrainType drainType, long time, int iconId, double power) {
        if (power > this.mMaxPower) {
            this.mMaxPower = power;
        }
        this.mTotalPower += power;
        BatterySipper bs = new BatterySipper((Context)this, this.mRequestQueue, this.mHandler, label, drainType, iconId, null, new double[]{power});
        bs.usageTime = time;
        bs.iconId = iconId;
        this.mUsageList.add(bs);
        return bs;
    }

    private void load() {
        try {
            byte[] data = this.mBatteryInfo.getStatistics();
            Parcel parcel = Parcel.obtain();
            parcel.unmarshall(data, 0, data.length);
            parcel.setDataPosition(0);
            this.mStats = (BatteryStatsImpl)BatteryStatsImpl.CREATOR.createFromParcel(parcel);
            this.mStats.distributeWorkLocked(0);
        }
        catch (RemoteException e) {
            Log.e((String)TAG, (String)"RemoteException:", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        while (true) {
            BatterySipper bs;
            ArrayList<BatterySipper> arrayList = this.mRequestQueue;
            synchronized (arrayList) {
                if (this.mRequestQueue.isEmpty() || this.mAbort) {
                    this.mRequestThread = null;
                    return;
                }
                bs = this.mRequestQueue.remove(0);
            }
            bs.getNameIcon();
        }
    }
}

