/*
 * Decompiled with CFR 0.152.
 */
package com.android.settings.fuelgauge;

import android.app.Activity;
import android.app.ActivityManager;
import android.app.ApplicationErrorReport;
import android.content.BroadcastReceiver;
import android.content.ComponentName;
import android.content.ContentResolver;
import android.content.Context;
import android.content.Intent;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.content.res.Resources;
import android.graphics.drawable.Drawable;
import android.net.Uri;
import android.os.Bundle;
import android.os.Parcelable;
import android.os.Process;
import android.provider.Settings;
import android.text.TextUtils;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.Button;
import android.widget.ImageView;
import android.widget.TextView;
import com.android.settings.applications.InstalledAppDetails;
import com.android.settings.fuelgauge.PercentageBar;
import com.android.settings.fuelgauge.Utils;

public class PowerUsageDetail
extends Activity
implements View.OnClickListener {
    private static int[] sDrainTypeDesciptions = new int[]{2131231671, 2131231672, 2131231670, 2131231676, 2131231678, 2131231674, 2131231681};
    public static final int ACTION_DISPLAY_SETTINGS = 1;
    public static final int ACTION_WIFI_SETTINGS = 2;
    public static final int ACTION_BLUETOOTH_SETTINGS = 3;
    public static final int ACTION_WIRELESS_SETTINGS = 4;
    public static final int ACTION_APP_DETAILS = 5;
    public static final int ACTION_SECURITY_SETTINGS = 6;
    public static final int ACTION_FORCE_STOP = 7;
    public static final int ACTION_REPORT = 8;
    public static final int USAGE_SINCE_UNPLUGGED = 1;
    public static final int USAGE_SINCE_RESET = 2;
    public static final String EXTRA_TITLE = "title";
    public static final String EXTRA_PERCENT = "percent";
    public static final String EXTRA_GAUGE = "gauge";
    public static final String EXTRA_UID = "uid";
    public static final String EXTRA_USAGE_SINCE = "since";
    public static final String EXTRA_USAGE_DURATION = "duration";
    public static final String EXTRA_REPORT_DETAILS = "report_details";
    public static final String EXTRA_REPORT_CHECKIN_DETAILS = "report_checkin_details";
    public static final String EXTRA_DETAIL_TYPES = "types";
    public static final String EXTRA_DETAIL_VALUES = "values";
    public static final String EXTRA_DRAIN_TYPE = "drainType";
    public static final String EXTRA_ICON_PACKAGE = "iconPackage";
    public static final String EXTRA_NO_COVERAGE = "noCoverage";
    public static final String EXTRA_ICON_ID = "iconId";
    private static final boolean DEBUG = true;
    private String mTitle;
    private int mUsageSince;
    private int[] mTypes;
    private int mUid;
    private double[] mValues;
    private TextView mTitleView;
    private ViewGroup mTwoButtonsPanel;
    private Button mForceStopButton;
    private Button mReportButton;
    private ViewGroup mDetailsParent;
    private ViewGroup mControlsParent;
    private long mStartTime;
    private DrainType mDrainType;
    private PercentageBar mGauge;
    private Drawable mAppIcon;
    private double mNoCoverage;
    private boolean mUsesGps;
    private static final String TAG = "PowerUsageDetail";
    private String[] mPackages;
    ApplicationInfo mApp;
    ComponentName mInstaller;
    private final BroadcastReceiver mCheckKillProcessesReceiver = new BroadcastReceiver(){

        public void onReceive(Context context, Intent intent) {
            PowerUsageDetail.this.mForceStopButton.setEnabled(this.getResultCode() != 0);
        }
    };

    protected void onCreate(Bundle icicle) {
        super.onCreate(icicle);
        this.setContentView(2130903078);
        this.createDetails();
    }

    protected void onResume() {
        super.onResume();
        this.mStartTime = Process.getElapsedCpuTime();
        this.checkForceStop();
    }

    protected void onPause() {
        super.onPause();
    }

    private void createDetails() {
        Intent intent = this.getIntent();
        this.mTitle = intent.getStringExtra(EXTRA_TITLE);
        int percentage = intent.getIntExtra(EXTRA_PERCENT, 1);
        int gaugeValue = intent.getIntExtra(EXTRA_GAUGE, 1);
        this.mUsageSince = intent.getIntExtra(EXTRA_USAGE_SINCE, 1);
        this.mUid = intent.getIntExtra(EXTRA_UID, 0);
        this.mDrainType = (DrainType)((Object)intent.getSerializableExtra(EXTRA_DRAIN_TYPE));
        this.mNoCoverage = intent.getDoubleExtra(EXTRA_NO_COVERAGE, 0.0);
        String iconPackage = intent.getStringExtra(EXTRA_ICON_PACKAGE);
        int iconId = intent.getIntExtra(EXTRA_ICON_ID, 0);
        if (!TextUtils.isEmpty((CharSequence)iconPackage)) {
            try {
                PackageManager pm = this.getPackageManager();
                ApplicationInfo ai = pm.getPackageInfo((String)iconPackage, (int)0).applicationInfo;
                if (ai != null) {
                    this.mAppIcon = ai.loadIcon(pm);
                }
            }
            catch (PackageManager.NameNotFoundException nnfe) {}
        } else if (iconId != 0) {
            this.mAppIcon = this.getResources().getDrawable(iconId);
        }
        if (this.mAppIcon == null) {
            this.mAppIcon = this.getPackageManager().getDefaultActivityIcon();
        }
        String summary = this.getDescriptionForDrainType();
        ((TextView)this.findViewById(2131427433)).setText((CharSequence)summary);
        this.mTypes = intent.getIntArrayExtra(EXTRA_DETAIL_TYPES);
        this.mValues = intent.getDoubleArrayExtra(EXTRA_DETAIL_VALUES);
        this.mTitleView = (TextView)this.findViewById(2131427379);
        this.mTitleView.setText((CharSequence)this.mTitle);
        ((TextView)this.findViewById(2131427437)).setText((CharSequence)String.format("%d%%", percentage));
        this.mTwoButtonsPanel = (ViewGroup)this.findViewById(2131427439);
        this.mForceStopButton = (Button)this.findViewById(2131427517);
        this.mReportButton = (Button)this.findViewById(2131427518);
        this.mForceStopButton.setEnabled(false);
        ImageView gaugeImage = (ImageView)this.findViewById(2131427438);
        this.mGauge = new PercentageBar();
        this.mGauge.percent = gaugeValue;
        this.mGauge.bar = this.getResources().getDrawable(2130837504);
        gaugeImage.setImageDrawable((Drawable)this.mGauge);
        ImageView iconImage = (ImageView)this.findViewById(2131427349);
        iconImage.setImageDrawable(this.mAppIcon);
        this.mDetailsParent = (ViewGroup)this.findViewById(2131427440);
        this.mControlsParent = (ViewGroup)this.findViewById(2131427441);
        this.fillDetailsSection();
        this.fillPackagesSection(this.mUid);
        this.fillControlsSection(this.mUid);
        if (this.mUid >= 10000) {
            this.mForceStopButton.setText(2131231452);
            this.mForceStopButton.setTag((Object)7);
            this.mForceStopButton.setOnClickListener((View.OnClickListener)this);
            this.mReportButton.setText(17040131);
            this.mReportButton.setTag((Object)8);
            this.mReportButton.setOnClickListener((View.OnClickListener)this);
            int enabled = Settings.Secure.getInt((ContentResolver)this.getContentResolver(), (String)"send_action_app_error", (int)0);
            if (enabled != 0) {
                if (this.mPackages != null && this.mPackages.length > 0) {
                    try {
                        this.mApp = this.getPackageManager().getApplicationInfo(this.mPackages[0], 0);
                        this.mInstaller = ApplicationErrorReport.getErrorReportReceiver((Context)this, (String)this.mPackages[0], (int)this.mApp.flags);
                    }
                    catch (PackageManager.NameNotFoundException e) {
                        // empty catch block
                    }
                }
                this.mReportButton.setEnabled(this.mInstaller != null);
            } else {
                this.mTwoButtonsPanel.setVisibility(8);
            }
        } else {
            this.mTwoButtonsPanel.setVisibility(8);
        }
    }

    public void onClick(View v) {
        this.doAction((Integer)v.getTag());
    }

    private void doAction(int action) {
        switch (action) {
            case 1: {
                this.startActivity(new Intent("android.settings.DISPLAY_SETTINGS"));
                break;
            }
            case 2: {
                this.startActivity(new Intent("android.settings.WIFI_SETTINGS"));
                break;
            }
            case 3: {
                this.startActivity(new Intent("android.settings.BLUETOOTH_SETTINGS"));
                break;
            }
            case 4: {
                this.startActivity(new Intent("android.settings.WIRELESS_SETTINGS"));
                break;
            }
            case 5: {
                Intent intent = new Intent("android.intent.action.VIEW", Uri.fromParts((String)"package", (String)this.mPackages[0], null));
                intent.setClass((Context)this, InstalledAppDetails.class);
                this.startActivity(intent);
                break;
            }
            case 6: {
                this.startActivity(new Intent("android.settings.SECURITY_SETTINGS"));
                break;
            }
            case 7: {
                this.killProcesses();
                break;
            }
            case 8: {
                this.reportBatteryUse();
            }
        }
    }

    private void fillDetailsSection() {
        LayoutInflater inflater = this.getLayoutInflater();
        if (this.mTypes != null && this.mValues != null) {
            for (int i = 0; i < this.mTypes.length; ++i) {
                if (this.mValues[i] <= 0.0) continue;
                String label = this.getString(this.mTypes[i]);
                String value = null;
                switch (this.mTypes[i]) {
                    case 2131231658: 
                    case 2131231659: {
                        value = Utils.formatBytes((Context)this, this.mValues[i]);
                        break;
                    }
                    case 2131231663: {
                        value = String.format("%d%%", (int)Math.floor(this.mValues[i]));
                        break;
                    }
                    case 2131231655: {
                        this.mUsesGps = true;
                    }
                    default: {
                        value = Utils.formatElapsedTime((Context)this, this.mValues[i]);
                    }
                }
                ViewGroup item = (ViewGroup)inflater.inflate(2130903077, null);
                this.mDetailsParent.addView((View)item);
                TextView labelView = (TextView)item.findViewById(2131427435);
                TextView valueView = (TextView)item.findViewById(2131427436);
                labelView.setText((CharSequence)label);
                valueView.setText((CharSequence)value);
            }
        }
    }

    private void fillControlsSection(int uid) {
        ApplicationInfo ai;
        PackageManager pm = this.getPackageManager();
        String[] packages = pm.getPackagesForUid(uid);
        PackageInfo pi = null;
        try {
            pi = packages != null ? pm.getPackageInfo(packages[0], 0) : null;
        }
        catch (PackageManager.NameNotFoundException nnfe) {
            // empty catch block
        }
        ApplicationInfo applicationInfo = ai = pi != null ? pi.applicationInfo : null;
        boolean isSystem = ai != null ? (ai.flags & 1) != 0 : false;
        boolean removeHeader = true;
        switch (this.mDrainType) {
            case APP: {
                if (packages != null && !isSystem) {
                    this.addControl(2131231665, 2131231682, 5);
                    removeHeader = false;
                }
                if (!this.mUsesGps) break;
                this.addControl(2131230951, 2131231683, 6);
                removeHeader = false;
                break;
            }
            case SCREEN: {
                this.addControl(2131231208, 2131231675, 1);
                removeHeader = false;
                break;
            }
            case WIFI: {
                this.addControl(2131231053, 2131231677, 2);
                removeHeader = false;
                break;
            }
            case BLUETOOTH: {
                this.addControl(2131230995, 2131231679, 3);
                removeHeader = false;
                break;
            }
            case CELL: {
                if (!(this.mNoCoverage > 10.0)) break;
                this.addControl(2131230927, 2131231673, 4);
                removeHeader = false;
            }
        }
        if (removeHeader) {
            this.mControlsParent.setVisibility(8);
        }
    }

    private void addControl(int title, int summary, int action) {
        Resources res = this.getResources();
        LayoutInflater inflater = this.getLayoutInflater();
        ViewGroup item = (ViewGroup)inflater.inflate(2130903076, null);
        this.mControlsParent.addView((View)item);
        Button actionButton = (Button)item.findViewById(2131427378);
        TextView summaryView = (TextView)item.findViewById(2131427433);
        actionButton.setText((CharSequence)res.getString(title));
        summaryView.setText((CharSequence)res.getString(summary));
        actionButton.setOnClickListener((View.OnClickListener)this);
        actionButton.setTag((Object)new Integer(action));
    }

    private void removePackagesSection() {
        View view = this.findViewById(2131427443);
        if (view != null) {
            view.setVisibility(8);
        }
        if ((view = this.findViewById(2131427444)) != null) {
            view.setVisibility(8);
        }
    }

    private void killProcesses() {
        if (this.mPackages == null) {
            return;
        }
        ActivityManager am = (ActivityManager)this.getSystemService("activity");
        for (int i = 0; i < this.mPackages.length; ++i) {
            am.forceStopPackage(this.mPackages[i]);
        }
        this.checkForceStop();
    }

    private void checkForceStop() {
        if (this.mPackages == null || this.mUid < 10000) {
            this.mForceStopButton.setEnabled(false);
            return;
        }
        Intent intent = new Intent("android.intent.action.QUERY_PACKAGE_RESTART", Uri.fromParts((String)"package", (String)this.mPackages[0], null));
        intent.putExtra("android.intent.extra.PACKAGES", this.mPackages);
        intent.putExtra("android.intent.extra.UID", this.mUid);
        this.sendOrderedBroadcast(intent, null, this.mCheckKillProcessesReceiver, null, 0, null, null);
    }

    private void reportBatteryUse() {
        if (this.mPackages == null) {
            return;
        }
        ApplicationErrorReport report = new ApplicationErrorReport();
        report.type = 3;
        report.packageName = this.mPackages[0];
        report.installerPackageName = this.mInstaller.getPackageName();
        report.processName = this.mPackages[0];
        report.time = System.currentTimeMillis();
        report.systemApp = (this.mApp.flags & 1) != 0;
        Intent intent = this.getIntent();
        ApplicationErrorReport.BatteryInfo batteryInfo = new ApplicationErrorReport.BatteryInfo();
        batteryInfo.usagePercent = intent.getIntExtra(EXTRA_PERCENT, 1);
        batteryInfo.durationMicros = intent.getLongExtra(EXTRA_USAGE_DURATION, 0L);
        batteryInfo.usageDetails = intent.getStringExtra(EXTRA_REPORT_DETAILS);
        batteryInfo.checkinDetails = intent.getStringExtra(EXTRA_REPORT_CHECKIN_DETAILS);
        report.batteryInfo = batteryInfo;
        Intent result = new Intent("android.intent.action.APP_ERROR");
        result.setComponent(this.mInstaller);
        result.putExtra("android.intent.extra.BUG_REPORT", (Parcelable)report);
        result.addFlags(0x10000000);
        this.startActivity(result);
    }

    private void fillPackagesSection(int uid) {
        if (uid < 1) {
            this.removePackagesSection();
            return;
        }
        ViewGroup packagesParent = (ViewGroup)this.findViewById(2131427444);
        if (packagesParent == null) {
            return;
        }
        LayoutInflater inflater = this.getLayoutInflater();
        PackageManager pm = this.getPackageManager();
        this.mPackages = pm.getPackagesForUid(uid);
        if (this.mPackages == null || this.mPackages.length < 2) {
            this.removePackagesSection();
            return;
        }
        for (int i = 0; i < this.mPackages.length; ++i) {
            try {
                ApplicationInfo ai = pm.getApplicationInfo(this.mPackages[i], 0);
                CharSequence label = ai.loadLabel(pm);
                if (label != null) {
                    this.mPackages[i] = ((Object)label).toString();
                }
                ViewGroup item = (ViewGroup)inflater.inflate(2130903079, null);
                packagesParent.addView((View)item);
                TextView labelView = (TextView)item.findViewById(2131427435);
                labelView.setText((CharSequence)this.mPackages[i]);
                continue;
            }
            catch (PackageManager.NameNotFoundException e) {
                // empty catch block
            }
        }
    }

    private String getDescriptionForDrainType() {
        return this.getResources().getString(sDrainTypeDesciptions[this.mDrainType.ordinal()]);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum DrainType {
        IDLE,
        CELL,
        PHONE,
        WIFI,
        BLUETOOTH,
        SCREEN,
        APP;

    }
}

