/*
 * Decompiled with CFR 0.152.
 */
package com.android.settings.fuelgauge;

import android.content.Context;
import android.graphics.drawable.Drawable;
import android.preference.Preference;
import android.view.View;
import android.widget.ImageView;
import android.widget.TextView;
import com.android.settings.fuelgauge.BatterySipper;
import com.android.settings.fuelgauge.PercentageBar;

public class PowerGaugePreference
extends Preference {
    private Drawable mIcon;
    private PercentageBar mGauge;
    private double mValue;
    private BatterySipper mInfo;
    private double mPercent;

    public PowerGaugePreference(Context context, Drawable icon, BatterySipper info) {
        super(context);
        this.setLayoutResource(2130903085);
        this.mIcon = icon;
        this.mGauge = new PercentageBar();
        this.mGauge.bar = context.getResources().getDrawable(2130837504);
        this.mInfo = info;
    }

    void setGaugeValue(double percent) {
        this.mGauge.percent = this.mValue = percent;
    }

    void setPercent(double percent) {
        this.mPercent = percent;
    }

    BatterySipper getInfo() {
        return this.mInfo;
    }

    void setIcon(Drawable icon) {
        this.mIcon = icon;
        this.notifyChanged();
    }

    protected void onBindView(View view) {
        super.onBindView(view);
        ImageView appIcon = (ImageView)view.findViewById(2131427452);
        if (this.mIcon == null) {
            this.mIcon = this.getContext().getResources().getDrawable(17301651);
        }
        appIcon.setImageDrawable(this.mIcon);
        ImageView appGauge = (ImageView)view.findViewById(2131427454);
        appGauge.setImageDrawable((Drawable)this.mGauge);
        TextView percentView = (TextView)view.findViewById(2131427453);
        percentView.setText((CharSequence)((int)Math.ceil(this.mPercent) + "%"));
    }
}

