/*
 * Decompiled with CFR 0.152.
 */
package com.android.settings.fuelgauge;

import android.content.Context;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.graphics.drawable.Drawable;
import android.os.BatteryStats;
import android.os.Handler;
import com.android.settings.fuelgauge.PowerUsageDetail;
import java.util.ArrayList;
import java.util.HashMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class BatterySipper
implements Comparable<BatterySipper> {
    final Context mContext;
    final HashMap<String, UidToDetail> mUidCache = new HashMap();
    final ArrayList<BatterySipper> mRequestQueue;
    final Handler mHandler;
    String name;
    Drawable icon;
    int iconId;
    BatteryStats.Uid uidObj;
    double value;
    double[] values;
    PowerUsageDetail.DrainType drainType;
    long usageTime;
    long cpuTime;
    long gpsTime;
    long wifiRunningTime;
    long cpuFgTime;
    long wakeLockTime;
    long tcpBytesReceived;
    long tcpBytesSent;
    double percent;
    double noCoveragePercent;
    String defaultPackageName;

    BatterySipper(Context context, ArrayList<BatterySipper> requestQueue, Handler handler, String label, PowerUsageDetail.DrainType drainType, int iconId, BatteryStats.Uid uid, double[] values) {
        this.mContext = context;
        this.mRequestQueue = requestQueue;
        this.mHandler = handler;
        this.values = values;
        this.name = label;
        this.drainType = drainType;
        if (iconId > 0) {
            this.icon = this.mContext.getResources().getDrawable(iconId);
        }
        if (values != null) {
            this.value = values[0];
        }
        if ((label == null || iconId == 0) && uid != null) {
            this.getQuickNameIconForUid(uid);
        }
        this.uidObj = uid;
    }

    double getSortValue() {
        return this.value;
    }

    double[] getValues() {
        return this.values;
    }

    Drawable getIcon() {
        return this.icon;
    }

    @Override
    public int compareTo(BatterySipper other) {
        return (int)(other.getSortValue() - this.getSortValue());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void getQuickNameIconForUid(BatteryStats.Uid uidObj) {
        int uid = uidObj.getUid();
        String uidString = Integer.toString(uid);
        if (this.mUidCache.containsKey(uidString)) {
            UidToDetail utd = this.mUidCache.get(uidString);
            this.defaultPackageName = utd.packageName;
            this.name = utd.name;
            this.icon = utd.icon;
            return;
        }
        PackageManager pm = this.mContext.getPackageManager();
        Drawable defaultActivityIcon = pm.getDefaultActivityIcon();
        String[] packages = pm.getPackagesForUid(uid);
        this.icon = pm.getDefaultActivityIcon();
        if (packages == null) {
            if (uid == 0) {
                this.name = this.mContext.getResources().getString(2131231689);
            } else if ("mediaserver".equals(this.name)) {
                this.name = this.mContext.getResources().getString(2131231690);
            }
            this.iconId = 2130837555;
            this.icon = this.mContext.getResources().getDrawable(this.iconId);
            return;
        }
        ArrayList<BatterySipper> arrayList = this.mRequestQueue;
        synchronized (arrayList) {
            this.mRequestQueue.add(this);
        }
    }

    void getNameIcon() {
        PackageManager pm = this.mContext.getPackageManager();
        int uid = this.uidObj.getUid();
        Drawable defaultActivityIcon = pm.getDefaultActivityIcon();
        String[] packages = pm.getPackagesForUid(uid);
        if (packages == null) {
            this.name = Integer.toString(uid);
            return;
        }
        String[] packageLabels = new String[packages.length];
        System.arraycopy(packages, 0, packageLabels, 0, packages.length);
        int preferredIndex = -1;
        for (int i = 0; i < packageLabels.length; ++i) {
            if (packageLabels[i].equals(this.name)) {
                preferredIndex = i;
            }
            try {
                ApplicationInfo ai = pm.getApplicationInfo(packageLabels[i], 0);
                CharSequence label = ai.loadLabel(pm);
                if (label != null) {
                    packageLabels[i] = ((Object)label).toString();
                }
                if (ai.icon == 0) continue;
                this.defaultPackageName = packages[i];
                this.icon = ai.loadIcon(pm);
                break;
            }
            catch (PackageManager.NameNotFoundException e) {
                // empty catch block
            }
        }
        if (this.icon == null) {
            this.icon = defaultActivityIcon;
        }
        if (packageLabels.length == 1) {
            this.name = packageLabels[0];
        } else {
            for (String pkgName : packages) {
                try {
                    CharSequence nm;
                    PackageInfo pi = pm.getPackageInfo(pkgName, 0);
                    if (pi.sharedUserLabel == 0 || (nm = pm.getText(pkgName, pi.sharedUserLabel, pi.applicationInfo)) == null) continue;
                    this.name = ((Object)nm).toString();
                    if (pi.applicationInfo.icon == 0) break;
                    this.defaultPackageName = pkgName;
                    this.icon = pi.applicationInfo.loadIcon(pm);
                    break;
                }
                catch (PackageManager.NameNotFoundException e) {
                    // empty catch block
                }
            }
        }
        String uidString = Integer.toString(this.uidObj.getUid());
        UidToDetail utd = new UidToDetail();
        utd.name = this.name;
        utd.icon = this.icon;
        utd.packageName = this.defaultPackageName;
        this.mUidCache.put(uidString, utd);
        this.mHandler.sendMessage(this.mHandler.obtainMessage(1, (Object)this));
    }

    static class UidToDetail {
        String name;
        String packageName;
        Drawable icon;

        UidToDetail() {
        }
    }
}

