/*
 * Decompiled with CFR 0.152.
 */
package com.android.settings.fuelgauge;

import android.content.Context;
import android.content.res.ColorStateList;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Path;
import android.graphics.Typeface;
import android.os.BatteryStats;
import android.os.SystemClock;
import android.text.TextPaint;
import android.util.AttributeSet;
import android.util.DisplayMetrics;
import android.util.TypedValue;
import android.view.View;
import com.android.internal.R;
import com.android.settings.R;
import com.android.settings.fuelgauge.Utils;

public class BatteryHistoryChart
extends View {
    static final int CHART_DATA_X_MASK = 65535;
    static final int CHART_DATA_BIN_MASK = -65536;
    static final int CHART_DATA_BIN_SHIFT = 16;
    static final int SANS = 1;
    static final int SERIF = 2;
    static final int MONOSPACE = 3;
    static final int BATTERY_WARN = 29;
    static final int BATTERY_CRITICAL = 14;
    static final int NUM_PHONE_SIGNALS = 7;
    final Paint mBatteryBackgroundPaint = new Paint(1);
    final Paint mBatteryGoodPaint = new Paint(1);
    final Paint mBatteryWarnPaint = new Paint(1);
    final Paint mBatteryCriticalPaint = new Paint(1);
    final Paint mChargingPaint = new Paint();
    final Paint mScreenOnPaint = new Paint();
    final Paint mGpsOnPaint = new Paint();
    final Paint mWifiRunningPaint = new Paint();
    final Paint mWakeLockPaint = new Paint();
    final ChartData mPhoneSignalChart = new ChartData();
    final TextPaint mTextPaint = new TextPaint(1);
    final Path mBatLevelPath = new Path();
    final Path mBatGoodPath = new Path();
    final Path mBatWarnPath = new Path();
    final Path mBatCriticalPath = new Path();
    final Path mChargingPath = new Path();
    final Path mScreenOnPath = new Path();
    final Path mGpsOnPath = new Path();
    final Path mWifiRunningPath = new Path();
    final Path mWakeLockPath = new Path();
    int mFontSize;
    BatteryStats mStats;
    long mStatsPeriod;
    String mDurationString;
    String mTotalDurationString;
    String mChargingLabel;
    String mScreenOnLabel;
    String mGpsOnLabel;
    String mWifiRunningLabel;
    String mWakeLockLabel;
    String mPhoneSignalLabel;
    int mTextAscent;
    int mTextDescent;
    int mDurationStringWidth;
    int mTotalDurationStringWidth;
    boolean mLargeMode;
    int mLineWidth;
    int mThinLineWidth;
    int mChargingOffset;
    int mScreenOnOffset;
    int mGpsOnOffset;
    int mWifiRunningOffset;
    int mWakeLockOffset;
    int mPhoneSignalOffset;
    int mLevelOffset;
    int mLevelTop;
    int mLevelBottom;
    static final int PHONE_SIGNAL_X_MASK = 65535;
    static final int PHONE_SIGNAL_BIN_MASK = -65536;
    static final int PHONE_SIGNAL_BIN_SHIFT = 16;
    int mNumHist;
    long mHistStart;
    long mHistEnd;
    int mBatLow;
    int mBatHigh;
    boolean mHaveWifi;
    boolean mHaveGps;

    public BatteryHistoryChart(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.mBatteryBackgroundPaint.setARGB(255, 128, 128, 128);
        this.mBatteryBackgroundPaint.setStyle(Paint.Style.FILL);
        this.mBatteryGoodPaint.setARGB(128, 0, 255, 0);
        this.mBatteryGoodPaint.setStyle(Paint.Style.STROKE);
        this.mBatteryWarnPaint.setARGB(128, 255, 255, 0);
        this.mBatteryWarnPaint.setStyle(Paint.Style.STROKE);
        this.mBatteryCriticalPaint.setARGB(192, 255, 0, 0);
        this.mBatteryCriticalPaint.setStyle(Paint.Style.STROKE);
        this.mChargingPaint.setARGB(255, 0, 128, 0);
        this.mChargingPaint.setStyle(Paint.Style.STROKE);
        this.mScreenOnPaint.setStyle(Paint.Style.STROKE);
        this.mGpsOnPaint.setStyle(Paint.Style.STROKE);
        this.mWifiRunningPaint.setStyle(Paint.Style.STROKE);
        this.mWakeLockPaint.setStyle(Paint.Style.STROKE);
        this.mPhoneSignalChart.setColors(new int[]{0, -6291456, -6250496, -8355808, -8355776, -8355744, -16744448});
        this.mTextPaint.density = this.getResources().getDisplayMetrics().density;
        this.mTextPaint.setCompatibilityScaling(this.getResources().getCompatibilityInfo().applicationScale);
        TypedArray a = context.obtainStyledAttributes(attrs, R.styleable.BatteryHistoryChart, 0, 0);
        ColorStateList textColor = null;
        int textSize = 15;
        int typefaceIndex = -1;
        int styleIndex = -1;
        TypedArray appearance = null;
        int ap = a.getResourceId(0, -1);
        if (ap != -1) {
            appearance = context.obtainStyledAttributes(ap, R.styleable.TextAppearance);
        }
        if (appearance != null) {
            int n = appearance.getIndexCount();
            block21: for (int i = 0; i < n; ++i) {
                int attr2 = appearance.getIndex(i);
                switch (attr2) {
                    case 3: {
                        textColor = appearance.getColorStateList(attr2);
                        continue block21;
                    }
                    case 0: {
                        textSize = appearance.getDimensionPixelSize(attr2, textSize);
                        continue block21;
                    }
                    case 1: {
                        typefaceIndex = appearance.getInt(attr2, -1);
                        continue block21;
                    }
                    case 2: {
                        styleIndex = appearance.getInt(attr2, -1);
                    }
                }
            }
            appearance.recycle();
        }
        int shadowcolor = 0;
        float dx = 0.0f;
        float dy = 0.0f;
        float r = 0.0f;
        int n = a.getIndexCount();
        block22: for (int i = 0; i < n; ++i) {
            int attr3 = a.getIndex(i);
            switch (attr3) {
                case 5: {
                    shadowcolor = a.getInt(attr3, 0);
                    continue block22;
                }
                case 6: {
                    dx = a.getFloat(attr3, 0.0f);
                    continue block22;
                }
                case 7: {
                    dy = a.getFloat(attr3, 0.0f);
                    continue block22;
                }
                case 8: {
                    r = a.getFloat(attr3, 0.0f);
                    continue block22;
                }
                case 4: {
                    textColor = a.getColorStateList(attr3);
                    continue block22;
                }
                case 1: {
                    textSize = a.getDimensionPixelSize(attr3, textSize);
                    continue block22;
                }
                case 2: {
                    typefaceIndex = a.getInt(attr3, typefaceIndex);
                    continue block22;
                }
                case 3: {
                    styleIndex = a.getInt(attr3, styleIndex);
                }
            }
        }
        a.recycle();
        this.mTextPaint.setColor(textColor.getDefaultColor());
        this.mTextPaint.setTextSize((float)textSize);
        Typeface tf = null;
        switch (typefaceIndex) {
            case 1: {
                tf = Typeface.SANS_SERIF;
                break;
            }
            case 2: {
                tf = Typeface.SERIF;
                break;
            }
            case 3: {
                tf = Typeface.MONOSPACE;
            }
        }
        this.setTypeface(tf, styleIndex);
        if (shadowcolor != 0) {
            this.mTextPaint.setShadowLayer(r, dx, dy, shadowcolor);
        }
    }

    public void setTypeface(Typeface tf, int style2) {
        if (style2 > 0) {
            tf = tf == null ? Typeface.defaultFromStyle((int)style2) : Typeface.create((Typeface)tf, (int)style2);
            this.mTextPaint.setTypeface(tf);
            int typefaceStyle = tf != null ? tf.getStyle() : 0;
            int need = style2 & ~typefaceStyle;
            this.mTextPaint.setFakeBoldText((need & 1) != 0);
            this.mTextPaint.setTextSkewX((need & 2) != 0 ? -0.25f : 0.0f);
        } else {
            this.mTextPaint.setFakeBoldText(false);
            this.mTextPaint.setTextSkewX(0.0f);
            this.mTextPaint.setTypeface(tf);
        }
    }

    void setStats(BatteryStats stats) {
        long uSecTime;
        this.mStats = stats;
        this.mStatsPeriod = uSecTime = this.mStats.computeBatteryRealtime(SystemClock.elapsedRealtime() * 1000L, 0);
        String durationString = Utils.formatElapsedTime(this.getContext(), this.mStatsPeriod / 1000L);
        this.mDurationString = this.getContext().getString(2131231629, new Object[]{durationString});
        this.mChargingLabel = this.getContext().getString(2131231631);
        this.mScreenOnLabel = this.getContext().getString(2131231632);
        this.mGpsOnLabel = this.getContext().getString(2131231633);
        this.mWifiRunningLabel = this.getContext().getString(2131231634);
        this.mWakeLockLabel = this.getContext().getString(2131231635);
        this.mPhoneSignalLabel = this.getContext().getString(2131231636);
        int pos = 0;
        int lastInteresting = 0;
        byte lastLevel = -1;
        this.mBatLow = 0;
        this.mBatHigh = 100;
        int aggrStates = 0;
        boolean first = true;
        if (stats.startIteratingHistoryLocked()) {
            BatteryStats.HistoryItem rec = new BatteryStats.HistoryItem();
            while (stats.getNextHistoryLocked(rec)) {
                ++pos;
                if (rec.cmd != 0) continue;
                if (first) {
                    first = false;
                    this.mHistStart = rec.time;
                }
                if (rec.batteryLevel != lastLevel || pos == 1) {
                    lastLevel = rec.batteryLevel;
                    lastInteresting = pos;
                    this.mHistEnd = rec.time;
                }
                aggrStates |= rec.states;
            }
        }
        this.mNumHist = lastInteresting;
        this.mHaveGps = (aggrStates & 0x10000000) != 0;
        boolean bl = this.mHaveWifi = (aggrStates & 0x1000000) != 0;
        if (this.mHistEnd <= this.mHistStart) {
            this.mHistEnd = this.mHistStart + 1L;
        }
        this.mTotalDurationString = Utils.formatElapsedTime(this.getContext(), this.mHistEnd - this.mHistStart);
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        super.onMeasure(widthMeasureSpec, heightMeasureSpec);
        this.mDurationStringWidth = (int)this.mTextPaint.measureText(this.mDurationString);
        this.mTotalDurationStringWidth = (int)this.mTextPaint.measureText(this.mTotalDurationString);
        this.mTextAscent = (int)this.mTextPaint.ascent();
        this.mTextDescent = (int)this.mTextPaint.descent();
    }

    void finishPaths(int w, int h, int levelh, int startX, int y, Path curLevelPath, int lastX, boolean lastCharging, boolean lastScreenOn, boolean lastGpsOn, boolean lastWifiRunning, boolean lastWakeLock, Path lastPath) {
        if (curLevelPath != null) {
            if (lastX >= 0 && lastX < w) {
                if (lastPath != null) {
                    lastPath.lineTo((float)w, (float)y);
                }
                curLevelPath.lineTo((float)w, (float)y);
            }
            curLevelPath.lineTo((float)w, (float)(this.mLevelTop + levelh));
            curLevelPath.lineTo((float)startX, (float)(this.mLevelTop + levelh));
            curLevelPath.close();
        }
        if (lastCharging) {
            this.mChargingPath.lineTo((float)w, (float)(h - this.mChargingOffset));
        }
        if (lastScreenOn) {
            this.mScreenOnPath.lineTo((float)w, (float)(h - this.mScreenOnOffset));
        }
        if (lastGpsOn) {
            this.mGpsOnPath.lineTo((float)w, (float)(h - this.mGpsOnOffset));
        }
        if (lastWifiRunning) {
            this.mWifiRunningPath.lineTo((float)w, (float)(h - this.mWifiRunningOffset));
        }
        if (lastWakeLock) {
            this.mWakeLockPath.lineTo((float)w, (float)(h - this.mWakeLockOffset));
        }
        this.mPhoneSignalChart.finish(w);
    }

    protected void onSizeChanged(int w, int h, int oldw, int oldh) {
        super.onSizeChanged(w, h, oldw, oldh);
        int textHeight = this.mTextDescent - this.mTextAscent;
        this.mThinLineWidth = (int)TypedValue.applyDimension((int)1, (float)2.0f, (DisplayMetrics)this.getResources().getDisplayMetrics());
        if (h > textHeight * 6) {
            this.mLargeMode = true;
            this.mLineWidth = textHeight / 2;
            this.mLevelTop = textHeight + this.mLineWidth;
            this.mScreenOnPaint.setARGB(255, 32, 64, 255);
            this.mGpsOnPaint.setARGB(255, 32, 64, 255);
            this.mWifiRunningPaint.setARGB(255, 32, 64, 255);
            this.mWakeLockPaint.setARGB(255, 32, 64, 255);
        } else {
            this.mLargeMode = false;
            this.mLineWidth = this.mThinLineWidth;
            this.mLevelTop = 0;
            this.mScreenOnPaint.setARGB(255, 0, 0, 255);
            this.mGpsOnPaint.setARGB(255, 0, 0, 255);
            this.mWifiRunningPaint.setARGB(255, 0, 0, 255);
            this.mWakeLockPaint.setARGB(255, 0, 0, 255);
        }
        if (this.mLineWidth <= 0) {
            this.mLineWidth = 1;
        }
        this.mTextPaint.setStrokeWidth((float)this.mThinLineWidth);
        this.mBatteryGoodPaint.setStrokeWidth((float)this.mThinLineWidth);
        this.mBatteryWarnPaint.setStrokeWidth((float)this.mThinLineWidth);
        this.mBatteryCriticalPaint.setStrokeWidth((float)this.mThinLineWidth);
        this.mChargingPaint.setStrokeWidth((float)this.mLineWidth);
        this.mScreenOnPaint.setStrokeWidth((float)this.mLineWidth);
        this.mGpsOnPaint.setStrokeWidth((float)this.mLineWidth);
        this.mWifiRunningPaint.setStrokeWidth((float)this.mLineWidth);
        this.mWakeLockPaint.setStrokeWidth((float)this.mLineWidth);
        if (this.mLargeMode) {
            int barOffset = textHeight + this.mLineWidth;
            this.mChargingOffset = this.mLineWidth;
            this.mScreenOnOffset = this.mChargingOffset + barOffset;
            this.mWakeLockOffset = this.mScreenOnOffset + barOffset;
            this.mWifiRunningOffset = this.mWakeLockOffset + barOffset;
            this.mGpsOnOffset = this.mWifiRunningOffset + (this.mHaveWifi ? barOffset : 0);
            this.mPhoneSignalOffset = this.mGpsOnOffset + (this.mHaveGps ? barOffset : 0);
            this.mLevelOffset = this.mPhoneSignalOffset + barOffset + this.mLineWidth;
            this.mPhoneSignalChart.init(w);
        } else {
            this.mWifiRunningOffset = this.mWakeLockOffset = this.mLineWidth;
            this.mGpsOnOffset = this.mWakeLockOffset;
            this.mScreenOnOffset = this.mWakeLockOffset;
            this.mChargingOffset = this.mLineWidth * 2;
            this.mPhoneSignalOffset = 0;
            this.mLevelOffset = this.mLineWidth * 3;
            this.mPhoneSignalChart.init(0);
        }
        this.mBatLevelPath.reset();
        this.mBatGoodPath.reset();
        this.mBatWarnPath.reset();
        this.mBatCriticalPath.reset();
        this.mScreenOnPath.reset();
        this.mGpsOnPath.reset();
        this.mWifiRunningPath.reset();
        this.mWakeLockPath.reset();
        this.mChargingPath.reset();
        long timeStart = this.mHistStart;
        long timeChange = this.mHistEnd - this.mHistStart;
        int batLow = this.mBatLow;
        int batChange = this.mBatHigh - this.mBatLow;
        int levelh = h - this.mLevelOffset - this.mLevelTop;
        this.mLevelBottom = this.mLevelTop + levelh;
        int x = 0;
        int y = 0;
        int startX = 0;
        int lastX = -1;
        int lastY = -1;
        Path curLevelPath = null;
        Path lastLinePath = null;
        boolean lastCharging = false;
        boolean lastScreenOn = false;
        boolean lastGpsOn = false;
        boolean lastWifiRunning = false;
        boolean lastWakeLock = false;
        int N = this.mNumHist;
        if (this.mStats.startIteratingHistoryLocked()) {
            BatteryStats.HistoryItem rec = new BatteryStats.HistoryItem();
            for (int i = 0; this.mStats.getNextHistoryLocked(rec) && i < N; ++i) {
                if (rec.cmd == 0) {
                    int bin;
                    boolean wakeLock;
                    boolean wifiRunning;
                    boolean gpsOn;
                    boolean screenOn;
                    boolean charging;
                    x = (int)((rec.time - timeStart) * (long)w / timeChange);
                    y = this.mLevelTop + levelh - (rec.batteryLevel - batLow) * (levelh - 1) / batChange;
                    if (lastX == x) continue;
                    if (lastY != y) {
                        byte value = rec.batteryLevel;
                        Path path = value <= 14 ? this.mBatCriticalPath : (value <= 29 ? this.mBatWarnPath : this.mBatGoodPath);
                        if (path != lastLinePath) {
                            if (lastLinePath != null) {
                                lastLinePath.lineTo((float)x, (float)y);
                            }
                            path.moveTo((float)x, (float)y);
                            lastLinePath = path;
                        } else {
                            path.lineTo((float)x, (float)y);
                        }
                        if (curLevelPath == null) {
                            curLevelPath = this.mBatLevelPath;
                            curLevelPath.moveTo((float)x, (float)y);
                            startX = x;
                        } else {
                            curLevelPath.lineTo((float)x, (float)y);
                        }
                        lastX = x;
                        lastY = y;
                    }
                    boolean bl = charging = (rec.states & 0x40000000) != 0;
                    if (charging != lastCharging) {
                        if (charging) {
                            this.mChargingPath.moveTo((float)x, (float)(h - this.mChargingOffset));
                        } else {
                            this.mChargingPath.lineTo((float)x, (float)(h - this.mChargingOffset));
                        }
                        lastCharging = charging;
                    }
                    boolean bl2 = screenOn = (rec.states & 0x20000000) != 0;
                    if (screenOn != lastScreenOn) {
                        if (screenOn) {
                            this.mScreenOnPath.moveTo((float)x, (float)(h - this.mScreenOnOffset));
                        } else {
                            this.mScreenOnPath.lineTo((float)x, (float)(h - this.mScreenOnOffset));
                        }
                        lastScreenOn = screenOn;
                    }
                    boolean bl3 = gpsOn = (rec.states & 0x10000000) != 0;
                    if (gpsOn != lastGpsOn) {
                        if (gpsOn) {
                            this.mGpsOnPath.moveTo((float)x, (float)(h - this.mGpsOnOffset));
                        } else {
                            this.mGpsOnPath.lineTo((float)x, (float)(h - this.mGpsOnOffset));
                        }
                        lastGpsOn = gpsOn;
                    }
                    boolean bl4 = wifiRunning = (rec.states & 0x1000000) != 0;
                    if (wifiRunning != lastWifiRunning) {
                        if (wifiRunning) {
                            this.mWifiRunningPath.moveTo((float)x, (float)(h - this.mWifiRunningOffset));
                        } else {
                            this.mWifiRunningPath.lineTo((float)x, (float)(h - this.mWifiRunningOffset));
                        }
                        lastWifiRunning = wifiRunning;
                    }
                    boolean bl5 = wakeLock = (rec.states & 0x20000) != 0;
                    if (wakeLock != lastWakeLock) {
                        if (wakeLock) {
                            this.mWakeLockPath.moveTo((float)x, (float)(h - this.mWakeLockOffset));
                        } else {
                            this.mWakeLockPath.lineTo((float)x, (float)(h - this.mWakeLockOffset));
                        }
                        lastWakeLock = wakeLock;
                    }
                    if (!this.mLargeMode) continue;
                    if ((rec.states & 0xF00) >> 8 == 3) {
                        bin = 0;
                    } else if ((rec.states & 0x4000000) != 0) {
                        bin = 1;
                    } else {
                        bin = (rec.states & 0xF0) >> 4;
                        bin += 2;
                    }
                    this.mPhoneSignalChart.addTick(x, bin);
                    continue;
                }
                if (rec.cmd == 2 || curLevelPath == null) continue;
                this.finishPaths(x + 1, h, levelh, startX, lastY, curLevelPath, lastX, lastCharging, lastScreenOn, lastGpsOn, lastWifiRunning, lastWakeLock, lastLinePath);
                lastY = -1;
                lastX = -1;
                curLevelPath = null;
                lastLinePath = null;
                lastWakeLock = false;
                lastGpsOn = false;
                lastScreenOn = false;
                lastCharging = false;
            }
        }
        this.finishPaths(w, h, levelh, startX, lastY, curLevelPath, lastX, lastCharging, lastScreenOn, lastGpsOn, lastWifiRunning, lastWakeLock, lastLinePath);
    }

    protected void onDraw(Canvas canvas) {
        super.onDraw(canvas);
        int width = this.getWidth();
        int height = this.getHeight();
        canvas.drawPath(this.mBatLevelPath, this.mBatteryBackgroundPaint);
        if (this.mLargeMode) {
            canvas.drawText(this.mDurationString, 0.0f, (float)(-this.mTextAscent + this.mLineWidth / 2), (Paint)this.mTextPaint);
            canvas.drawText(this.mTotalDurationString, (float)(width / 2 - this.mTotalDurationStringWidth / 2), (float)(this.mLevelBottom - this.mTextAscent + this.mThinLineWidth), (Paint)this.mTextPaint);
        } else {
            canvas.drawText(this.mDurationString, (float)(width / 2 - this.mDurationStringWidth / 2), (float)(height / 2 - (this.mTextDescent - this.mTextAscent) / 2 - this.mTextAscent), (Paint)this.mTextPaint);
        }
        if (!this.mBatGoodPath.isEmpty()) {
            canvas.drawPath(this.mBatGoodPath, this.mBatteryGoodPaint);
        }
        if (!this.mBatWarnPath.isEmpty()) {
            canvas.drawPath(this.mBatWarnPath, this.mBatteryWarnPaint);
        }
        if (!this.mBatCriticalPath.isEmpty()) {
            canvas.drawPath(this.mBatCriticalPath, this.mBatteryCriticalPaint);
        }
        int top = height - this.mPhoneSignalOffset - this.mLineWidth / 2;
        this.mPhoneSignalChart.draw(canvas, top, this.mLineWidth);
        if (!this.mScreenOnPath.isEmpty()) {
            canvas.drawPath(this.mScreenOnPath, this.mScreenOnPaint);
        }
        if (!this.mChargingPath.isEmpty()) {
            canvas.drawPath(this.mChargingPath, this.mChargingPaint);
        }
        if (this.mHaveGps && !this.mGpsOnPath.isEmpty()) {
            canvas.drawPath(this.mGpsOnPath, this.mGpsOnPaint);
        }
        if (this.mHaveWifi && !this.mWifiRunningPath.isEmpty()) {
            canvas.drawPath(this.mWifiRunningPath, this.mWifiRunningPaint);
        }
        if (!this.mWakeLockPath.isEmpty()) {
            canvas.drawPath(this.mWakeLockPath, this.mWakeLockPaint);
        }
        if (this.mLargeMode) {
            canvas.drawText(this.mPhoneSignalLabel, 0.0f, (float)(height - this.mPhoneSignalOffset - this.mTextDescent), (Paint)this.mTextPaint);
            if (this.mHaveGps) {
                canvas.drawText(this.mGpsOnLabel, 0.0f, (float)(height - this.mGpsOnOffset - this.mTextDescent), (Paint)this.mTextPaint);
            }
            if (this.mHaveWifi) {
                canvas.drawText(this.mWifiRunningLabel, 0.0f, (float)(height - this.mWifiRunningOffset - this.mTextDescent), (Paint)this.mTextPaint);
            }
            canvas.drawText(this.mWakeLockLabel, 0.0f, (float)(height - this.mWakeLockOffset - this.mTextDescent), (Paint)this.mTextPaint);
            canvas.drawText(this.mChargingLabel, 0.0f, (float)(height - this.mChargingOffset - this.mTextDescent), (Paint)this.mTextPaint);
            canvas.drawText(this.mScreenOnLabel, 0.0f, (float)(height - this.mScreenOnOffset - this.mTextDescent), (Paint)this.mTextPaint);
            canvas.drawLine(0.0f, (float)(this.mLevelBottom + this.mThinLineWidth / 2), (float)width, (float)(this.mLevelBottom + this.mThinLineWidth / 2), (Paint)this.mTextPaint);
            canvas.drawLine(0.0f, (float)this.mLevelTop, 0.0f, (float)(this.mLevelBottom + this.mThinLineWidth / 2), (Paint)this.mTextPaint);
            for (int i = 0; i < 10; ++i) {
                int y = this.mLevelTop + (this.mLevelBottom - this.mLevelTop) * i / 10;
                canvas.drawLine(0.0f, (float)y, (float)(this.mThinLineWidth * 2), (float)y, (Paint)this.mTextPaint);
            }
        }
    }

    static class ChartData {
        int[] mColors;
        Paint[] mPaints;
        int mNumTicks;
        int[] mTicks;
        int mLastBin;

        ChartData() {
        }

        void setColors(int[] colors) {
            this.mColors = colors;
            this.mPaints = new Paint[colors.length];
            for (int i = 0; i < colors.length; ++i) {
                this.mPaints[i] = new Paint();
                this.mPaints[i].setColor(colors[i]);
                this.mPaints[i].setStyle(Paint.Style.FILL);
            }
        }

        void init(int width) {
            this.mTicks = (int[])(width > 0 ? new int[width * 2] : null);
            this.mNumTicks = 0;
            this.mLastBin = 0;
        }

        void addTick(int x, int bin) {
            if (bin != this.mLastBin && this.mNumTicks < this.mTicks.length) {
                this.mTicks[this.mNumTicks] = x | bin << 16;
                ++this.mNumTicks;
                this.mLastBin = bin;
            }
        }

        void finish(int width) {
            if (this.mLastBin != 0) {
                this.addTick(width, 0);
            }
        }

        void draw(Canvas canvas, int top, int height) {
            int lastBin = 0;
            int lastX = 0;
            int bottom = top + height;
            for (int i = 0; i < this.mNumTicks; ++i) {
                int tick = this.mTicks[i];
                int x = tick & 0xFFFF;
                int bin = (tick & 0xFFFF0000) >> 16;
                if (lastBin != 0) {
                    canvas.drawRect((float)lastX, (float)top, (float)x, (float)bottom, this.mPaints[lastBin]);
                }
                lastBin = bin;
                lastX = x;
            }
        }
    }
}

