/*
 * Decompiled with CFR 0.152.
 */
package com.android.settings.deviceinfo;

import android.bluetooth.BluetoothAdapter;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.res.Resources;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.net.wifi.WifiInfo;
import android.net.wifi.WifiManager;
import android.os.Bundle;
import android.os.Handler;
import android.os.Message;
import android.os.SystemClock;
import android.os.SystemProperties;
import android.preference.Preference;
import android.preference.PreferenceActivity;
import android.preference.PreferenceScreen;
import android.telephony.PhoneNumberUtils;
import android.telephony.PhoneStateListener;
import android.telephony.ServiceState;
import android.telephony.TelephonyManager;
import android.text.TextUtils;
import com.android.internal.telephony.Phone;
import com.android.internal.telephony.PhoneFactory;
import com.android.internal.telephony.PhoneStateIntentReceiver;
import java.lang.ref.WeakReference;

public class Status
extends PreferenceActivity {
    private static final String KEY_WIMAX_MAC_ADDRESS = "wimax_mac_address";
    private static final String KEY_WIFI_MAC_ADDRESS = "wifi_mac_address";
    private static final String KEY_BT_ADDRESS = "bt_address";
    private static final int EVENT_SIGNAL_STRENGTH_CHANGED = 200;
    private static final int EVENT_SERVICE_STATE_CHANGED = 300;
    private static final int EVENT_UPDATE_STATS = 500;
    private TelephonyManager mTelephonyManager;
    private Phone mPhone = null;
    private PhoneStateIntentReceiver mPhoneStateReceiver;
    private Resources mRes;
    private Preference mSignalStrength;
    private Preference mUptime;
    private static String sUnknown;
    private Preference mBatteryStatus;
    private Preference mBatteryLevel;
    private Handler mHandler;
    private BroadcastReceiver mBatteryInfoReceiver = new BroadcastReceiver(){

        public void onReceive(Context context, Intent intent) {
            String action = intent.getAction();
            if ("android.intent.action.BATTERY_CHANGED".equals(action)) {
                String statusString;
                int level = intent.getIntExtra("level", 0);
                int scale = intent.getIntExtra("scale", 100);
                Status.this.mBatteryLevel.setSummary((CharSequence)(String.valueOf(level * 100 / scale) + "%"));
                int plugType = intent.getIntExtra("plugged", 0);
                int status = intent.getIntExtra("status", 1);
                if (status == 2) {
                    statusString = Status.this.getString(2131230774);
                    if (plugType > 0) {
                        statusString = statusString + " " + Status.this.getString(plugType == 1 ? 2131230775 : 2131230776);
                    }
                } else {
                    statusString = status == 3 ? Status.this.getString(2131230777) : (status == 4 ? Status.this.getString(2131230778) : (status == 5 ? Status.this.getString(2131230779) : Status.this.getString(2131230773)));
                }
                Status.this.mBatteryStatus.setSummary((CharSequence)statusString);
            }
        }
    };
    private PhoneStateListener mPhoneStateListener = new PhoneStateListener(){

        public void onDataConnectionStateChanged(int state) {
            Status.this.updateDataState();
            Status.this.updateNetworkType();
        }
    };

    protected void onCreate(Bundle icicle) {
        super.onCreate(icicle);
        this.mHandler = new MyHandler(this);
        this.mTelephonyManager = (TelephonyManager)this.getSystemService("phone");
        this.addPreferencesFromResource(2130968587);
        this.mBatteryLevel = this.findPreference("battery_level");
        this.mBatteryStatus = this.findPreference("battery_status");
        this.mRes = this.getResources();
        if (sUnknown == null) {
            sUnknown = this.mRes.getString(2131230724);
        }
        this.mPhone = PhoneFactory.getDefaultPhone();
        this.mSignalStrength = this.findPreference("signal_strength");
        this.mUptime = this.findPreference("up_time");
        if (this.mPhone.getPhoneName().equals("CDMA")) {
            this.setSummaryText("meid_number", this.mPhone.getMeid());
            this.setSummaryText("min_number", this.mPhone.getCdmaMin());
            if (this.getResources().getBoolean(2131099651)) {
                this.findPreference("min_number").setTitle(2131231260);
            }
            this.setSummaryText("prl_version", this.mPhone.getCdmaPrlVersion());
            Preference removablePref = this.findPreference("imei");
            if (removablePref != null) {
                this.getPreferenceScreen().removePreference(removablePref);
            }
            if ((removablePref = this.findPreference("imei_sv")) != null) {
                this.getPreferenceScreen().removePreference(removablePref);
            }
        } else {
            this.setSummaryText("imei", this.mPhone.getDeviceId());
            this.setSummaryText("imei_sv", ((TelephonyManager)this.getSystemService("phone")).getDeviceSoftwareVersion());
            Preference removablePref = this.findPreference("prl_version");
            if (removablePref != null) {
                this.getPreferenceScreen().removePreference(removablePref);
            }
            if ((removablePref = this.findPreference("meid_number")) != null) {
                this.getPreferenceScreen().removePreference(removablePref);
            }
            if ((removablePref = this.findPreference("min_number")) != null) {
                this.getPreferenceScreen().removePreference(removablePref);
            }
        }
        String rawNumber = this.mPhone.getLine1Number();
        String formattedNumber = null;
        if (!TextUtils.isEmpty((CharSequence)rawNumber)) {
            formattedNumber = PhoneNumberUtils.formatNumber((String)rawNumber);
        }
        this.setSummaryText("number", formattedNumber);
        this.mPhoneStateReceiver = new PhoneStateIntentReceiver((Context)this, this.mHandler);
        this.mPhoneStateReceiver.notifySignalStrength(200);
        this.mPhoneStateReceiver.notifyServiceState(300);
        this.setWimaxStatus();
        this.setWifiStatus();
        this.setBtStatus();
    }

    protected void onResume() {
        super.onResume();
        this.mPhoneStateReceiver.registerIntent();
        this.registerReceiver(this.mBatteryInfoReceiver, new IntentFilter("android.intent.action.BATTERY_CHANGED"));
        this.updateSignalStrength();
        this.updateServiceState(this.mPhone.getServiceState());
        this.updateDataState();
        this.mTelephonyManager.listen(this.mPhoneStateListener, 64);
        this.mHandler.sendEmptyMessage(500);
    }

    public void onPause() {
        super.onPause();
        this.mPhoneStateReceiver.unregisterIntent();
        this.mTelephonyManager.listen(this.mPhoneStateListener, 0);
        this.unregisterReceiver(this.mBatteryInfoReceiver);
        this.mHandler.removeMessages(500);
    }

    private void setSummary(String preference, String property, String alt) {
        try {
            this.findPreference(preference).setSummary((CharSequence)SystemProperties.get((String)property, (String)alt));
        }
        catch (RuntimeException e) {
            // empty catch block
        }
    }

    private void setSummaryText(String preference, String text) {
        if (TextUtils.isEmpty((CharSequence)text)) {
            text = sUnknown;
        }
        if (this.findPreference(preference) != null) {
            this.findPreference(preference).setSummary((CharSequence)text);
        }
    }

    private void updateNetworkType() {
        this.setSummary("network_type", "gsm.network.type", sUnknown);
    }

    private void updateDataState() {
        int state = this.mTelephonyManager.getDataState();
        String display = this.mRes.getString(2131230744);
        switch (state) {
            case 2: {
                display = this.mRes.getString(2131230742);
                break;
            }
            case 3: {
                display = this.mRes.getString(2131230743);
                break;
            }
            case 1: {
                display = this.mRes.getString(2131230741);
                break;
            }
            case 0: {
                display = this.mRes.getString(2131230740);
            }
        }
        this.setSummaryText("data_state", display);
    }

    private void updateServiceState(ServiceState serviceState) {
        int state = serviceState.getState();
        String display = this.mRes.getString(2131230744);
        switch (state) {
            case 0: {
                display = this.mRes.getString(2131230731);
                break;
            }
            case 1: 
            case 2: {
                display = this.mRes.getString(2131230732);
                break;
            }
            case 3: {
                display = this.mRes.getString(2131230734);
            }
        }
        this.setSummaryText("service_state", display);
        if (serviceState.getRoaming()) {
            this.setSummaryText("roaming_state", this.mRes.getString(2131230735));
        } else {
            this.setSummaryText("roaming_state", this.mRes.getString(2131230736));
        }
        this.setSummaryText("operator_name", serviceState.getOperatorAlphaLong());
    }

    void updateSignalStrength() {
        if (this.mSignalStrength != null) {
            int signalAsu;
            int signalDbm;
            int state = this.mPhoneStateReceiver.getServiceState().getState();
            Resources r = this.getResources();
            if (1 == state || 3 == state) {
                this.mSignalStrength.setSummary((CharSequence)"0");
            }
            if (-1 == (signalDbm = this.mPhoneStateReceiver.getSignalStrengthDbm())) {
                signalDbm = 0;
            }
            if (-1 == (signalAsu = this.mPhoneStateReceiver.getSignalStrength())) {
                signalAsu = 0;
            }
            this.mSignalStrength.setSummary((CharSequence)(String.valueOf(signalDbm) + " " + r.getString(2131230747) + "   " + String.valueOf(signalAsu) + " " + r.getString(2131230748)));
        }
    }

    private void setWimaxStatus() {
        ConnectivityManager cm = (ConnectivityManager)this.getSystemService("connectivity");
        NetworkInfo ni = cm.getNetworkInfo(6);
        if (ni == null) {
            PreferenceScreen root = this.getPreferenceScreen();
            Preference ps = this.findPreference(KEY_WIMAX_MAC_ADDRESS);
            if (ps != null) {
                root.removePreference(ps);
            }
        } else {
            Preference wimaxMacAddressPref = this.findPreference(KEY_WIMAX_MAC_ADDRESS);
            String macAddress = SystemProperties.get((String)"net.wimax.mac.address", (String)this.getString(2131231271));
            wimaxMacAddressPref.setSummary((CharSequence)macAddress);
        }
    }

    private void setWifiStatus() {
        WifiManager wifiManager = (WifiManager)this.getSystemService("wifi");
        WifiInfo wifiInfo = wifiManager.getConnectionInfo();
        Preference wifiMacAddressPref = this.findPreference(KEY_WIFI_MAC_ADDRESS);
        String macAddress = wifiInfo == null ? null : wifiInfo.getMacAddress();
        wifiMacAddressPref.setSummary((CharSequence)(!TextUtils.isEmpty((CharSequence)macAddress) ? macAddress : this.getString(2131231271)));
    }

    private void setBtStatus() {
        BluetoothAdapter bluetooth = BluetoothAdapter.getDefaultAdapter();
        Preference btAddressPref = this.findPreference(KEY_BT_ADDRESS);
        if (bluetooth == null) {
            this.getPreferenceScreen().removePreference(btAddressPref);
        } else {
            String address = bluetooth.isEnabled() ? bluetooth.getAddress() : null;
            btAddressPref.setSummary((CharSequence)(!TextUtils.isEmpty((CharSequence)address) ? address : this.getString(2131231271)));
        }
    }

    void updateTimes() {
        long at = SystemClock.uptimeMillis() / 1000L;
        long ut = SystemClock.elapsedRealtime() / 1000L;
        if (ut == 0L) {
            ut = 1L;
        }
        this.mUptime.setSummary((CharSequence)this.convert(ut));
    }

    private String pad(int n) {
        if (n >= 10) {
            return String.valueOf(n);
        }
        return "0" + String.valueOf(n);
    }

    private String convert(long t) {
        int s = (int)(t % 60L);
        int m = (int)(t / 60L % 60L);
        int h = (int)(t / 3600L);
        return h + ":" + this.pad(m) + ":" + this.pad(s);
    }

    private static class MyHandler
    extends Handler {
        private WeakReference<Status> mStatus;

        public MyHandler(Status activity) {
            this.mStatus = new WeakReference<Status>(activity);
        }

        public void handleMessage(Message msg) {
            Status status = (Status)((Object)this.mStatus.get());
            if (status == null) {
                return;
            }
            switch (msg.what) {
                case 200: {
                    status.updateSignalStrength();
                    break;
                }
                case 300: {
                    ServiceState serviceState = status.mPhoneStateReceiver.getServiceState();
                    status.updateServiceState(serviceState);
                    break;
                }
                case 500: {
                    status.updateTimes();
                    this.sendEmptyMessageDelayed(500, 1000L);
                }
            }
        }
    }
}

