/*
 * Decompiled with CFR 0.152.
 */
package com.android.settings.deviceinfo;

import android.app.ActivityManager;
import android.app.AlertDialog;
import android.app.Dialog;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.res.Resources;
import android.os.Bundle;
import android.os.Environment;
import android.os.IBinder;
import android.os.RemoteException;
import android.os.ServiceManager;
import android.os.StatFs;
import android.os.storage.IMountService;
import android.os.storage.StorageEventListener;
import android.os.storage.StorageManager;
import android.preference.Preference;
import android.preference.PreferenceActivity;
import android.preference.PreferenceGroup;
import android.preference.PreferenceScreen;
import android.text.format.Formatter;
import android.util.Log;
import android.widget.Toast;
import com.android.settings.MediaFormat;
import java.io.File;
import java.util.List;

public class Memory
extends PreferenceActivity
implements DialogInterface.OnCancelListener {
    private static final String TAG = "Memory";
    private static final boolean localLOGV = false;
    private static final String MEMORY_SD_SIZE = "memory_sd_size";
    private static final String MEMORY_SD_AVAIL = "memory_sd_avail";
    private static final String MEMORY_SD_MOUNT_TOGGLE = "memory_sd_mount_toggle";
    private static final String MEMORY_SD_FORMAT = "memory_sd_format";
    private static final String MEMORY_SD_GROUP = "memory_sd";
    private static final int DLG_CONFIRM_UNMOUNT = 1;
    private static final int DLG_ERROR_UNMOUNT = 2;
    private Resources mRes;
    private Preference mSdSize;
    private Preference mSdAvail;
    private Preference mSdMountToggle;
    private Preference mSdFormat;
    private PreferenceGroup mSdMountPreferenceGroup;
    boolean mSdMountToggleAdded = true;
    private IMountService mMountService = null;
    private StorageManager mStorageManager = null;
    StorageEventListener mStorageListener = new StorageEventListener(){

        public void onStorageStateChanged(String path, String oldState, String newState) {
            Log.i((String)Memory.TAG, (String)("Received storage state changed notification that " + path + " changed state from " + oldState + " to " + newState));
            Memory.this.updateMemoryStatus();
        }
    };
    private final BroadcastReceiver mReceiver = new BroadcastReceiver(){

        public void onReceive(Context context, Intent intent) {
            Memory.this.updateMemoryStatus();
        }
    };

    protected void onCreate(Bundle icicle) {
        super.onCreate(icicle);
        if (this.mStorageManager == null) {
            this.mStorageManager = (StorageManager)this.getSystemService("storage");
            this.mStorageManager.registerListener(this.mStorageListener);
        }
        this.addPreferencesFromResource(2130968585);
        this.mRes = this.getResources();
        this.mSdSize = this.findPreference(MEMORY_SD_SIZE);
        this.mSdAvail = this.findPreference(MEMORY_SD_AVAIL);
        this.mSdMountToggle = this.findPreference(MEMORY_SD_MOUNT_TOGGLE);
        this.mSdFormat = this.findPreference(MEMORY_SD_FORMAT);
        this.mSdMountPreferenceGroup = (PreferenceGroup)this.findPreference(MEMORY_SD_GROUP);
    }

    protected void onResume() {
        super.onResume();
        IntentFilter intentFilter = new IntentFilter("android.intent.action.MEDIA_SCANNER_STARTED");
        intentFilter.addAction("android.intent.action.MEDIA_SCANNER_FINISHED");
        intentFilter.addDataScheme("file");
        this.registerReceiver(this.mReceiver, intentFilter);
        this.updateMemoryStatus();
    }

    protected void onPause() {
        super.onPause();
        this.unregisterReceiver(this.mReceiver);
    }

    protected void onDestroy() {
        if (this.mStorageManager != null && this.mStorageListener != null) {
            this.mStorageManager.unregisterListener(this.mStorageListener);
        }
        super.onDestroy();
    }

    private synchronized IMountService getMountService() {
        if (this.mMountService == null) {
            IBinder service = ServiceManager.getService((String)"mount");
            if (service != null) {
                this.mMountService = IMountService.Stub.asInterface((IBinder)service);
            } else {
                Log.e((String)TAG, (String)"Can't get mount service");
            }
        }
        return this.mMountService;
    }

    public boolean onPreferenceTreeClick(PreferenceScreen preferenceScreen, Preference preference) {
        if (preference == this.mSdMountToggle) {
            String status = Environment.getExternalStorageState();
            if (status.equals("mounted")) {
                this.unmount();
            } else {
                this.mount();
            }
            return true;
        }
        if (preference == this.mSdFormat) {
            Intent intent = new Intent("android.intent.action.VIEW");
            intent.setClass((Context)this, MediaFormat.class);
            this.startActivity(intent);
            return true;
        }
        return false;
    }

    public Dialog onCreateDialog(int id2, Bundle args) {
        switch (id2) {
            case 1: {
                return new AlertDialog.Builder((Context)this).setTitle(2131231287).setPositiveButton(2131231483, new DialogInterface.OnClickListener(){

                    public void onClick(DialogInterface dialog, int which) {
                        Memory.this.doUnmount(true);
                    }
                }).setNegativeButton(2131230919, null).setMessage(2131231288).setOnCancelListener((DialogInterface.OnCancelListener)this).create();
            }
            case 2: {
                return new AlertDialog.Builder((Context)this).setTitle(2131231289).setNeutralButton(2131231483, null).setMessage(2131231290).setOnCancelListener((DialogInterface.OnCancelListener)this).create();
            }
        }
        return null;
    }

    private void doUnmount(boolean force) {
        Toast.makeText((Context)this, (int)2131231291, (int)0).show();
        IMountService mountService = this.getMountService();
        String extStoragePath = Environment.getExternalStorageDirectory().toString();
        try {
            this.mSdMountToggle.setEnabled(false);
            this.mSdMountToggle.setTitle((CharSequence)this.mRes.getString(2131231292));
            this.mSdMountToggle.setSummary((CharSequence)this.mRes.getString(2131231293));
            mountService.unmountVolume(extStoragePath, force);
        }
        catch (RemoteException e) {
            this.showDialogInner(2);
        }
    }

    private void showDialogInner(int id2) {
        this.removeDialog(id2);
        this.showDialog(id2);
    }

    private boolean hasAppsAccessingStorage() throws RemoteException {
        String extStoragePath = Environment.getExternalStorageDirectory().toString();
        IMountService mountService = this.getMountService();
        int[] stUsers = mountService.getStorageUsers(extStoragePath);
        if (stUsers != null && stUsers.length > 0) {
            return true;
        }
        ActivityManager am = (ActivityManager)this.getSystemService("activity");
        List list = am.getRunningExternalApplications();
        return list != null && list.size() > 0;
    }

    private void unmount() {
        try {
            if (this.hasAppsAccessingStorage()) {
                this.showDialogInner(1);
            } else {
                this.doUnmount(true);
            }
        }
        catch (RemoteException e) {
            Log.e((String)TAG, (String)"Is MountService running?");
            this.showDialogInner(2);
        }
    }

    private void mount() {
        IMountService mountService = this.getMountService();
        try {
            if (mountService != null) {
                mountService.mountVolume(Environment.getExternalStorageDirectory().toString());
            } else {
                Log.e((String)TAG, (String)"Mount service is null, can't mount");
            }
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
    }

    private void updateMemoryStatus() {
        long blockSize;
        StatFs stat;
        File path;
        String status = Environment.getExternalStorageState();
        String readOnly = "";
        if (status.equals("mounted_ro")) {
            status = "mounted";
            readOnly = this.mRes.getString(2131231286);
        }
        if (status.equals("mounted")) {
            if (!Environment.isExternalStorageRemovable() && this.mSdMountToggleAdded) {
                this.mSdMountPreferenceGroup.removePreference(this.mSdMountToggle);
                this.mSdMountToggleAdded = false;
            }
            try {
                path = Environment.getExternalStorageDirectory();
                stat = new StatFs(path.getPath());
                blockSize = stat.getBlockSize();
                long totalBlocks = stat.getBlockCount();
                long availableBlocks = stat.getAvailableBlocks();
                this.mSdSize.setSummary((CharSequence)this.formatSize(totalBlocks * blockSize));
                this.mSdAvail.setSummary((CharSequence)(this.formatSize(availableBlocks * blockSize) + readOnly));
                this.mSdMountToggle.setEnabled(true);
                this.mSdMountToggle.setTitle((CharSequence)this.mRes.getString(2131231278));
                this.mSdMountToggle.setSummary((CharSequence)this.mRes.getString(2131231279));
            }
            catch (IllegalArgumentException e) {
                status = "removed";
            }
        } else {
            this.mSdSize.setSummary((CharSequence)this.mRes.getString(2131231285));
            this.mSdAvail.setSummary((CharSequence)this.mRes.getString(2131231285));
            if (!Environment.isExternalStorageRemovable() && status.equals("unmounted") && !this.mSdMountToggleAdded) {
                this.mSdMountPreferenceGroup.addPreference(this.mSdMountToggle);
                this.mSdMountToggleAdded = true;
            }
            if (status.equals("unmounted") || status.equals("nofs") || status.equals("unmountable")) {
                this.mSdMountToggle.setEnabled(true);
                this.mSdMountToggle.setTitle((CharSequence)this.mRes.getString(2131231281));
                this.mSdMountToggle.setSummary((CharSequence)this.mRes.getString(2131231282));
            } else {
                this.mSdMountToggle.setEnabled(false);
                this.mSdMountToggle.setTitle((CharSequence)this.mRes.getString(2131231281));
                this.mSdMountToggle.setSummary((CharSequence)this.mRes.getString(2131231280));
            }
        }
        path = Environment.getDataDirectory();
        stat = new StatFs(path.getPath());
        blockSize = stat.getBlockSize();
        long availableBlocks = stat.getAvailableBlocks();
        this.findPreference("memory_internal_avail").setSummary((CharSequence)this.formatSize(availableBlocks * blockSize));
    }

    private String formatSize(long size) {
        return Formatter.formatFileSize((Context)this, (long)size);
    }

    public void onCancel(DialogInterface dialog) {
        this.finish();
    }
}

