/*
 * Decompiled with CFR 0.152.
 */
package com.android.settings.bluetooth;

import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.os.Bundle;
import android.util.Log;
import android.view.View;
import android.widget.TextView;
import com.android.internal.app.AlertActivity;
import com.android.internal.app.AlertController;
import com.android.settings.bluetooth.LocalBluetoothManager;

public class RequestPermissionHelperActivity
extends AlertActivity
implements DialogInterface.OnClickListener {
    private static final String TAG = "RequestPermissionHelperActivity";
    public static final String ACTION_INTERNAL_REQUEST_BT_ON = "com.android.settings.bluetooth.ACTION_INTERNAL_REQUEST_BT_ON";
    public static final String ACTION_INTERNAL_REQUEST_BT_ON_AND_DISCOVERABLE = "com.android.settings.bluetooth.ACTION_INTERNAL_REQUEST_BT_ON_AND_DISCOVERABLE";
    private LocalBluetoothManager mLocalManager;
    private int mTimeout;
    private boolean mEnableOnly;

    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        if (this.parseIntent()) {
            this.finish();
            return;
        }
        this.createDialog();
    }

    void createDialog() {
        View view;
        AlertController.AlertParams p = this.mAlertParams;
        p.mIconId = 17301659;
        p.mTitle = this.getString(2131230819);
        p.mView = view = this.getLayoutInflater().inflate(2130903046, null);
        TextView tv = (TextView)view.findViewById(2131427341);
        if (this.mEnableOnly) {
            tv.setText((CharSequence)this.getString(2131230820));
        } else if (this.mTimeout == 0) {
            tv.setText((CharSequence)this.getString(2131230824));
        } else {
            tv.setText((CharSequence)this.getString(2131230823, new Object[]{this.mTimeout}));
        }
        p.mPositiveButtonText = this.getString(2131230722);
        p.mPositiveButtonListener = this;
        p.mNegativeButtonText = this.getString(2131230723);
        p.mNegativeButtonListener = this;
        this.setupAlert();
    }

    public void onClick(DialogInterface dialog, int which) {
        int returnCode;
        switch (which) {
            case -1: {
                int btState = 0;
                try {
                    int retryCount = 30;
                    do {
                        btState = this.mLocalManager.getBluetoothState();
                        Thread.sleep(100L);
                    } while (btState == 13 && --retryCount > 0);
                }
                catch (InterruptedException e) {
                    // empty catch block
                }
                if (btState == 11 || btState == 12 || this.mLocalManager.getBluetoothAdapter().enable()) {
                    returnCode = -1000;
                    break;
                }
                returnCode = 0;
                break;
            }
            case -2: {
                returnCode = 0;
                break;
            }
            default: {
                return;
            }
        }
        this.setResult(returnCode);
    }

    private boolean parseIntent() {
        Intent intent = this.getIntent();
        if (intent != null && intent.getAction().equals(ACTION_INTERNAL_REQUEST_BT_ON)) {
            this.mEnableOnly = true;
        } else if (intent != null && intent.getAction().equals(ACTION_INTERNAL_REQUEST_BT_ON_AND_DISCOVERABLE)) {
            this.mEnableOnly = false;
            this.mTimeout = intent.getIntExtra("android.bluetooth.adapter.extra.DISCOVERABLE_DURATION", 120);
        } else {
            this.setResult(0);
            return true;
        }
        this.mLocalManager = LocalBluetoothManager.getInstance((Context)this);
        if (this.mLocalManager == null) {
            Log.e((String)TAG, (String)"Error: there's a problem starting bluetooth");
            this.setResult(0);
            return true;
        }
        return false;
    }

    public void onBackPressed() {
        this.setResult(0);
        super.onBackPressed();
    }
}

