/*
 * Decompiled with CFR 0.152.
 */
package com.android.settings.bluetooth;

import android.app.Activity;
import android.app.AlertDialog;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.SharedPreferences;
import android.os.Bundle;
import android.util.Log;
import com.android.settings.bluetooth.LocalBluetoothManager;
import com.android.settings.bluetooth.RequestPermissionHelperActivity;

public class RequestPermissionActivity
extends Activity
implements DialogInterface.OnClickListener {
    private static final String TAG = "RequestPermissionActivity";
    private static final int MAX_DISCOVERABLE_TIMEOUT = 3600;
    static final int RESULT_BT_STARTING_OR_STARTED = -1000;
    private static final int REQUEST_CODE_START_BT = 1;
    private LocalBluetoothManager mLocalManager;
    private int mTimeout = 120;
    private boolean mNeededToEnableBluetooth;
    private boolean mEnableOnly = false;
    private boolean mUserConfirmed = false;
    private AlertDialog mDialog = null;
    private BroadcastReceiver mReceiver = new BroadcastReceiver(){

        public void onReceive(Context context, Intent intent) {
            int state;
            if (intent == null) {
                return;
            }
            if (RequestPermissionActivity.this.mNeededToEnableBluetooth && "android.bluetooth.adapter.action.STATE_CHANGED".equals(intent.getAction()) && (state = intent.getIntExtra("android.bluetooth.adapter.extra.STATE", Integer.MIN_VALUE)) == 12 && RequestPermissionActivity.this.mUserConfirmed) {
                RequestPermissionActivity.this.proceedAndFinish();
            }
        }
    };

    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        if (this.parseIntent()) {
            this.finish();
            return;
        }
        int btState = this.mLocalManager.getBluetoothState();
        switch (btState) {
            case 10: 
            case 11: 
            case 13: {
                this.registerReceiver(this.mReceiver, new IntentFilter("android.bluetooth.adapter.action.STATE_CHANGED"));
                Intent i = new Intent();
                i.setClass((Context)this, RequestPermissionHelperActivity.class);
                if (this.mEnableOnly) {
                    i.setAction("com.android.settings.bluetooth.ACTION_INTERNAL_REQUEST_BT_ON");
                } else {
                    i.setAction("com.android.settings.bluetooth.ACTION_INTERNAL_REQUEST_BT_ON_AND_DISCOVERABLE");
                    i.putExtra("android.bluetooth.adapter.extra.DISCOVERABLE_DURATION", this.mTimeout);
                }
                this.startActivityForResult(i, 1);
                this.mNeededToEnableBluetooth = true;
                break;
            }
            case 12: {
                if (this.mEnableOnly) {
                    this.proceedAndFinish();
                    return;
                }
                this.createDialog();
            }
        }
    }

    private void createDialog() {
        AlertDialog.Builder builder = new AlertDialog.Builder((Context)this);
        builder.setIcon(17301659);
        builder.setTitle((CharSequence)this.getString(2131230819));
        if (this.mNeededToEnableBluetooth) {
            builder.setMessage((CharSequence)this.getString(2131230825));
            builder.setCancelable(false);
        } else {
            if (this.mTimeout == 0) {
                builder.setMessage((CharSequence)this.getString(2131230822));
            } else {
                builder.setMessage((CharSequence)this.getString(2131230821, new Object[]{this.mTimeout}));
            }
            builder.setPositiveButton((CharSequence)this.getString(2131230722), (DialogInterface.OnClickListener)this);
            builder.setNegativeButton((CharSequence)this.getString(2131230723), (DialogInterface.OnClickListener)this);
        }
        this.mDialog = builder.create();
        this.mDialog.show();
    }

    protected void onActivityResult(int requestCode, int resultCode, Intent data) {
        if (requestCode != 1) {
            Log.e((String)TAG, (String)("Unexpected onActivityResult " + requestCode + " " + resultCode));
            this.setResult(0);
            this.finish();
            return;
        }
        if (resultCode != -1000) {
            this.setResult(resultCode);
            this.finish();
            return;
        }
        this.mUserConfirmed = true;
        if (this.mLocalManager.getBluetoothState() == 12) {
            this.proceedAndFinish();
        } else {
            this.createDialog();
        }
    }

    public void onClick(DialogInterface dialog, int which) {
        switch (which) {
            case -1: {
                this.proceedAndFinish();
                break;
            }
            case -2: {
                this.setResult(0);
                this.finish();
            }
        }
    }

    private void proceedAndFinish() {
        int returnCode;
        if (this.mEnableOnly) {
            returnCode = -1;
        } else if (this.mLocalManager.getBluetoothAdapter().setScanMode(23, this.mTimeout)) {
            this.persistDiscoverableEndTimestamp(System.currentTimeMillis() + (long)(this.mTimeout * 1000));
            returnCode = this.mTimeout;
            if (returnCode < 1) {
                returnCode = 1;
            }
        } else {
            returnCode = 0;
        }
        if (this.mDialog != null) {
            this.mDialog.dismiss();
        }
        this.setResult(returnCode);
        this.finish();
    }

    private boolean parseIntent() {
        Intent intent = this.getIntent();
        if (intent != null && intent.getAction().equals("android.bluetooth.adapter.action.REQUEST_ENABLE")) {
            this.mEnableOnly = true;
        } else if (intent != null && intent.getAction().equals("android.bluetooth.adapter.action.REQUEST_DISCOVERABLE")) {
            this.mTimeout = intent.getIntExtra("android.bluetooth.adapter.extra.DISCOVERABLE_DURATION", 120);
            Log.d((String)TAG, (String)("Setting Bluetooth Discoverable Timeout = " + this.mTimeout));
            if (this.mTimeout < 0 || this.mTimeout > 3600) {
                this.mTimeout = 120;
            }
        } else {
            Log.e((String)TAG, (String)"Error: this activity may be started only with intent android.bluetooth.adapter.action.REQUEST_ENABLE or android.bluetooth.adapter.action.REQUEST_DISCOVERABLE");
            this.setResult(0);
            return true;
        }
        this.mLocalManager = LocalBluetoothManager.getInstance((Context)this);
        if (this.mLocalManager == null) {
            Log.e((String)TAG, (String)"Error: there's a problem starting bluetooth");
            this.setResult(0);
            return true;
        }
        return false;
    }

    protected void onDestroy() {
        super.onDestroy();
        if (this.mNeededToEnableBluetooth) {
            this.unregisterReceiver(this.mReceiver);
        }
    }

    private void persistDiscoverableEndTimestamp(long endTimestamp) {
        SharedPreferences.Editor editor = this.mLocalManager.getSharedPreferences().edit();
        editor.putLong("discoverable_end_timestamp", endTimestamp);
        editor.apply();
    }

    public void onBackPressed() {
        this.setResult(0);
        super.onBackPressed();
    }
}

