/*
 * Decompiled with CFR 0.152.
 */
package com.android.settings.bluetooth;

import android.bluetooth.BluetoothA2dp;
import android.bluetooth.BluetoothDevice;
import android.bluetooth.BluetoothHeadset;
import android.bluetooth.BluetoothUuid;
import android.os.Handler;
import android.os.ParcelUuid;
import android.util.Log;
import com.android.settings.bluetooth.LocalBluetoothManager;
import com.android.settings.bluetooth.SettingsBtStatus;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class LocalBluetoothProfileManager {
    private static final String TAG = "LocalBluetoothProfileManager";
    static final ParcelUuid[] HEADSET_PROFILE_UUIDS = new ParcelUuid[]{BluetoothUuid.HSP, BluetoothUuid.Handsfree};
    static final ParcelUuid[] A2DP_PROFILE_UUIDS = new ParcelUuid[]{BluetoothUuid.AudioSink, BluetoothUuid.AdvAudioDist};
    static final ParcelUuid[] OPP_PROFILE_UUIDS = new ParcelUuid[]{BluetoothUuid.ObexObjectPush};
    private static Map<Profile, LocalBluetoothProfileManager> sProfileMap = new HashMap<Profile, LocalBluetoothProfileManager>();
    protected LocalBluetoothManager mLocalManager;
    private static LinkedList<ServiceListener> mServiceListeners = new LinkedList();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void init(LocalBluetoothManager localManager) {
        Map<Profile, LocalBluetoothProfileManager> map = sProfileMap;
        synchronized (map) {
            if (sProfileMap.size() == 0) {
                LocalBluetoothProfileManager profileManager = new A2dpProfileManager(localManager);
                sProfileMap.put(Profile.A2DP, profileManager);
                profileManager = new HeadsetProfileManager(localManager);
                sProfileMap.put(Profile.HEADSET, profileManager);
                profileManager = new OppProfileManager(localManager);
                sProfileMap.put(Profile.OPP, profileManager);
            }
        }
    }

    public static void addServiceListener(ServiceListener l) {
        mServiceListeners.add(l);
    }

    public static void removeServiceListener(ServiceListener l) {
        mServiceListeners.remove(l);
    }

    public static boolean isManagerReady() {
        LocalBluetoothProfileManager profileManager = sProfileMap.get((Object)Profile.HEADSET);
        if (profileManager == null) {
            return sProfileMap.size() > 0;
        }
        return profileManager.isProfileReady();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static LocalBluetoothProfileManager getProfileManager(LocalBluetoothManager localManager, Profile profile) {
        Map<Profile, LocalBluetoothProfileManager> map = sProfileMap;
        synchronized (map) {
            LocalBluetoothProfileManager profileManager = sProfileMap.get((Object)profile);
            if (profileManager == null) {
                Log.e((String)TAG, (String)("profileManager can't be found for " + profile.toString()));
            }
            return profileManager;
        }
    }

    public static void updateProfiles(ParcelUuid[] uuids, List<Profile> profiles) {
        profiles.clear();
        if (uuids == null) {
            return;
        }
        if (BluetoothUuid.containsAnyUuid((ParcelUuid[])uuids, (ParcelUuid[])HEADSET_PROFILE_UUIDS)) {
            profiles.add(Profile.HEADSET);
        }
        if (BluetoothUuid.containsAnyUuid((ParcelUuid[])uuids, (ParcelUuid[])A2DP_PROFILE_UUIDS)) {
            profiles.add(Profile.A2DP);
        }
        if (BluetoothUuid.containsAnyUuid((ParcelUuid[])uuids, (ParcelUuid[])OPP_PROFILE_UUIDS)) {
            profiles.add(Profile.OPP);
        }
    }

    protected LocalBluetoothProfileManager(LocalBluetoothManager localManager) {
        this.mLocalManager = localManager;
    }

    public abstract Set<BluetoothDevice> getConnectedDevices();

    public abstract boolean connect(BluetoothDevice var1);

    public abstract boolean disconnect(BluetoothDevice var1);

    public abstract int getConnectionStatus(BluetoothDevice var1);

    public abstract int getSummary(BluetoothDevice var1);

    public abstract int convertState(int var1);

    public abstract boolean isPreferred(BluetoothDevice var1);

    public abstract int getPreferred(BluetoothDevice var1);

    public abstract void setPreferred(BluetoothDevice var1, boolean var2);

    public boolean isConnected(BluetoothDevice device) {
        return SettingsBtStatus.isConnectionStatusConnected(this.getConnectionStatus(device));
    }

    public abstract boolean isProfileReady();

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class OppProfileManager
    extends LocalBluetoothProfileManager {
        public OppProfileManager(LocalBluetoothManager localManager) {
            super(localManager);
        }

        @Override
        public Set<BluetoothDevice> getConnectedDevices() {
            return null;
        }

        @Override
        public boolean connect(BluetoothDevice device) {
            return false;
        }

        @Override
        public boolean disconnect(BluetoothDevice device) {
            return false;
        }

        @Override
        public int getConnectionStatus(BluetoothDevice device) {
            return -1;
        }

        @Override
        public int getSummary(BluetoothDevice device) {
            int connectionStatus = this.getConnectionStatus(device);
            if (SettingsBtStatus.isConnectionStatusConnected(connectionStatus)) {
                return 2131231038;
            }
            return 2131231039;
        }

        @Override
        public boolean isPreferred(BluetoothDevice device) {
            return false;
        }

        @Override
        public int getPreferred(BluetoothDevice device) {
            return -1;
        }

        @Override
        public void setPreferred(BluetoothDevice device, boolean preferred) {
        }

        @Override
        public boolean isProfileReady() {
            return true;
        }

        @Override
        public int convertState(int oppState) {
            switch (oppState) {
                case 0: {
                    return 2;
                }
                case 1: {
                    return 3;
                }
                case 2: {
                    return 4;
                }
            }
            return 0;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class HeadsetProfileManager
    extends LocalBluetoothProfileManager
    implements BluetoothHeadset.ServiceListener {
        private BluetoothHeadset mService;
        private Handler mUiHandler = new Handler();
        private boolean profileReady = false;
        private BluetoothDevice mDelayedConnectDevice = null;
        private BluetoothDevice mDelayedDisconnectDevice = null;

        public HeadsetProfileManager(LocalBluetoothManager localManager) {
            super(localManager);
            this.mService = new BluetoothHeadset(localManager.getContext(), (BluetoothHeadset.ServiceListener)this);
        }

        public void onServiceConnected() {
            this.profileReady = true;
            this.mUiHandler.postDelayed(new Runnable(){

                public void run() {
                    BluetoothDevice device = HeadsetProfileManager.this.mService.getCurrentHeadset();
                    if (HeadsetProfileManager.this.mDelayedConnectDevice != null) {
                        Log.i((String)LocalBluetoothProfileManager.TAG, (String)"service ready: connecting...");
                        BluetoothDevice newDevice = HeadsetProfileManager.this.mDelayedConnectDevice;
                        HeadsetProfileManager.this.mDelayedConnectDevice = null;
                        if (!newDevice.equals((Object)device)) {
                            if (device != null) {
                                Log.i((String)LocalBluetoothProfileManager.TAG, (String)"disconnecting old headset");
                                HeadsetProfileManager.this.mService.disconnectHeadset(device);
                            }
                            Log.i((String)LocalBluetoothProfileManager.TAG, (String)"connecting to pending headset");
                            HeadsetProfileManager.this.mService.connectHeadset(newDevice);
                        }
                    } else if (HeadsetProfileManager.this.mDelayedDisconnectDevice != null) {
                        Log.i((String)LocalBluetoothProfileManager.TAG, (String)"service ready: disconnecting...");
                        if (HeadsetProfileManager.this.mDelayedDisconnectDevice.equals((Object)device)) {
                            Log.i((String)LocalBluetoothProfileManager.TAG, (String)"disconnecting headset");
                            HeadsetProfileManager.this.mService.disconnectHeadset(device);
                        }
                        HeadsetProfileManager.this.mDelayedDisconnectDevice = null;
                    } else {
                        if (device == null) {
                            return;
                        }
                        HeadsetProfileManager.this.mLocalManager.getCachedDeviceManager().onProfileStateChanged(device, Profile.HEADSET, 2);
                    }
                }
            }, 2000L);
            if (mServiceListeners.size() > 0) {
                Iterator it = mServiceListeners.iterator();
                while (it.hasNext()) {
                    ((ServiceListener)it.next()).onServiceConnected();
                }
            }
        }

        public void onServiceDisconnected() {
            this.profileReady = false;
            if (mServiceListeners.size() > 0) {
                Iterator it = mServiceListeners.iterator();
                while (it.hasNext()) {
                    ((ServiceListener)it.next()).onServiceDisconnected();
                }
            }
        }

        @Override
        public boolean isProfileReady() {
            return this.profileReady;
        }

        @Override
        public Set<BluetoothDevice> getConnectedDevices() {
            HashSet<BluetoothDevice> devices = null;
            BluetoothDevice device = this.mService.getCurrentHeadset();
            if (device != null) {
                devices = new HashSet<BluetoothDevice>();
                devices.add(device);
            }
            return devices;
        }

        @Override
        public boolean connect(BluetoothDevice device) {
            if (!HeadsetProfileManager.isManagerReady()) {
                Log.w((String)LocalBluetoothProfileManager.TAG, (String)"HeadsetProfileManager delaying connect, manager not ready");
                this.mDelayedConnectDevice = device;
                this.mDelayedDisconnectDevice = null;
                return true;
            }
            BluetoothDevice currDevice = this.mService.getCurrentHeadset();
            if (currDevice != null) {
                this.mService.disconnectHeadset(currDevice);
            }
            return this.mService.connectHeadset(device);
        }

        @Override
        public boolean disconnect(BluetoothDevice device) {
            if (!HeadsetProfileManager.isManagerReady()) {
                Log.w((String)LocalBluetoothProfileManager.TAG, (String)"HeadsetProfileManager delaying disconnect, manager not ready");
                this.mDelayedConnectDevice = null;
                this.mDelayedDisconnectDevice = device;
                return true;
            }
            BluetoothDevice currDevice = this.mService.getCurrentHeadset();
            if (currDevice != null && currDevice.equals((Object)device)) {
                if (this.mService.getPriority(device) > 100) {
                    this.mService.setPriority(device, 100);
                }
                return this.mService.disconnectHeadset(device);
            }
            return false;
        }

        @Override
        public int getConnectionStatus(BluetoothDevice device) {
            BluetoothDevice currentDevice = this.mService.getCurrentHeadset();
            return currentDevice != null && currentDevice.equals((Object)device) ? this.convertState(this.mService.getState(device)) : 4;
        }

        @Override
        public int getSummary(BluetoothDevice device) {
            int connectionStatus = this.getConnectionStatus(device);
            if (SettingsBtStatus.isConnectionStatusConnected(connectionStatus)) {
                return 2131231037;
            }
            return SettingsBtStatus.getConnectionStatusSummary(connectionStatus);
        }

        @Override
        public boolean isPreferred(BluetoothDevice device) {
            return this.mService.getPriority(device) > 0;
        }

        @Override
        public int getPreferred(BluetoothDevice device) {
            return this.mService.getPriority(device);
        }

        @Override
        public void setPreferred(BluetoothDevice device, boolean preferred) {
            if (preferred) {
                if (this.mService.getPriority(device) < 100) {
                    this.mService.setPriority(device, 100);
                }
            } else {
                this.mService.setPriority(device, 0);
            }
        }

        @Override
        public int convertState(int headsetState) {
            switch (headsetState) {
                case 2: {
                    return 2;
                }
                case 1: {
                    return 3;
                }
                case 0: {
                    return 4;
                }
            }
            return 0;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class A2dpProfileManager
    extends LocalBluetoothProfileManager {
        private BluetoothA2dp mService;

        public A2dpProfileManager(LocalBluetoothManager localManager) {
            super(localManager);
            this.mService = new BluetoothA2dp(localManager.getContext());
        }

        @Override
        public Set<BluetoothDevice> getConnectedDevices() {
            return this.mService.getNonDisconnectedSinks();
        }

        @Override
        public boolean connect(BluetoothDevice device) {
            Set sinks = this.mService.getNonDisconnectedSinks();
            if (sinks != null) {
                for (BluetoothDevice sink : sinks) {
                    this.mService.disconnectSink(sink);
                }
            }
            return this.mService.connectSink(device);
        }

        @Override
        public boolean disconnect(BluetoothDevice device) {
            if (this.mService.getSinkPriority(device) > 100) {
                this.mService.setSinkPriority(device, 100);
            }
            return this.mService.disconnectSink(device);
        }

        @Override
        public int getConnectionStatus(BluetoothDevice device) {
            return this.convertState(this.mService.getSinkState(device));
        }

        @Override
        public int getSummary(BluetoothDevice device) {
            int connectionStatus = this.getConnectionStatus(device);
            if (SettingsBtStatus.isConnectionStatusConnected(connectionStatus)) {
                return 2131231036;
            }
            return SettingsBtStatus.getConnectionStatusSummary(connectionStatus);
        }

        @Override
        public boolean isPreferred(BluetoothDevice device) {
            return this.mService.getSinkPriority(device) > 0;
        }

        @Override
        public int getPreferred(BluetoothDevice device) {
            return this.mService.getSinkPriority(device);
        }

        @Override
        public void setPreferred(BluetoothDevice device, boolean preferred) {
            if (preferred) {
                if (this.mService.getSinkPriority(device) < 100) {
                    this.mService.setSinkPriority(device, 100);
                }
            } else {
                this.mService.setSinkPriority(device, 0);
            }
        }

        @Override
        public int convertState(int a2dpState) {
            switch (a2dpState) {
                case 2: {
                    return 2;
                }
                case 1: {
                    return 3;
                }
                case 0: {
                    return 4;
                }
                case 3: {
                    return 5;
                }
                case 4: {
                    return 1;
                }
            }
            return 0;
        }

        @Override
        public boolean isProfileReady() {
            return true;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Profile {
        HEADSET(2131231027),
        A2DP(2131231026),
        OPP(2131231028);

        public final int localizedString;

        private Profile(int localizedString) {
            this.localizedString = localizedString;
        }
    }

    public static interface ServiceListener {
        public void onServiceConnected();

        public void onServiceDisconnected();
    }
}

