/*
 * Decompiled with CFR 0.152.
 */
package com.android.settings.bluetooth;

import android.app.Activity;
import android.app.AlertDialog;
import android.bluetooth.BluetoothA2dp;
import android.bluetooth.BluetoothAdapter;
import android.bluetooth.BluetoothDevice;
import android.content.Context;
import android.content.SharedPreferences;
import android.widget.Toast;
import com.android.settings.bluetooth.BluetoothEventRedirector;
import com.android.settings.bluetooth.CachedBluetoothDevice;
import com.android.settings.bluetooth.CachedBluetoothDeviceManager;
import com.android.settings.bluetooth.LocalBluetoothProfileManager;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LocalBluetoothManager {
    private static final String TAG = "LocalBluetoothManager";
    static final boolean V = false;
    static final boolean D = true;
    private static final String SHARED_PREFERENCES_NAME = "bluetooth_settings";
    private static LocalBluetoothManager INSTANCE;
    private boolean mInitialized;
    private Context mContext;
    private Activity mForegroundActivity;
    private AlertDialog mErrorDialog = null;
    private BluetoothAdapter mAdapter;
    private CachedBluetoothDeviceManager mCachedDeviceManager;
    private BluetoothEventRedirector mEventRedirector;
    private BluetoothA2dp mBluetoothA2dp;
    private int mState = Integer.MIN_VALUE;
    private List<Callback> mCallbacks = new ArrayList<Callback>();
    private static final int SCAN_EXPIRATION_MS = 300000;
    private static long GRACE_PERIOD_TO_SHOW_DIALOGS_IN_FOREGROUND;
    public static final String SHARED_PREFERENCES_KEY_DISCOVERING_TIMESTAMP = "last_discovering_time";
    private static final String SHARED_PREFERENCES_KEY_LAST_SELECTED_DEVICE = "last_selected_device";
    private static final String SHARED_PREFERENCES_KEY_LAST_SELECTED_DEVICE_TIME = "last_selected_device_time";
    private static final String SHARED_PREFERENCES_KEY_DOCK_AUTO_CONNECT = "auto_connect_to_dock";
    private long mLastScan;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static LocalBluetoothManager getInstance(Context context) {
        Class<LocalBluetoothManager> clazz = LocalBluetoothManager.class;
        synchronized (LocalBluetoothManager.class) {
            if (INSTANCE == null) {
                INSTANCE = new LocalBluetoothManager();
            }
            if (!INSTANCE.init(context)) {
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return null;
            }
            LocalBluetoothProfileManager.init(INSTANCE);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return INSTANCE;
        }
    }

    private boolean init(Context context) {
        if (this.mInitialized) {
            return true;
        }
        this.mInitialized = true;
        this.mContext = context.getApplicationContext();
        this.mAdapter = BluetoothAdapter.getDefaultAdapter();
        if (this.mAdapter == null) {
            return false;
        }
        this.mCachedDeviceManager = new CachedBluetoothDeviceManager(this);
        this.mEventRedirector = new BluetoothEventRedirector(this);
        this.mEventRedirector.start();
        this.mBluetoothA2dp = new BluetoothA2dp(context);
        return true;
    }

    public BluetoothAdapter getBluetoothAdapter() {
        return this.mAdapter;
    }

    public Context getContext() {
        return this.mContext;
    }

    public Activity getForegroundActivity() {
        return this.mForegroundActivity;
    }

    public void setForegroundActivity(Activity activity) {
        if (this.mErrorDialog != null) {
            this.mErrorDialog.dismiss();
            this.mErrorDialog = null;
        }
        this.mForegroundActivity = activity;
    }

    public SharedPreferences getSharedPreferences() {
        return this.mContext.getSharedPreferences(SHARED_PREFERENCES_NAME, 0);
    }

    public CachedBluetoothDeviceManager getCachedDeviceManager() {
        return this.mCachedDeviceManager;
    }

    List<Callback> getCallbacks() {
        return this.mCallbacks;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerCallback(Callback callback) {
        List<Callback> list = this.mCallbacks;
        synchronized (list) {
            this.mCallbacks.add(callback);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregisterCallback(Callback callback) {
        List<Callback> list = this.mCallbacks;
        synchronized (list) {
            this.mCallbacks.remove(callback);
        }
    }

    public void startScanning(boolean force) {
        if (this.mAdapter.isDiscovering()) {
            this.dispatchScanningStateChanged(true);
        } else {
            if (!force) {
                if (this.mLastScan + 300000L > System.currentTimeMillis()) {
                    return;
                }
                Set sinks = this.mBluetoothA2dp.getConnectedSinks();
                if (sinks != null) {
                    for (BluetoothDevice sink : sinks) {
                        if (this.mBluetoothA2dp.getSinkState(sink) != 4) continue;
                        return;
                    }
                }
            }
            if (this.mAdapter.startDiscovery()) {
                this.mLastScan = System.currentTimeMillis();
            }
        }
    }

    public void stopScanning() {
        if (this.mAdapter.isDiscovering()) {
            this.mAdapter.cancelDiscovery();
        }
    }

    public int getBluetoothState() {
        if (this.mState == Integer.MIN_VALUE) {
            this.syncBluetoothState();
        }
        return this.mState;
    }

    void setBluetoothStateInt(int state) {
        this.mState = state;
        if (state == 12 || state == 10) {
            this.mCachedDeviceManager.onBluetoothStateChanged(state == 12);
        }
    }

    private void syncBluetoothState() {
        int bluetoothState = this.mAdapter != null ? (this.mAdapter.isEnabled() ? 12 : 10) : Integer.MIN_VALUE;
        this.setBluetoothStateInt(bluetoothState);
    }

    public void setBluetoothEnabled(boolean enabled) {
        boolean wasSetStateSuccessful;
        boolean bl = wasSetStateSuccessful = enabled ? this.mAdapter.enable() : this.mAdapter.disable();
        if (wasSetStateSuccessful) {
            this.setBluetoothStateInt(enabled ? 11 : 13);
        } else {
            this.syncBluetoothState();
        }
    }

    void onScanningStateChanged(boolean started) {
        this.mCachedDeviceManager.onScanningStateChanged(started);
        this.dispatchScanningStateChanged(started);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void dispatchScanningStateChanged(boolean started) {
        List<Callback> list = this.mCallbacks;
        synchronized (list) {
            for (Callback callback : this.mCallbacks) {
                callback.onScanningStateChanged(started);
            }
        }
    }

    public void showError(BluetoothDevice device, int titleResId, int messageResId) {
        CachedBluetoothDevice cachedDevice = this.mCachedDeviceManager.findDevice(device);
        String name = null;
        if (cachedDevice == null) {
            if (device != null) {
                name = device.getName();
            }
            if (name == null) {
                name = this.mContext.getString(2131231007);
            }
        } else {
            name = cachedDevice.getName();
        }
        String message = this.mContext.getString(messageResId, new Object[]{name});
        if (this.mForegroundActivity != null) {
            this.mErrorDialog = new AlertDialog.Builder((Context)this.mForegroundActivity).setIcon(17301543).setTitle(titleResId).setMessage((CharSequence)message).setPositiveButton(17039370, null).show();
        } else {
            Toast.makeText((Context)this.mContext, (CharSequence)message, (int)1).show();
        }
    }

    public boolean shouldShowDialogInForeground(String deviceAddress) {
        long lastDeviceSelectedTime;
        String lastSelectedDevice;
        if (this.mForegroundActivity != null) {
            return true;
        }
        long currentTimeMillis = System.currentTimeMillis();
        SharedPreferences sharedPreferences = this.getSharedPreferences();
        long lastDiscoverableEndTime = sharedPreferences.getLong("discoverable_end_timestamp", 0L);
        if (lastDiscoverableEndTime + GRACE_PERIOD_TO_SHOW_DIALOGS_IN_FOREGROUND > currentTimeMillis) {
            return true;
        }
        if (this.mAdapter != null && this.mAdapter.isDiscovering()) {
            return true;
        }
        if (sharedPreferences.getLong(SHARED_PREFERENCES_KEY_DISCOVERING_TIMESTAMP, 0L) + GRACE_PERIOD_TO_SHOW_DIALOGS_IN_FOREGROUND > currentTimeMillis) {
            return true;
        }
        return deviceAddress != null && deviceAddress.equals(lastSelectedDevice = sharedPreferences.getString(SHARED_PREFERENCES_KEY_LAST_SELECTED_DEVICE, null)) && (lastDeviceSelectedTime = sharedPreferences.getLong(SHARED_PREFERENCES_KEY_LAST_SELECTED_DEVICE_TIME, 0L)) + GRACE_PERIOD_TO_SHOW_DIALOGS_IN_FOREGROUND > currentTimeMillis;
    }

    void persistSelectedDeviceInPicker(String deviceAddress) {
        SharedPreferences.Editor editor = this.getSharedPreferences().edit();
        editor.putString(SHARED_PREFERENCES_KEY_LAST_SELECTED_DEVICE, deviceAddress);
        editor.putLong(SHARED_PREFERENCES_KEY_LAST_SELECTED_DEVICE_TIME, System.currentTimeMillis());
        editor.apply();
    }

    public boolean hasDockAutoConnectSetting(String addr) {
        return this.getSharedPreferences().contains(SHARED_PREFERENCES_KEY_DOCK_AUTO_CONNECT + addr);
    }

    public boolean getDockAutoConnectSetting(String addr) {
        return this.getSharedPreferences().getBoolean(SHARED_PREFERENCES_KEY_DOCK_AUTO_CONNECT + addr, false);
    }

    public void saveDockAutoConnectSetting(String addr, boolean autoConnect) {
        SharedPreferences.Editor editor = this.getSharedPreferences().edit();
        editor.putBoolean(SHARED_PREFERENCES_KEY_DOCK_AUTO_CONNECT + addr, autoConnect);
        editor.apply();
    }

    public void removeDockAutoConnectSetting(String addr) {
        SharedPreferences.Editor editor = this.getSharedPreferences().edit();
        editor.remove(SHARED_PREFERENCES_KEY_DOCK_AUTO_CONNECT + addr);
        editor.apply();
    }

    static {
        GRACE_PERIOD_TO_SHOW_DIALOGS_IN_FOREGROUND = 60000L;
    }

    public static interface Callback {
        public void onScanningStateChanged(boolean var1);

        public void onDeviceAdded(CachedBluetoothDevice var1);

        public void onDeviceDeleted(CachedBluetoothDevice var1);
    }
}

