/*
 * Decompiled with CFR 0.152.
 */
package com.android.settings.bluetooth;

import android.app.AlertDialog;
import android.app.Notification;
import android.app.Service;
import android.bluetooth.BluetoothDevice;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.SharedPreferences;
import android.os.Handler;
import android.os.HandlerThread;
import android.os.IBinder;
import android.os.Looper;
import android.os.Message;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.View;
import android.widget.CheckBox;
import android.widget.CompoundButton;
import com.android.settings.bluetooth.CachedBluetoothDevice;
import com.android.settings.bluetooth.CachedBluetoothDeviceManager;
import com.android.settings.bluetooth.DockEventReceiver;
import com.android.settings.bluetooth.LocalBluetoothManager;
import com.android.settings.bluetooth.LocalBluetoothProfileManager;
import com.android.settings.bluetooth.SettingsBtStatus;
import java.util.List;
import java.util.Set;

public class DockService
extends Service
implements DialogInterface.OnMultiChoiceClickListener,
DialogInterface.OnClickListener,
DialogInterface.OnDismissListener,
CompoundButton.OnCheckedChangeListener,
LocalBluetoothProfileManager.ServiceListener {
    private static final String TAG = "DockService";
    static final boolean DEBUG = false;
    private static final long UNDOCKED_GRACE_PERIOD = 1000L;
    private static final long DISABLE_BT_GRACE_PERIOD = 2000L;
    private static final int MSG_TYPE_SHOW_UI = 111;
    private static final int MSG_TYPE_DOCKED = 222;
    private static final int MSG_TYPE_UNDOCKED_TEMPORARY = 333;
    private static final int MSG_TYPE_UNDOCKED_PERMANENT = 444;
    private static final int MSG_TYPE_DISABLE_BT = 555;
    private static final String SHARED_PREFERENCES_NAME = "dock_settings";
    private static final String SHARED_PREFERENCES_KEY_DISABLE_BT_WHEN_UNDOCKED = "disable_bt_when_undock";
    private static final String SHARED_PREFERENCES_KEY_DISABLE_BT = "disable_bt";
    private static final String SHARED_PREFERENCES_KEY_CONNECT_RETRY_COUNT = "connect_retry_count";
    private static final int MAX_CONNECT_RETRY = 6;
    private static final int INVALID_STARTID = -100;
    private volatile Looper mServiceLooper;
    private volatile ServiceHandler mServiceHandler;
    private Runnable mRunnable;
    private DockService mContext;
    private LocalBluetoothManager mBtManager;
    private BluetoothDevice mDevice;
    private AlertDialog mDialog;
    private LocalBluetoothProfileManager.Profile[] mProfiles;
    private boolean[] mCheckedItems;
    private int mStartIdAssociatedWithDialog;
    private BluetoothDevice mPendingDevice;
    private int mPendingStartId;
    private int mPendingTurnOnStartId = -100;
    private int mPendingTurnOffStartId = -100;

    public void onCreate() {
        this.mBtManager = LocalBluetoothManager.getInstance((Context)this);
        this.mContext = this;
        HandlerThread thread = new HandlerThread(TAG);
        thread.start();
        this.mServiceLooper = thread.getLooper();
        this.mServiceHandler = new ServiceHandler(this.mServiceLooper);
    }

    public void onDestroy() {
        this.mRunnable = null;
        LocalBluetoothProfileManager.removeServiceListener(this);
        if (this.mDialog != null) {
            this.mDialog.dismiss();
            this.mDialog = null;
        }
        this.mServiceLooper.quit();
    }

    public IBinder onBind(Intent intent) {
        return null;
    }

    public int onStartCommand(Intent intent, int flags, int startId) {
        if (intent == null) {
            DockEventReceiver.finishStartingService(this, startId);
            return 2;
        }
        if ("android.bluetooth.adapter.action.STATE_CHANGED".equals(intent.getAction())) {
            this.handleBtStateChange(intent, startId);
            return 2;
        }
        if ("android.bluetooth.headset.action.STATE_CHANGED".equals(intent.getAction())) {
            BluetoothDevice disconnectedDevice = (BluetoothDevice)intent.getParcelableExtra("android.bluetooth.device.extra.DEVICE");
            int retryCount = this.getSettingInt(SHARED_PREFERENCES_KEY_CONNECT_RETRY_COUNT, 0);
            if (retryCount < 6) {
                this.setSettingInt(SHARED_PREFERENCES_KEY_CONNECT_RETRY_COUNT, retryCount + 1);
                this.handleUnexpectedDisconnect(disconnectedDevice, LocalBluetoothProfileManager.Profile.HEADSET, startId);
            }
            return 2;
        }
        if ("android.bluetooth.a2dp.action.SINK_STATE_CHANGED".equals(intent.getAction())) {
            BluetoothDevice disconnectedDevice = (BluetoothDevice)intent.getParcelableExtra("android.bluetooth.device.extra.DEVICE");
            int retryCount = this.getSettingInt(SHARED_PREFERENCES_KEY_CONNECT_RETRY_COUNT, 0);
            if (retryCount < 6) {
                this.setSettingInt(SHARED_PREFERENCES_KEY_CONNECT_RETRY_COUNT, retryCount + 1);
                this.handleUnexpectedDisconnect(disconnectedDevice, LocalBluetoothProfileManager.Profile.A2DP, startId);
            }
            return 2;
        }
        Message msg = this.parseIntent(intent);
        if (msg == null) {
            DockEventReceiver.finishStartingService(this, startId);
            return 2;
        }
        if (msg.what == 222) {
            this.removeSetting(SHARED_PREFERENCES_KEY_CONNECT_RETRY_COUNT);
        }
        msg.arg2 = startId;
        this.processMessage(msg);
        return 2;
    }

    private synchronized void processMessage(Message msg) {
        int msgType = msg.what;
        final int state = msg.arg1;
        final int startId = msg.arg2;
        boolean deferFinishCall = false;
        BluetoothDevice device = null;
        if (msg.obj != null) {
            device = (BluetoothDevice)msg.obj;
        }
        switch (msgType) {
            case 111: {
                if (this.mDialog != null) {
                    this.mDialog.dismiss();
                    this.mDialog = null;
                }
                this.mDevice = device;
                this.createDialog(this.mContext, this.mDevice, state, startId);
                break;
            }
            case 222: {
                this.mServiceHandler.removeMessages(444);
                this.mServiceHandler.removeMessages(555);
                this.removeSetting(SHARED_PREFERENCES_KEY_DISABLE_BT);
                if (device.equals((Object)this.mDevice)) break;
                if (this.mDevice != null) {
                    this.handleUndocked((Context)this.mContext, this.mBtManager, this.mDevice);
                }
                this.mDevice = device;
                LocalBluetoothProfileManager.addServiceListener(this);
                if (LocalBluetoothProfileManager.isManagerReady()) {
                    this.handleDocked(device, state, startId);
                    LocalBluetoothProfileManager.removeServiceListener(this);
                    break;
                }
                final BluetoothDevice d = device;
                this.mRunnable = new Runnable(){

                    public void run() {
                        DockService.this.handleDocked(d, state, startId);
                    }
                };
                deferFinishCall = true;
                break;
            }
            case 444: {
                this.handleUndocked((Context)this.mContext, this.mBtManager, device);
                if (!this.getSettingBool(SHARED_PREFERENCES_KEY_DISABLE_BT_WHEN_UNDOCKED)) break;
                if (!this.hasOtherConnectedDevices(device)) {
                    Message newMsg = this.mServiceHandler.obtainMessage(555, 0, startId, null);
                    this.mServiceHandler.sendMessageDelayed(newMsg, 2000L);
                    deferFinishCall = true;
                    break;
                }
                this.removeSetting(SHARED_PREFERENCES_KEY_DISABLE_BT_WHEN_UNDOCKED);
                break;
            }
            case 333: {
                Message newMsg = this.mServiceHandler.obtainMessage(444, state, startId, device);
                this.mServiceHandler.sendMessageDelayed(newMsg, 1000L);
                break;
            }
            case 555: {
                if (this.mBtManager.getBluetoothAdapter().disable()) {
                    this.removeSetting(SHARED_PREFERENCES_KEY_DISABLE_BT_WHEN_UNDOCKED);
                    break;
                }
                this.setSettingBool(SHARED_PREFERENCES_KEY_DISABLE_BT, true);
                this.mPendingTurnOffStartId = startId;
                deferFinishCall = true;
            }
        }
        if (this.mDialog == null && this.mPendingDevice == null && msgType != 333 && !deferFinishCall) {
            DockEventReceiver.finishStartingService(this, startId);
        }
    }

    public synchronized boolean hasOtherConnectedDevices(BluetoothDevice dock) {
        List<CachedBluetoothDevice> cachedDevices = this.mBtManager.getCachedDeviceManager().getCachedDevicesCopy();
        Set btDevices = this.mBtManager.getBluetoothAdapter().getBondedDevices();
        if (btDevices == null || cachedDevices == null || btDevices.size() == 0) {
            return false;
        }
        for (CachedBluetoothDevice device : cachedDevices) {
            BluetoothDevice btDevice = device.getDevice();
            if (btDevice.equals((Object)dock) || !btDevices.contains(btDevice) || !device.isConnected()) continue;
            return true;
        }
        return false;
    }

    private Message parseIntent(Intent intent) {
        int msgType;
        BluetoothDevice device = (BluetoothDevice)intent.getParcelableExtra("android.bluetooth.device.extra.DEVICE");
        int state = intent.getIntExtra("android.intent.extra.DOCK_STATE", -1234);
        if (device == null) {
            Log.w((String)TAG, (String)"device is null");
            return null;
        }
        switch (state) {
            case 0: {
                msgType = 333;
                break;
            }
            case 1: 
            case 2: {
                if ("com.android.settings.bluetooth.action.DOCK_SHOW_UI".equals(intent.getAction())) {
                    msgType = 111;
                    break;
                }
                msgType = 222;
                break;
            }
            default: {
                return null;
            }
        }
        return this.mServiceHandler.obtainMessage(msgType, state, 0, device);
    }

    private boolean createDialog(DockService service, BluetoothDevice device, int state, int startId) {
        switch (state) {
            case 1: 
            case 2: {
                break;
            }
            default: {
                return false;
            }
        }
        this.startForeground(0, new Notification());
        boolean firstTime = !this.mBtManager.hasDockAutoConnectSetting(device.getAddress());
        CharSequence[] items = this.initBtSettings(service, device, state, firstTime);
        AlertDialog.Builder ab = new AlertDialog.Builder((Context)service);
        ab.setTitle((CharSequence)service.getString(2131231044));
        ab.setMultiChoiceItems(items, this.mCheckedItems, (DialogInterface.OnMultiChoiceClickListener)service);
        LayoutInflater inflater = (LayoutInflater)service.getSystemService("layout_inflater");
        float pixelScaleFactor = service.getResources().getDisplayMetrics().density;
        View view = inflater.inflate(2130903091, null);
        CheckBox rememberCheckbox = (CheckBox)view.findViewById(2131427497);
        boolean checked = firstTime || this.mBtManager.getDockAutoConnectSetting(device.getAddress());
        rememberCheckbox.setChecked(checked);
        rememberCheckbox.setOnCheckedChangeListener((CompoundButton.OnCheckedChangeListener)this);
        int viewSpacingLeft = (int)(14.0f * pixelScaleFactor);
        int viewSpacingRight = (int)(14.0f * pixelScaleFactor);
        ab.setView(view, viewSpacingLeft, 0, viewSpacingRight, 0);
        ab.setPositiveButton((CharSequence)service.getString(17039370), (DialogInterface.OnClickListener)service);
        this.mStartIdAssociatedWithDialog = startId;
        this.mDialog = ab.create();
        this.mDialog.getWindow().setType(2009);
        this.mDialog.setOnDismissListener((DialogInterface.OnDismissListener)service);
        this.mDialog.show();
        return true;
    }

    public void onClick(DialogInterface dialog, int which, boolean isChecked) {
        this.mCheckedItems[which] = isChecked;
    }

    public void onCheckedChanged(CompoundButton buttonView, boolean isChecked) {
        if (this.mDevice != null) {
            this.mBtManager.saveDockAutoConnectSetting(this.mDevice.getAddress(), isChecked);
        }
    }

    public void onDismiss(DialogInterface dialog) {
        if (this.mPendingDevice == null) {
            DockEventReceiver.finishStartingService(this.mContext, this.mStartIdAssociatedWithDialog);
        }
        this.mContext.stopForeground(true);
    }

    public void onClick(DialogInterface dialog, int which) {
        if (which == -1 && this.mDevice != null) {
            if (!this.mBtManager.hasDockAutoConnectSetting(this.mDevice.getAddress())) {
                this.mBtManager.saveDockAutoConnectSetting(this.mDevice.getAddress(), true);
            }
            this.applyBtSettings(this.mDevice, this.mStartIdAssociatedWithDialog);
        }
    }

    private CharSequence[] initBtSettings(DockService service, BluetoothDevice device, int state, boolean firstTime) {
        int numOfProfiles = 0;
        switch (state) {
            case 1: {
                numOfProfiles = 1;
                break;
            }
            case 2: {
                numOfProfiles = 2;
                break;
            }
            default: {
                return null;
            }
        }
        this.mProfiles = new LocalBluetoothProfileManager.Profile[numOfProfiles];
        this.mCheckedItems = new boolean[numOfProfiles];
        CharSequence[] items = new CharSequence[numOfProfiles];
        switch (state) {
            case 2: {
                items[0] = service.getString(2131231045);
                items[1] = service.getString(2131231046);
                this.mProfiles[0] = LocalBluetoothProfileManager.Profile.HEADSET;
                this.mProfiles[1] = LocalBluetoothProfileManager.Profile.A2DP;
                if (firstTime) {
                    this.mCheckedItems[0] = true;
                    this.mCheckedItems[1] = true;
                    break;
                }
                this.mCheckedItems[0] = LocalBluetoothProfileManager.getProfileManager(this.mBtManager, LocalBluetoothProfileManager.Profile.HEADSET).isPreferred(device);
                this.mCheckedItems[1] = LocalBluetoothProfileManager.getProfileManager(this.mBtManager, LocalBluetoothProfileManager.Profile.A2DP).isPreferred(device);
                break;
            }
            case 1: {
                items[0] = service.getString(2131231046);
                this.mProfiles[0] = LocalBluetoothProfileManager.Profile.A2DP;
                this.mCheckedItems[0] = firstTime ? false : LocalBluetoothProfileManager.getProfileManager(this.mBtManager, LocalBluetoothProfileManager.Profile.A2DP).isPreferred(device);
            }
        }
        return items;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleBtStateChange(Intent intent, int startId) {
        int btState = intent.getIntExtra("android.bluetooth.adapter.extra.STATE", Integer.MIN_VALUE);
        DockService dockService = this;
        synchronized (dockService) {
            if (btState == 12) {
                if (this.mPendingDevice != null) {
                    if (this.mPendingDevice.equals((Object)this.mDevice)) {
                        this.applyBtSettings(this.mPendingDevice, this.mPendingStartId);
                    }
                    this.mPendingDevice = null;
                    DockEventReceiver.finishStartingService(this.mContext, this.mPendingStartId);
                } else {
                    Intent i = this.registerReceiver(null, new IntentFilter("android.intent.action.DOCK_EVENT"));
                    if (i != null) {
                        int state = i.getIntExtra("android.intent.extra.DOCK_STATE", 0);
                        if (state != 0) {
                            BluetoothDevice device = (BluetoothDevice)i.getParcelableExtra("android.bluetooth.device.extra.DEVICE");
                            if (device != null) {
                                this.connectIfEnabled(device);
                            }
                        } else if (this.getSettingBool(SHARED_PREFERENCES_KEY_DISABLE_BT) && this.mBtManager.getBluetoothAdapter().disable()) {
                            this.mPendingTurnOffStartId = startId;
                            this.removeSetting(SHARED_PREFERENCES_KEY_DISABLE_BT);
                            return;
                        }
                    }
                }
                if (this.mPendingTurnOnStartId != -100) {
                    DockEventReceiver.finishStartingService(this, this.mPendingTurnOnStartId);
                    this.mPendingTurnOnStartId = -100;
                }
                DockEventReceiver.finishStartingService(this, startId);
            } else if (btState == 13) {
                this.removeSetting(SHARED_PREFERENCES_KEY_DISABLE_BT_WHEN_UNDOCKED);
                DockEventReceiver.finishStartingService(this, startId);
            } else if (btState == 10) {
                if (this.mPendingTurnOffStartId != -100) {
                    DockEventReceiver.finishStartingService(this, this.mPendingTurnOffStartId);
                    this.removeSetting(SHARED_PREFERENCES_KEY_DISABLE_BT);
                    this.mPendingTurnOffStartId = -100;
                }
                if (this.mPendingDevice != null) {
                    this.mBtManager.getBluetoothAdapter().enable();
                    this.mPendingTurnOnStartId = startId;
                } else {
                    DockEventReceiver.finishStartingService(this, startId);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleUnexpectedDisconnect(BluetoothDevice disconnectedDevice, LocalBluetoothProfileManager.Profile profile, int startId) {
        DockService dockService = this;
        synchronized (dockService) {
            BluetoothDevice dockedDevice;
            int state;
            Intent i;
            if (disconnectedDevice != null && (i = this.registerReceiver(null, new IntentFilter("android.intent.action.DOCK_EVENT"))) != null && (state = i.getIntExtra("android.intent.extra.DOCK_STATE", 0)) != 0 && (dockedDevice = (BluetoothDevice)i.getParcelableExtra("android.bluetooth.device.extra.DEVICE")) != null && dockedDevice.equals((Object)disconnectedDevice)) {
                CachedBluetoothDevice cachedDevice = DockService.getCachedBluetoothDevice((Context)this.mContext, this.mBtManager, dockedDevice);
                cachedDevice.connect(profile);
            }
            DockEventReceiver.finishStartingService(this, startId);
        }
    }

    private synchronized void connectIfEnabled(BluetoothDevice device) {
        CachedBluetoothDevice cachedDevice = DockService.getCachedBluetoothDevice((Context)this.mContext, this.mBtManager, device);
        List<LocalBluetoothProfileManager.Profile> profiles = cachedDevice.getConnectableProfiles();
        for (int i = 0; i < profiles.size(); ++i) {
            int auto;
            LocalBluetoothProfileManager profileManager = LocalBluetoothProfileManager.getProfileManager(this.mBtManager, profiles.get(i));
            if (LocalBluetoothProfileManager.Profile.A2DP == profiles.get(i)) {
                auto = 1000;
            } else {
                if (LocalBluetoothProfileManager.Profile.HEADSET != profiles.get(i)) continue;
                auto = 1000;
            }
            if (profileManager.getPreferred(device) != auto) continue;
            cachedDevice.connect();
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void applyBtSettings(BluetoothDevice device, int startId) {
        if (device == null || this.mProfiles == null || this.mCheckedItems == null) {
            return;
        }
        DockService dockService = this;
        synchronized (dockService) {
            for (boolean enable : this.mCheckedItems) {
                if (!enable) continue;
                int btState = this.mBtManager.getBluetoothState();
                this.mBtManager.getBluetoothAdapter().enable();
                switch (btState) {
                    case 10: 
                    case 11: 
                    case 13: {
                        if (this.mPendingDevice != null && this.mPendingDevice.equals((Object)this.mDevice)) {
                            return;
                        }
                        this.mPendingDevice = device;
                        this.mPendingStartId = startId;
                        if (btState != 11) {
                            this.setSettingBool(SHARED_PREFERENCES_KEY_DISABLE_BT_WHEN_UNDOCKED, true);
                        }
                        return;
                    }
                }
            }
        }
        this.mPendingDevice = null;
        boolean callConnect = false;
        CachedBluetoothDevice cachedDevice = DockService.getCachedBluetoothDevice((Context)this.mContext, this.mBtManager, device);
        for (int i = 0; i < this.mProfiles.length; ++i) {
            int status;
            LocalBluetoothProfileManager profileManager = LocalBluetoothProfileManager.getProfileManager(this.mBtManager, this.mProfiles[i]);
            if (this.mCheckedItems[i]) {
                callConnect = true;
            } else if (!this.mCheckedItems[i] && SettingsBtStatus.isConnectionStatusConnected(status = profileManager.getConnectionStatus(cachedDevice.getDevice()))) {
                cachedDevice.disconnect(this.mProfiles[i]);
            }
            profileManager.setPreferred(device, this.mCheckedItems[i]);
        }
        if (callConnect) {
            cachedDevice.connect();
        }
    }

    private synchronized void handleDocked(BluetoothDevice device, int state, int startId) {
        if (this.mBtManager.getDockAutoConnectSetting(device.getAddress())) {
            this.initBtSettings(this.mContext, device, state, false);
            this.applyBtSettings(this.mDevice, startId);
        } else {
            this.createDialog(this.mContext, device, state, startId);
        }
    }

    private synchronized void handleUndocked(Context context, LocalBluetoothManager localManager, BluetoothDevice device) {
        this.mRunnable = null;
        LocalBluetoothProfileManager.removeServiceListener(this);
        if (this.mDialog != null) {
            this.mDialog.dismiss();
            this.mDialog = null;
        }
        this.mDevice = null;
        this.mPendingDevice = null;
        CachedBluetoothDevice cachedBluetoothDevice = DockService.getCachedBluetoothDevice(context, localManager, device);
        cachedBluetoothDevice.disconnect();
    }

    private static CachedBluetoothDevice getCachedBluetoothDevice(Context context, LocalBluetoothManager localManager, BluetoothDevice device) {
        CachedBluetoothDeviceManager cachedDeviceManager = localManager.getCachedDeviceManager();
        CachedBluetoothDevice cachedBluetoothDevice = cachedDeviceManager.findDevice(device);
        if (cachedBluetoothDevice == null) {
            cachedBluetoothDevice = new CachedBluetoothDevice(context, device);
        }
        return cachedBluetoothDevice;
    }

    private boolean getSettingBool(String key) {
        SharedPreferences sharedPref = this.getSharedPreferences(SHARED_PREFERENCES_NAME, 0);
        return sharedPref.getBoolean(key, false);
    }

    private int getSettingInt(String key, int defaultValue) {
        SharedPreferences sharedPref = this.getSharedPreferences(SHARED_PREFERENCES_NAME, 0);
        return sharedPref.getInt(key, defaultValue);
    }

    private void setSettingBool(String key, boolean bool2) {
        SharedPreferences.Editor editor = this.getSharedPreferences(SHARED_PREFERENCES_NAME, 0).edit();
        editor.putBoolean(key, bool2);
        editor.apply();
    }

    private void setSettingInt(String key, int value) {
        SharedPreferences.Editor editor = this.getSharedPreferences(SHARED_PREFERENCES_NAME, 0).edit();
        editor.putInt(key, value);
        editor.apply();
    }

    private void removeSetting(String key) {
        SharedPreferences sharedPref = this.getSharedPreferences(SHARED_PREFERENCES_NAME, 0);
        SharedPreferences.Editor editor = sharedPref.edit();
        editor.remove(key);
        editor.apply();
    }

    public synchronized void onServiceConnected() {
        if (this.mRunnable != null) {
            this.mRunnable.run();
            this.mRunnable = null;
            LocalBluetoothProfileManager.removeServiceListener(this);
        }
    }

    public void onServiceDisconnected() {
    }

    private final class ServiceHandler
    extends Handler {
        public ServiceHandler(Looper looper) {
            super(looper);
        }

        public void handleMessage(Message msg) {
            DockService.this.processMessage(msg);
        }
    }
}

