/*
 * Decompiled with CFR 0.152.
 */
package com.android.settings.bluetooth;

import android.app.Service;
import android.bluetooth.BluetoothDevice;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.os.PowerManager;
import android.util.Log;
import com.android.settings.bluetooth.DockService;

public class DockEventReceiver
extends BroadcastReceiver {
    private static final boolean DEBUG = false;
    private static final String TAG = "DockEventReceiver";
    public static final String ACTION_DOCK_SHOW_UI = "com.android.settings.bluetooth.action.DOCK_SHOW_UI";
    private static final int EXTRA_INVALID = -1234;
    private static final Object mStartingServiceSync = new Object();
    private static final long WAKELOCK_TIMEOUT = 5000L;
    private static PowerManager.WakeLock mStartingService;

    public void onReceive(Context context, Intent intent) {
        int btState;
        if (intent == null) {
            return;
        }
        int state = intent.getIntExtra("android.intent.extra.DOCK_STATE", intent.getIntExtra("android.bluetooth.adapter.extra.STATE", -1234));
        BluetoothDevice device = (BluetoothDevice)intent.getParcelableExtra("android.bluetooth.device.extra.DEVICE");
        if ("android.intent.action.DOCK_EVENT".equals(intent.getAction()) || ACTION_DOCK_SHOW_UI.endsWith(intent.getAction())) {
            if (device == null) {
                return;
            }
            switch (state) {
                case 0: 
                case 1: 
                case 2: {
                    Intent i = new Intent(intent);
                    i.setClass(context, DockService.class);
                    DockEventReceiver.beginStartingService(context, i);
                    break;
                }
            }
        } else if ("android.bluetooth.headset.action.STATE_CHANGED".equals(intent.getAction())) {
            if (device == null) {
                return;
            }
            int newState = intent.getIntExtra("android.bluetooth.headset.extra.STATE", 2);
            if (newState != 0) {
                return;
            }
            int source = intent.getIntExtra("android.bluetooth.headset.extra.DISCONNECT_INITIATOR", 1);
            if (source != 0) {
                return;
            }
            Intent i = new Intent(intent);
            i.setClass(context, DockService.class);
            DockEventReceiver.beginStartingService(context, i);
        } else if ("android.bluetooth.a2dp.action.SINK_STATE_CHANGED".equals(intent.getAction())) {
            if (device == null) {
                return;
            }
            int newState = intent.getIntExtra("android.bluetooth.a2dp.extra.SINK_STATE", 0);
            int oldState = intent.getIntExtra("android.bluetooth.a2dp.extra.PREVIOUS_SINK_STATE", 0);
            if (newState == 0 && oldState != 3) {
                Intent i = new Intent(intent);
                i.setClass(context, DockService.class);
                DockEventReceiver.beginStartingService(context, i);
            }
        } else if ("android.bluetooth.adapter.action.STATE_CHANGED".equals(intent.getAction()) && (btState = intent.getIntExtra("android.bluetooth.adapter.extra.STATE", Integer.MIN_VALUE)) != 11) {
            Intent i = new Intent(intent);
            i.setClass(context, DockService.class);
            DockEventReceiver.beginStartingService(context, i);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void beginStartingService(Context context, Intent intent) {
        Object object = mStartingServiceSync;
        synchronized (object) {
            if (mStartingService == null) {
                PowerManager pm = (PowerManager)context.getSystemService("power");
                mStartingService = pm.newWakeLock(1, "StartingDockService");
            }
            mStartingService.acquire(5000L);
            if (context.startService(intent) == null) {
                Log.e((String)TAG, (String)"Can't start DockService");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void finishStartingService(Service service, int startId) {
        Object object = mStartingServiceSync;
        synchronized (object) {
            if (mStartingService != null) {
                service.stopSelfResult(startId);
            }
        }
    }
}

