/*
 * Decompiled with CFR 0.152.
 */
package com.android.settings.bluetooth;

import android.app.Activity;
import android.bluetooth.BluetoothDevice;
import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.os.Parcelable;
import android.preference.CheckBoxPreference;
import android.preference.Preference;
import android.preference.PreferenceActivity;
import android.preference.PreferenceGroup;
import android.text.TextUtils;
import android.util.Log;
import com.android.settings.bluetooth.CachedBluetoothDevice;
import com.android.settings.bluetooth.LocalBluetoothManager;
import com.android.settings.bluetooth.LocalBluetoothProfileManager;

public class ConnectSpecificProfilesActivity
extends PreferenceActivity
implements CachedBluetoothDevice.Callback,
Preference.OnPreferenceChangeListener {
    private static final String TAG = "ConnectSpecificProfilesActivity";
    private static final String KEY_ONLINE_MODE = "online_mode";
    private static final String KEY_TITLE = "title";
    private static final String KEY_PROFILE_CONTAINER = "profile_container";
    public static final String EXTRA_DEVICE = "device";
    private LocalBluetoothManager mManager;
    private CachedBluetoothDevice mCachedDevice;
    private PreferenceGroup mProfileContainer;
    private CheckBoxPreference mOnlineModePreference;
    private boolean mOnlineMode;

    protected void onCreate(Bundle savedInstanceState) {
        BluetoothDevice device;
        super.onCreate(savedInstanceState);
        if (savedInstanceState != null) {
            device = (BluetoothDevice)savedInstanceState.getParcelable(EXTRA_DEVICE);
        } else {
            Intent intent = this.getIntent();
            device = (BluetoothDevice)intent.getParcelableExtra(EXTRA_DEVICE);
        }
        if (device == null) {
            Log.w((String)TAG, (String)"Activity started without a remote Bluetooth device");
            this.finish();
        }
        this.mManager = LocalBluetoothManager.getInstance((Context)this);
        this.mCachedDevice = this.mManager.getCachedDeviceManager().findDevice(device);
        if (this.mCachedDevice == null) {
            Log.w((String)TAG, (String)"Device not found, cannot connect to it");
            this.finish();
        }
        this.addPreferencesFromResource(2130968581);
        this.mProfileContainer = (PreferenceGroup)this.findPreference(KEY_PROFILE_CONTAINER);
        this.findPreference(KEY_TITLE).setTitle((CharSequence)this.getString(2131231032, new Object[]{this.mCachedDevice.getName()}));
        this.mOnlineModePreference = (CheckBoxPreference)this.findPreference(KEY_ONLINE_MODE);
        this.mOnlineModePreference.setOnPreferenceChangeListener((Preference.OnPreferenceChangeListener)this);
        this.addPreferencesForProfiles();
    }

    protected void onSaveInstanceState(Bundle outState) {
        super.onSaveInstanceState(outState);
        outState.putParcelable(EXTRA_DEVICE, (Parcelable)this.mCachedDevice.getDevice());
    }

    protected void onResume() {
        super.onResume();
        this.mManager.setForegroundActivity((Activity)this);
        this.mCachedDevice.registerCallback(this);
        this.refresh();
    }

    protected void onPause() {
        super.onPause();
        this.mCachedDevice.unregisterCallback(this);
        this.mManager.setForegroundActivity(null);
    }

    private void addPreferencesForProfiles() {
        for (LocalBluetoothProfileManager.Profile profile : this.mCachedDevice.getConnectableProfiles()) {
            CheckBoxPreference pref = this.createProfilePreference(profile);
            this.mProfileContainer.addPreference((Preference)pref);
        }
    }

    private CheckBoxPreference createProfilePreference(LocalBluetoothProfileManager.Profile profile) {
        CheckBoxPreference pref = new CheckBoxPreference((Context)this);
        pref.setKey(profile.toString());
        pref.setTitle(profile.localizedString);
        pref.setPersistent(false);
        pref.setOnPreferenceChangeListener((Preference.OnPreferenceChangeListener)this);
        LocalBluetoothProfileManager profileManager = LocalBluetoothProfileManager.getProfileManager(this.mManager, profile);
        pref.setEnabled(!this.mCachedDevice.isBusy());
        this.refreshProfilePreference(pref, profile);
        return pref;
    }

    public boolean onPreferenceChange(Preference preference, Object newValue) {
        String key = preference.getKey();
        if (TextUtils.isEmpty((CharSequence)key) || newValue == null) {
            return true;
        }
        if (key.equals(KEY_ONLINE_MODE)) {
            this.onOnlineModeCheckedStateChanged((Boolean)newValue);
        } else {
            LocalBluetoothProfileManager.Profile profile = this.getProfileOf(preference);
            if (profile == null) {
                return false;
            }
            this.onProfileCheckedStateChanged(profile, (Boolean)newValue);
        }
        return true;
    }

    private void onOnlineModeCheckedStateChanged(boolean checked) {
        this.setOnlineMode(checked, true);
    }

    private void onProfileCheckedStateChanged(LocalBluetoothProfileManager.Profile profile, boolean checked) {
        LocalBluetoothProfileManager profileManager = LocalBluetoothProfileManager.getProfileManager(this.mManager, profile);
        profileManager.setPreferred(this.mCachedDevice.getDevice(), checked);
        if (this.mOnlineMode) {
            if (checked) {
                this.mCachedDevice.connect(profile);
            } else {
                this.mCachedDevice.disconnect(profile);
            }
        }
    }

    public void onDeviceAttributesChanged(CachedBluetoothDevice cachedDevice) {
        this.refresh();
    }

    private void refresh() {
        this.setOnlineMode(this.mCachedDevice.isConnected() || this.mCachedDevice.isBusy(), false);
        this.refreshProfiles();
    }

    private void setOnlineMode(boolean onlineMode, boolean takeAction) {
        this.mOnlineMode = onlineMode;
        if (takeAction) {
            if (onlineMode) {
                this.mCachedDevice.connect();
            } else {
                this.mCachedDevice.disconnect();
            }
        }
        this.refreshOnlineModePreference();
    }

    private void refreshOnlineModePreference() {
        this.mOnlineModePreference.setChecked(this.mOnlineMode);
        this.mOnlineModePreference.setEnabled(!this.mCachedDevice.isBusy());
        this.mOnlineModePreference.setSummary(this.mOnlineMode ? this.mCachedDevice.getSummary() : 2131231034);
    }

    private void refreshProfiles() {
        for (LocalBluetoothProfileManager.Profile profile : this.mCachedDevice.getConnectableProfiles()) {
            CheckBoxPreference profilePref = (CheckBoxPreference)this.findPreference(profile.toString());
            if (profilePref == null) {
                profilePref = this.createProfilePreference(profile);
                this.mProfileContainer.addPreference((Preference)profilePref);
                continue;
            }
            this.refreshProfilePreference(profilePref, profile);
        }
    }

    private void refreshProfilePreference(CheckBoxPreference profilePref, LocalBluetoothProfileManager.Profile profile) {
        BluetoothDevice device = this.mCachedDevice.getDevice();
        LocalBluetoothProfileManager profileManager = LocalBluetoothProfileManager.getProfileManager(this.mManager, profile);
        int connectionStatus = profileManager.getConnectionStatus(device);
        profilePref.setEnabled(!this.mCachedDevice.isBusy());
        profilePref.setSummary(ConnectSpecificProfilesActivity.getProfileSummary(profileManager, profile, device, connectionStatus, this.mOnlineMode));
        profilePref.setChecked(profileManager.isPreferred(device));
    }

    private LocalBluetoothProfileManager.Profile getProfileOf(Preference pref) {
        if (!(pref instanceof CheckBoxPreference)) {
            return null;
        }
        String key = pref.getKey();
        if (TextUtils.isEmpty((CharSequence)key)) {
            return null;
        }
        try {
            return LocalBluetoothProfileManager.Profile.valueOf(pref.getKey());
        }
        catch (IllegalArgumentException e) {
            return null;
        }
    }

    private static int getProfileSummary(LocalBluetoothProfileManager profileManager, LocalBluetoothProfileManager.Profile profile, BluetoothDevice device, int connectionStatus, boolean onlineMode) {
        if (!onlineMode || connectionStatus == 4) {
            return ConnectSpecificProfilesActivity.getProfileSummaryForSettingPreference(profile);
        }
        return profileManager.getSummary(device);
    }

    private static final int getProfileSummaryForSettingPreference(LocalBluetoothProfileManager.Profile profile) {
        switch (profile) {
            case A2DP: {
                return 2131231040;
            }
            case HEADSET: {
                return 2131231041;
            }
        }
        return 0;
    }
}

