/*
 * Decompiled with CFR 0.152.
 */
package com.android.settings.bluetooth;

import android.bluetooth.BluetoothAdapter;
import android.bluetooth.BluetoothClass;
import android.bluetooth.BluetoothDevice;
import android.util.Log;
import com.android.settings.bluetooth.CachedBluetoothDevice;
import com.android.settings.bluetooth.LocalBluetoothManager;
import com.android.settings.bluetooth.LocalBluetoothProfileManager;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CachedBluetoothDeviceManager {
    private static final String TAG = "CachedBluetoothDeviceManager";
    final LocalBluetoothManager mLocalManager;
    final List<LocalBluetoothManager.Callback> mCallbacks;
    final List<CachedBluetoothDevice> mCachedDevices = new ArrayList<CachedBluetoothDevice>();

    public CachedBluetoothDeviceManager(LocalBluetoothManager localManager) {
        this.mLocalManager = localManager;
        this.mCallbacks = localManager.getCallbacks();
    }

    private synchronized boolean readPairedDevices() {
        BluetoothAdapter adapter = this.mLocalManager.getBluetoothAdapter();
        Set bondedDevices = adapter.getBondedDevices();
        if (bondedDevices == null) {
            return false;
        }
        boolean deviceAdded = false;
        for (BluetoothDevice device : bondedDevices) {
            CachedBluetoothDevice cachedDevice = this.findDevice(device);
            if (cachedDevice != null) continue;
            cachedDevice = new CachedBluetoothDevice(this.mLocalManager.getContext(), device);
            this.mCachedDevices.add(cachedDevice);
            this.dispatchDeviceAdded(cachedDevice);
            deviceAdded = true;
        }
        return deviceAdded;
    }

    public synchronized List<CachedBluetoothDevice> getCachedDevicesCopy() {
        return new ArrayList<CachedBluetoothDevice>(this.mCachedDevices);
    }

    void onBluetoothStateChanged(boolean enabled) {
        if (enabled) {
            this.readPairedDevices();
        }
    }

    public synchronized void onDeviceAppeared(BluetoothDevice device, short rssi, BluetoothClass btClass, String name) {
        boolean deviceAdded = false;
        CachedBluetoothDevice cachedDevice = this.findDevice(device);
        if (cachedDevice == null) {
            cachedDevice = new CachedBluetoothDevice(this.mLocalManager.getContext(), device);
            this.mCachedDevices.add(cachedDevice);
            deviceAdded = true;
        }
        cachedDevice.setRssi(rssi);
        cachedDevice.setBtClass(btClass);
        cachedDevice.setName(name);
        cachedDevice.setVisible(true);
        if (deviceAdded) {
            this.dispatchDeviceAdded(cachedDevice);
        }
    }

    public synchronized void onDeviceDisappeared(BluetoothDevice device) {
        CachedBluetoothDevice cachedDevice = this.findDevice(device);
        if (cachedDevice == null) {
            return;
        }
        cachedDevice.setVisible(false);
        this.checkForDeviceRemoval(cachedDevice);
    }

    private void checkForDeviceRemoval(CachedBluetoothDevice cachedDevice) {
        if (cachedDevice.getBondState() == 10 && !cachedDevice.isVisible()) {
            this.mCachedDevices.remove(cachedDevice);
            this.dispatchDeviceDeleted(cachedDevice);
        }
    }

    public synchronized void onDeviceNameUpdated(BluetoothDevice device) {
        CachedBluetoothDevice cachedDevice = this.findDevice(device);
        if (cachedDevice != null) {
            cachedDevice.refreshName();
        }
    }

    public synchronized CachedBluetoothDevice findDevice(BluetoothDevice device) {
        for (int i = this.mCachedDevices.size() - 1; i >= 0; --i) {
            CachedBluetoothDevice cachedDevice = this.mCachedDevices.get(i);
            if (!cachedDevice.getDevice().equals((Object)device)) continue;
            return cachedDevice;
        }
        return null;
    }

    public String getName(BluetoothDevice device) {
        CachedBluetoothDevice cachedDevice = this.findDevice(device);
        if (cachedDevice != null) {
            return cachedDevice.getName();
        }
        String name = device.getName();
        if (name != null) {
            return name;
        }
        return device.getAddress();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void dispatchDeviceAdded(CachedBluetoothDevice cachedDevice) {
        List<LocalBluetoothManager.Callback> list = this.mCallbacks;
        synchronized (list) {
            for (LocalBluetoothManager.Callback callback : this.mCallbacks) {
                callback.onDeviceAdded(cachedDevice);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void dispatchDeviceDeleted(CachedBluetoothDevice cachedDevice) {
        List<LocalBluetoothManager.Callback> list = this.mCallbacks;
        synchronized (list) {
            for (LocalBluetoothManager.Callback callback : this.mCallbacks) {
                callback.onDeviceDeleted(cachedDevice);
            }
        }
    }

    public synchronized void onBondingStateChanged(BluetoothDevice device, int bondState) {
        CachedBluetoothDevice cachedDevice = this.findDevice(device);
        if (cachedDevice == null) {
            if (!this.readPairedDevices()) {
                Log.e((String)TAG, (String)("Got bonding state changed for " + device + ", but we have no record of that device."));
                return;
            }
            cachedDevice = this.findDevice(device);
            if (cachedDevice == null) {
                Log.e((String)TAG, (String)("Got bonding state changed for " + device + "but device not added in cache"));
                return;
            }
        }
        cachedDevice.onBondingStateChanged(bondState);
    }

    public synchronized void showUnbondMessage(BluetoothDevice device, int reason) {
        switch (reason) {
            case 1: {
                int errorMsg = 2131231010;
                this.mLocalManager.showError(device, 2131231008, errorMsg);
                break;
            }
            case 2: {
                int errorMsg = 2131231012;
                this.mLocalManager.showError(device, 2131231008, errorMsg);
                break;
            }
            case 4: {
                int errorMsg = 2131231011;
                this.mLocalManager.showError(device, 2131231008, errorMsg);
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                int errorMsg = 2131231009;
                this.mLocalManager.showError(device, 2131231008, errorMsg);
                break;
            }
            default: {
                Log.w((String)TAG, (String)("showUnbondMessage: Not displaying any message for reason:" + reason));
            }
        }
    }

    public synchronized void onProfileStateChanged(BluetoothDevice device, LocalBluetoothProfileManager.Profile profile, int newProfileState) {
        CachedBluetoothDevice cachedDevice = this.findDevice(device);
        if (cachedDevice == null) {
            return;
        }
        cachedDevice.onProfileStateChanged(profile, newProfileState);
        cachedDevice.refresh();
    }

    public synchronized void onConnectingError(BluetoothDevice device) {
        CachedBluetoothDevice cachedDevice = this.findDevice(device);
        if (cachedDevice == null) {
            return;
        }
        cachedDevice.showConnectingError();
    }

    public synchronized void onScanningStateChanged(boolean started) {
        if (!started) {
            return;
        }
        for (int i = this.mCachedDevices.size() - 1; i >= 0; --i) {
            CachedBluetoothDevice cachedDevice = this.mCachedDevices.get(i);
            cachedDevice.setVisible(false);
            this.checkForDeviceRemoval(cachedDevice);
        }
    }

    public synchronized void onBtClassChanged(BluetoothDevice device) {
        CachedBluetoothDevice cachedDevice = this.findDevice(device);
        if (cachedDevice != null) {
            cachedDevice.refreshBtClass();
        }
    }

    public synchronized void onUuidChanged(BluetoothDevice device) {
        CachedBluetoothDevice cachedDevice = this.findDevice(device);
        if (cachedDevice != null) {
            cachedDevice.onUuidChanged();
        }
    }
}

