/*
 * Decompiled with CFR 0.152.
 */
package com.android.settings.bluetooth;

import android.app.Activity;
import android.app.AlertDialog;
import android.bluetooth.BluetoothAdapter;
import android.bluetooth.BluetoothClass;
import android.bluetooth.BluetoothDevice;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.content.res.Resources;
import android.os.ParcelUuid;
import android.os.Parcelable;
import android.os.SystemClock;
import android.text.TextUtils;
import android.util.Log;
import android.view.ContextMenu;
import android.view.MenuItem;
import com.android.settings.bluetooth.CachedBluetoothDeviceManager;
import com.android.settings.bluetooth.ConnectSpecificProfilesActivity;
import com.android.settings.bluetooth.LocalBluetoothManager;
import com.android.settings.bluetooth.LocalBluetoothProfileManager;
import com.android.settings.bluetooth.SettingsBtStatus;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CachedBluetoothDevice
implements Comparable<CachedBluetoothDevice> {
    private static final String TAG = "CachedBluetoothDevice";
    private static final boolean D = true;
    private static final boolean V = false;
    private static final boolean DEBUG = false;
    private static final int CONTEXT_ITEM_CONNECT = 2;
    private static final int CONTEXT_ITEM_DISCONNECT = 3;
    private static final int CONTEXT_ITEM_UNPAIR = 4;
    private static final int CONTEXT_ITEM_CONNECT_ADVANCED = 5;
    private final BluetoothDevice mDevice;
    private String mName;
    private short mRssi;
    private BluetoothClass mBtClass;
    private List<LocalBluetoothProfileManager.Profile> mProfiles = new ArrayList<LocalBluetoothProfileManager.Profile>();
    private boolean mVisible;
    private final LocalBluetoothManager mLocalManager;
    private List<Callback> mCallbacks = new ArrayList<Callback>();
    private boolean mIsConnectingErrorPossible;
    private long mConnectAttempted;
    private static final long MAX_UUID_DELAY_FOR_AUTO_CONNECT = 5000L;
    private boolean mConnectAfterPairing;

    private String describe(CachedBluetoothDevice cachedDevice, LocalBluetoothProfileManager.Profile profile) {
        StringBuilder sb = new StringBuilder();
        sb.append("Address:").append(cachedDevice.mDevice);
        if (profile != null) {
            sb.append(" Profile:").append(profile.name());
        }
        return sb.toString();
    }

    private String describe(LocalBluetoothProfileManager.Profile profile) {
        return this.describe(this, profile);
    }

    public void onProfileStateChanged(LocalBluetoothProfileManager.Profile profile, int newProfileState) {
        Log.d((String)TAG, (String)("onProfileStateChanged: profile " + profile.toString() + " newProfileState " + newProfileState));
        int newState = LocalBluetoothProfileManager.getProfileManager(this.mLocalManager, profile).convertState(newProfileState);
        if (newState == 2 && !this.mProfiles.contains((Object)profile)) {
            this.mProfiles.add(profile);
        }
    }

    CachedBluetoothDevice(Context context, BluetoothDevice device) {
        this.mLocalManager = LocalBluetoothManager.getInstance(context);
        if (this.mLocalManager == null) {
            throw new IllegalStateException("Cannot use CachedBluetoothDevice without Bluetooth hardware");
        }
        this.mDevice = device;
        this.fillData();
    }

    public void onClicked() {
        int bondState = this.getBondState();
        if (this.isConnected()) {
            this.askDisconnect();
        } else if (bondState == 12) {
            this.connect();
        } else if (bondState == 10) {
            this.pair();
        }
    }

    public void disconnect() {
        for (LocalBluetoothProfileManager.Profile profile : this.mProfiles) {
            this.disconnect(profile);
        }
    }

    public void disconnect(LocalBluetoothProfileManager.Profile profile) {
        this.disconnectInt(this, profile);
    }

    private boolean disconnectInt(CachedBluetoothDevice cachedDevice, LocalBluetoothProfileManager.Profile profile) {
        LocalBluetoothProfileManager profileManager = LocalBluetoothProfileManager.getProfileManager(this.mLocalManager, profile);
        int status = profileManager.getConnectionStatus(cachedDevice.mDevice);
        if (profileManager.disconnect(cachedDevice.mDevice)) {
            Log.d((String)TAG, (String)("Command sent successfully:DISCONNECT " + this.describe(profile)));
            return true;
        }
        return false;
    }

    public void askDisconnect() {
        Activity context = this.mLocalManager.getForegroundActivity();
        if (context == null) {
            this.disconnect();
            return;
        }
        Resources res = context.getResources();
        String name = this.getName();
        if (TextUtils.isEmpty((CharSequence)name)) {
            name = res.getString(2131230813);
        }
        String message = res.getString(2131230804, new Object[]{name});
        DialogInterface.OnClickListener disconnectListener = new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialog, int which) {
                CachedBluetoothDevice.this.disconnect();
            }
        };
        new AlertDialog.Builder((Context)context).setTitle((CharSequence)this.getName()).setMessage((CharSequence)message).setPositiveButton(17039370, disconnectListener).setNegativeButton(0x1040000, null).show();
    }

    public void connect() {
        if (!this.ensurePaired()) {
            return;
        }
        this.mConnectAttempted = SystemClock.elapsedRealtime();
        this.connectWithoutResettingTimer();
    }

    void onBondingDockConnect() {
        this.connect();
    }

    private void connectWithoutResettingTimer() {
        if (this.mProfiles.size() == 0 && !this.updateProfiles()) {
            return;
        }
        this.mIsConnectingErrorPossible = true;
        int preferredProfiles = 0;
        for (LocalBluetoothProfileManager.Profile profile : this.mProfiles) {
            LocalBluetoothProfileManager profileManager;
            if (!this.isConnectableProfile(profile) || !(profileManager = LocalBluetoothProfileManager.getProfileManager(this.mLocalManager, profile)).isPreferred(this.mDevice)) continue;
            ++preferredProfiles;
            this.disconnectConnected(this, profile);
            this.connectInt(this, profile);
        }
        if (preferredProfiles == 0) {
            this.connectAllProfiles();
        }
    }

    private void connectAllProfiles() {
        if (!this.ensurePaired()) {
            return;
        }
        this.mIsConnectingErrorPossible = true;
        for (LocalBluetoothProfileManager.Profile profile : this.mProfiles) {
            if (!this.isConnectableProfile(profile)) continue;
            LocalBluetoothProfileManager profileManager = LocalBluetoothProfileManager.getProfileManager(this.mLocalManager, profile);
            profileManager.setPreferred(this.mDevice, false);
            this.disconnectConnected(this, profile);
            this.connectInt(this, profile);
        }
    }

    public void connect(LocalBluetoothProfileManager.Profile profile) {
        this.mConnectAttempted = SystemClock.elapsedRealtime();
        this.mIsConnectingErrorPossible = true;
        this.disconnectConnected(this, profile);
        this.connectInt(this, profile);
    }

    private void disconnectConnected(CachedBluetoothDevice device, LocalBluetoothProfileManager.Profile profile) {
        LocalBluetoothProfileManager profileManager = LocalBluetoothProfileManager.getProfileManager(this.mLocalManager, profile);
        CachedBluetoothDeviceManager cachedDeviceManager = this.mLocalManager.getCachedDeviceManager();
        Set<BluetoothDevice> devices = profileManager.getConnectedDevices();
        if (devices == null) {
            return;
        }
        for (BluetoothDevice btDevice : devices) {
            CachedBluetoothDevice cachedDevice = cachedDeviceManager.findDevice(btDevice);
            if (cachedDevice == null || cachedDevice.equals(device)) continue;
            this.disconnectInt(cachedDevice, profile);
        }
    }

    private boolean connectInt(CachedBluetoothDevice cachedDevice, LocalBluetoothProfileManager.Profile profile) {
        if (!cachedDevice.ensurePaired()) {
            return false;
        }
        LocalBluetoothProfileManager profileManager = LocalBluetoothProfileManager.getProfileManager(this.mLocalManager, profile);
        int status = profileManager.getConnectionStatus(cachedDevice.mDevice);
        if (profileManager.connect(cachedDevice.mDevice)) {
            Log.d((String)TAG, (String)("Command sent successfully:CONNECT " + this.describe(profile)));
            return true;
        }
        Log.i((String)TAG, (String)("Failed to connect " + profile.toString() + " to " + cachedDevice.mName));
        return false;
    }

    public void showConnectingError() {
        if (!this.mIsConnectingErrorPossible) {
            return;
        }
        this.mIsConnectingErrorPossible = false;
        this.mLocalManager.showError(this.mDevice, 2131231008, 2131231013);
    }

    private boolean ensurePaired() {
        if (this.getBondState() == 10) {
            this.pair();
            return false;
        }
        return true;
    }

    public void pair() {
        BluetoothAdapter adapter = this.mLocalManager.getBluetoothAdapter();
        if (adapter.isDiscovering()) {
            adapter.cancelDiscovery();
        }
        if (!this.mDevice.createBond()) {
            this.mLocalManager.showError(this.mDevice, 2131231008, 2131231009);
            return;
        }
        this.mConnectAfterPairing = true;
    }

    public void unpair() {
        boolean successful;
        BluetoothDevice dev;
        this.disconnect();
        int state = this.getBondState();
        if (state == 11) {
            this.mDevice.cancelBondProcess();
        }
        if (state != 10 && (dev = this.getDevice()) != null && (successful = dev.removeBond())) {
            Log.d((String)TAG, (String)("Command sent successfully:REMOVE_BOND " + this.describe(null)));
        }
    }

    private void fillData() {
        this.fetchName();
        this.fetchBtClass();
        this.updateProfiles();
        this.mVisible = false;
        this.dispatchAttributesChanged();
    }

    public BluetoothDevice getDevice() {
        return this.mDevice;
    }

    public String getName() {
        return this.mName;
    }

    public void setName(String name) {
        if (!this.mName.equals(name)) {
            this.mName = TextUtils.isEmpty((CharSequence)name) ? this.mDevice.getAddress() : name;
            this.dispatchAttributesChanged();
        }
    }

    public void refreshName() {
        this.fetchName();
        this.dispatchAttributesChanged();
    }

    private void fetchName() {
        this.mName = this.mDevice.getName();
        if (TextUtils.isEmpty((CharSequence)this.mName)) {
            this.mName = this.mDevice.getAddress();
        }
    }

    public void refresh() {
        this.dispatchAttributesChanged();
    }

    public boolean isVisible() {
        return this.mVisible;
    }

    void setVisible(boolean visible) {
        if (this.mVisible != visible) {
            this.mVisible = visible;
            this.dispatchAttributesChanged();
        }
    }

    public int getBondState() {
        return this.mDevice.getBondState();
    }

    void setRssi(short rssi) {
        if (this.mRssi != rssi) {
            this.mRssi = rssi;
            this.dispatchAttributesChanged();
        }
    }

    public boolean isConnected() {
        for (LocalBluetoothProfileManager.Profile profile : this.mProfiles) {
            int status = LocalBluetoothProfileManager.getProfileManager(this.mLocalManager, profile).getConnectionStatus(this.mDevice);
            if (!SettingsBtStatus.isConnectionStatusConnected(status)) continue;
            return true;
        }
        return false;
    }

    public boolean isBusy() {
        for (LocalBluetoothProfileManager.Profile profile : this.mProfiles) {
            int status = LocalBluetoothProfileManager.getProfileManager(this.mLocalManager, profile).getConnectionStatus(this.mDevice);
            if (!SettingsBtStatus.isConnectionStatusBusy(status)) continue;
            return true;
        }
        return this.getBondState() == 11;
    }

    public int getBtClassDrawable() {
        if (this.mBtClass != null) {
            switch (this.mBtClass.getMajorDeviceClass()) {
                case 256: {
                    return 2130837542;
                }
                case 512: {
                    return 2130837539;
                }
            }
        } else {
            Log.w((String)TAG, (String)"mBtClass is null");
        }
        if (this.mProfiles.size() > 0) {
            if (this.mProfiles.contains((Object)LocalBluetoothProfileManager.Profile.A2DP)) {
                return 2130837540;
            }
            if (this.mProfiles.contains((Object)LocalBluetoothProfileManager.Profile.HEADSET)) {
                return 2130837541;
            }
        } else if (this.mBtClass != null) {
            if (this.mBtClass.doesClassMatch(1)) {
                return 2130837540;
            }
            if (this.mBtClass.doesClassMatch(0)) {
                return 2130837541;
            }
        }
        return 0;
    }

    private void fetchBtClass() {
        this.mBtClass = this.mDevice.getBluetoothClass();
    }

    private boolean updateProfiles() {
        ParcelUuid[] uuids = this.mDevice.getUuids();
        if (uuids == null) {
            return false;
        }
        LocalBluetoothProfileManager.updateProfiles(uuids, this.mProfiles);
        return true;
    }

    public void refreshBtClass() {
        this.fetchBtClass();
        this.dispatchAttributesChanged();
    }

    public void onUuidChanged() {
        this.updateProfiles();
        if (this.mProfiles.size() > 0 && this.mConnectAttempted + 5000L > SystemClock.elapsedRealtime()) {
            this.connectWithoutResettingTimer();
        }
        this.dispatchAttributesChanged();
    }

    public void onBondingStateChanged(int bondState) {
        if (bondState == 10) {
            this.mProfiles.clear();
            this.mConnectAfterPairing = false;
        }
        this.refresh();
        if (bondState == 12) {
            if (this.mDevice.isBluetoothDock()) {
                this.onBondingDockConnect();
            } else if (this.mConnectAfterPairing) {
                this.connect();
            }
            this.mConnectAfterPairing = false;
        }
    }

    public void setBtClass(BluetoothClass btClass) {
        if (btClass != null && this.mBtClass != btClass) {
            this.mBtClass = btClass;
            this.dispatchAttributesChanged();
        }
    }

    public int getSummary() {
        int oneOffSummary = this.getOneOffSummary();
        if (oneOffSummary != 0) {
            return oneOffSummary;
        }
        for (LocalBluetoothProfileManager.Profile profile : this.mProfiles) {
            LocalBluetoothProfileManager profileManager = LocalBluetoothProfileManager.getProfileManager(this.mLocalManager, profile);
            int connectionStatus = profileManager.getConnectionStatus(this.mDevice);
            if (!SettingsBtStatus.isConnectionStatusConnected(connectionStatus) && connectionStatus != 3 && connectionStatus != 5) continue;
            return SettingsBtStatus.getConnectionStatusSummary(connectionStatus);
        }
        return SettingsBtStatus.getPairingStatusSummary(this.getBondState());
    }

    private int getOneOffSummary() {
        LocalBluetoothProfileManager profileManager;
        boolean isA2dpConnected = false;
        boolean isHeadsetConnected = false;
        boolean isConnecting = false;
        if (this.mProfiles.contains((Object)LocalBluetoothProfileManager.Profile.A2DP)) {
            profileManager = LocalBluetoothProfileManager.getProfileManager(this.mLocalManager, LocalBluetoothProfileManager.Profile.A2DP);
            isConnecting = profileManager.getConnectionStatus(this.mDevice) == 3;
            isA2dpConnected = profileManager.isConnected(this.mDevice);
        }
        if (this.mProfiles.contains((Object)LocalBluetoothProfileManager.Profile.HEADSET)) {
            profileManager = LocalBluetoothProfileManager.getProfileManager(this.mLocalManager, LocalBluetoothProfileManager.Profile.HEADSET);
            isConnecting |= profileManager.getConnectionStatus(this.mDevice) == 3;
            isHeadsetConnected = profileManager.isConnected(this.mDevice);
        }
        if (isConnecting) {
            return SettingsBtStatus.getConnectionStatusSummary(3);
        }
        if (isA2dpConnected && isHeadsetConnected) {
            return 2131231031;
        }
        if (isA2dpConnected) {
            return 2131231029;
        }
        if (isHeadsetConnected) {
            return 2131231030;
        }
        return 0;
    }

    public List<LocalBluetoothProfileManager.Profile> getConnectableProfiles() {
        ArrayList<LocalBluetoothProfileManager.Profile> connectableProfiles = new ArrayList<LocalBluetoothProfileManager.Profile>();
        for (LocalBluetoothProfileManager.Profile profile : this.mProfiles) {
            if (!this.isConnectableProfile(profile)) continue;
            connectableProfiles.add(profile);
        }
        return connectableProfiles;
    }

    private boolean isConnectableProfile(LocalBluetoothProfileManager.Profile profile) {
        return profile.equals((Object)LocalBluetoothProfileManager.Profile.HEADSET) || profile.equals((Object)LocalBluetoothProfileManager.Profile.A2DP);
    }

    public void onCreateContextMenu(ContextMenu menu) {
        if (this.mLocalManager.getBluetoothState() != 12 || this.isBusy()) {
            return;
        }
        int bondState = this.getBondState();
        boolean isConnected = this.isConnected();
        boolean hasConnectableProfiles = false;
        for (LocalBluetoothProfileManager.Profile profile : this.mProfiles) {
            if (!this.isConnectableProfile(profile)) continue;
            hasConnectableProfiles = true;
            break;
        }
        menu.setHeaderTitle((CharSequence)this.getName());
        if (bondState == 10) {
            menu.add(0, 2, 0, 2131231021);
        } else {
            if (isConnected) {
                menu.add(0, 3, 0, 2131231020);
                menu.add(0, 4, 0, 2131231023);
            } else {
                if (hasConnectableProfiles) {
                    menu.add(0, 2, 0, 2131231019);
                }
                menu.add(0, 4, 0, 2131231022);
            }
            if (hasConnectableProfiles) {
                menu.add(0, 5, 0, 2131231024);
            }
        }
    }

    public void onContextItemSelected(MenuItem item) {
        switch (item.getItemId()) {
            case 3: {
                this.disconnect();
                break;
            }
            case 2: {
                this.connect();
                break;
            }
            case 4: {
                this.unpair();
                break;
            }
            case 5: {
                Intent intent = new Intent();
                Activity context = this.mLocalManager.getForegroundActivity();
                if (context == null) {
                    context = this.mLocalManager.getContext();
                    intent.setFlags(0x10000000);
                }
                intent.setClass((Context)context, ConnectSpecificProfilesActivity.class);
                intent.putExtra("device", (Parcelable)this.mDevice);
                context.startActivity(intent);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerCallback(Callback callback) {
        List<Callback> list = this.mCallbacks;
        synchronized (list) {
            this.mCallbacks.add(callback);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregisterCallback(Callback callback) {
        List<Callback> list = this.mCallbacks;
        synchronized (list) {
            this.mCallbacks.remove(callback);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void dispatchAttributesChanged() {
        List<Callback> list = this.mCallbacks;
        synchronized (list) {
            for (Callback callback : this.mCallbacks) {
                callback.onDeviceAttributesChanged(this);
            }
        }
    }

    public String toString() {
        return this.mDevice.toString();
    }

    public boolean equals(Object o) {
        if (o == null || !(o instanceof CachedBluetoothDevice)) {
            throw new ClassCastException();
        }
        return this.mDevice.equals((Object)((CachedBluetoothDevice)o).mDevice);
    }

    public int hashCode() {
        return this.mDevice.getAddress().hashCode();
    }

    @Override
    public int compareTo(CachedBluetoothDevice another) {
        int comparison = (another.isConnected() ? 1 : 0) - (this.isConnected() ? 1 : 0);
        if (comparison != 0) {
            return comparison;
        }
        comparison = (another.getBondState() == 12 ? 1 : 0) - (this.getBondState() == 12 ? 1 : 0);
        if (comparison != 0) {
            return comparison;
        }
        comparison = (another.mVisible ? 1 : 0) - (this.mVisible ? 1 : 0);
        if (comparison != 0) {
            return comparison;
        }
        comparison = another.mRssi - this.mRssi;
        if (comparison != 0) {
            return comparison;
        }
        return this.getName().compareTo(another.getName());
    }

    public static interface Callback {
        public void onDeviceAttributesChanged(CachedBluetoothDevice var1);
    }
}

