/*
 * Decompiled with CFR 0.152.
 */
package com.android.settings.bluetooth;

import android.app.Activity;
import android.bluetooth.BluetoothClass;
import android.bluetooth.BluetoothDevice;
import android.bluetooth.BluetoothUuid;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.os.Bundle;
import android.os.ParcelUuid;
import android.os.Parcelable;
import android.preference.CheckBoxPreference;
import android.preference.ListPreference;
import android.preference.Preference;
import android.preference.PreferenceActivity;
import android.preference.PreferenceScreen;
import android.view.ContextMenu;
import android.view.MenuItem;
import android.view.View;
import android.widget.AdapterView;
import com.android.settings.ProgressCategory;
import com.android.settings.bluetooth.BluetoothDevicePreference;
import com.android.settings.bluetooth.BluetoothDiscoverableEnabler;
import com.android.settings.bluetooth.BluetoothEnabler;
import com.android.settings.bluetooth.BluetoothNamePreference;
import com.android.settings.bluetooth.CachedBluetoothDevice;
import com.android.settings.bluetooth.LocalBluetoothManager;
import com.android.settings.bluetooth.LocalBluetoothProfileManager;
import java.util.List;
import java.util.WeakHashMap;

public class BluetoothSettings
extends PreferenceActivity
implements LocalBluetoothManager.Callback {
    private static final String TAG = "BluetoothSettings";
    private static final String KEY_BT_CHECKBOX = "bt_checkbox";
    private static final String KEY_BT_DISCOVERABLE = "bt_discoverable";
    private static final String KEY_BT_DEVICE_LIST = "bt_device_list";
    private static final String KEY_BT_DISCOVERABLE_TIMEOUT = "bt_discoverable_timeout";
    private static final String KEY_BT_NAME = "bt_name";
    private static final String KEY_BT_SCAN = "bt_scan";
    private static final int SCREEN_TYPE_SETTINGS = 0;
    private static final int SCREEN_TYPE_DEVICEPICKER = 1;
    private int mScreenType;
    private int mFilterType;
    private boolean mNeedAuth;
    private String mLaunchPackage;
    private String mLaunchClass;
    private BluetoothDevice mSelectedDevice = null;
    private LocalBluetoothManager mLocalManager;
    private BluetoothEnabler mEnabler;
    private BluetoothDiscoverableEnabler mDiscoverableEnabler;
    private BluetoothNamePreference mNamePreference;
    private ProgressCategory mDeviceList;
    private WeakHashMap<CachedBluetoothDevice, BluetoothDevicePreference> mDevicePreferenceMap = new WeakHashMap();
    private final BroadcastReceiver mReceiver = new BroadcastReceiver(){

        public void onReceive(Context context, Intent intent) {
            BluetoothDevice device;
            int bondState;
            if (intent.getAction().equals("android.bluetooth.adapter.action.STATE_CHANGED")) {
                BluetoothSettings.this.onBluetoothStateChanged(BluetoothSettings.this.mLocalManager.getBluetoothState());
            } else if (intent.getAction().equals("android.bluetooth.device.action.BOND_STATE_CHANGED") && BluetoothSettings.this.mScreenType == 1 && (bondState = intent.getIntExtra("android.bluetooth.device.extra.BOND_STATE", Integer.MIN_VALUE)) == 12 && (device = (BluetoothDevice)intent.getParcelableExtra("android.bluetooth.device.extra.DEVICE")).equals((Object)BluetoothSettings.this.mSelectedDevice)) {
                BluetoothSettings.this.sendDevicePickedIntent(device);
                BluetoothSettings.this.finish();
            }
        }
    };

    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.mLocalManager = LocalBluetoothManager.getInstance((Context)this);
        if (this.mLocalManager == null) {
            this.finish();
        }
        this.mFilterType = 0;
        Intent intent = this.getIntent();
        String action = intent.getAction();
        if (action.equals("android.bluetooth.devicepicker.action.LAUNCH")) {
            this.mScreenType = 1;
            this.mNeedAuth = intent.getBooleanExtra("android.bluetooth.devicepicker.extra.NEED_AUTH", false);
            this.mFilterType = intent.getIntExtra("android.bluetooth.devicepicker.extra.FILTER_TYPE", 0);
            this.mLaunchPackage = intent.getStringExtra("android.bluetooth.devicepicker.extra.LAUNCH_PACKAGE");
            this.mLaunchClass = intent.getStringExtra("android.bluetooth.devicepicker.extra.DEVICE_PICKER_LAUNCH_CLASS");
            this.setTitle(this.getString(2131230818));
            this.addPreferencesFromResource(2130968588);
        } else {
            this.addPreferencesFromResource(2130968582);
            this.mEnabler = new BluetoothEnabler((Context)this, (CheckBoxPreference)this.findPreference(KEY_BT_CHECKBOX));
            this.mDiscoverableEnabler = new BluetoothDiscoverableEnabler((Context)this, (CheckBoxPreference)this.findPreference(KEY_BT_DISCOVERABLE), (ListPreference)this.findPreference(KEY_BT_DISCOVERABLE_TIMEOUT));
            this.mNamePreference = (BluetoothNamePreference)this.findPreference(KEY_BT_NAME);
            this.mDeviceList = (ProgressCategory)this.findPreference(KEY_BT_DEVICE_LIST);
        }
        this.mDeviceList = (ProgressCategory)this.findPreference(KEY_BT_DEVICE_LIST);
        this.registerForContextMenu((View)this.getListView());
    }

    protected void onResume() {
        super.onResume();
        this.mDevicePreferenceMap.clear();
        this.mDeviceList.removeAll();
        this.addDevices();
        if (this.mScreenType == 0) {
            this.mEnabler.resume();
            this.mDiscoverableEnabler.resume();
            this.mNamePreference.resume();
        }
        this.mLocalManager.registerCallback(this);
        this.mDeviceList.setProgress(this.mLocalManager.getBluetoothAdapter().isDiscovering());
        this.mLocalManager.startScanning(false);
        IntentFilter intentFilter = new IntentFilter();
        intentFilter.addAction("android.bluetooth.adapter.action.STATE_CHANGED");
        intentFilter.addAction("android.bluetooth.device.action.BOND_STATE_CHANGED");
        this.registerReceiver(this.mReceiver, intentFilter);
        this.mLocalManager.setForegroundActivity((Activity)this);
    }

    protected void onPause() {
        super.onPause();
        this.mLocalManager.setForegroundActivity(null);
        this.unregisterReceiver(this.mReceiver);
        this.mLocalManager.unregisterCallback(this);
        if (this.mScreenType == 0) {
            this.mNamePreference.pause();
            this.mDiscoverableEnabler.pause();
            this.mEnabler.pause();
        }
    }

    protected void onUserLeaveHint() {
        super.onUserLeaveHint();
        this.mLocalManager.stopScanning();
    }

    private void addDevices() {
        List<CachedBluetoothDevice> cachedDevices = this.mLocalManager.getCachedDeviceManager().getCachedDevicesCopy();
        for (CachedBluetoothDevice cachedDevice : cachedDevices) {
            this.onDeviceAdded(cachedDevice);
        }
    }

    public boolean onPreferenceTreeClick(PreferenceScreen preferenceScreen, Preference preference) {
        if (KEY_BT_SCAN.equals(preference.getKey())) {
            this.mLocalManager.startScanning(true);
            return true;
        }
        if (preference instanceof BluetoothDevicePreference) {
            BluetoothDevicePreference btPreference = (BluetoothDevicePreference)preference;
            if (this.mScreenType == 0) {
                btPreference.getCachedDevice().onClicked();
            } else if (this.mScreenType == 1) {
                CachedBluetoothDevice device = btPreference.getCachedDevice();
                this.mSelectedDevice = device.getDevice();
                this.mLocalManager.stopScanning();
                this.mLocalManager.persistSelectedDeviceInPicker(this.mSelectedDevice.getAddress());
                if (device.getBondState() == 12 || !this.mNeedAuth) {
                    this.sendDevicePickedIntent(this.mSelectedDevice);
                    this.finish();
                } else {
                    btPreference.getCachedDevice().onClicked();
                }
            }
            return true;
        }
        return super.onPreferenceTreeClick(preferenceScreen, preference);
    }

    public void onCreateContextMenu(ContextMenu menu, View v, ContextMenu.ContextMenuInfo menuInfo) {
        if (this.mScreenType != 0) {
            return;
        }
        CachedBluetoothDevice cachedDevice = this.getDeviceFromMenuInfo(menuInfo);
        if (cachedDevice == null) {
            return;
        }
        cachedDevice.onCreateContextMenu(menu);
    }

    public boolean onContextItemSelected(MenuItem item) {
        CachedBluetoothDevice cachedDevice = this.getDeviceFromMenuInfo(item.getMenuInfo());
        if (cachedDevice == null) {
            return false;
        }
        cachedDevice.onContextItemSelected(item);
        return true;
    }

    private CachedBluetoothDevice getDeviceFromMenuInfo(ContextMenu.ContextMenuInfo menuInfo) {
        if (menuInfo == null || !(menuInfo instanceof AdapterView.AdapterContextMenuInfo)) {
            return null;
        }
        AdapterView.AdapterContextMenuInfo adapterMenuInfo = (AdapterView.AdapterContextMenuInfo)menuInfo;
        Preference pref = (Preference)this.getPreferenceScreen().getRootAdapter().getItem(adapterMenuInfo.position);
        if (pref == null || !(pref instanceof BluetoothDevicePreference)) {
            return null;
        }
        return ((BluetoothDevicePreference)pref).getCachedDevice();
    }

    public void onDeviceAdded(CachedBluetoothDevice cachedDevice) {
        if (this.mDevicePreferenceMap.get(cachedDevice) != null) {
            throw new IllegalStateException("Got onDeviceAdded, but cachedDevice already exists");
        }
        if (this.addDevicePreference(cachedDevice)) {
            this.createDevicePreference(cachedDevice);
        }
    }

    private boolean addDevicePreference(CachedBluetoothDevice cachedDevice) {
        ParcelUuid[] uuids = cachedDevice.getDevice().getUuids();
        BluetoothClass bluetoothClass = cachedDevice.getDevice().getBluetoothClass();
        switch (this.mFilterType) {
            case 2: {
                if (uuids != null && BluetoothUuid.containsAnyUuid((ParcelUuid[])uuids, (ParcelUuid[])LocalBluetoothProfileManager.OPP_PROFILE_UUIDS)) {
                    return true;
                }
                if (bluetoothClass == null || !bluetoothClass.doesClassMatch(2)) break;
                return true;
            }
            case 1: {
                if (uuids != null) {
                    if (BluetoothUuid.containsAnyUuid((ParcelUuid[])uuids, (ParcelUuid[])LocalBluetoothProfileManager.A2DP_PROFILE_UUIDS)) {
                        return true;
                    }
                    if (!BluetoothUuid.containsAnyUuid((ParcelUuid[])uuids, (ParcelUuid[])LocalBluetoothProfileManager.HEADSET_PROFILE_UUIDS)) break;
                    return true;
                }
                if (bluetoothClass == null) break;
                if (bluetoothClass.doesClassMatch(1)) {
                    return true;
                }
                if (!bluetoothClass.doesClassMatch(0)) break;
                return true;
            }
            default: {
                return true;
            }
        }
        return false;
    }

    private void createDevicePreference(CachedBluetoothDevice cachedDevice) {
        BluetoothDevicePreference preference = new BluetoothDevicePreference((Context)this, cachedDevice);
        this.mDeviceList.addPreference(preference);
        this.mDevicePreferenceMap.put(cachedDevice, preference);
    }

    public void onDeviceDeleted(CachedBluetoothDevice cachedDevice) {
        BluetoothDevicePreference preference = this.mDevicePreferenceMap.remove(cachedDevice);
        if (preference != null) {
            this.mDeviceList.removePreference(preference);
        }
    }

    public void onScanningStateChanged(boolean started) {
        this.mDeviceList.setProgress(started);
    }

    private void onBluetoothStateChanged(int bluetoothState) {
        if (bluetoothState == 12) {
            this.mLocalManager.startScanning(false);
        } else if (bluetoothState == 10) {
            this.mDeviceList.setProgress(false);
        }
    }

    private void sendDevicePickedIntent(BluetoothDevice device) {
        Intent intent = new Intent("android.bluetooth.devicepicker.action.DEVICE_SELECTED");
        if (this.mLaunchPackage != null && this.mLaunchClass != null) {
            intent.setClassName(this.mLaunchPackage, this.mLaunchClass);
        }
        intent.putExtra("android.bluetooth.device.extra.DEVICE", (Parcelable)device);
        this.sendBroadcast(intent);
    }
}

