/*
 * Decompiled with CFR 0.152.
 */
package com.android.settings.bluetooth;

import android.app.Notification;
import android.app.NotificationManager;
import android.app.PendingIntent;
import android.bluetooth.BluetoothDevice;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.os.Parcelable;
import android.os.PowerManager;
import com.android.settings.bluetooth.BluetoothPermissionActivity;
import com.android.settings.bluetooth.LocalBluetoothManager;

public final class BluetoothPermissionRequest
extends BroadcastReceiver {
    private static final String TAG = "BluetoothPermissionRequest";
    private static final boolean DEBUG = false;
    private BluetoothDevice mDevice;
    public static final int NOTIFICATION_ID = 0x1080080;

    public void onReceive(Context context, Intent intent) {
        String action = intent.getAction();
        if (action.equals("android.bluetooth.device.action.CONNECTION_ACCESS_REQUEST")) {
            LocalBluetoothManager localManager = LocalBluetoothManager.getInstance(context);
            this.mDevice = (BluetoothDevice)intent.getParcelableExtra("android.bluetooth.device.extra.DEVICE");
            Intent connectionAccessIntent = new Intent(action);
            connectionAccessIntent.setClass(context, BluetoothPermissionActivity.class);
            connectionAccessIntent.setFlags(0x10000000);
            connectionAccessIntent.putExtra("android.bluetooth.device.extra.DEVICE", (Parcelable)this.mDevice);
            String deviceAddress = this.mDevice != null ? this.mDevice.getAddress() : null;
            PowerManager powerManager = (PowerManager)context.getSystemService("power");
            if (powerManager.isScreenOn() && localManager.shouldShowDialogInForeground(deviceAddress)) {
                context.startActivity(connectionAccessIntent);
            } else {
                Intent deleteIntent = new Intent("android.bluetooth.device.action.CONNECTION_ACCESS_REPLY");
                deleteIntent.putExtra("android.bluetooth.device.extra.DEVICE", (Parcelable)this.mDevice);
                deleteIntent.putExtra("android.bluetooth.device.extra.CONNECTION_ACCESS_RESULT", 2);
                Notification notification = new Notification(0x1080080, (CharSequence)context.getString(2131230831), System.currentTimeMillis());
                String deviceName = this.mDevice != null ? this.mDevice.getName() : null;
                notification.setLatestEventInfo(context, (CharSequence)context.getString(2131230831), (CharSequence)context.getString(2131230832, new Object[]{deviceName}), PendingIntent.getActivity((Context)context, (int)0, (Intent)connectionAccessIntent, (int)0));
                notification.flags = 24;
                notification.defaults = 1;
                notification.deleteIntent = PendingIntent.getBroadcast((Context)context, (int)0, (Intent)deleteIntent, (int)0);
                NotificationManager notificationManager = (NotificationManager)context.getSystemService("notification");
                notificationManager.notify(0x1080080, notification);
            }
        } else if (action.equals("android.bluetooth.device.action.CONNECTION_ACCESS_CANCEL")) {
            NotificationManager manager = (NotificationManager)context.getSystemService("notification");
            manager.cancel(0x1080080);
        }
    }
}

