/*
 * Decompiled with CFR 0.152.
 */
package com.android.settings.bluetooth;

import android.bluetooth.BluetoothDevice;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.content.IntentFilter;
import android.os.Bundle;
import android.os.Parcelable;
import android.preference.Preference;
import android.util.Log;
import android.view.View;
import android.widget.Button;
import android.widget.TextView;
import com.android.internal.app.AlertActivity;
import com.android.internal.app.AlertController;

public class BluetoothPermissionActivity
extends AlertActivity
implements DialogInterface.OnClickListener,
Preference.OnPreferenceChangeListener {
    private static final String TAG = "BluetoothPermissionActivity";
    private static final boolean DEBUG = false;
    private static final String KEY_USER_TIMEOUT = "user_timeout";
    private View mView;
    private TextView messageView;
    private Button mOkButton;
    private BluetoothDevice mDevice;
    private BroadcastReceiver mReceiver = new BroadcastReceiver(){

        public void onReceive(Context context, Intent intent) {
            String action = intent.getAction();
            if (action.equals("android.bluetooth.device.action.CONNECTION_ACCESS_CANCEL")) {
                BluetoothDevice device = (BluetoothDevice)intent.getParcelableExtra("android.bluetooth.device.extra.DEVICE");
                if (BluetoothPermissionActivity.this.mDevice.equals((Object)device)) {
                    BluetoothPermissionActivity.this.dismissDialog();
                }
            }
        }
    };

    private void dismissDialog() {
        this.dismiss();
    }

    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        Intent i = this.getIntent();
        String action = i.getAction();
        if (action.equals("android.bluetooth.device.action.CONNECTION_ACCESS_REQUEST")) {
            this.mDevice = (BluetoothDevice)i.getParcelableExtra("android.bluetooth.device.extra.DEVICE");
            this.showConnectionDialog();
            this.registerReceiver(this.mReceiver, new IntentFilter("android.bluetooth.device.action.CONNECTION_ACCESS_CANCEL"));
        } else {
            Log.e((String)TAG, (String)"Error: this activity may be started only with intent ACTION_CONNECTION_ACCESS_REQUEST");
            this.finish();
        }
    }

    private void showConnectionDialog() {
        AlertController.AlertParams p = this.mAlertParams;
        p.mIconId = 17301659;
        p.mTitle = this.getString(2131230831);
        p.mView = this.createView();
        p.mPositiveButtonText = this.getString(2131230722);
        p.mPositiveButtonListener = this;
        p.mNegativeButtonText = this.getString(2131230723);
        p.mNegativeButtonListener = this;
        this.mOkButton = this.mAlert.getButton(-1);
        this.setupAlert();
    }

    private String createDisplayText() {
        String mRemoteName;
        String string2 = mRemoteName = this.mDevice != null ? this.mDevice.getName() : null;
        if (mRemoteName == null) {
            mRemoteName = this.getString(2131231464);
        }
        String mMessage1 = this.getString(2131230833, new Object[]{mRemoteName});
        return mMessage1;
    }

    private View createView() {
        this.mView = this.getLayoutInflater().inflate(2130903044, null);
        this.messageView = (TextView)this.mView.findViewById(2131427341);
        this.messageView.setText((CharSequence)this.createDisplayText());
        return this.mView;
    }

    private void onPositive() {
        this.sendIntentToReceiver("android.bluetooth.device.action.CONNECTION_ACCESS_REPLY", "android.bluetooth.device.extra.CONNECTION_ACCESS_RESULT", 1);
        this.finish();
    }

    private void onNegative() {
        this.sendIntentToReceiver("android.bluetooth.device.action.CONNECTION_ACCESS_REPLY", "android.bluetooth.device.extra.CONNECTION_ACCESS_RESULT", 2);
        this.finish();
    }

    private void sendIntentToReceiver(String intentName, String extraName, int extraValue) {
        Intent intent = new Intent(intentName);
        if (extraName != null) {
            intent.putExtra(extraName, extraValue);
        }
        intent.putExtra("android.bluetooth.device.extra.DEVICE", (Parcelable)this.mDevice);
        this.sendBroadcast(intent, "android.permission.BLUETOOTH_ADMIN");
    }

    public void onClick(DialogInterface dialog, int which) {
        switch (which) {
            case -1: {
                this.onPositive();
                break;
            }
            case -2: {
                this.onNegative();
                break;
            }
        }
    }

    protected void onDestroy() {
        super.onDestroy();
        this.unregisterReceiver(this.mReceiver);
    }

    public boolean onPreferenceChange(Preference preference, Object newValue) {
        return true;
    }
}

