/*
 * Decompiled with CFR 0.152.
 */
package com.android.settings.bluetooth;

import android.app.Notification;
import android.app.NotificationManager;
import android.app.PendingIntent;
import android.bluetooth.BluetoothDevice;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.res.Resources;
import android.os.Parcelable;
import android.os.PowerManager;
import android.text.TextUtils;
import com.android.settings.bluetooth.BluetoothPairingDialog;
import com.android.settings.bluetooth.LocalBluetoothManager;

public class BluetoothPairingRequest
extends BroadcastReceiver {
    public static final int NOTIFICATION_ID = 0x1080080;

    public void onReceive(Context context, Intent intent) {
        String action = intent.getAction();
        if (action.equals("android.bluetooth.device.action.PAIRING_REQUEST")) {
            String deviceAddress;
            LocalBluetoothManager localManager = LocalBluetoothManager.getInstance(context);
            BluetoothDevice device = (BluetoothDevice)intent.getParcelableExtra("android.bluetooth.device.extra.DEVICE");
            int type = intent.getIntExtra("android.bluetooth.device.extra.PAIRING_VARIANT", Integer.MIN_VALUE);
            Intent pairingIntent = new Intent();
            pairingIntent.setClass(context, BluetoothPairingDialog.class);
            pairingIntent.putExtra("android.bluetooth.device.extra.DEVICE", (Parcelable)device);
            pairingIntent.putExtra("android.bluetooth.device.extra.PAIRING_VARIANT", type);
            if (type == 2 || type == 4) {
                int passkey = intent.getIntExtra("android.bluetooth.device.extra.PASSKEY", Integer.MIN_VALUE);
                pairingIntent.putExtra("android.bluetooth.device.extra.PASSKEY", passkey);
            }
            pairingIntent.setAction("android.bluetooth.device.action.PAIRING_REQUEST");
            pairingIntent.setFlags(0x10000000);
            PowerManager powerManager = (PowerManager)context.getSystemService("power");
            String string2 = deviceAddress = device != null ? device.getAddress() : null;
            if (powerManager.isScreenOn() && localManager.shouldShowDialogInForeground(deviceAddress)) {
                context.startActivity(pairingIntent);
            } else {
                Resources res = context.getResources();
                Notification notification = new Notification(0x1080080, (CharSequence)res.getString(2131230815), System.currentTimeMillis());
                PendingIntent pending = PendingIntent.getActivity((Context)context, (int)0, (Intent)pairingIntent, (int)0x40000000);
                String name = intent.getStringExtra("android.bluetooth.device.extra.NAME");
                if (TextUtils.isEmpty((CharSequence)name)) {
                    name = device.getName();
                }
                notification.setLatestEventInfo(context, (CharSequence)res.getString(2131230816), (CharSequence)(res.getString(2131230817) + name), pending);
                notification.flags |= 0x10;
                notification.defaults |= 1;
                NotificationManager manager = (NotificationManager)context.getSystemService("notification");
                manager.notify(0x1080080, notification);
            }
        } else if (action.equals("android.bluetooth.device.action.PAIRING_CANCEL")) {
            NotificationManager manager = (NotificationManager)context.getSystemService("notification");
            manager.cancel(0x1080080);
        }
    }
}

