/*
 * Decompiled with CFR 0.152.
 */
package com.android.settings.bluetooth;

import android.bluetooth.BluetoothDevice;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.content.IntentFilter;
import android.os.Bundle;
import android.text.Editable;
import android.text.InputFilter;
import android.text.TextWatcher;
import android.util.Log;
import android.view.View;
import android.widget.Button;
import android.widget.EditText;
import android.widget.TextView;
import com.android.internal.app.AlertActivity;
import com.android.internal.app.AlertController;
import com.android.settings.bluetooth.LocalBluetoothManager;

public class BluetoothPairingDialog
extends AlertActivity
implements DialogInterface.OnClickListener,
TextWatcher {
    private static final String TAG = "BluetoothPairingDialog";
    private final int BLUETOOTH_PIN_MAX_LENGTH = 16;
    private final int BLUETOOTH_PASSKEY_MAX_LENGTH = 6;
    private LocalBluetoothManager mLocalManager;
    private BluetoothDevice mDevice;
    private int mType;
    private String mPasskey;
    private EditText mPairingView;
    private Button mOkButton;
    private BroadcastReceiver mReceiver = new BroadcastReceiver(){

        public void onReceive(Context context, Intent intent) {
            BluetoothDevice device;
            if ("android.bluetooth.device.action.BOND_STATE_CHANGED".equals(intent.getAction())) {
                int bondState = intent.getIntExtra("android.bluetooth.device.extra.BOND_STATE", Integer.MIN_VALUE);
                if (bondState == 12 || bondState == 10) {
                    BluetoothPairingDialog.this.dismissDialog();
                }
            } else if ("android.bluetooth.device.action.PAIRING_CANCEL".equals(intent.getAction()) && ((device = (BluetoothDevice)intent.getParcelableExtra("android.bluetooth.device.extra.DEVICE")) == null || device.equals((Object)BluetoothPairingDialog.this.mDevice))) {
                BluetoothPairingDialog.this.dismissDialog();
            }
        }
    };

    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        Intent intent = this.getIntent();
        if (!intent.getAction().equals("android.bluetooth.device.action.PAIRING_REQUEST")) {
            Log.e((String)TAG, (String)"Error: this activity may be started only with intent android.bluetooth.device.action.PAIRING_REQUEST");
            this.finish();
        }
        this.mLocalManager = LocalBluetoothManager.getInstance((Context)this);
        this.mDevice = (BluetoothDevice)intent.getParcelableExtra("android.bluetooth.device.extra.DEVICE");
        this.mType = intent.getIntExtra("android.bluetooth.device.extra.PAIRING_VARIANT", Integer.MIN_VALUE);
        if (this.mType == 0) {
            this.createUserEntryDialog();
        } else if (this.mType == 1) {
            this.createUserEntryDialog();
        } else if (this.mType == 2) {
            int passkey = intent.getIntExtra("android.bluetooth.device.extra.PASSKEY", Integer.MIN_VALUE);
            if (passkey == Integer.MIN_VALUE) {
                Log.e((String)TAG, (String)"Invalid ConfirmationPasskey received, not showing any dialog");
                return;
            }
            this.mPasskey = String.format("%06d", passkey);
            this.createConfirmationDialog();
        } else if (this.mType == 3) {
            this.createConsentDialog();
        } else if (this.mType == 4) {
            int passkey = intent.getIntExtra("android.bluetooth.device.extra.PASSKEY", Integer.MIN_VALUE);
            if (passkey == Integer.MIN_VALUE) {
                Log.e((String)TAG, (String)"Invalid ConfirmationPasskey received, not showing any dialog");
                return;
            }
            this.mPasskey = String.format("%06d", passkey);
            this.createDisplayPasskeyDialog();
        } else if (this.mType == 5) {
            this.createConsentDialog();
        } else {
            Log.e((String)TAG, (String)"Incorrect pairing type received, not showing any dialog");
        }
        this.registerReceiver(this.mReceiver, new IntentFilter("android.bluetooth.device.action.PAIRING_CANCEL"));
        this.registerReceiver(this.mReceiver, new IntentFilter("android.bluetooth.device.action.BOND_STATE_CHANGED"));
    }

    private void createUserEntryDialog() {
        AlertController.AlertParams p = this.mAlertParams;
        p.mIconId = 17301659;
        p.mTitle = this.getString(2131230998);
        p.mView = this.createView();
        p.mPositiveButtonText = this.getString(17039370);
        p.mPositiveButtonListener = this;
        p.mNegativeButtonText = this.getString(0x1040000);
        p.mNegativeButtonListener = this;
        this.setupAlert();
        this.mOkButton = this.mAlert.getButton(-1);
        this.mOkButton.setEnabled(false);
    }

    private View createView() {
        View view = this.getLayoutInflater().inflate(2130903047, null);
        String name = this.mLocalManager.getCachedDeviceManager().getName(this.mDevice);
        TextView messageView = (TextView)view.findViewById(2131427341);
        this.mPairingView = (EditText)view.findViewById(2131427348);
        this.mPairingView.addTextChangedListener((TextWatcher)this);
        if (this.mType == 0) {
            messageView.setText((CharSequence)this.getString(2131231000, new Object[]{name}));
            this.mPairingView.setFilters(new InputFilter[]{new InputFilter.LengthFilter(16)});
        } else if (this.mType == 1) {
            messageView.setText((CharSequence)this.getString(2131231001, new Object[]{name}));
            this.mPairingView.setInputType(4098);
            this.mPairingView.setFilters(new InputFilter[]{new InputFilter.LengthFilter(6)});
        } else if (this.mType == 2) {
            this.mPairingView.setVisibility(8);
            messageView.setText((CharSequence)this.getString(2131231002, new Object[]{name, this.mPasskey}));
        } else if (this.mType == 3) {
            this.mPairingView.setVisibility(8);
            messageView.setText((CharSequence)this.getString(2131231003, new Object[]{name}));
        } else if (this.mType == 4) {
            this.mPairingView.setVisibility(8);
            messageView.setText((CharSequence)this.getString(2131231004, new Object[]{name, this.mPasskey}));
        } else if (this.mType == 5) {
            this.mPairingView.setVisibility(8);
            messageView.setText((CharSequence)this.getString(2131231003, new Object[]{name}));
        } else {
            Log.e((String)TAG, (String)"Incorrect pairing type received, not creating view");
        }
        return view;
    }

    private void createConfirmationDialog() {
        AlertController.AlertParams p = this.mAlertParams;
        p.mIconId = 17301659;
        p.mTitle = this.getString(2131230998);
        p.mView = this.createView();
        p.mPositiveButtonText = this.getString(2131231005);
        p.mPositiveButtonListener = this;
        p.mNegativeButtonText = this.getString(2131231006);
        p.mNegativeButtonListener = this;
        this.setupAlert();
    }

    private void createConsentDialog() {
        AlertController.AlertParams p = this.mAlertParams;
        p.mIconId = 17301659;
        p.mTitle = this.getString(2131230998);
        p.mView = this.createView();
        p.mPositiveButtonText = this.getString(2131231005);
        p.mPositiveButtonListener = this;
        p.mNegativeButtonText = this.getString(2131231006);
        p.mNegativeButtonListener = this;
        this.setupAlert();
    }

    private void createDisplayPasskeyDialog() {
        AlertController.AlertParams p = this.mAlertParams;
        p.mIconId = 17301659;
        p.mTitle = this.getString(2131230998);
        p.mView = this.createView();
        p.mPositiveButtonText = this.getString(17039370);
        p.mPositiveButtonListener = this;
        this.setupAlert();
        this.mDevice.setPairingConfirmation(true);
    }

    protected void onDestroy() {
        super.onDestroy();
        this.unregisterReceiver(this.mReceiver);
    }

    public void afterTextChanged(Editable s) {
        if (s.length() > 0) {
            this.mOkButton.setEnabled(true);
        }
    }

    private void dismissDialog() {
        this.dismiss();
    }

    private void onPair(String value) {
        if (this.mType == 0) {
            byte[] pinBytes = BluetoothDevice.convertPinToBytes((String)value);
            if (pinBytes == null) {
                return;
            }
            this.mDevice.setPin(pinBytes);
        } else if (this.mType == 1) {
            int passkey = Integer.parseInt(value);
            this.mDevice.setPasskey(passkey);
        } else if (this.mType == 2) {
            this.mDevice.setPairingConfirmation(true);
        } else if (this.mType == 3) {
            this.mDevice.setPairingConfirmation(true);
        } else if (this.mType != 4) {
            if (this.mType == 5) {
                this.mDevice.setRemoteOutOfBandData();
            } else {
                Log.e((String)TAG, (String)"Incorrect pairing type received");
            }
        }
    }

    private void onCancel() {
        this.mDevice.cancelPairingUserInput();
    }

    public void onClick(DialogInterface dialog, int which) {
        switch (which) {
            case -1: {
                this.onPair(this.mPairingView.getText().toString());
                break;
            }
            case -2: {
                this.onCancel();
            }
        }
    }

    public void beforeTextChanged(CharSequence s, int start, int count, int after) {
    }

    public void onTextChanged(CharSequence s, int start, int before, int count) {
    }
}

