/*
 * Decompiled with CFR 0.152.
 */
package com.android.settings.bluetooth;

import android.app.AlertDialog;
import android.app.Dialog;
import android.bluetooth.BluetoothAdapter;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.preference.EditTextPreference;
import android.text.Editable;
import android.text.InputFilter;
import android.text.Spanned;
import android.text.TextWatcher;
import android.util.AttributeSet;
import android.widget.Button;
import android.widget.EditText;
import com.android.settings.bluetooth.LocalBluetoothManager;

public class BluetoothNamePreference
extends EditTextPreference
implements TextWatcher {
    private static final String TAG = "BluetoothNamePreference";
    private static final int BLUETOOTH_NAME_MAX_LENGTH_BYTES = 246;
    private LocalBluetoothManager mLocalManager;
    private BroadcastReceiver mReceiver = new BroadcastReceiver(){

        public void onReceive(Context context, Intent intent) {
            String action = intent.getAction();
            if (action.equals("android.bluetooth.adapter.action.LOCAL_NAME_CHANGED")) {
                BluetoothNamePreference.this.setSummaryToName();
            } else if (action.equals("android.bluetooth.adapter.action.STATE_CHANGED") && intent.getIntExtra("android.bluetooth.adapter.extra.STATE", Integer.MIN_VALUE) == 12) {
                BluetoothNamePreference.this.setSummaryToName();
            }
        }
    };

    public BluetoothNamePreference(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.mLocalManager = LocalBluetoothManager.getInstance(context);
        this.setSummaryToName();
    }

    public void resume() {
        IntentFilter filter = new IntentFilter();
        filter.addAction("android.bluetooth.adapter.action.STATE_CHANGED");
        filter.addAction("android.bluetooth.adapter.action.LOCAL_NAME_CHANGED");
        this.getContext().registerReceiver(this.mReceiver, filter);
        EditText et = this.getEditText();
        if (et != null) {
            et.setFilters(new InputFilter[]{new Utf8ByteLengthFilter(246)});
            et.addTextChangedListener((TextWatcher)this);
            Dialog d = this.getDialog();
            if (d instanceof AlertDialog) {
                Button b = ((AlertDialog)d).getButton(-1);
                b.setEnabled(et.getText().length() > 0);
            }
        }
    }

    public void pause() {
        EditText et = this.getEditText();
        if (et != null) {
            et.removeTextChangedListener((TextWatcher)this);
        }
        this.getContext().unregisterReceiver(this.mReceiver);
    }

    private void setSummaryToName() {
        BluetoothAdapter adapter = this.mLocalManager.getBluetoothAdapter();
        if (adapter.isEnabled()) {
            this.setSummary(adapter.getName());
        }
    }

    protected boolean persistString(String value) {
        BluetoothAdapter adapter = this.mLocalManager.getBluetoothAdapter();
        adapter.setName(value);
        return true;
    }

    protected void onClick() {
        super.onClick();
        EditText et = this.getEditText();
        if (et != null) {
            et.setText((CharSequence)this.mLocalManager.getBluetoothAdapter().getName());
        }
    }

    public void afterTextChanged(Editable s) {
        Dialog d = this.getDialog();
        if (d instanceof AlertDialog) {
            ((AlertDialog)d).getButton(-1).setEnabled(s.length() > 0);
        }
    }

    public void beforeTextChanged(CharSequence s, int start, int count, int after) {
    }

    public void onTextChanged(CharSequence s, int start, int before, int count) {
    }

    public static class Utf8ByteLengthFilter
    implements InputFilter {
        private int mMaxBytes;

        public Utf8ByteLengthFilter(int maxBytes) {
            this.mMaxBytes = maxBytes;
        }

        public CharSequence filter(CharSequence source, int start, int end, Spanned dest, int dstart, int dend) {
            int srcByteCount = 0;
            for (int i = start; i < end; ++i) {
                char c = source.charAt(i);
                srcByteCount += c < '\u0080' ? 1 : (c < '\u0800' ? 2 : 3);
            }
            int destLen = dest.length();
            int destByteCount = 0;
            for (int i = 0; i < destLen; ++i) {
                if (i >= dstart && i < dend) continue;
                char c = dest.charAt(i);
                destByteCount += c < '\u0080' ? 1 : (c < '\u0800' ? 2 : 3);
            }
            int keepBytes = this.mMaxBytes - destByteCount;
            if (keepBytes <= 0) {
                return "";
            }
            if (keepBytes >= srcByteCount) {
                return null;
            }
            for (int i = start; i < end; ++i) {
                char c = source.charAt(i);
                if ((keepBytes -= c < '\u0080' ? 1 : (c < '\u0800' ? 2 : 3)) >= 0) continue;
                return source.subSequence(start, i);
            }
            return null;
        }
    }
}

