/*
 * Decompiled with CFR 0.152.
 */
package com.android.settings.bluetooth;

import android.bluetooth.BluetoothClass;
import android.bluetooth.BluetoothDevice;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.SharedPreferences;
import android.util.Log;
import com.android.settings.bluetooth.CachedBluetoothDeviceManager;
import com.android.settings.bluetooth.LocalBluetoothManager;
import com.android.settings.bluetooth.LocalBluetoothProfileManager;

public class BluetoothEventRedirector {
    private static final String TAG = "BluetoothEventRedirector";
    private LocalBluetoothManager mManager;
    private BroadcastReceiver mBroadcastReceiver = new BroadcastReceiver(){

        public void onReceive(Context context, Intent intent) {
            int anythingButUnDocked;
            int state;
            Log.v((String)BluetoothEventRedirector.TAG, (String)("Received " + intent.getAction()));
            String action = intent.getAction();
            BluetoothDevice device = (BluetoothDevice)intent.getParcelableExtra("android.bluetooth.device.extra.DEVICE");
            if (action.equals("android.bluetooth.adapter.action.STATE_CHANGED")) {
                int state2 = intent.getIntExtra("android.bluetooth.adapter.extra.STATE", Integer.MIN_VALUE);
                BluetoothEventRedirector.this.mManager.setBluetoothStateInt(state2);
            } else if (action.equals("android.bluetooth.adapter.action.DISCOVERY_STARTED")) {
                BluetoothEventRedirector.this.persistDiscoveringTimestamp();
                BluetoothEventRedirector.this.mManager.onScanningStateChanged(true);
            } else if (action.equals("android.bluetooth.adapter.action.DISCOVERY_FINISHED")) {
                BluetoothEventRedirector.this.persistDiscoveringTimestamp();
                BluetoothEventRedirector.this.mManager.onScanningStateChanged(false);
            } else if (action.equals("android.bluetooth.device.action.FOUND")) {
                short rssi = intent.getShortExtra("android.bluetooth.device.extra.RSSI", (short)Short.MIN_VALUE);
                BluetoothClass btClass = (BluetoothClass)intent.getParcelableExtra("android.bluetooth.device.extra.CLASS");
                String name = intent.getStringExtra("android.bluetooth.device.extra.NAME");
                BluetoothEventRedirector.this.mManager.getCachedDeviceManager().onDeviceAppeared(device, rssi, btClass, name);
            } else if (action.equals("android.bluetooth.device.action.DISAPPEARED")) {
                BluetoothEventRedirector.this.mManager.getCachedDeviceManager().onDeviceDisappeared(device);
            } else if (action.equals("android.bluetooth.device.action.NAME_CHANGED")) {
                BluetoothEventRedirector.this.mManager.getCachedDeviceManager().onDeviceNameUpdated(device);
            } else if (action.equals("android.bluetooth.device.action.BOND_STATE_CHANGED")) {
                int bondState = intent.getIntExtra("android.bluetooth.device.extra.BOND_STATE", Integer.MIN_VALUE);
                CachedBluetoothDeviceManager cachedDeviceMgr = BluetoothEventRedirector.this.mManager.getCachedDeviceManager();
                cachedDeviceMgr.onBondingStateChanged(device, bondState);
                if (bondState == 10) {
                    if (device.isBluetoothDock()) {
                        BluetoothEventRedirector.this.mManager.removeDockAutoConnectSetting(device.getAddress());
                        if (!device.getAddress().equals(BluetoothEventRedirector.this.getDockedDeviceAddress(context))) {
                            cachedDeviceMgr.onDeviceDisappeared(device);
                        }
                    }
                    int reason = intent.getIntExtra("android.bluetooth.device.extra.REASON", Integer.MIN_VALUE);
                    cachedDeviceMgr.showUnbondMessage(device, reason);
                }
            } else if (action.equals("android.bluetooth.headset.action.STATE_CHANGED")) {
                int newState = intent.getIntExtra("android.bluetooth.headset.extra.STATE", 0);
                int oldState = intent.getIntExtra("android.bluetooth.headset.extra.PREVIOUS_STATE", 0);
                if (newState == 0 && oldState == 1) {
                    Log.i((String)BluetoothEventRedirector.TAG, (String)"Failed to connect BT headset");
                }
                BluetoothEventRedirector.this.mManager.getCachedDeviceManager().onProfileStateChanged(device, LocalBluetoothProfileManager.Profile.HEADSET, newState);
            } else if (action.equals("android.bluetooth.a2dp.action.SINK_STATE_CHANGED")) {
                int newState = intent.getIntExtra("android.bluetooth.a2dp.extra.SINK_STATE", 0);
                int oldState = intent.getIntExtra("android.bluetooth.a2dp.extra.PREVIOUS_SINK_STATE", 0);
                if (newState == 0 && oldState == 1) {
                    Log.i((String)BluetoothEventRedirector.TAG, (String)"Failed to connect BT A2DP");
                }
                BluetoothEventRedirector.this.mManager.getCachedDeviceManager().onProfileStateChanged(device, LocalBluetoothProfileManager.Profile.A2DP, newState);
            } else if (action.equals("android.bluetooth.device.action.CLASS_CHANGED")) {
                BluetoothEventRedirector.this.mManager.getCachedDeviceManager().onBtClassChanged(device);
            } else if (action.equals("android.bleutooth.device.action.UUID")) {
                BluetoothEventRedirector.this.mManager.getCachedDeviceManager().onUuidChanged(device);
            } else if (action.equals("android.bluetooth.device.action.PAIRING_CANCEL")) {
                int errorMsg = 2131231009;
                BluetoothEventRedirector.this.mManager.showError(device, 2131231008, errorMsg);
            } else if (action.equals("android.intent.action.DOCK_EVENT") && (state = intent.getIntExtra("android.intent.extra.DOCK_STATE", anythingButUnDocked = 1)) == 0 && device != null && device.getBondState() == 10) {
                BluetoothEventRedirector.this.mManager.getCachedDeviceManager().onDeviceDisappeared(device);
            }
        }
    };

    public BluetoothEventRedirector(LocalBluetoothManager localBluetoothManager) {
        this.mManager = localBluetoothManager;
    }

    public void start() {
        IntentFilter filter = new IntentFilter();
        filter.addAction("android.bluetooth.adapter.action.STATE_CHANGED");
        filter.addAction("android.bluetooth.adapter.action.DISCOVERY_STARTED");
        filter.addAction("android.bluetooth.adapter.action.DISCOVERY_FINISHED");
        filter.addAction("android.bluetooth.device.action.DISAPPEARED");
        filter.addAction("android.bluetooth.device.action.FOUND");
        filter.addAction("android.bluetooth.device.action.NAME_CHANGED");
        filter.addAction("android.bluetooth.device.action.BOND_STATE_CHANGED");
        filter.addAction("android.bluetooth.device.action.PAIRING_CANCEL");
        filter.addAction("android.bluetooth.a2dp.action.SINK_STATE_CHANGED");
        filter.addAction("android.bluetooth.headset.action.STATE_CHANGED");
        filter.addAction("android.bluetooth.device.action.CLASS_CHANGED");
        filter.addAction("android.bleutooth.device.action.UUID");
        filter.addAction("android.intent.action.DOCK_EVENT");
        this.mManager.getContext().registerReceiver(this.mBroadcastReceiver, filter);
    }

    public void stop() {
        this.mManager.getContext().unregisterReceiver(this.mBroadcastReceiver);
    }

    private String getDockedDeviceAddress(Context context) {
        BluetoothDevice device;
        int state;
        Intent i = context.registerReceiver(null, new IntentFilter("android.intent.action.DOCK_EVENT"));
        if (i != null && (state = i.getIntExtra("android.intent.extra.DOCK_STATE", 0)) != 0 && (device = (BluetoothDevice)i.getParcelableExtra("android.bluetooth.device.extra.DEVICE")) != null) {
            return device.getAddress();
        }
        return null;
    }

    private void persistDiscoveringTimestamp() {
        SharedPreferences.Editor editor = this.mManager.getSharedPreferences().edit();
        editor.putLong("last_discovering_time", System.currentTimeMillis());
        editor.apply();
    }
}

