/*
 * Decompiled with CFR 0.152.
 */
package com.android.settings.bluetooth;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.preference.CheckBoxPreference;
import android.preference.Preference;
import android.widget.Toast;
import com.android.settings.WirelessSettings;
import com.android.settings.bluetooth.LocalBluetoothManager;

public class BluetoothEnabler
implements Preference.OnPreferenceChangeListener {
    private final Context mContext;
    private final CheckBoxPreference mCheckBox;
    private final CharSequence mOriginalSummary;
    private final LocalBluetoothManager mLocalManager;
    private final IntentFilter mIntentFilter;
    private final BroadcastReceiver mReceiver = new BroadcastReceiver(){

        public void onReceive(Context context, Intent intent) {
            int state = intent.getIntExtra("android.bluetooth.adapter.extra.STATE", Integer.MIN_VALUE);
            BluetoothEnabler.this.handleStateChanged(state);
        }
    };

    public BluetoothEnabler(Context context, CheckBoxPreference checkBox) {
        this.mContext = context;
        this.mCheckBox = checkBox;
        this.mOriginalSummary = checkBox.getSummary();
        checkBox.setPersistent(false);
        this.mLocalManager = LocalBluetoothManager.getInstance(context);
        if (this.mLocalManager == null) {
            checkBox.setEnabled(false);
        }
        this.mIntentFilter = new IntentFilter("android.bluetooth.adapter.action.STATE_CHANGED");
    }

    public void resume() {
        if (this.mLocalManager == null) {
            return;
        }
        this.handleStateChanged(this.mLocalManager.getBluetoothState());
        this.mContext.registerReceiver(this.mReceiver, this.mIntentFilter);
        this.mCheckBox.setOnPreferenceChangeListener((Preference.OnPreferenceChangeListener)this);
    }

    public void pause() {
        if (this.mLocalManager == null) {
            return;
        }
        this.mContext.unregisterReceiver(this.mReceiver);
        this.mCheckBox.setOnPreferenceChangeListener(null);
    }

    public boolean onPreferenceChange(Preference preference, Object value) {
        boolean enable = (Boolean)value;
        if (enable && !WirelessSettings.isRadioAllowed(this.mContext, "bluetooth")) {
            Toast.makeText((Context)this.mContext, (int)2131231059, (int)0).show();
            return false;
        }
        this.mLocalManager.setBluetoothEnabled(enable);
        this.mCheckBox.setEnabled(false);
        return false;
    }

    private void handleStateChanged(int state) {
        switch (state) {
            case 11: {
                this.mCheckBox.setSummary(2131231056);
                this.mCheckBox.setEnabled(false);
                break;
            }
            case 12: {
                this.mCheckBox.setChecked(true);
                this.mCheckBox.setSummary(null);
                this.mCheckBox.setEnabled(true);
                break;
            }
            case 13: {
                this.mCheckBox.setSummary(2131231057);
                this.mCheckBox.setEnabled(false);
                break;
            }
            case 10: {
                this.mCheckBox.setChecked(false);
                this.mCheckBox.setSummary(this.mOriginalSummary);
                this.mCheckBox.setEnabled(true);
                break;
            }
            default: {
                this.mCheckBox.setChecked(false);
                this.mCheckBox.setSummary(2131231058);
                this.mCheckBox.setEnabled(true);
            }
        }
    }
}

