/*
 * Decompiled with CFR 0.152.
 */
package com.android.settings.bluetooth;

import android.bluetooth.BluetoothAdapter;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.SharedPreferences;
import android.os.Handler;
import android.os.SystemProperties;
import android.preference.CheckBoxPreference;
import android.preference.ListPreference;
import android.preference.Preference;
import com.android.settings.bluetooth.LocalBluetoothManager;

public class BluetoothDiscoverableEnabler
implements Preference.OnPreferenceChangeListener {
    private static final String TAG = "BluetoothDiscoverableEnabler";
    private static final String SYSTEM_PROPERTY_DISCOVERABLE_TIMEOUT = "debug.bt.discoverable_time";
    static final int DISCOVERABLE_TIMEOUT_TWO_MINUTES = 120;
    static final int DISCOVERABLE_TIMEOUT_FIVE_MINUTES = 300;
    static final int DISCOVERABLE_TIMEOUT_ONE_HOUR = 3600;
    static final int DISCOVERABLE_TIMEOUT_NEVER = 0;
    static final String SHARED_PREFERENCES_KEY_DISCOVERABLE_END_TIMESTAMP = "discoverable_end_timestamp";
    private static final String VALUE_DISCOVERABLE_TIMEOUT_TWO_MINUTES = "twomin";
    private static final String VALUE_DISCOVERABLE_TIMEOUT_FIVE_MINUTES = "fivemin";
    private static final String VALUE_DISCOVERABLE_TIMEOUT_ONE_HOUR = "onehour";
    private static final String VALUE_DISCOVERABLE_TIMEOUT_NEVER = "never";
    static final int DEFAULT_DISCOVERABLE_TIMEOUT = 120;
    private final Context mContext;
    private final Handler mUiHandler;
    private final CheckBoxPreference mCheckBoxPreference;
    private final ListPreference mTimeoutListPreference;
    private final LocalBluetoothManager mLocalManager;
    private final BroadcastReceiver mReceiver = new BroadcastReceiver(){

        public void onReceive(Context context, Intent intent) {
            int mode;
            if ("android.bluetooth.adapter.action.SCAN_MODE_CHANGED".equals(intent.getAction()) && (mode = intent.getIntExtra("android.bluetooth.adapter.extra.SCAN_MODE", Integer.MIN_VALUE)) != Integer.MIN_VALUE) {
                BluetoothDiscoverableEnabler.this.handleModeChanged(mode);
            }
        }
    };
    private final Runnable mUpdateCountdownSummaryRunnable = new Runnable(){

        public void run() {
            BluetoothDiscoverableEnabler.this.updateCountdownSummary();
        }
    };

    public BluetoothDiscoverableEnabler(Context context, CheckBoxPreference checkBoxPreference, ListPreference timeoutListPreference) {
        this.mContext = context;
        this.mUiHandler = new Handler();
        this.mCheckBoxPreference = checkBoxPreference;
        this.mTimeoutListPreference = timeoutListPreference;
        checkBoxPreference.setPersistent(false);
        this.mTimeoutListPreference.setPersistent(true);
        this.mLocalManager = LocalBluetoothManager.getInstance(context);
        if (this.mLocalManager == null) {
            checkBoxPreference.setEnabled(false);
        }
    }

    public void resume() {
        if (this.mLocalManager == null) {
            return;
        }
        IntentFilter filter = new IntentFilter("android.bluetooth.adapter.action.SCAN_MODE_CHANGED");
        this.mContext.registerReceiver(this.mReceiver, filter);
        this.mCheckBoxPreference.setOnPreferenceChangeListener((Preference.OnPreferenceChangeListener)this);
        this.mTimeoutListPreference.setOnPreferenceChangeListener((Preference.OnPreferenceChangeListener)this);
        this.handleModeChanged(this.mLocalManager.getBluetoothAdapter().getScanMode());
    }

    public void pause() {
        if (this.mLocalManager == null) {
            return;
        }
        this.mUiHandler.removeCallbacks(this.mUpdateCountdownSummaryRunnable);
        this.mCheckBoxPreference.setOnPreferenceChangeListener(null);
        this.mTimeoutListPreference.setOnPreferenceChangeListener(null);
        this.mContext.unregisterReceiver(this.mReceiver);
    }

    public boolean onPreferenceChange(Preference preference, Object value) {
        if (preference == this.mCheckBoxPreference) {
            this.setEnabled((Boolean)value);
        } else if (preference == this.mTimeoutListPreference) {
            this.mTimeoutListPreference.setValue((String)value);
            this.setEnabled(true);
        }
        return true;
    }

    private void setEnabled(boolean enable) {
        BluetoothAdapter manager = this.mLocalManager.getBluetoothAdapter();
        if (enable) {
            int timeout = this.getDiscoverableTimeout();
            manager.setDiscoverableTimeout(timeout);
            long endTimestamp = System.currentTimeMillis() + (long)timeout * 1000L;
            this.persistDiscoverableEndTimestamp(endTimestamp);
            this.updateCountdownSummary();
            manager.setScanMode(23, timeout);
        } else {
            manager.setScanMode(21);
        }
    }

    private void updateTimerDisplay(int timeout) {
        if (this.getDiscoverableTimeout() == 0) {
            this.mCheckBoxPreference.setSummaryOn((CharSequence)this.mContext.getResources().getString(2131230794));
        } else {
            this.mCheckBoxPreference.setSummaryOn((CharSequence)this.mContext.getResources().getString(2131230793, new Object[]{timeout}));
        }
    }

    private int getDiscoverableTimeout() {
        int timeout = SystemProperties.getInt((String)SYSTEM_PROPERTY_DISCOVERABLE_TIMEOUT, (int)-1);
        if (timeout < 0) {
            String timeoutValue = null;
            if (this.mTimeoutListPreference == null || this.mTimeoutListPreference.getValue() == null) {
                this.mTimeoutListPreference.setValue(VALUE_DISCOVERABLE_TIMEOUT_TWO_MINUTES);
                return 120;
            }
            timeoutValue = this.mTimeoutListPreference.getValue().toString();
            timeout = timeoutValue.equals(VALUE_DISCOVERABLE_TIMEOUT_NEVER) ? 0 : (timeoutValue.equals(VALUE_DISCOVERABLE_TIMEOUT_ONE_HOUR) ? 3600 : (timeoutValue.equals(VALUE_DISCOVERABLE_TIMEOUT_FIVE_MINUTES) ? 300 : 120));
        }
        return timeout;
    }

    private void persistDiscoverableEndTimestamp(long endTimestamp) {
        SharedPreferences.Editor editor = this.mLocalManager.getSharedPreferences().edit();
        editor.putLong(SHARED_PREFERENCES_KEY_DISCOVERABLE_END_TIMESTAMP, endTimestamp);
        editor.apply();
    }

    private void handleModeChanged(int mode) {
        if (mode == 23) {
            this.mCheckBoxPreference.setChecked(true);
            this.updateCountdownSummary();
        } else {
            this.mCheckBoxPreference.setChecked(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateCountdownSummary() {
        long endTimestamp;
        int mode = this.mLocalManager.getBluetoothAdapter().getScanMode();
        if (mode != 23) {
            return;
        }
        long currentTimestamp = System.currentTimeMillis();
        if (currentTimestamp > (endTimestamp = this.mLocalManager.getSharedPreferences().getLong(SHARED_PREFERENCES_KEY_DISCOVERABLE_END_TIMESTAMP, 0L))) {
            this.mCheckBoxPreference.setSummaryOn(null);
            return;
        }
        int timeLeft = (int)((endTimestamp - currentTimestamp) / 1000L);
        this.updateTimerDisplay(timeLeft);
        BluetoothDiscoverableEnabler bluetoothDiscoverableEnabler = this;
        synchronized (bluetoothDiscoverableEnabler) {
            this.mUiHandler.removeCallbacks(this.mUpdateCountdownSummaryRunnable);
            this.mUiHandler.postDelayed(this.mUpdateCountdownSummaryRunnable, 1000L);
        }
    }
}

