/*
 * Decompiled with CFR 0.152.
 */
package com.android.settings.bluetooth;

import android.content.Context;
import android.preference.Preference;
import android.util.TypedValue;
import android.view.View;
import android.widget.ImageView;
import com.android.settings.bluetooth.CachedBluetoothDevice;

public class BluetoothDevicePreference
extends Preference
implements CachedBluetoothDevice.Callback {
    private static final String TAG = "BluetoothDevicePreference";
    private static int sDimAlpha = Integer.MIN_VALUE;
    private CachedBluetoothDevice mCachedDevice;
    private boolean mIsBusy;

    public BluetoothDevicePreference(Context context, CachedBluetoothDevice cachedDevice) {
        super(context);
        if (sDimAlpha == Integer.MIN_VALUE) {
            TypedValue outValue = new TypedValue();
            context.getTheme().resolveAttribute(0x1010033, outValue, true);
            sDimAlpha = (int)(outValue.getFloat() * 255.0f);
        }
        this.mCachedDevice = cachedDevice;
        this.setLayoutResource(2130903081);
        cachedDevice.registerCallback(this);
        this.onDeviceAttributesChanged(cachedDevice);
    }

    public CachedBluetoothDevice getCachedDevice() {
        return this.mCachedDevice;
    }

    protected void onPrepareForRemoval() {
        super.onPrepareForRemoval();
        this.mCachedDevice.unregisterCallback(this);
    }

    public void onDeviceAttributesChanged(CachedBluetoothDevice cachedDevice) {
        this.setTitle(this.mCachedDevice.getName());
        this.setSummary(this.mCachedDevice.getSummary());
        this.mIsBusy = this.mCachedDevice.isBusy();
        this.notifyChanged();
        this.notifyHierarchyChanged();
    }

    public boolean isEnabled() {
        this.setEnabled(true);
        return super.isEnabled() && !this.mIsBusy;
    }

    protected void onBindView(View view) {
        if (null != this.findPreferenceInHierarchy("bt_checkbox")) {
            this.setDependency("bt_checkbox");
        }
        super.onBindView(view);
        ImageView btClass = (ImageView)view.findViewById(2131427445);
        btClass.setImageResource(this.mCachedDevice.getBtClassDrawable());
        btClass.setAlpha(this.isEnabled() ? 255 : sDimAlpha);
    }

    public int compareTo(Preference another) {
        if (!(another instanceof BluetoothDevicePreference)) {
            return 1;
        }
        return this.mCachedDevice.compareTo(((BluetoothDevicePreference)another).mCachedDevice);
    }
}

