/*
 * Decompiled with CFR 0.152.
 */
package com.android.settings.applications;

import android.app.ActivityManager;
import android.app.ActivityManagerNative;
import android.content.ComponentName;
import android.content.Context;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageInfo;
import android.content.pm.PackageItemInfo;
import android.content.pm.PackageManager;
import android.content.pm.ServiceInfo;
import android.content.res.Resources;
import android.os.Debug;
import android.os.Handler;
import android.os.HandlerThread;
import android.os.Looper;
import android.os.Message;
import android.os.RemoteException;
import android.text.format.Formatter;
import android.util.Log;
import android.util.SparseArray;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RunningState {
    static Object sGlobalLock = new Object();
    static RunningState sInstance;
    static final int MSG_UPDATE_CONTENTS = 1;
    static final int MSG_REFRESH_UI = 2;
    static final int MSG_UPDATE_TIME = 3;
    static final long TIME_UPDATE_DELAY = 1000L;
    static final long CONTENTS_UPDATE_DELAY = 2000L;
    static final int MAX_SERVICES = 100;
    final Context mApplicationContext;
    final ActivityManager mAm;
    final PackageManager mPm;
    OnRefreshUiListener mRefreshUiListener;
    final SparseArray<HashMap<String, ProcessItem>> mServiceProcessesByName = new SparseArray();
    final SparseArray<ProcessItem> mServiceProcessesByPid = new SparseArray();
    final ServiceProcessComparator mServiceProcessComparator = new ServiceProcessComparator();
    final ArrayList<ProcessItem> mInterestingProcesses = new ArrayList();
    final SparseArray<ProcessItem> mRunningProcesses = new SparseArray();
    final ArrayList<ProcessItem> mProcessItems = new ArrayList();
    final ArrayList<ProcessItem> mAllProcessItems = new ArrayList();
    int mSequence = 0;
    final Object mLock = new Object();
    boolean mResumed;
    boolean mHaveData;
    boolean mWatchingBackgroundItems;
    ArrayList<BaseItem> mItems = new ArrayList();
    ArrayList<MergedItem> mMergedItems = new ArrayList();
    ArrayList<MergedItem> mBackgroundItems = new ArrayList();
    int mNumBackgroundProcesses;
    long mBackgroundProcessMemory;
    int mNumForegroundProcesses;
    long mForegroundProcessMemory;
    int mNumServiceProcesses;
    long mServiceProcessMemory;
    final HandlerThread mBackgroundThread;
    final BackgroundHandler mBackgroundHandler;
    final Handler mHandler = new Handler(){
        int mNextUpdate = 0;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void handleMessage(Message msg) {
            switch (msg.what) {
                case 2: {
                    this.mNextUpdate = msg.arg1 != 0 ? 2 : 1;
                    break;
                }
                case 3: {
                    Object object = RunningState.this.mLock;
                    synchronized (object) {
                        if (!RunningState.this.mResumed) {
                            return;
                        }
                    }
                    this.removeMessages(3);
                    Message m = this.obtainMessage(3);
                    this.sendMessageDelayed(m, 1000L);
                    if (RunningState.this.mRefreshUiListener == null) break;
                    RunningState.this.mRefreshUiListener.onRefreshUi(this.mNextUpdate);
                    this.mNextUpdate = 0;
                }
            }
        }
    };

    static CharSequence makeLabel(PackageManager pm, String className, PackageItemInfo item) {
        CharSequence label;
        if (item != null && (item.labelRes != 0 || item.nonLocalizedLabel != null) && (label = item.loadLabel(pm)) != null) {
            return label;
        }
        label = className;
        int tail = ((String)label).lastIndexOf(46);
        if (tail >= 0) {
            label = ((String)label).substring(tail + 1, ((String)label).length());
        }
        return label;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static RunningState getInstance(Context context) {
        Object object = sGlobalLock;
        synchronized (object) {
            if (sInstance == null) {
                sInstance = new RunningState(context);
            }
            return sInstance;
        }
    }

    private RunningState(Context context) {
        this.mApplicationContext = context.getApplicationContext();
        this.mAm = (ActivityManager)this.mApplicationContext.getSystemService("activity");
        this.mPm = this.mApplicationContext.getPackageManager();
        this.mResumed = false;
        this.mBackgroundThread = new HandlerThread("RunningState:Background");
        this.mBackgroundThread.start();
        this.mBackgroundHandler = new BackgroundHandler(this.mBackgroundThread.getLooper());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void resume(OnRefreshUiListener listener) {
        Object object = this.mLock;
        synchronized (object) {
            this.mResumed = true;
            this.mRefreshUiListener = listener;
            if (!this.mBackgroundHandler.hasMessages(1)) {
                this.mBackgroundHandler.sendEmptyMessage(1);
            }
            this.mHandler.sendEmptyMessage(3);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void updateNow() {
        Object object = this.mLock;
        synchronized (object) {
            this.mBackgroundHandler.removeMessages(1);
            this.mBackgroundHandler.sendEmptyMessage(1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean hasData() {
        Object object = this.mLock;
        synchronized (object) {
            return this.mHaveData;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void waitForData() {
        Object object = this.mLock;
        synchronized (object) {
            while (!this.mHaveData) {
                try {
                    this.mLock.wait(0L);
                }
                catch (InterruptedException interruptedException) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void pause() {
        Object object = this.mLock;
        synchronized (object) {
            this.mResumed = false;
            this.mRefreshUiListener = null;
            this.mHandler.removeMessages(3);
        }
    }

    private boolean isInterestingProcess(ActivityManager.RunningAppProcessInfo pi) {
        if ((pi.flags & 1) != 0) {
            return true;
        }
        return (pi.flags & 2) == 0 && pi.importance == 100 && pi.importanceReasonCode == 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean update(Context context, ActivityManager am) {
        ProcessItem proc;
        int i;
        PackageManager pm = context.getPackageManager();
        ++this.mSequence;
        boolean changed = false;
        List services = am.getRunningServices(100);
        int NS = services != null ? services.size() : 0;
        for (int i2 = 0; i2 < NS; ++i2) {
            ProcessItem proc2;
            ActivityManager.RunningServiceInfo si = (ActivityManager.RunningServiceInfo)services.get(i2);
            if (!si.started && si.clientLabel == 0 || (si.flags & 8) != 0) continue;
            HashMap<String, ProcessItem> procs = (HashMap<String, ProcessItem>)this.mServiceProcessesByName.get(si.uid);
            if (procs == null) {
                procs = new HashMap<String, ProcessItem>();
                this.mServiceProcessesByName.put(si.uid, procs);
            }
            if ((proc2 = (ProcessItem)procs.get(si.process)) == null) {
                changed = true;
                proc2 = new ProcessItem(context, si.uid, si.process);
                procs.put(si.process, proc2);
            }
            if (proc2.mCurSeq != this.mSequence) {
                int pid;
                int n = pid = si.restarting == 0L ? si.pid : 0;
                if (pid != proc2.mPid) {
                    changed = true;
                    if (proc2.mPid != pid) {
                        if (proc2.mPid != 0) {
                            this.mServiceProcessesByPid.remove(proc2.mPid);
                        }
                        if (pid != 0) {
                            this.mServiceProcessesByPid.put(pid, (Object)proc2);
                        }
                        proc2.mPid = pid;
                    }
                }
                proc2.mDependentProcesses.clear();
                proc2.mCurSeq = this.mSequence;
            }
            changed |= proc2.updateService(context, si);
        }
        List processes = am.getRunningAppProcesses();
        int NP = processes != null ? processes.size() : 0;
        for (int i3 = 0; i3 < NP; ++i3) {
            ActivityManager.RunningAppProcessInfo pi = (ActivityManager.RunningAppProcessInfo)processes.get(i3);
            ProcessItem proc3 = (ProcessItem)this.mServiceProcessesByPid.get(pi.pid);
            if (proc3 == null) {
                proc3 = (ProcessItem)this.mRunningProcesses.get(pi.pid);
                if (proc3 == null) {
                    changed = true;
                    proc3 = new ProcessItem(context, pi.uid, pi.processName);
                    proc3.mPid = pi.pid;
                    this.mRunningProcesses.put(pi.pid, (Object)proc3);
                }
                proc3.mDependentProcesses.clear();
            }
            if (this.isInterestingProcess(pi)) {
                if (!this.mInterestingProcesses.contains(proc3)) {
                    changed = true;
                    this.mInterestingProcesses.add(proc3);
                }
                proc3.mCurSeq = this.mSequence;
                proc3.ensureLabel(pm);
            }
            proc3.mRunningSeq = this.mSequence;
            proc3.mRunningProcessInfo = pi;
        }
        int NRP = this.mRunningProcesses.size();
        for (int i4 = 0; i4 < NRP; ++i4) {
            ProcessItem proc4 = (ProcessItem)this.mRunningProcesses.valueAt(i4);
            if (proc4.mRunningSeq == this.mSequence) {
                int clientPid = proc4.mRunningProcessInfo.importanceReasonPid;
                if (clientPid != 0) {
                    ProcessItem client = (ProcessItem)this.mServiceProcessesByPid.get(clientPid);
                    if (client == null) {
                        client = (ProcessItem)this.mRunningProcesses.get(clientPid);
                    }
                    if (client == null) continue;
                    client.mDependentProcesses.put(proc4.mPid, (Object)proc4);
                    continue;
                }
                proc4.mClient = null;
                continue;
            }
            changed = true;
            this.mRunningProcesses.remove(this.mRunningProcesses.keyAt(i4));
        }
        int NHP = this.mInterestingProcesses.size();
        for (int i5 = 0; i5 < NHP; ++i5) {
            ProcessItem proc5 = this.mInterestingProcesses.get(i5);
            if (this.mRunningProcesses.get(proc5.mPid) != null) continue;
            changed = true;
            this.mInterestingProcesses.remove(i5);
            --i5;
            --NHP;
        }
        int NAP = this.mServiceProcessesByPid.size();
        for (i = 0; i < NAP; ++i) {
            ProcessItem proc6 = (ProcessItem)this.mServiceProcessesByPid.valueAt(i);
            if (proc6.mCurSeq != this.mSequence) continue;
            changed |= proc6.buildDependencyChain(context, pm, this.mSequence);
        }
        for (i = 0; i < this.mServiceProcessesByName.size(); ++i) {
            HashMap procs = (HashMap)this.mServiceProcessesByName.valueAt(i);
            Iterator pit = procs.values().iterator();
            while (pit.hasNext()) {
                ProcessItem pi = (ProcessItem)pit.next();
                if (pi.mCurSeq == this.mSequence) {
                    pi.ensureLabel(pm);
                    if (pi.mPid == 0) {
                        pi.mDependentProcesses.clear();
                    }
                } else {
                    changed = true;
                    pit.remove();
                    if (procs.size() == 0) {
                        this.mServiceProcessesByName.remove(this.mServiceProcessesByName.keyAt(i));
                    }
                    if (pi.mPid == 0) continue;
                    this.mServiceProcessesByPid.remove(pi.mPid);
                    continue;
                }
                Iterator<ServiceItem> sit = pi.mServices.values().iterator();
                while (sit.hasNext()) {
                    ServiceItem si = sit.next();
                    if (si.mCurSeq == this.mSequence) continue;
                    changed = true;
                    sit.remove();
                }
            }
        }
        if (changed) {
            int i6;
            ArrayList<ProcessItem> sortedProcesses = new ArrayList<ProcessItem>();
            for (int i7 = 0; i7 < this.mServiceProcessesByName.size(); ++i7) {
                for (ProcessItem pi : ((HashMap)this.mServiceProcessesByName.valueAt(i7)).values()) {
                    pi.mIsSystem = false;
                    pi.mIsStarted = true;
                    pi.mActiveSince = Long.MAX_VALUE;
                    for (ServiceItem si : pi.mServices.values()) {
                        if (si.mServiceInfo != null && (si.mServiceInfo.applicationInfo.flags & 1) != 0) {
                            pi.mIsSystem = true;
                        }
                        if (si.mRunningService == null || si.mRunningService.clientLabel == 0) continue;
                        pi.mIsStarted = false;
                        if (pi.mActiveSince <= si.mRunningService.activeSince) continue;
                        pi.mActiveSince = si.mRunningService.activeSince;
                    }
                    sortedProcesses.add(pi);
                }
            }
            Collections.sort(sortedProcesses, this.mServiceProcessComparator);
            ArrayList<BaseItem> newItems = new ArrayList<BaseItem>();
            ArrayList<MergedItem> newMergedItems = new ArrayList<MergedItem>();
            this.mProcessItems.clear();
            for (i6 = 0; i6 < sortedProcesses.size(); ++i6) {
                ProcessItem pi = (ProcessItem)sortedProcesses.get(i6);
                pi.mNeedDivider = false;
                int firstProc = this.mProcessItems.size();
                pi.addDependentProcesses(newItems, this.mProcessItems);
                newItems.add(pi);
                if (pi.mPid > 0) {
                    this.mProcessItems.add(pi);
                }
                MergedItem mergedItem = null;
                boolean haveAllMerged = false;
                boolean needDivider = false;
                for (ServiceItem si : pi.mServices.values()) {
                    si.mNeedDivider = needDivider;
                    needDivider = true;
                    newItems.add(si);
                    if (si.mMergedItem != null) {
                        if (mergedItem != null && mergedItem != si.mMergedItem) {
                            haveAllMerged = false;
                        }
                        mergedItem = si.mMergedItem;
                        continue;
                    }
                    haveAllMerged = false;
                }
                if (!haveAllMerged || mergedItem == null || mergedItem.mServices.size() != pi.mServices.size()) {
                    mergedItem = new MergedItem();
                    for (ServiceItem si : pi.mServices.values()) {
                        mergedItem.mServices.add(si);
                        si.mMergedItem = mergedItem;
                    }
                    mergedItem.mProcess = pi;
                    mergedItem.mOtherProcesses.clear();
                    for (int mpi = firstProc; mpi < this.mProcessItems.size() - 1; ++mpi) {
                        mergedItem.mOtherProcesses.add(this.mProcessItems.get(mpi));
                    }
                }
                mergedItem.update(context, false);
                newMergedItems.add(mergedItem);
            }
            NHP = this.mInterestingProcesses.size();
            for (i6 = 0; i6 < NHP; ++i6) {
                proc = this.mInterestingProcesses.get(i6);
                if (proc.mClient != null || proc.mServices.size() > 0) continue;
                if (proc.mMergedItem == null) {
                    proc.mMergedItem = new MergedItem();
                    proc.mMergedItem.mProcess = proc;
                }
                proc.mMergedItem.update(context, false);
                newMergedItems.add(0, proc.mMergedItem);
                this.mProcessItems.add(proc);
            }
            Object i8 = this.mLock;
            synchronized (i8) {
                this.mItems = newItems;
                this.mMergedItems = newMergedItems;
            }
        }
        this.mAllProcessItems.clear();
        this.mAllProcessItems.addAll(this.mProcessItems);
        int numBackgroundProcesses = 0;
        int numForegroundProcesses = 0;
        int numServiceProcesses = 0;
        NRP = this.mRunningProcesses.size();
        for (int i9 = 0; i9 < NRP; ++i9) {
            proc = (ProcessItem)this.mRunningProcesses.valueAt(i9);
            if (proc.mCurSeq != this.mSequence) {
                if (proc.mRunningProcessInfo.importance >= 400) {
                    ++numBackgroundProcesses;
                    this.mAllProcessItems.add(proc);
                    continue;
                }
                if (proc.mRunningProcessInfo.importance <= 200) {
                    ++numForegroundProcesses;
                    this.mAllProcessItems.add(proc);
                    continue;
                }
                Log.i((String)"RunningState", (String)("Unknown non-service process: " + proc.mProcessName + " #" + proc.mPid));
                continue;
            }
            ++numServiceProcesses;
        }
        long backgroundProcessMemory = 0L;
        long foregroundProcessMemory = 0L;
        long serviceProcessMemory = 0L;
        ArrayList<MergedItem> newBackgroundItems = null;
        try {
            int numProc = this.mAllProcessItems.size();
            int[] pids = new int[numProc];
            for (int i10 = 0; i10 < numProc; ++i10) {
                pids[i10] = this.mAllProcessItems.get((int)i10).mPid;
            }
            Debug.MemoryInfo[] mem = ActivityManagerNative.getDefault().getProcessMemoryInfo(pids);
            int bgIndex = 0;
            for (int i11 = 0; i11 < pids.length; ++i11) {
                ProcessItem proc7 = this.mAllProcessItems.get(i11);
                changed |= proc7.updateSize(context, mem[i11], this.mSequence);
                if (proc7.mCurSeq == this.mSequence) {
                    serviceProcessMemory += proc7.mSize;
                    continue;
                }
                if (proc7.mRunningProcessInfo.importance >= 400) {
                    MergedItem mergedItem;
                    backgroundProcessMemory += proc7.mSize;
                    if (newBackgroundItems != null) {
                        mergedItem = proc7.mMergedItem = new MergedItem();
                        proc7.mMergedItem.mProcess = proc7;
                        newBackgroundItems.add(mergedItem);
                    } else if (bgIndex >= this.mBackgroundItems.size() || this.mBackgroundItems.get((int)bgIndex).mProcess != proc7) {
                        newBackgroundItems = new ArrayList(numBackgroundProcesses);
                        for (int bgi = 0; bgi < bgIndex; ++bgi) {
                            newBackgroundItems.add(this.mBackgroundItems.get(bgi));
                        }
                        mergedItem = proc7.mMergedItem = new MergedItem();
                        proc7.mMergedItem.mProcess = proc7;
                        newBackgroundItems.add(mergedItem);
                    } else {
                        mergedItem = this.mBackgroundItems.get(bgIndex);
                    }
                    mergedItem.update(context, true);
                    mergedItem.updateSize(context);
                    ++bgIndex;
                    continue;
                }
                if (proc7.mRunningProcessInfo.importance > 200) continue;
                foregroundProcessMemory += proc7.mSize;
            }
        }
        catch (RemoteException e) {
            // empty catch block
        }
        if (newBackgroundItems == null && this.mBackgroundItems.size() > numBackgroundProcesses) {
            newBackgroundItems = new ArrayList<MergedItem>(numBackgroundProcesses);
            for (int bgi = 0; bgi < numBackgroundProcesses; ++bgi) {
                newBackgroundItems.add(this.mBackgroundItems.get(bgi));
            }
        }
        for (int i12 = 0; i12 < this.mMergedItems.size(); ++i12) {
            this.mMergedItems.get(i12).updateSize(context);
        }
        Object object = this.mLock;
        synchronized (object) {
            this.mNumBackgroundProcesses = numBackgroundProcesses;
            this.mNumForegroundProcesses = numForegroundProcesses;
            this.mNumServiceProcesses = numServiceProcesses;
            this.mBackgroundProcessMemory = backgroundProcessMemory;
            this.mForegroundProcessMemory = foregroundProcessMemory;
            this.mServiceProcessMemory = serviceProcessMemory;
            if (newBackgroundItems != null) {
                this.mBackgroundItems = newBackgroundItems;
                if (this.mWatchingBackgroundItems) {
                    changed = true;
                }
            }
            if (!this.mHaveData) {
                this.mHaveData = true;
                this.mLock.notifyAll();
            }
        }
        return changed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ArrayList<BaseItem> getCurrentItems() {
        Object object = this.mLock;
        synchronized (object) {
            return this.mItems;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setWatchingBackgroundItems(boolean watching) {
        Object object = this.mLock;
        synchronized (object) {
            this.mWatchingBackgroundItems = watching;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ArrayList<MergedItem> getCurrentMergedItems() {
        Object object = this.mLock;
        synchronized (object) {
            return this.mMergedItems;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ArrayList<MergedItem> getCurrentBackgroundItems() {
        Object object = this.mLock;
        synchronized (object) {
            return this.mBackgroundItems;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class ServiceProcessComparator
    implements Comparator<ProcessItem> {
        ServiceProcessComparator() {
        }

        @Override
        public int compare(ProcessItem object1, ProcessItem object2) {
            if (object1.mIsStarted != object2.mIsStarted) {
                return object1.mIsStarted ? -1 : 1;
            }
            if (object1.mIsSystem != object2.mIsSystem) {
                return object1.mIsSystem ? 1 : -1;
            }
            if (object1.mActiveSince != object2.mActiveSince) {
                return object1.mActiveSince > object2.mActiveSince ? -1 : 1;
            }
            return 0;
        }
    }

    static class MergedItem
    extends BaseItem {
        ProcessItem mProcess;
        final ArrayList<ProcessItem> mOtherProcesses = new ArrayList();
        final ArrayList<ServiceItem> mServices = new ArrayList();
        private int mLastNumProcesses = -1;
        private int mLastNumServices = -1;

        MergedItem() {
            super(false);
        }

        boolean update(Context context, boolean background) {
            this.mPackageInfo = this.mProcess.mPackageInfo;
            this.mDisplayLabel = this.mProcess.mDisplayLabel;
            this.mLabel = this.mProcess.mLabel;
            this.mBackground = background;
            if (!this.mBackground) {
                int numProcesses = (this.mProcess.mPid > 0 ? 1 : 0) + this.mOtherProcesses.size();
                int numServices = this.mServices.size();
                if (this.mLastNumProcesses != numProcesses || this.mLastNumServices != numServices) {
                    this.mLastNumProcesses = numProcesses;
                    this.mLastNumServices = numServices;
                    int resid = 2131231525;
                    if (numProcesses != 1) {
                        resid = numServices != 1 ? 2131231528 : 2131231527;
                    } else if (numServices != 1) {
                        resid = 2131231526;
                    }
                    this.mDescription = context.getResources().getString(resid, new Object[]{numProcesses, numServices});
                }
            }
            this.mActiveSince = -1L;
            for (int i = 0; i < this.mServices.size(); ++i) {
                ServiceItem si = this.mServices.get(i);
                if (si.mActiveSince < 0L || this.mActiveSince >= si.mActiveSince) continue;
                this.mActiveSince = si.mActiveSince;
            }
            return false;
        }

        boolean updateSize(Context context) {
            this.mSize = this.mProcess.mSize;
            for (int i = 0; i < this.mOtherProcesses.size(); ++i) {
                this.mSize += this.mOtherProcesses.get((int)i).mSize;
            }
            String sizeStr = Formatter.formatShortFileSize((Context)context, (long)this.mSize);
            if (!sizeStr.equals(this.mSizeStr)) {
                this.mSizeStr = sizeStr;
                return false;
            }
            return false;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class ProcessItem
    extends BaseItem {
        final HashMap<ComponentName, ServiceItem> mServices = new HashMap();
        final SparseArray<ProcessItem> mDependentProcesses = new SparseArray();
        final int mUid;
        final String mProcessName;
        int mPid;
        ProcessItem mClient;
        int mLastNumDependentProcesses;
        int mRunningSeq;
        ActivityManager.RunningAppProcessInfo mRunningProcessInfo;
        MergedItem mMergedItem;
        boolean mIsSystem;
        boolean mIsStarted;
        long mActiveSince;

        public ProcessItem(Context context, int uid, String processName) {
            super(true);
            this.mDescription = context.getResources().getString(2131231524, new Object[]{processName});
            this.mUid = uid;
            this.mProcessName = processName;
        }

        void ensureLabel(PackageManager pm) {
            if (this.mLabel != null) {
                return;
            }
            try {
                ApplicationInfo ai = pm.getApplicationInfo(this.mProcessName, 0);
                if (ai.uid == this.mUid) {
                    this.mDisplayLabel = ai.loadLabel(pm);
                    this.mLabel = ((Object)this.mDisplayLabel).toString();
                    this.mPackageInfo = ai;
                    return;
                }
            }
            catch (PackageManager.NameNotFoundException e) {
                // empty catch block
            }
            String[] pkgs = pm.getPackagesForUid(this.mUid);
            if (pkgs.length == 1) {
                try {
                    ApplicationInfo ai = pm.getApplicationInfo(pkgs[0], 0);
                    this.mDisplayLabel = ai.loadLabel(pm);
                    this.mLabel = ((Object)this.mDisplayLabel).toString();
                    this.mPackageInfo = ai;
                    return;
                }
                catch (PackageManager.NameNotFoundException e) {
                    // empty catch block
                }
            }
            for (String name : pkgs) {
                try {
                    CharSequence nm;
                    PackageInfo pi = pm.getPackageInfo(name, 0);
                    if (pi.sharedUserLabel == 0 || (nm = pm.getText(name, pi.sharedUserLabel, pi.applicationInfo)) == null) continue;
                    this.mDisplayLabel = nm;
                    this.mLabel = ((Object)nm).toString();
                    this.mPackageInfo = pi.applicationInfo;
                    return;
                }
                catch (PackageManager.NameNotFoundException e) {
                    // empty catch block
                }
            }
            if (this.mServices.size() > 0) {
                this.mPackageInfo = this.mServices.values().iterator().next().mServiceInfo.applicationInfo;
                this.mDisplayLabel = this.mPackageInfo.loadLabel(pm);
                this.mLabel = ((Object)this.mDisplayLabel).toString();
                return;
            }
            try {
                ApplicationInfo ai = pm.getApplicationInfo(pkgs[0], 0);
                this.mDisplayLabel = ai.loadLabel(pm);
                this.mLabel = ((Object)this.mDisplayLabel).toString();
                this.mPackageInfo = ai;
                return;
            }
            catch (PackageManager.NameNotFoundException nameNotFoundException) {
                return;
            }
        }

        boolean updateService(Context context, ActivityManager.RunningServiceInfo service) {
            long activeSince;
            PackageManager pm = context.getPackageManager();
            boolean changed = false;
            ServiceItem si = this.mServices.get(service.service);
            if (si == null) {
                changed = true;
                si = new ServiceItem();
                si.mRunningService = service;
                try {
                    si.mServiceInfo = pm.getServiceInfo(service.service, 0);
                }
                catch (PackageManager.NameNotFoundException e) {
                    // empty catch block
                }
                si.mDisplayLabel = RunningState.makeLabel(pm, si.mRunningService.service.getClassName(), (PackageItemInfo)si.mServiceInfo);
                this.mLabel = this.mDisplayLabel != null ? ((Object)this.mDisplayLabel).toString() : null;
                si.mPackageInfo = si.mServiceInfo.applicationInfo;
                this.mServices.put(service.service, si);
            }
            si.mCurSeq = this.mCurSeq;
            si.mRunningService = service;
            long l = activeSince = service.restarting == 0L ? service.activeSince : -1L;
            if (si.mActiveSince != activeSince) {
                si.mActiveSince = activeSince;
                changed = true;
            }
            if (service.clientPackage != null && service.clientLabel != 0) {
                if (si.mShownAsStarted) {
                    si.mShownAsStarted = false;
                    changed = true;
                }
                try {
                    Resources clientr = pm.getResourcesForApplication(service.clientPackage);
                    String label = clientr.getString(service.clientLabel);
                    si.mDescription = context.getResources().getString(2131231520, new Object[]{label});
                }
                catch (PackageManager.NameNotFoundException e) {
                    si.mDescription = null;
                }
            } else {
                if (!si.mShownAsStarted) {
                    si.mShownAsStarted = true;
                    changed = true;
                }
                si.mDescription = context.getResources().getString(2131231519);
            }
            return changed;
        }

        boolean updateSize(Context context, Debug.MemoryInfo mem, int curSeq) {
            String sizeStr;
            this.mSize = (long)mem.getTotalPss() * 1024L;
            if (this.mCurSeq == curSeq && !(sizeStr = Formatter.formatShortFileSize((Context)context, (long)this.mSize)).equals(this.mSizeStr)) {
                this.mSizeStr = sizeStr;
                return false;
            }
            return false;
        }

        boolean buildDependencyChain(Context context, PackageManager pm, int curSeq) {
            int NP = this.mDependentProcesses.size();
            boolean changed = false;
            for (int i = 0; i < NP; ++i) {
                ProcessItem proc = (ProcessItem)this.mDependentProcesses.valueAt(i);
                if (proc.mClient != this) {
                    changed = true;
                    proc.mClient = this;
                }
                proc.mCurSeq = curSeq;
                proc.ensureLabel(pm);
                changed |= proc.buildDependencyChain(context, pm, curSeq);
            }
            if (this.mLastNumDependentProcesses != this.mDependentProcesses.size()) {
                changed = true;
                this.mLastNumDependentProcesses = this.mDependentProcesses.size();
            }
            return changed;
        }

        void addDependentProcesses(ArrayList<BaseItem> dest, ArrayList<ProcessItem> destProc) {
            int NP = this.mDependentProcesses.size();
            for (int i = 0; i < NP; ++i) {
                ProcessItem proc = (ProcessItem)this.mDependentProcesses.valueAt(i);
                proc.addDependentProcesses(dest, destProc);
                dest.add(proc);
                if (proc.mPid <= 0) continue;
                destProc.add(proc);
            }
        }
    }

    static class ServiceItem
    extends BaseItem {
        ActivityManager.RunningServiceInfo mRunningService;
        ServiceInfo mServiceInfo;
        boolean mShownAsStarted;
        MergedItem mMergedItem;

        public ServiceItem() {
            super(false);
        }
    }

    static class BaseItem {
        final boolean mIsProcess;
        PackageItemInfo mPackageInfo;
        CharSequence mDisplayLabel;
        String mLabel;
        String mDescription;
        int mCurSeq;
        long mActiveSince;
        long mSize;
        String mSizeStr;
        String mCurSizeStr;
        boolean mNeedDivider;
        boolean mBackground;

        public BaseItem(boolean isProcess) {
            this.mIsProcess = isProcess;
        }
    }

    static interface OnRefreshUiListener {
        public static final int REFRESH_TIME = 0;
        public static final int REFRESH_DATA = 1;
        public static final int REFRESH_STRUCTURE = 2;

        public void onRefreshUi(int var1);
    }

    final class BackgroundHandler
    extends Handler {
        public BackgroundHandler(Looper looper) {
            super(looper);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void handleMessage(Message msg) {
            switch (msg.what) {
                case 1: {
                    Object object = RunningState.this.mLock;
                    synchronized (object) {
                        if (!RunningState.this.mResumed) {
                            return;
                        }
                    }
                    Message cmd = RunningState.this.mHandler.obtainMessage(2);
                    cmd.arg1 = RunningState.this.update(RunningState.this.mApplicationContext, RunningState.this.mAm) ? 1 : 0;
                    RunningState.this.mHandler.sendMessage(cmd);
                    this.removeMessages(1);
                    msg = this.obtainMessage(1);
                    this.sendMessageDelayed(msg, 2000L);
                }
            }
        }
    }
}

