/*
 * Decompiled with CFR 0.152.
 */
package com.android.settings.applications;

import android.app.Activity;
import android.app.ActivityManager;
import android.app.AlertDialog;
import android.app.ApplicationErrorReport;
import android.app.Dialog;
import android.app.PendingIntent;
import android.content.ActivityNotFoundException;
import android.content.ComponentName;
import android.content.ContentResolver;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.content.IntentSender;
import android.content.pm.PackageItemInfo;
import android.content.pm.PackageManager;
import android.content.pm.ProviderInfo;
import android.content.pm.ServiceInfo;
import android.content.res.Resources;
import android.os.Bundle;
import android.os.Debug;
import android.os.Parcelable;
import android.os.SystemClock;
import android.provider.Settings;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.Button;
import android.widget.TextView;
import com.android.settings.applications.RunningProcessesView;
import com.android.settings.applications.RunningState;
import java.io.File;
import java.io.FileDescriptor;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;

public class RunningServiceDetails
extends Activity
implements RunningState.OnRefreshUiListener {
    static final String TAG = "RunningServicesDetails";
    static final String KEY_UID = "uid";
    static final String KEY_PROCESS = "process";
    static final String KEY_BACKGROUND = "background";
    static final int DIALOG_CONFIRM_STOP = 1;
    ActivityManager mAm;
    LayoutInflater mInflater;
    RunningState mState;
    boolean mHaveData;
    int mUid;
    String mProcessName;
    boolean mShowBackground;
    RunningState.MergedItem mMergedItem;
    ViewGroup mAllDetails;
    ViewGroup mSnippet;
    RunningProcessesView.ActiveItem mSnippetActiveItem;
    RunningProcessesView.ViewHolder mSnippetViewHolder;
    int mNumServices;
    int mNumProcesses;
    TextView mServicesHeader;
    TextView mProcessesHeader;
    final ArrayList<ActiveDetail> mActiveDetails = new ArrayList();
    StringBuilder mBuilder = new StringBuilder(128);

    boolean findMergedItem() {
        ArrayList<RunningState.MergedItem> newItems;
        RunningState.MergedItem item = null;
        ArrayList<RunningState.MergedItem> arrayList = newItems = this.mShowBackground ? this.mState.getCurrentBackgroundItems() : this.mState.getCurrentMergedItems();
        if (newItems != null) {
            for (int i = 0; i < newItems.size(); ++i) {
                RunningState.MergedItem mi = newItems.get(i);
                if (mi.mProcess.mUid != this.mUid || !mi.mProcess.mProcessName.equals(this.mProcessName)) continue;
                item = mi;
                break;
            }
        }
        if (this.mMergedItem != item) {
            this.mMergedItem = item;
            return true;
        }
        return false;
    }

    void addServiceDetailsView(RunningState.ServiceItem si, RunningState.MergedItem mi) {
        if (this.mNumServices == 0) {
            this.mServicesHeader = (TextView)this.mInflater.inflate(2130903097, this.mAllDetails, false);
            this.mServicesHeader.setText(2131231531);
            this.mAllDetails.addView((View)this.mServicesHeader);
        }
        ++this.mNumServices;
        RunningState.BaseItem bi = si != null ? si : mi;
        ActiveDetail detail = new ActiveDetail();
        View root = this.mInflater.inflate(2130903096, this.mAllDetails, false);
        this.mAllDetails.addView(root);
        detail.mRootView = root;
        detail.mServiceItem = si;
        detail.mViewHolder = new RunningProcessesView.ViewHolder(root);
        detail.mActiveItem = detail.mViewHolder.bind(this.mState, bi, this.mBuilder);
        if (si != null && si.mRunningService.clientLabel != 0) {
            detail.mManageIntent = this.mAm.getRunningServiceControlPanel(si.mRunningService.service);
        }
        TextView description = (TextView)root.findViewById(2131427504);
        if (si != null && si.mServiceInfo.descriptionRes != 0) {
            description.setText(this.getPackageManager().getText(si.mServiceInfo.packageName, si.mServiceInfo.descriptionRes, si.mServiceInfo.applicationInfo));
        } else if (mi.mBackground) {
            description.setText(2131231537);
        } else if (detail.mManageIntent != null) {
            try {
                Resources clientr = this.getPackageManager().getResourcesForApplication(si.mRunningService.clientPackage);
                String label = clientr.getString(si.mRunningService.clientLabel);
                description.setText((CharSequence)this.getString(2131231538, new Object[]{label}));
            }
            catch (PackageManager.NameNotFoundException e) {}
        } else {
            description.setText(this.getText(si != null ? 2131231535 : 2131231536));
        }
        detail.mStopButton = (Button)root.findViewById(2131427517);
        detail.mStopButton.setOnClickListener((View.OnClickListener)detail);
        detail.mStopButton.setText(this.getText(detail.mManageIntent != null ? 2131231534 : 2131231533));
        detail.mReportButton = (Button)root.findViewById(2131427518);
        detail.mReportButton.setOnClickListener((View.OnClickListener)detail);
        detail.mReportButton.setText(17040131);
        int enabled = Settings.Secure.getInt((ContentResolver)this.getContentResolver(), (String)"send_action_app_error", (int)0);
        if (enabled != 0 && si != null) {
            detail.mInstaller = ApplicationErrorReport.getErrorReportReceiver((Context)this, (String)si.mServiceInfo.packageName, (int)si.mServiceInfo.applicationInfo.flags);
            detail.mReportButton.setEnabled(detail.mInstaller != null);
        } else {
            detail.mReportButton.setEnabled(false);
        }
        this.mActiveDetails.add(detail);
    }

    void addProcessDetailsView(RunningState.ProcessItem pi, boolean isMain) {
        if (this.mNumProcesses == 0) {
            this.mProcessesHeader = (TextView)this.mInflater.inflate(2130903097, this.mAllDetails, false);
            this.mProcessesHeader.setText(2131231532);
            this.mAllDetails.addView((View)this.mProcessesHeader);
        }
        ++this.mNumProcesses;
        ActiveDetail detail = new ActiveDetail();
        View root = this.mInflater.inflate(2130903095, this.mAllDetails, false);
        this.mAllDetails.addView(root);
        detail.mRootView = root;
        detail.mViewHolder = new RunningProcessesView.ViewHolder(root);
        detail.mActiveItem = detail.mViewHolder.bind(this.mState, pi, this.mBuilder);
        TextView description = (TextView)root.findViewById(2131427504);
        if (isMain) {
            description.setText(2131231539);
        } else {
            int textid = 0;
            CharSequence label = null;
            ActivityManager.RunningAppProcessInfo rpi = pi.mRunningProcessInfo;
            ComponentName comp = rpi.importanceReasonComponent;
            switch (rpi.importanceReasonCode) {
                case 1: {
                    textid = 2131231541;
                    if (rpi.importanceReasonComponent == null) break;
                    try {
                        ProviderInfo prov = this.getPackageManager().getProviderInfo(rpi.importanceReasonComponent, 0);
                        label = RunningState.makeLabel(this.getPackageManager(), prov.name, (PackageItemInfo)prov);
                    }
                    catch (PackageManager.NameNotFoundException e) {}
                    break;
                }
                case 2: {
                    textid = 2131231540;
                    if (rpi.importanceReasonComponent == null) break;
                    try {
                        ServiceInfo serv = this.getPackageManager().getServiceInfo(rpi.importanceReasonComponent, 0);
                        label = RunningState.makeLabel(this.getPackageManager(), serv.name, (PackageItemInfo)serv);
                        break;
                    }
                    catch (PackageManager.NameNotFoundException e) {
                        // empty catch block
                    }
                }
            }
            if (textid != 0 && label != null) {
                description.setText((CharSequence)this.getString(textid, new Object[]{label}));
            }
        }
        this.mActiveDetails.add(detail);
    }

    void addDetailViews() {
        int i;
        for (i = this.mActiveDetails.size() - 1; i >= 0; --i) {
            this.mAllDetails.removeView(this.mActiveDetails.get((int)i).mRootView);
        }
        this.mActiveDetails.clear();
        if (this.mServicesHeader != null) {
            this.mAllDetails.removeView((View)this.mServicesHeader);
            this.mServicesHeader = null;
        }
        if (this.mProcessesHeader != null) {
            this.mAllDetails.removeView((View)this.mProcessesHeader);
            this.mProcessesHeader = null;
        }
        this.mNumProcesses = 0;
        this.mNumServices = 0;
        if (this.mMergedItem != null) {
            for (i = 0; i < this.mMergedItem.mServices.size(); ++i) {
                this.addServiceDetailsView(this.mMergedItem.mServices.get(i), this.mMergedItem);
            }
            if (this.mMergedItem.mServices.size() <= 0) {
                this.addServiceDetailsView(null, this.mMergedItem);
            }
            for (i = -1; i < this.mMergedItem.mOtherProcesses.size(); ++i) {
                RunningState.ProcessItem pi;
                RunningState.ProcessItem processItem = pi = i < 0 ? this.mMergedItem.mProcess : this.mMergedItem.mOtherProcesses.get(i);
                if (pi.mPid <= 0) continue;
                this.addProcessDetailsView(pi, i < 0);
            }
        }
    }

    void refreshUi(boolean dataChanged) {
        if (this.findMergedItem()) {
            dataChanged = true;
        }
        if (dataChanged) {
            if (this.mMergedItem != null) {
                this.mSnippetActiveItem = this.mSnippetViewHolder.bind(this.mState, this.mMergedItem, this.mBuilder);
            } else if (this.mSnippetActiveItem != null) {
                this.mSnippetActiveItem.mHolder.size.setText((CharSequence)"");
                this.mSnippetActiveItem.mHolder.uptime.setText((CharSequence)"");
                this.mSnippetActiveItem.mHolder.description.setText(2131231530);
            } else {
                this.finish();
                return;
            }
            this.addDetailViews();
        }
    }

    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.mUid = this.getIntent().getIntExtra(KEY_UID, 0);
        this.mProcessName = this.getIntent().getStringExtra(KEY_PROCESS);
        this.mShowBackground = this.getIntent().getBooleanExtra(KEY_BACKGROUND, false);
        this.mAm = (ActivityManager)this.getSystemService("activity");
        this.mInflater = (LayoutInflater)this.getSystemService("layout_inflater");
        this.mState = RunningState.getInstance((Context)this);
        this.setContentView(2130903094);
        this.mAllDetails = (ViewGroup)this.findViewById(2131427386);
        this.mSnippet = (ViewGroup)this.findViewById(2131427502);
        this.mSnippet.setBackgroundResource(17302327);
        this.mSnippet.setPadding(0, this.mSnippet.getPaddingTop(), 0, this.mSnippet.getPaddingBottom());
        this.mSnippetViewHolder = new RunningProcessesView.ViewHolder((View)this.mSnippet);
        this.ensureData();
    }

    protected void onPause() {
        super.onPause();
        this.mHaveData = false;
        this.mState.pause();
    }

    protected void onResume() {
        super.onResume();
        this.ensureData();
    }

    protected void onSaveInstanceState(Bundle outState) {
        super.onSaveInstanceState(outState);
    }

    ActiveDetail activeDetailForService(ComponentName comp) {
        for (int i = 0; i < this.mActiveDetails.size(); ++i) {
            ActiveDetail ad = this.mActiveDetails.get(i);
            if (ad.mServiceItem == null || ad.mServiceItem.mRunningService == null || !comp.equals((Object)ad.mServiceItem.mRunningService.service)) continue;
            return ad;
        }
        return null;
    }

    protected Dialog onCreateDialog(int id2, Bundle args) {
        switch (id2) {
            case 1: {
                final ComponentName comp = (ComponentName)args.getParcelable("comp");
                if (this.activeDetailForService(comp) == null) {
                    return null;
                }
                return new AlertDialog.Builder((Context)this).setTitle((CharSequence)this.getString(2131231542)).setIcon(17301543).setMessage((CharSequence)this.getString(2131231543)).setPositiveButton(2131231483, new DialogInterface.OnClickListener(){

                    public void onClick(DialogInterface dialog, int which) {
                        ActiveDetail ad = RunningServiceDetails.this.activeDetailForService(comp);
                        if (ad != null) {
                            ad.stopActiveService(true);
                        }
                    }
                }).setNegativeButton(2131231484, null).create();
            }
        }
        return super.onCreateDialog(id2, args);
    }

    void ensureData() {
        if (!this.mHaveData) {
            this.mHaveData = true;
            this.mState.resume(this);
            this.mState.waitForData();
            this.refreshUi(true);
        }
    }

    void updateTimes() {
        if (this.mSnippetActiveItem != null) {
            this.mSnippetActiveItem.updateTime((Context)this, this.mBuilder);
        }
        for (int i = 0; i < this.mActiveDetails.size(); ++i) {
            this.mActiveDetails.get((int)i).mActiveItem.updateTime((Context)this, this.mBuilder);
        }
    }

    public void onRefreshUi(int what) {
        switch (what) {
            case 0: {
                this.updateTimes();
                break;
            }
            case 1: {
                this.refreshUi(false);
                this.updateTimes();
                break;
            }
            case 2: {
                this.refreshUi(true);
                this.updateTimes();
            }
        }
    }

    class ActiveDetail
    implements View.OnClickListener {
        View mRootView;
        Button mStopButton;
        Button mReportButton;
        RunningState.ServiceItem mServiceItem;
        RunningProcessesView.ActiveItem mActiveItem;
        RunningProcessesView.ViewHolder mViewHolder;
        PendingIntent mManageIntent;
        ComponentName mInstaller;

        ActiveDetail() {
        }

        void stopActiveService(boolean confirmed) {
            RunningState.ServiceItem si = this.mServiceItem;
            if (!confirmed && (si.mServiceInfo.applicationInfo.flags & 1) != 0) {
                Bundle args = new Bundle();
                args.putParcelable("comp", (Parcelable)si.mRunningService.service);
                RunningServiceDetails.this.removeDialog(1);
                RunningServiceDetails.this.showDialog(1, args);
                return;
            }
            RunningServiceDetails.this.stopService(new Intent().setComponent(si.mRunningService.service));
            if (RunningServiceDetails.this.mMergedItem == null) {
                RunningServiceDetails.this.mState.updateNow();
                RunningServiceDetails.this.finish();
            } else if (!RunningServiceDetails.this.mShowBackground && RunningServiceDetails.this.mMergedItem.mServices.size() <= 1) {
                RunningServiceDetails.this.mState.updateNow();
                RunningServiceDetails.this.finish();
            } else {
                RunningServiceDetails.this.mState.updateNow();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onClick(View v) {
            if (v == this.mReportButton) {
                ApplicationErrorReport report = new ApplicationErrorReport();
                report.type = 5;
                report.packageName = this.mServiceItem.mServiceInfo.packageName;
                report.installerPackageName = this.mInstaller.getPackageName();
                report.processName = this.mServiceItem.mRunningService.process;
                report.time = System.currentTimeMillis();
                report.systemApp = (this.mServiceItem.mServiceInfo.applicationInfo.flags & 1) != 0;
                ApplicationErrorReport.RunningServiceInfo info = new ApplicationErrorReport.RunningServiceInfo();
                info.durationMillis = this.mActiveItem.mFirstRunTime >= 0L ? SystemClock.elapsedRealtime() - this.mActiveItem.mFirstRunTime : -1L;
                ComponentName comp = new ComponentName(this.mServiceItem.mServiceInfo.packageName, this.mServiceItem.mServiceInfo.name);
                File filename = RunningServiceDetails.this.getFileStreamPath("service_dump.txt");
                FileOutputStream output = null;
                try {
                    output = new FileOutputStream(filename);
                    Debug.dumpService((String)"activity", (FileDescriptor)output.getFD(), (String[])new String[]{"-a", "service", comp.flattenToString()});
                }
                catch (IOException e) {
                    Log.w((String)RunningServiceDetails.TAG, (String)("Can't dump service: " + comp), (Throwable)e);
                }
                finally {
                    if (output != null) {
                        try {
                            output.close();
                        }
                        catch (IOException e) {}
                    }
                }
                FileInputStream input = null;
                try {
                    input = new FileInputStream(filename);
                    byte[] buffer = new byte[(int)filename.length()];
                    input.read(buffer);
                    info.serviceDetails = new String(buffer);
                }
                catch (IOException e) {
                    Log.w((String)RunningServiceDetails.TAG, (String)("Can't read service dump: " + comp), (Throwable)e);
                }
                finally {
                    if (input != null) {
                        try {
                            input.close();
                        }
                        catch (IOException e) {}
                    }
                }
                filename.delete();
                Log.i((String)RunningServiceDetails.TAG, (String)("Details: " + info.serviceDetails));
                report.runningServiceInfo = info;
                Intent result = new Intent("android.intent.action.APP_ERROR");
                result.setComponent(this.mInstaller);
                result.putExtra("android.intent.extra.BUG_REPORT", (Parcelable)report);
                result.addFlags(0x10000000);
                RunningServiceDetails.this.startActivity(result);
                return;
            }
            if (this.mManageIntent != null) {
                try {
                    RunningServiceDetails.this.startIntentSender(this.mManageIntent.getIntentSender(), null, 0x10080000, 524288, 0);
                }
                catch (IntentSender.SendIntentException e) {
                    Log.w((String)RunningServiceDetails.TAG, (Throwable)e);
                }
                catch (IllegalArgumentException e) {
                    Log.w((String)RunningServiceDetails.TAG, (Throwable)e);
                }
                catch (ActivityNotFoundException e) {
                    Log.w((String)RunningServiceDetails.TAG, (Throwable)e);
                }
            } else if (this.mServiceItem != null) {
                this.stopActiveService(false);
            } else if (this.mActiveItem.mItem.mBackground) {
                RunningServiceDetails.this.mAm.killBackgroundProcesses(this.mActiveItem.mItem.mPackageInfo.packageName);
                RunningServiceDetails.this.finish();
            } else {
                RunningServiceDetails.this.mAm.forceStopPackage(this.mActiveItem.mItem.mPackageInfo.packageName);
                RunningServiceDetails.this.finish();
            }
        }
    }
}

