/*
 * Decompiled with CFR 0.152.
 */
package com.android.settings.applications;

import android.app.ActivityManager;
import android.app.Dialog;
import android.content.Context;
import android.content.Intent;
import android.content.pm.PackageManager;
import android.os.Bundle;
import android.os.SystemClock;
import android.os.SystemProperties;
import android.text.format.DateUtils;
import android.text.format.Formatter;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.AbsListView;
import android.widget.AdapterView;
import android.widget.BaseAdapter;
import android.widget.FrameLayout;
import android.widget.ImageView;
import android.widget.ListAdapter;
import android.widget.ListView;
import android.widget.TextView;
import com.android.settings.applications.LinearColorBar;
import com.android.settings.applications.RunningServiceDetails;
import com.android.settings.applications.RunningState;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RunningProcessesView
extends FrameLayout
implements AdapterView.OnItemClickListener,
AbsListView.RecyclerListener,
RunningState.OnRefreshUiListener {
    static final long PAGE_SIZE = 4096L;
    long SECONDARY_SERVER_MEM;
    final HashMap<View, ActiveItem> mActiveItems = new HashMap();
    ActivityManager mAm;
    RunningState mState;
    Runnable mDataAvail;
    StringBuilder mBuilder = new StringBuilder(128);
    RunningState.BaseItem mCurSelected;
    ListView mListView;
    ServiceListAdapter mAdapter;
    LinearColorBar mColorBar;
    TextView mBackgroundProcessText;
    TextView mForegroundProcessText;
    int mLastNumBackgroundProcesses = -1;
    int mLastNumForegroundProcesses = -1;
    int mLastNumServiceProcesses = -1;
    long mLastBackgroundProcessMemory = -1L;
    long mLastForegroundProcessMemory = -1L;
    long mLastServiceProcessMemory = -1L;
    long mLastAvailMemory = -1L;
    Dialog mCurDialog;
    byte[] mBuffer = new byte[1024];

    private boolean matchText(byte[] buffer, int index, String text) {
        int N = text.length();
        if (index + N >= buffer.length) {
            return false;
        }
        for (int i = 0; i < N; ++i) {
            if (buffer[index + i] == text.charAt(i)) continue;
            return false;
        }
        return true;
    }

    private long extractMemValue(byte[] buffer, int index) {
        while (index < buffer.length && buffer[index] != 10) {
            if (buffer[index] >= 48 && buffer[index] <= 57) {
                int start = index++;
                while (index < buffer.length && buffer[index] >= 48 && buffer[index] <= 57) {
                    ++index;
                }
                String str = new String(buffer, 0, start, index - start);
                return (long)Integer.parseInt(str) * 1024L;
            }
            ++index;
        }
        return 0L;
    }

    private long readAvailMem() {
        try {
            long memFree = 0L;
            long memCached = 0L;
            FileInputStream is = new FileInputStream("/proc/meminfo");
            int len = is.read(this.mBuffer);
            is.close();
            int BUFLEN = this.mBuffer.length;
            for (int i = 0; i < len && (memFree == 0L || memCached == 0L); ++i) {
                if (this.matchText(this.mBuffer, i, "MemFree")) {
                    memFree = this.extractMemValue(this.mBuffer, i += 7);
                } else if (this.matchText(this.mBuffer, i, "Cached")) {
                    memCached = this.extractMemValue(this.mBuffer, i += 6);
                }
                while (i < BUFLEN && this.mBuffer[i] != 10) {
                    ++i;
                }
            }
            return memFree + memCached;
        }
        catch (FileNotFoundException e) {
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return 0L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void refreshUi(boolean dataChanged) {
        long availMem;
        if (dataChanged) {
            ServiceListAdapter adapter = (ServiceListAdapter)this.mListView.getAdapter();
            adapter.refreshItems();
            adapter.notifyDataSetChanged();
        }
        if (this.mDataAvail != null) {
            this.mDataAvail.run();
            this.mDataAvail = null;
        }
        if ((availMem = this.readAvailMem() - this.SECONDARY_SERVER_MEM) < 0L) {
            availMem = 0L;
        }
        Object object = this.mState.mLock;
        synchronized (object) {
            String sizeStr;
            if (this.mLastNumBackgroundProcesses != this.mState.mNumBackgroundProcesses || this.mLastBackgroundProcessMemory != this.mState.mBackgroundProcessMemory || this.mLastAvailMemory != availMem) {
                this.mLastNumBackgroundProcesses = this.mState.mNumBackgroundProcesses;
                this.mLastBackgroundProcessMemory = this.mState.mBackgroundProcessMemory;
                this.mLastAvailMemory = availMem;
                sizeStr = Formatter.formatShortFileSize((Context)this.getContext(), (long)(this.mLastAvailMemory + this.mLastBackgroundProcessMemory));
                this.mBackgroundProcessText.setText((CharSequence)this.getResources().getString(2131231521, new Object[]{sizeStr}));
            }
            if (this.mLastNumForegroundProcesses != this.mState.mNumForegroundProcesses || this.mLastForegroundProcessMemory != this.mState.mForegroundProcessMemory || this.mLastNumServiceProcesses != this.mState.mNumServiceProcesses || this.mLastServiceProcessMemory != this.mState.mServiceProcessMemory) {
                this.mLastNumForegroundProcesses = this.mState.mNumForegroundProcesses;
                this.mLastForegroundProcessMemory = this.mState.mForegroundProcessMemory;
                this.mLastNumServiceProcesses = this.mState.mNumServiceProcesses;
                this.mLastServiceProcessMemory = this.mState.mServiceProcessMemory;
                sizeStr = Formatter.formatShortFileSize((Context)this.getContext(), (long)(this.mLastForegroundProcessMemory + this.mLastServiceProcessMemory));
                this.mForegroundProcessText.setText((CharSequence)this.getResources().getString(2131231522, new Object[]{sizeStr}));
            }
            float totalMem = availMem + this.mLastBackgroundProcessMemory + this.mLastForegroundProcessMemory + this.mLastServiceProcessMemory;
            this.mColorBar.setRatios((float)this.mLastForegroundProcessMemory / totalMem, (float)this.mLastServiceProcessMemory / totalMem, (float)this.mLastBackgroundProcessMemory / totalMem);
        }
    }

    public void onItemClick(AdapterView<?> parent, View v, int position, long id2) {
        ListView l = (ListView)parent;
        RunningState.MergedItem mi = (RunningState.MergedItem)l.getAdapter().getItem(position);
        this.mCurSelected = mi;
        Intent intent = new Intent();
        intent.putExtra("uid", mi.mProcess.mUid);
        intent.putExtra("process", mi.mProcess.mProcessName);
        intent.putExtra("background", this.mAdapter.mShowBackground);
        intent.setClass(this.getContext(), RunningServiceDetails.class);
        this.getContext().startActivity(intent);
    }

    public void onMovedToScrapHeap(View view) {
        this.mActiveItems.remove(view);
    }

    public RunningProcessesView(Context context, AttributeSet attrs) {
        super(context, attrs);
    }

    public void doCreate(Bundle savedInstanceState, Object nonConfigurationInstace) {
        this.mAm = (ActivityManager)this.getContext().getSystemService("activity");
        this.mState = RunningState.getInstance(this.getContext());
        LayoutInflater inflater = (LayoutInflater)this.getContext().getSystemService("layout_inflater");
        inflater.inflate(2130903093, (ViewGroup)this);
        this.mListView = (ListView)this.findViewById(16908298);
        View emptyView = this.findViewById(16908292);
        if (emptyView != null) {
            this.mListView.setEmptyView(emptyView);
        }
        this.mListView.setOnItemClickListener((AdapterView.OnItemClickListener)this);
        this.mListView.setRecyclerListener((AbsListView.RecyclerListener)this);
        this.mAdapter = new ServiceListAdapter(this.mState);
        this.mListView.setAdapter((ListAdapter)this.mAdapter);
        this.mColorBar = (LinearColorBar)this.findViewById(2131427499);
        this.mBackgroundProcessText = (TextView)this.findViewById(2131427501);
        this.mBackgroundProcessText.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                RunningProcessesView.this.mAdapter.setShowBackground(true);
            }
        });
        this.mForegroundProcessText = (TextView)this.findViewById(2131427500);
        this.mForegroundProcessText.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                RunningProcessesView.this.mAdapter.setShowBackground(false);
            }
        });
        this.SECONDARY_SERVER_MEM = (long)Integer.valueOf(SystemProperties.get((String)"ro.SECONDARY_SERVER_MEM")).intValue() * 4096L;
    }

    public void doPause() {
        this.mState.pause();
        this.mDataAvail = null;
    }

    public boolean doResume(Runnable dataAvail) {
        this.mState.resume(this);
        if (this.mState.hasData()) {
            this.refreshUi(true);
            return true;
        }
        this.mDataAvail = dataAvail;
        return false;
    }

    public Object doRetainNonConfigurationInstance() {
        return null;
    }

    void updateTimes() {
        Iterator<ActiveItem> it = this.mActiveItems.values().iterator();
        while (it.hasNext()) {
            ActiveItem ai = it.next();
            if (ai.mRootView.getWindowToken() == null) {
                it.remove();
                continue;
            }
            ai.updateTime(this.getContext(), this.mBuilder);
        }
    }

    @Override
    public void onRefreshUi(int what) {
        switch (what) {
            case 0: {
                this.updateTimes();
                break;
            }
            case 1: {
                this.refreshUi(false);
                this.updateTimes();
                break;
            }
            case 2: {
                this.refreshUi(true);
                this.updateTimes();
            }
        }
    }

    class ServiceListAdapter
    extends BaseAdapter {
        final RunningState mState;
        final LayoutInflater mInflater;
        boolean mShowBackground;
        ArrayList<RunningState.MergedItem> mItems;

        ServiceListAdapter(RunningState state) {
            this.mState = state;
            this.mInflater = (LayoutInflater)RunningProcessesView.this.getContext().getSystemService("layout_inflater");
            this.refreshItems();
        }

        void setShowBackground(boolean showBackground) {
            if (this.mShowBackground != showBackground) {
                this.mShowBackground = showBackground;
                this.mState.setWatchingBackgroundItems(showBackground);
                this.refreshItems();
                this.notifyDataSetChanged();
                RunningProcessesView.this.mColorBar.setShowingGreen(this.mShowBackground);
            }
        }

        boolean getShowBackground() {
            return this.mShowBackground;
        }

        void refreshItems() {
            ArrayList<RunningState.MergedItem> newItems;
            ArrayList<RunningState.MergedItem> arrayList = newItems = this.mShowBackground ? this.mState.getCurrentBackgroundItems() : this.mState.getCurrentMergedItems();
            if (this.mItems != newItems) {
                this.mItems = newItems;
            }
            if (this.mItems == null) {
                this.mItems = new ArrayList();
            }
        }

        public boolean hasStableIds() {
            return true;
        }

        public int getCount() {
            return this.mItems.size();
        }

        public boolean isEmpty() {
            return this.mState.hasData() && this.mItems.size() == 0;
        }

        public Object getItem(int position) {
            return this.mItems.get(position);
        }

        public long getItemId(int position) {
            return this.mItems.get(position).hashCode();
        }

        public boolean areAllItemsEnabled() {
            return false;
        }

        public boolean isEnabled(int position) {
            return !this.mItems.get((int)position).mIsProcess;
        }

        public View getView(int position, View convertView, ViewGroup parent) {
            View v = convertView == null ? this.newView(parent) : convertView;
            this.bindView(v, position);
            return v;
        }

        public View newView(ViewGroup parent) {
            View v = this.mInflater.inflate(2130903092, parent, false);
            new ViewHolder(v);
            return v;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void bindView(View view, int position) {
            Object object = this.mState.mLock;
            synchronized (object) {
                if (position >= this.mItems.size()) {
                    return;
                }
                ViewHolder vh = (ViewHolder)view.getTag();
                RunningState.MergedItem item = this.mItems.get(position);
                ActiveItem ai = vh.bind(this.mState, item, RunningProcessesView.this.mBuilder);
                RunningProcessesView.this.mActiveItems.put(view, ai);
            }
        }
    }

    static class TimeTicker
    extends TextView {
        public TimeTicker(Context context, AttributeSet attrs) {
            super(context, attrs);
        }
    }

    public static class ViewHolder {
        public View rootView;
        public ImageView icon;
        public TextView name;
        public TextView description;
        public TextView size;
        public TextView uptime;

        public ViewHolder(View v) {
            this.rootView = v;
            this.icon = (ImageView)v.findViewById(2131427349);
            this.name = (TextView)v.findViewById(2131427379);
            this.description = (TextView)v.findViewById(2131427381);
            this.size = (TextView)v.findViewById(2131427498);
            this.uptime = (TextView)v.findViewById(2131427337);
            v.setTag((Object)this);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public ActiveItem bind(RunningState state, RunningState.BaseItem item, StringBuilder builder) {
            Object object = state.mLock;
            synchronized (object) {
                PackageManager pm = this.rootView.getContext().getPackageManager();
                if (item.mPackageInfo == null && item instanceof RunningState.MergedItem) {
                    ((RunningState.MergedItem)item).mProcess.ensureLabel(pm);
                    item.mPackageInfo = ((RunningState.MergedItem)item).mProcess.mPackageInfo;
                    item.mDisplayLabel = ((RunningState.MergedItem)item).mProcess.mDisplayLabel;
                }
                this.name.setText(item.mDisplayLabel);
                ActiveItem ai = new ActiveItem();
                ai.mRootView = this.rootView;
                ai.mItem = item;
                ai.mHolder = this;
                ai.mFirstRunTime = item.mActiveSince;
                if (item.mBackground) {
                    this.description.setText(this.rootView.getContext().getText(2131231517));
                } else {
                    this.description.setText((CharSequence)item.mDescription);
                }
                item.mCurSizeStr = null;
                if (item.mPackageInfo != null) {
                    this.icon.setImageDrawable(item.mPackageInfo.loadIcon(pm));
                }
                this.icon.setVisibility(0);
                ai.updateTime(this.rootView.getContext(), builder);
                return ai;
            }
        }
    }

    public static class ActiveItem {
        View mRootView;
        RunningState.BaseItem mItem;
        ActivityManager.RunningServiceInfo mService;
        ViewHolder mHolder;
        long mFirstRunTime;
        boolean mSetBackground;

        void updateTime(Context context, StringBuilder builder) {
            TextView uptimeView = null;
            if (this.mItem instanceof RunningState.ServiceItem) {
                uptimeView = this.mHolder.size;
            } else {
                String size;
                String string2 = size = this.mItem.mSizeStr != null ? this.mItem.mSizeStr : "";
                if (!size.equals(this.mItem.mCurSizeStr)) {
                    this.mItem.mCurSizeStr = size;
                    this.mHolder.size.setText((CharSequence)size);
                }
                if (this.mItem.mBackground) {
                    if (!this.mSetBackground) {
                        this.mSetBackground = true;
                        this.mHolder.uptime.setText((CharSequence)"");
                    }
                } else if (this.mItem instanceof RunningState.MergedItem) {
                    uptimeView = this.mHolder.uptime;
                }
            }
            if (uptimeView != null) {
                this.mSetBackground = false;
                if (this.mFirstRunTime >= 0L) {
                    uptimeView.setText((CharSequence)DateUtils.formatElapsedTime((StringBuilder)builder, (long)((SystemClock.elapsedRealtime() - this.mFirstRunTime) / 1000L)));
                } else {
                    boolean isService = false;
                    if (this.mItem instanceof RunningState.MergedItem) {
                        boolean bl = isService = ((RunningState.MergedItem)this.mItem).mServices.size() > 0;
                    }
                    if (isService) {
                        uptimeView.setText(context.getResources().getText(2131231516));
                    } else {
                        uptimeView.setText((CharSequence)"");
                    }
                }
            }
        }
    }
}

