/*
 * Decompiled with CFR 0.152.
 */
package com.android.settings.applications;

import android.app.TabActivity;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.net.Uri;
import android.os.Bundle;
import android.os.Environment;
import android.os.StatFs;
import android.text.format.Formatter;
import android.view.KeyEvent;
import android.view.LayoutInflater;
import android.view.Menu;
import android.view.MenuItem;
import android.view.View;
import android.view.ViewGroup;
import android.view.animation.AnimationUtils;
import android.view.inputmethod.InputMethodManager;
import android.widget.AbsListView;
import android.widget.AdapterView;
import android.widget.BaseAdapter;
import android.widget.CheckBox;
import android.widget.Filter;
import android.widget.Filterable;
import android.widget.ImageView;
import android.widget.ListAdapter;
import android.widget.ListView;
import android.widget.TabHost;
import android.widget.TextView;
import com.android.settings.applications.ApplicationsState;
import com.android.settings.applications.LinearColorBar;
import com.android.settings.applications.RunningProcessesView;
import java.util.ArrayList;
import java.util.Comparator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ManageApplications
extends TabActivity
implements AdapterView.OnItemClickListener,
DialogInterface.OnCancelListener,
TabHost.TabContentFactory,
TabHost.OnTabChangeListener {
    static final String TAG = "ManageApplications";
    static final boolean DEBUG = false;
    public static final String APP_CHG = "chg";
    private static final int INSTALLED_APP_DETAILS = 1;
    private static final int MENU_OPTIONS_BASE = 0;
    public static final int FILTER_APPS_ALL = 0;
    public static final int FILTER_APPS_THIRD_PARTY = 1;
    public static final int FILTER_APPS_SDCARD = 2;
    public static final int SORT_ORDER_ALPHA = 4;
    public static final int SORT_ORDER_SIZE = 5;
    public static final int SHOW_RUNNING_SERVICES = 6;
    public static final int SHOW_BACKGROUND_PROCESSES = 7;
    private int mSortOrder = 4;
    private int mFilterApps = 1;
    private ApplicationsState mApplicationsState;
    private ApplicationsAdapter mApplicationsAdapter;
    private CharSequence mInvalidSizeStr;
    private CharSequence mComputingSizeStr;
    private LayoutInflater mInflater;
    private String mCurrentPkgName;
    private View mLoadingContainer;
    private View mListContainer;
    private ListView mListView;
    private RunningProcessesView mRunningProcessesView;
    LinearColorBar mColorBar;
    TextView mStorageChartLabel;
    TextView mUsedStorageText;
    TextView mFreeStorageText;
    private int mCurView;
    private boolean mCreatedRunning;
    private boolean mResumedRunning;
    private boolean mActivityResumed;
    private Object mNonConfigInstance;
    private StatFs mDataFileStats;
    private StatFs mSDCardFileStats;
    private boolean mLastShowedInternalStorage = true;
    private long mLastUsedStorage;
    private long mLastAppStorage;
    private long mLastFreeStorage;
    final Runnable mRunningProcessesAvail = new Runnable(){

        public void run() {
            ManageApplications.this.handleRunningProcessesAvail();
        }
    };
    static final String TAB_DOWNLOADED = "Downloaded";
    static final String TAB_RUNNING = "Running";
    static final String TAB_ALL = "All";
    static final String TAB_SDCARD = "OnSdCard";
    private View mRootView;
    static final int VIEW_NOTHING = 0;
    static final int VIEW_LIST = 1;
    static final int VIEW_RUNNING = 2;

    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.mApplicationsState = ApplicationsState.getInstance(this.getApplication());
        this.mApplicationsAdapter = new ApplicationsAdapter(this.mApplicationsState);
        Intent intent = this.getIntent();
        String action = intent.getAction();
        String defaultTabTag = TAB_DOWNLOADED;
        if (intent.getComponent().getClassName().equals("com.android.settings.RunningServices")) {
            defaultTabTag = TAB_RUNNING;
        } else if (intent.getComponent().getClassName().equals("com.android.settings.applications.StorageUse") || action.equals("android.intent.action.MANAGE_PACKAGE_STORAGE")) {
            this.mSortOrder = 5;
            this.mFilterApps = 0;
            defaultTabTag = TAB_ALL;
        } else if (action.equals("android.settings.MANAGE_ALL_APPLICATIONS_SETTINGS")) {
            defaultTabTag = TAB_ALL;
        }
        if (savedInstanceState != null) {
            this.mSortOrder = savedInstanceState.getInt("sortOrder", this.mSortOrder);
            this.mFilterApps = savedInstanceState.getInt("filterApps", this.mFilterApps);
            String tmp = savedInstanceState.getString("defaultTabTag");
            if (tmp != null) {
                defaultTabTag = tmp;
            }
        }
        this.mNonConfigInstance = this.getLastNonConfigurationInstance();
        this.mDataFileStats = new StatFs("/data");
        this.mSDCardFileStats = new StatFs(Environment.getExternalStorageDirectory().toString());
        this.requestWindowFeature(4);
        this.requestWindowFeature(5);
        this.mInvalidSizeStr = this.getText(2131231494);
        this.mComputingSizeStr = this.getText(2131231493);
        this.mInflater = (LayoutInflater)this.getSystemService("layout_inflater");
        this.mRootView = this.mInflater.inflate(2130903069, null);
        this.mLoadingContainer = this.mRootView.findViewById(2131427421);
        this.mListContainer = this.mRootView.findViewById(2131427415);
        ListView lv = (ListView)this.mListContainer.findViewById(16908298);
        View emptyView = this.mListContainer.findViewById(16908292);
        if (emptyView != null) {
            lv.setEmptyView(emptyView);
        }
        lv.setOnItemClickListener((AdapterView.OnItemClickListener)this);
        lv.setSaveEnabled(true);
        lv.setItemsCanFocus(true);
        lv.setOnItemClickListener((AdapterView.OnItemClickListener)this);
        lv.setTextFilterEnabled(true);
        this.mListView = lv;
        lv.setRecyclerListener((AbsListView.RecyclerListener)this.mApplicationsAdapter);
        this.mListView.setAdapter((ListAdapter)this.mApplicationsAdapter);
        this.mColorBar = (LinearColorBar)this.mListContainer.findViewById(2131427416);
        this.mStorageChartLabel = (TextView)this.mListContainer.findViewById(2131427418);
        this.mUsedStorageText = (TextView)this.mListContainer.findViewById(2131427417);
        this.mFreeStorageText = (TextView)this.mListContainer.findViewById(2131427419);
        this.mRunningProcessesView = (RunningProcessesView)this.mRootView.findViewById(2131427420);
        TabHost tabHost = this.getTabHost();
        tabHost.addTab(tabHost.newTabSpec(TAB_DOWNLOADED).setIndicator((CharSequence)this.getString(2131231473), this.getResources().getDrawable(2130837577)).setContent((TabHost.TabContentFactory)this));
        tabHost.addTab(tabHost.newTabSpec(TAB_ALL).setIndicator((CharSequence)this.getString(2131231472), this.getResources().getDrawable(2130837576)).setContent((TabHost.TabContentFactory)this));
        tabHost.addTab(tabHost.newTabSpec(TAB_SDCARD).setIndicator((CharSequence)this.getString(2131231475), this.getResources().getDrawable(2130837579)).setContent((TabHost.TabContentFactory)this));
        tabHost.addTab(tabHost.newTabSpec(TAB_RUNNING).setIndicator((CharSequence)this.getString(2131231474), this.getResources().getDrawable(2130837578)).setContent((TabHost.TabContentFactory)this));
        tabHost.setCurrentTabByTag(defaultTabTag);
        tabHost.setOnTabChangedListener((TabHost.OnTabChangeListener)this);
    }

    public void onStart() {
        super.onStart();
    }

    protected void onResume() {
        super.onResume();
        this.mActivityResumed = true;
        this.showCurrentTab();
    }

    protected void onSaveInstanceState(Bundle outState) {
        super.onSaveInstanceState(outState);
        outState.putInt("sortOrder", this.mSortOrder);
        outState.putInt("filterApps", this.mFilterApps);
        outState.putString("defautTabTag", this.getTabHost().getCurrentTabTag());
    }

    public Object onRetainNonConfigurationInstance() {
        return this.mRunningProcessesView.doRetainNonConfigurationInstance();
    }

    protected void onPause() {
        super.onPause();
        this.mActivityResumed = false;
        this.mApplicationsAdapter.pause();
        if (this.mResumedRunning) {
            this.mRunningProcessesView.doPause();
            this.mResumedRunning = false;
        }
    }

    protected void onActivityResult(int requestCode, int resultCode, Intent data) {
        if (requestCode == 1 && this.mCurrentPkgName != null) {
            this.mApplicationsState.requestSize(this.mCurrentPkgName);
        }
    }

    private void startApplicationDetailsActivity() {
        Intent intent = new Intent("android.settings.APPLICATION_DETAILS_SETTINGS", Uri.fromParts((String)"package", (String)this.mCurrentPkgName, null));
        this.startActivityForResult(intent, 1);
    }

    public boolean onCreateOptionsMenu(Menu menu) {
        menu.add(0, 4, 1, 2131231465).setIcon(17301660);
        menu.add(0, 5, 2, 2131231466).setIcon(17301661);
        menu.add(0, 6, 3, 2131231467);
        menu.add(0, 7, 3, 2131231468);
        return true;
    }

    public boolean onPrepareOptionsMenu(Menu menu) {
        if (this.mCurView == 2) {
            boolean showingBackground = this.mRunningProcessesView.mAdapter.getShowBackground();
            menu.findItem(4).setVisible(false);
            menu.findItem(5).setVisible(false);
            menu.findItem(6).setVisible(showingBackground);
            menu.findItem(7).setVisible(!showingBackground);
        } else {
            menu.findItem(4).setVisible(this.mSortOrder != 4);
            menu.findItem(5).setVisible(this.mSortOrder != 5);
            menu.findItem(6).setVisible(false);
            menu.findItem(7).setVisible(false);
        }
        return true;
    }

    public boolean onOptionsItemSelected(MenuItem item) {
        int menuId = item.getItemId();
        if (menuId == 4 || menuId == 5) {
            this.mSortOrder = menuId;
            if (this.mCurView != 2) {
                this.mApplicationsAdapter.rebuild(this.mFilterApps, this.mSortOrder);
            }
        } else if (menuId == 6) {
            this.mRunningProcessesView.mAdapter.setShowBackground(false);
        } else if (menuId == 7) {
            this.mRunningProcessesView.mAdapter.setShowBackground(true);
        }
        return true;
    }

    public boolean onKeyUp(int keyCode, KeyEvent event) {
        if (keyCode == 84 && event.isTracking()) {
            if (this.mCurView != 2) {
                ((InputMethodManager)this.getSystemService("input_method")).showSoftInputUnchecked(0, null);
            }
            return true;
        }
        return super.onKeyUp(keyCode, event);
    }

    public void onItemClick(AdapterView<?> parent, View view, int position, long id2) {
        ApplicationsState.AppEntry entry = this.mApplicationsAdapter.getAppEntry(position);
        this.mCurrentPkgName = entry.info.packageName;
        this.startApplicationDetailsActivity();
    }

    public void onCancel(DialogInterface dialog) {
        this.finish();
    }

    public View createTabContent(String tag) {
        return this.mRootView;
    }

    void updateStorageUsage() {
        if (this.mCurView == 2) {
            return;
        }
        long freeStorage = 0L;
        long appStorage = 0L;
        long totalStorage = 0L;
        CharSequence newLabel = null;
        if (this.mFilterApps == 2) {
            if (this.mLastShowedInternalStorage) {
                this.mLastShowedInternalStorage = false;
            }
            newLabel = this.getText(2131231479);
            this.mSDCardFileStats.restat(Environment.getExternalStorageDirectory().toString());
            try {
                totalStorage = (long)this.mSDCardFileStats.getBlockCount() * (long)this.mSDCardFileStats.getBlockSize();
                freeStorage = (long)this.mSDCardFileStats.getAvailableBlocks() * (long)this.mSDCardFileStats.getBlockSize();
            }
            catch (IllegalArgumentException e) {}
        } else {
            if (!this.mLastShowedInternalStorage) {
                this.mLastShowedInternalStorage = true;
            }
            newLabel = this.getText(2131231478);
            this.mDataFileStats.restat("/data");
            try {
                totalStorage = (long)this.mDataFileStats.getBlockCount() * (long)this.mDataFileStats.getBlockSize();
                freeStorage = (long)this.mDataFileStats.getAvailableBlocks() * (long)this.mDataFileStats.getBlockSize();
            }
            catch (IllegalArgumentException e) {
                // empty catch block
            }
            int N = this.mApplicationsAdapter.getCount();
            for (int i = 0; i < N; ++i) {
                ApplicationsState.AppEntry ae = this.mApplicationsAdapter.getAppEntry(i);
                appStorage += ae.codeSize + ae.dataSize;
            }
            freeStorage += this.mApplicationsState.sumCacheSizes();
        }
        if (newLabel != null) {
            this.mStorageChartLabel.setText(newLabel);
        }
        if (totalStorage > 0L) {
            String sizeStr;
            this.mColorBar.setRatios((float)(totalStorage - freeStorage - appStorage) / (float)totalStorage, (float)appStorage / (float)totalStorage, (float)freeStorage / (float)totalStorage);
            long usedStorage = totalStorage - freeStorage;
            if (this.mLastUsedStorage != usedStorage) {
                this.mLastUsedStorage = usedStorage;
                sizeStr = Formatter.formatShortFileSize((Context)this, (long)usedStorage);
                this.mUsedStorageText.setText((CharSequence)this.getResources().getString(2131231522, new Object[]{sizeStr}));
            }
            if (this.mLastFreeStorage != freeStorage) {
                this.mLastFreeStorage = freeStorage;
                sizeStr = Formatter.formatShortFileSize((Context)this, (long)freeStorage);
                this.mFreeStorageText.setText((CharSequence)this.getResources().getString(2131231521, new Object[]{sizeStr}));
            }
        } else {
            this.mColorBar.setRatios(0.0f, 0.0f, 0.0f);
            if (this.mLastUsedStorage != -1L) {
                this.mLastUsedStorage = -1L;
                this.mUsedStorageText.setText((CharSequence)"");
            }
            if (this.mLastFreeStorage != -1L) {
                this.mLastFreeStorage = -1L;
                this.mFreeStorageText.setText((CharSequence)"");
            }
        }
    }

    private void selectView(int which) {
        if (which == 1) {
            if (this.mResumedRunning) {
                this.mRunningProcessesView.doPause();
                this.mResumedRunning = false;
            }
            if (this.mCurView != which) {
                this.mRunningProcessesView.setVisibility(8);
                this.mListContainer.setVisibility(0);
                this.mLoadingContainer.setVisibility(8);
            }
            if (this.mActivityResumed) {
                this.mApplicationsAdapter.resume(this.mFilterApps, this.mSortOrder);
            }
        } else if (which == 2) {
            if (!this.mCreatedRunning) {
                this.mRunningProcessesView.doCreate(null, this.mNonConfigInstance);
                this.mCreatedRunning = true;
            }
            boolean haveData = true;
            if (this.mActivityResumed && !this.mResumedRunning) {
                haveData = this.mRunningProcessesView.doResume(this.mRunningProcessesAvail);
                this.mResumedRunning = true;
            }
            this.mApplicationsAdapter.pause();
            if (this.mCurView != which) {
                if (haveData) {
                    this.mRunningProcessesView.setVisibility(0);
                } else {
                    this.mLoadingContainer.setVisibility(0);
                }
                this.mListContainer.setVisibility(8);
            }
        }
        this.mCurView = which;
    }

    void handleRunningProcessesAvail() {
        if (this.mCurView == 2) {
            this.mLoadingContainer.startAnimation(AnimationUtils.loadAnimation((Context)this, (int)0x10A0001));
            this.mRunningProcessesView.startAnimation(AnimationUtils.loadAnimation((Context)this, (int)0x10A0000));
            this.mRunningProcessesView.setVisibility(0);
            this.mLoadingContainer.setVisibility(8);
        }
    }

    public void showCurrentTab() {
        int newOption;
        String tabId = this.getTabHost().getCurrentTabTag();
        if (TAB_DOWNLOADED.equalsIgnoreCase(tabId)) {
            newOption = 1;
        } else if (TAB_ALL.equalsIgnoreCase(tabId)) {
            newOption = 0;
        } else if (TAB_SDCARD.equalsIgnoreCase(tabId)) {
            newOption = 2;
        } else {
            if (TAB_RUNNING.equalsIgnoreCase(tabId)) {
                ((InputMethodManager)this.getSystemService("input_method")).hideSoftInputFromWindow(this.getWindow().getDecorView().getWindowToken(), 0);
                this.selectView(2);
                return;
            }
            return;
        }
        this.mFilterApps = newOption;
        this.selectView(1);
        this.updateStorageUsage();
    }

    public void onTabChanged(String tabId) {
        this.showCurrentTab();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class ApplicationsAdapter
    extends BaseAdapter
    implements Filterable,
    ApplicationsState.Callbacks,
    AbsListView.RecyclerListener {
        private final ApplicationsState mState;
        private final ArrayList<View> mActive = new ArrayList();
        private ArrayList<ApplicationsState.AppEntry> mBaseEntries;
        private ArrayList<ApplicationsState.AppEntry> mEntries;
        private boolean mResumed;
        private int mLastFilterMode = -1;
        private int mLastSortMode = -1;
        private boolean mWaitingForData;
        CharSequence mCurFilterPrefix;
        private Filter mFilter = new Filter(){

            protected Filter.FilterResults performFiltering(CharSequence constraint) {
                ArrayList<ApplicationsState.AppEntry> entries = ApplicationsAdapter.this.applyPrefixFilter(constraint, ApplicationsAdapter.this.mBaseEntries);
                Filter.FilterResults fr = new Filter.FilterResults();
                fr.values = entries;
                fr.count = entries.size();
                return fr;
            }

            protected void publishResults(CharSequence constraint, Filter.FilterResults results) {
                ApplicationsAdapter.this.mCurFilterPrefix = constraint;
                ApplicationsAdapter.this.mEntries = (ArrayList)results.values;
                ApplicationsAdapter.this.notifyDataSetChanged();
                ManageApplications.this.updateStorageUsage();
            }
        };

        public ApplicationsAdapter(ApplicationsState state) {
            this.mState = state;
        }

        public void resume(int filter, int sort) {
            if (!this.mResumed) {
                this.mResumed = true;
                this.mState.resume(this);
                this.mLastFilterMode = filter;
                this.mLastSortMode = sort;
                this.rebuild(true);
            } else {
                this.rebuild(filter, sort);
            }
        }

        public void pause() {
            if (this.mResumed) {
                this.mResumed = false;
                this.mState.pause();
            }
        }

        public void rebuild(int filter, int sort) {
            if (filter == this.mLastFilterMode && sort == this.mLastSortMode) {
                return;
            }
            this.mLastFilterMode = filter;
            this.mLastSortMode = sort;
            this.rebuild(true);
        }

        public void rebuild(boolean eraseold) {
            Comparator<ApplicationsState.AppEntry> comparatorObj;
            ApplicationsState.AppFilter filterObj;
            switch (this.mLastFilterMode) {
                case 1: {
                    filterObj = ApplicationsState.THIRD_PARTY_FILTER;
                    break;
                }
                case 2: {
                    filterObj = ApplicationsState.ON_SD_CARD_FILTER;
                    break;
                }
                default: {
                    filterObj = null;
                }
            }
            switch (this.mLastSortMode) {
                case 5: {
                    comparatorObj = ApplicationsState.SIZE_COMPARATOR;
                    break;
                }
                default: {
                    comparatorObj = ApplicationsState.ALPHA_COMPARATOR;
                }
            }
            ArrayList<ApplicationsState.AppEntry> entries = this.mState.rebuild(filterObj, comparatorObj);
            if (entries == null && !eraseold) {
                return;
            }
            this.mBaseEntries = entries;
            this.mEntries = this.mBaseEntries != null ? this.applyPrefixFilter(this.mCurFilterPrefix, this.mBaseEntries) : null;
            this.notifyDataSetChanged();
            ManageApplications.this.updateStorageUsage();
            if (entries == null) {
                this.mWaitingForData = true;
                ManageApplications.this.mListContainer.setVisibility(4);
                ManageApplications.this.mLoadingContainer.setVisibility(0);
            } else {
                ManageApplications.this.mListContainer.setVisibility(0);
                ManageApplications.this.mLoadingContainer.setVisibility(8);
            }
        }

        ArrayList<ApplicationsState.AppEntry> applyPrefixFilter(CharSequence prefix, ArrayList<ApplicationsState.AppEntry> origEntries) {
            if (prefix == null || prefix.length() == 0) {
                return origEntries;
            }
            String prefixStr = ApplicationsState.normalize(((Object)prefix).toString());
            String spacePrefixStr = " " + prefixStr;
            ArrayList<ApplicationsState.AppEntry> newEntries = new ArrayList<ApplicationsState.AppEntry>();
            for (int i = 0; i < origEntries.size(); ++i) {
                ApplicationsState.AppEntry entry = origEntries.get(i);
                String nlabel = entry.getNormalizedLabel();
                if (!nlabel.startsWith(prefixStr) && nlabel.indexOf(spacePrefixStr) == -1) continue;
                newEntries.add(entry);
            }
            return newEntries;
        }

        @Override
        public void onRunningStateChanged(boolean running) {
            ManageApplications.this.setProgressBarIndeterminateVisibility(running);
        }

        @Override
        public void onRebuildComplete(ArrayList<ApplicationsState.AppEntry> apps) {
            if (ManageApplications.this.mLoadingContainer.getVisibility() == 0) {
                ManageApplications.this.mLoadingContainer.startAnimation(AnimationUtils.loadAnimation((Context)ManageApplications.this, (int)0x10A0001));
                ManageApplications.this.mListContainer.startAnimation(AnimationUtils.loadAnimation((Context)ManageApplications.this, (int)0x10A0000));
            }
            ManageApplications.this.mListContainer.setVisibility(0);
            ManageApplications.this.mLoadingContainer.setVisibility(8);
            this.mWaitingForData = false;
            this.mBaseEntries = apps;
            this.mEntries = this.applyPrefixFilter(this.mCurFilterPrefix, this.mBaseEntries);
            this.notifyDataSetChanged();
            ManageApplications.this.updateStorageUsage();
        }

        @Override
        public void onPackageListChanged() {
            this.rebuild(false);
        }

        @Override
        public void onPackageIconChanged() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onPackageSizeChanged(String packageName) {
            for (int i = 0; i < this.mActive.size(); ++i) {
                AppViewHolder holder = (AppViewHolder)this.mActive.get(i).getTag();
                if (!holder.entry.info.packageName.equals(packageName)) continue;
                ApplicationsState.AppEntry appEntry = holder.entry;
                synchronized (appEntry) {
                    holder.updateSizeText(ManageApplications.this);
                }
                if (holder.entry.info.packageName.equals(ManageApplications.this.mCurrentPkgName) && this.mLastSortMode == 5) {
                    this.rebuild(false);
                }
                ManageApplications.this.updateStorageUsage();
                return;
            }
        }

        @Override
        public void onAllSizesComputed() {
            if (this.mLastSortMode == 5) {
                this.rebuild(false);
            }
        }

        public int getCount() {
            return this.mEntries != null ? this.mEntries.size() : 0;
        }

        public Object getItem(int position) {
            return this.mEntries.get(position);
        }

        public ApplicationsState.AppEntry getAppEntry(int position) {
            return this.mEntries.get(position);
        }

        public long getItemId(int position) {
            return this.mEntries.get((int)position).id;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public View getView(int position, View convertView, ViewGroup parent) {
            ApplicationsState.AppEntry entry;
            AppViewHolder holder;
            if (convertView == null) {
                convertView = ManageApplications.this.mInflater.inflate(2130903070, null);
                holder = new AppViewHolder();
                holder.appName = (TextView)convertView.findViewById(2131427423);
                holder.appIcon = (ImageView)convertView.findViewById(2131427422);
                holder.appSize = (TextView)convertView.findViewById(2131427424);
                holder.disabled = (TextView)convertView.findViewById(2131427425);
                holder.checkBox = (CheckBox)convertView.findViewById(2131427426);
                convertView.setTag((Object)holder);
            } else {
                holder = (AppViewHolder)convertView.getTag();
            }
            ApplicationsState.AppEntry appEntry = entry = this.mEntries.get(position);
            synchronized (appEntry) {
                holder.entry = entry;
                if (entry.label != null) {
                    holder.appName.setText((CharSequence)entry.label);
                    holder.appName.setTextColor(ManageApplications.this.getResources().getColorStateList(entry.info.enabled ? 0x1060001 : 17170437));
                }
                this.mState.ensureIcon(entry);
                if (entry.icon != null) {
                    holder.appIcon.setImageDrawable(entry.icon);
                }
                holder.updateSizeText(ManageApplications.this);
                holder.disabled.setVisibility(8);
                if (this.mLastFilterMode == 2) {
                    holder.checkBox.setVisibility(0);
                    holder.checkBox.setChecked((entry.info.flags & 0x40000) != 0);
                } else {
                    holder.checkBox.setVisibility(8);
                }
            }
            this.mActive.remove(convertView);
            this.mActive.add(convertView);
            return convertView;
        }

        public Filter getFilter() {
            return this.mFilter;
        }

        public void onMovedToScrapHeap(View view) {
            this.mActive.remove(view);
        }
    }

    static class AppViewHolder {
        ApplicationsState.AppEntry entry;
        TextView appName;
        ImageView appIcon;
        TextView appSize;
        TextView disabled;
        CheckBox checkBox;

        AppViewHolder() {
        }

        void updateSizeText(ManageApplications ma) {
            if (this.entry.sizeStr != null) {
                this.appSize.setText((CharSequence)this.entry.sizeStr);
            } else if (this.entry.size == -2L) {
                this.appSize.setText(ma.mInvalidSizeStr);
            }
        }
    }
}

